/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.framework.PO;
import org.compiere.model.MBPartner;
import org.compiere.model.MBilling;
import org.compiere.model.MBillingLine;
import org.compiere.model.MTax;
import org.compiere.model.X_C_BillingTax;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MBillingTax
extends X_C_BillingTax {
    private static CLogger s_log = CLogger.getCLogger(MBillingTax.class);
    private MTax m_tax = null;
    private Integer m_precision = null;

    public static MBillingTax get(MBillingLine line, int precision, boolean oldTax, String trxName) {
        MBillingTax retValue = null;
        if (line == null || line.getC_Billing_ID() == 0 || line.isDescription()) {
            return null;
        }
        int C_Tax_ID = line.getC_Tax_ID();
        if (oldTax && line.is_ValueChanged("C_Tax_ID")) {
            Object old = line.get_ValueOld("C_Tax_ID");
            if (old == null) {
                return null;
            }
            C_Tax_ID = (Integer)old;
        }
        if (C_Tax_ID == 0) {
            s_log.warning("C_Tax_ID=0");
            return null;
        }
        String sql = "SELECT * FROM C_BillingTax WHERE C_Billing_ID=? AND C_Tax_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, line.getC_Billing_ID());
            pstmt.setInt(2, C_Tax_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MBillingTax(line.getCtx(), rs, trxName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (retValue != null) {
            retValue.set_TrxName(trxName);
            retValue.setPrecision(precision);
            s_log.fine("(old=" + oldTax + ") " + (Object)((Object)retValue));
            return retValue;
        }
        retValue = new MBillingTax(line.getCtx(), 0, trxName);
        retValue.set_TrxName(trxName);
        retValue.setClientOrg((PO)line);
        retValue.setC_Billing_ID(line.getC_Billing_ID());
        retValue.setC_Tax_ID(line.getC_Tax_ID());
        retValue.setPrecision(precision);
        retValue.setIsTaxIncluded(line.isTaxIncluded());
        s_log.fine("(new) " + (Object)((Object)retValue));
        return retValue;
    }

    public MBillingTax(Ctx ctx, int ignored, String trxName) {
        super(ctx, 0, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
        this.setTaxAmt(Env.ZERO);
        this.setTaxBaseAmt(Env.ZERO);
        this.setIsTaxIncluded(false);
    }

    public MBillingTax(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    private int getPrecision() {
        if (this.m_precision == null) {
            return 2;
        }
        return this.m_precision;
    }

    protected void setPrecision(int precision) {
        this.m_precision = new Integer(precision);
    }

    protected MTax getTax() {
        if (this.m_tax == null) {
            this.m_tax = MTax.get(this.getCtx(), this.getC_Tax_ID());
        }
        return this.m_tax;
    }

    public boolean calculateTaxFromLines() {
        BigDecimal totalBaseAmt = Env.ZERO;
        BigDecimal taxBaseAmt = Env.ZERO;
        BigDecimal taxAmt = Env.ZERO;
        int m_InOut_ID = 0;
        MBilling billing = new MBilling(this.getCtx(), this.getC_Billing_ID(), this.get_TrxName());
        MBPartner partner = MBPartner.get(this.getCtx(), billing.getC_BPartner_ID());
        boolean documentLevel = this.getTax().isDocumentLevel();
        documentLevel = partner.isTaxDocumentLevel(documentLevel);
        boolean shipmentLevel = false;
        if (documentLevel) {
            shipmentLevel = partner.isTaxShipmentLevel();
        }
        MTax tax = this.getTax();
        String sql = "SELECT il.LineNetAmt, COALESCE(il.TaxAmt,0), i.IsSOTrx, iol.M_InOut_ID FROM C_BillingLine il INNER JOIN C_Billing i ON (il.C_Billing_ID=i.C_Billing_ID)  LEFT JOIN M_InOutLine iol ON (il.M_InOutLine_ID=iol.M_InOutLine_ID) WHERE il.C_Billing_ID=? AND il.C_Tax_ID=? ORDER BY iol.M_InOut_ID ";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getC_Billing_ID());
            pstmt.setInt(2, this.getC_Tax_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int temp_InOut_ID = rs.getInt(4);
                if (documentLevel && shipmentLevel && m_InOut_ID != temp_InOut_ID) {
                    BigDecimal shipTaxAmt = tax.calculateTax(taxBaseAmt, this.isTaxIncluded(), this.getPrecision(), partner.getTaxRoundModeAsInt());
                    taxAmt = taxAmt.add(shipTaxAmt);
                    taxBaseAmt = Env.ZERO;
                    m_InOut_ID = temp_InOut_ID;
                }
                BigDecimal baseAmt = rs.getBigDecimal(1);
                taxBaseAmt = taxBaseAmt.add(baseAmt);
                totalBaseAmt = totalBaseAmt.add(baseAmt);
                BigDecimal amt = rs.getBigDecimal(2);
                if (amt == null) {
                    amt = Env.ZERO;
                }
                boolean isSOTrx = "Y".equals(rs.getString(3));
                if (documentLevel || baseAmt.signum() == 0) {
                    amt = Env.ZERO;
                } else if (amt.signum() == 0 || isSOTrx) {
                    amt = tax.calculateTax(baseAmt, this.isTaxIncluded(), this.getPrecision(), partner.getTaxRoundModeAsInt());
                }
                taxAmt = taxAmt.add(amt);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "setTaxBaseAmt", (Throwable)e);
            taxBaseAmt = null;
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (taxBaseAmt == null) {
            return false;
        }
        if (documentLevel || taxAmt.signum() == 0) {
            BigDecimal amt = tax.calculateTax(taxBaseAmt, this.isTaxIncluded(), this.getPrecision(), partner.getTaxRoundModeAsInt());
            taxAmt = taxAmt.add(amt);
        }
        this.setTaxAmt(taxAmt);
        if (this.isTaxIncluded()) {
            this.setTaxBaseAmt(totalBaseAmt.subtract(taxAmt));
        } else {
            this.setTaxBaseAmt(totalBaseAmt);
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MBillingTax[");
        sb.append("C_Billing_ID=").append(this.getC_Billing_ID()).append(",C_Tax_ID=").append(this.getC_Tax_ID()).append(", Base=").append(this.getTaxBaseAmt()).append(",Tax=").append(this.getTaxAmt()).append("]");
        return sb.toString();
    }
}

