/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.api.UICallout;
import org.compiere.framework.PO;
import org.compiere.model.MBPartner;
import org.compiere.model.MBankAccount;
import org.compiere.model.MCash;
import org.compiere.model.MCashBook;
import org.compiere.model.MCharge;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MTax;
import org.compiere.model.X_C_CashLine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MCashLine
extends X_C_CashLine {
    private MCash m_parent = null;
    private MCashBook m_cashBook = null;
    private MBankAccount m_bankAccount = null;
    private MInvoice m_invoice = null;

    public MCashLine(Ctx ctx, int C_CashLine_ID, String trxName) {
        super(ctx, C_CashLine_ID, trxName);
        if (C_CashLine_ID == 0) {
            this.setAmount(Env.ZERO);
            this.setDiscountAmt(Env.ZERO);
            this.setWriteOffAmt(Env.ZERO);
            this.setIsGenerated(false);
        }
    }

    public MCashLine(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCashLine(MCash cash) {
        this(cash.getCtx(), 0, cash.get_TrxName());
        this.setClientOrg((PO)cash);
        this.setC_Cash_ID(cash.getC_Cash_ID());
        this.m_parent = cash;
        this.m_cashBook = this.m_parent.getCashBook();
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public void setInvoice(MInvoice invoice) {
        this.setC_Invoice_ID(invoice.getC_Invoice_ID());
        this.setCashType("I");
        this.setC_Currency_ID(invoice.getC_Currency_ID());
        MDocType dt = MDocType.get((Ctx)this.getCtx(), (int)invoice.getC_DocType_ID());
        BigDecimal amt = invoice.getGrandTotal();
        if ("API".equals(dt.getDocBaseType()) || "ARC".equals(dt.getDocBaseType())) {
            amt = amt.negate();
        }
        this.setAmount(amt);
        this.setDiscountAmt(Env.ZERO);
        this.setWriteOffAmt(Env.ZERO);
        this.setIsGenerated(true);
        this.m_invoice = invoice;
    }

    @UICallout
    public void setC_Invoice_ID(String oldC_Invoice_ID, String newC_Invoice_ID, int windowNo) throws Exception {
        if (newC_Invoice_ID == null || newC_Invoice_ID.length() == 0) {
            return;
        }
        int C_Invoice_ID = Integer.parseInt(newC_Invoice_ID);
        if (C_Invoice_ID == 0) {
            return;
        }
        Timestamp ts = new Timestamp(this.getCtx().getContextAsTime(windowNo, "DateAcct"));
        String sql = "SELECT C_BPartner_ID, C_Currency_ID,invoiceOpen(C_Invoice_ID, 0), IsSOTrx, paymentTermDiscount(invoiceOpen(C_Invoice_ID, 0),C_Currency_ID,C_PaymentTerm_ID,DateInvoiced,?) FROM C_Invoice WHERE C_Invoice_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setTimestamp(1, ts);
            pstmt.setInt(2, C_Invoice_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                this.setC_Currency_ID(rs.getInt(2));
                BigDecimal PayAmt = rs.getBigDecimal(3);
                BigDecimal DiscountAmt = rs.getBigDecimal(5);
                boolean isSOTrx = "Y".equals(rs.getString(4));
                if (!isSOTrx) {
                    PayAmt = PayAmt.negate();
                    DiscountAmt = DiscountAmt.negate();
                }
                this.setAmount(PayAmt.subtract(DiscountAmt));
                this.setDiscountAmt(DiscountAmt);
                this.setWriteOffAmt(Env.ZERO);
                this.p_changeVO.setContext(this.getCtx(), windowNo, "InvTotalAmt", (Number)PayAmt);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
    }

    public void setOrder(MOrder order, String trxName) {
        this.setCashType("I");
        this.setC_Currency_ID(order.getC_Currency_ID());
        BigDecimal amt = order.getGrandTotal();
        this.setAmount(amt);
        this.setDiscountAmt(Env.ZERO);
        this.setWriteOffAmt(Env.ZERO);
        this.setIsGenerated(true);
        if ("WP".equals(order.getDocStatus())) {
            this.save(trxName);
            order.setC_CashLine_ID(this.getC_CashLine_ID());
            order.processIt("WC");
            order.save(trxName);
            MInvoice[] invoices = order.getInvoices(true);
            int length = invoices.length;
            if (length > 0) {
                this.m_invoice = invoices[length - 1];
                this.setC_Invoice_ID(this.m_invoice.getC_Invoice_ID());
                this.setCashType("I");
            }
        }
    }

    @UICallout
    public void setAmount(String oldAmount, String newAmount, int windowNo) throws Exception {
        if (newAmount == null || newAmount.length() == 0) {
            return;
        }
        BigDecimal Amount = new BigDecimal(newAmount);
        super.setAmount(Amount);
        this.setAmt(windowNo, "Amount");
    }

    @UICallout
    public void setWriteOffAmt(String oldWriteOffAmt, String newWriteOffAmt, int windowNo) throws Exception {
        if (newWriteOffAmt == null || newWriteOffAmt.length() == 0) {
            return;
        }
        BigDecimal WriteOffAmt = new BigDecimal(newWriteOffAmt);
        super.setWriteOffAmt(WriteOffAmt);
        this.setAmt(windowNo, "WriteOffAmt");
    }

    @UICallout
    public void setDiscountAmt(String oldDiscountAmt, String newDiscountAmt, int windowNo) throws Exception {
        if (newDiscountAmt == null || newDiscountAmt.length() == 0) {
            return;
        }
        BigDecimal DiscountAmt = new BigDecimal(newDiscountAmt);
        super.setDiscountAmt(DiscountAmt);
        this.setAmt(windowNo, "DiscountAmt");
    }

    private void setAmt(int windowNo, String columnName) {
        if (!"I".equals(this.getCashType())) {
            return;
        }
        String total = this.getCtx().getContext(windowNo, "InvTotalAmt");
        if (total == null || total.length() == 0) {
            return;
        }
        BigDecimal InvTotalAmt = new BigDecimal(total);
        BigDecimal PayAmt = this.getAmount();
        BigDecimal DiscountAmt = this.getDiscountAmt();
        BigDecimal WriteOffAmt = this.getWriteOffAmt();
        this.log.fine(columnName + " - Invoice=" + InvTotalAmt + " - Amount=" + PayAmt + ", Discount=" + DiscountAmt + ", WriteOff=" + WriteOffAmt);
        if (columnName.equals("Amount")) {
            WriteOffAmt = InvTotalAmt.subtract(PayAmt).subtract(DiscountAmt);
            this.setWriteOffAmt(WriteOffAmt);
        } else {
            PayAmt = InvTotalAmt.subtract(DiscountAmt).subtract(WriteOffAmt);
            this.setAmount(PayAmt);
        }
    }

    public Timestamp getStatementDate() {
        return this.getParent().getStatementDate();
    }

    public MCashLine createReversal() {
        MCash parent = this.getParent();
        if (parent.isProcessed()) {
            parent = MCash.get(this.getCtx(), parent.getAD_Org_ID(), parent.getStatementDate(), parent.getC_Currency_ID(), this.get_TrxName());
        }
        MCashLine reversal = new MCashLine(parent);
        reversal.setClientOrg((PO)this);
        reversal.setC_BankAccount_ID(this.getC_BankAccount_ID());
        reversal.setC_Charge_ID(this.getC_Charge_ID());
        reversal.setC_Currency_ID(this.getC_Currency_ID());
        reversal.setC_Invoice_ID(this.getC_Invoice_ID());
        reversal.setCashType(this.getCashType());
        reversal.setDescription(this.getDescription());
        reversal.setIsGenerated(true);
        reversal.setAmount(this.getAmount().negate());
        if (this.getDiscountAmt() == null) {
            this.setDiscountAmt(Env.ZERO);
        } else {
            reversal.setDiscountAmt(this.getDiscountAmt().negate());
        }
        if (this.getWriteOffAmt() == null) {
            this.setWriteOffAmt(Env.ZERO);
        } else {
            reversal.setWriteOffAmt(this.getWriteOffAmt().negate());
        }
        reversal.addDescription("(" + this.getLine() + ")");
        return reversal;
    }

    public MCash getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MCash(this.getCtx(), this.getC_Cash_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public MCashBook getCashBook() {
        if (this.m_cashBook == null) {
            this.m_cashBook = MCashBook.get(this.getCtx(), this.getParent().getC_CashBook_ID());
        }
        return this.m_cashBook;
    }

    public MBankAccount getBankAccount() {
        if (this.m_bankAccount == null && this.getC_BankAccount_ID() != 0) {
            this.m_bankAccount = MBankAccount.get(this.getCtx(), this.getC_BankAccount_ID());
        }
        return this.m_bankAccount;
    }

    public MInvoice getInvoice() {
        if (this.m_invoice == null && this.getC_Invoice_ID() != 0) {
            this.m_invoice = MInvoice.get(this.getCtx(), this.getC_Invoice_ID());
        }
        return this.m_invoice;
    }

    protected boolean beforeDelete() {
        Boolean generated = (Boolean)this.get_ValueOld("IsGenerated");
        if (generated != null && generated.booleanValue() && this.get_ValueOld("C_Invoice_ID") != null) {
            Integer C_Invoice_ID = (Integer)this.get_ValueOld("C_Invoice_ID");
            MInvoice invoice = new MInvoice(this.getCtx(), (int)C_Invoice_ID, null);
            if (invoice.getC_CashLine_ID() == this.getC_CashLine_ID()) {
                this.log.warning("Cannot delete line with generated Invoice");
                return false;
            }
        }
        return true;
    }

    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        return this.updateHeader();
    }

    protected boolean beforeSave(boolean newRecord) {
        BigDecimal amount;
        boolean verify;
        Object generated;
        Integer oldValue = (Integer)this.get_ValueOld("C_Invoice_ID");
        if (this.is_ValueChanged("C_Invoice_ID") && oldValue != null && oldValue != 0 && (generated = this.get_ValueOld("IsGenerated")) != null && ((Boolean)generated).booleanValue()) {
            this.log.warning("Cannot change line with generated Invoice");
            return true;
        }
        if ("I".equals(this.getCashType()) && this.getC_Invoice_ID() == 0) {
            this.setCashType("E");
        }
        if ("T".equals(this.getCashType()) && this.getC_BankAccount_ID() == 0) {
            this.setCashType("E");
        }
        if ("C".equals(this.getCashType()) && this.getC_Charge_ID() == 0) {
            this.setCashType("E");
        }
        boolean bl = verify = newRecord || this.is_ValueChanged("CashType") || this.is_ValueChanged("C_Invoice_ID") || this.is_ValueChanged("C_BankAccount_ID");
        if (verify) {
            if ("T".equals(this.getCashType())) {
                this.setC_Currency_ID(this.getBankAccount().getC_Currency_ID());
            } else if ("I".equals(this.getCashType())) {
                this.setC_Currency_ID(this.getInvoice().getC_Currency_ID());
            } else {
                this.setC_Currency_ID(this.getCashBook().getC_Currency_ID());
            }
            if ("T".equals(this.getCashType())) {
                this.setAD_Org_ID(this.getBankAccount().getAD_Org_ID());
            } else if ("I".equals(this.getCashType())) {
                this.setAD_Org_ID(this.getCashBook().getAD_Org_ID());
            }
            if (this.getAD_Org_ID() == 0) {
                this.setAD_Org_ID(this.getParent().getAD_Org_ID());
            }
        }
        if (this.getLine() == 0) {
            String sql = "SELECT COALESCE(MAX(Line),0)+10 FROM C_CashLine WHERE C_Cash_ID=?";
            int ii = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getC_Cash_ID());
            this.setLine(ii);
        }
        if ("C".equals(this.getCashType())) {
            amount = this.getAmount();
            Ctx ctx = this.getCtx();
            MCharge charge = MCharge.get(ctx, this.getC_Charge_ID());
            if (charge != null) {
                this.setIsTaxIncluded(charge.isTaxIncluded());
                MTax tax = MTax.get(ctx, this.getC_Tax_ID());
                if (tax != null) {
                    int roundmode = 4;
                    MBPartner bartner = MBPartner.get(ctx, this.getC_BPartner_ID());
                    if (bartner != null) {
                        roundmode = bartner.getTaxRoundModeAsInt();
                    }
                    MCurrency currency = MCurrency.get((Ctx)ctx, (int)this.getC_Currency_ID());
                    boolean taxIncluded = this.isTaxIncluded();
                    BigDecimal taxAmt = tax.calculateTax(amount, taxIncluded, currency.getStdPrecision(), roundmode);
                    this.setTaxAmt(taxAmt);
                    if (this.isTaxIncluded()) {
                        this.setTotalAmt(amount);
                    } else {
                        this.setTotalAmt(amount.add(taxAmt));
                    }
                }
            }
        } else {
            amount = this.getAmount();
            BigDecimal taxAmt = BigDecimal.ZERO;
            this.setTaxAmt(taxAmt);
            this.setTotalAmt(amount);
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        return this.updateHeader();
    }

    private boolean updateHeader() {
        String sql = "SELECT COALESCE(SUM(currencyConvert(cl.TotalAmt, cl.C_Currency_ID, cb.C_Currency_ID, c.DateAcct, 0, c.AD_Client_ID, c.AD_Org_ID)),0) FROM C_CashLine cl, C_CashBook cb, C_Cash c WHERE cb.C_CashBook_ID=c.C_CashBook_ID AND cl.C_Cash_ID=c.C_Cash_ID AND c.C_Cash_ID=" + this.getC_Cash_ID();
        CPreparedStatement pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
        BigDecimal sum = Env.ZERO;
        try {
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                sum = rs.getBigDecimal(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.severe(e.getMessage());
            return false;
        }
        sql = "UPDATE C_Cash SET EndingBalance = BeginningBalance + " + sum + ", " + " StatementDifference=" + sum + " WHERE C_Cash_ID=" + this.getC_Cash_ID();
        int no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        if (no != 1) {
            this.log.warning("Balance #" + no);
        }
        return no == 1;
    }
}

