/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.X_C_Charge;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MCharge
extends X_C_Charge {
    private static CCache<Integer, MCharge> s_cache = new CCache("C_Charge", 10);
    private static CLogger s_log = CLogger.getCLogger(MCharge.class);

    public static MAccount getAccount(int C_Charge_ID, MAcctSchema as, BigDecimal amount) {
        if (C_Charge_ID == 0 || as == null) {
            return null;
        }
        int acct_index = 1;
        if (amount != null && amount.signum() < 0) {
            acct_index = 2;
        }
        String sql = "SELECT CH_Expense_Acct, CH_Revenue_Acct FROM C_Charge_Acct WHERE C_Charge_ID=? AND C_AcctSchema_ID=?";
        int Account_ID = 0;
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, C_Charge_ID);
            pstmt.setInt(2, as.getC_AcctSchema_ID());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                Account_ID = rs.getInt(acct_index);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
            return null;
        }
        if (Account_ID == 0) {
            s_log.severe("NO account for C_Charge_ID=" + C_Charge_ID);
            return null;
        }
        MAccount acct = MAccount.get((Ctx)as.getCtx(), (int)Account_ID);
        return acct;
    }

    public static MCharge get(Ctx ctx, int C_Charge_ID) {
        Integer key = new Integer(C_Charge_ID);
        MCharge retValue = (MCharge)((Object)s_cache.get((Object)key));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MCharge(ctx, C_Charge_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)key, (Object)retValue);
        }
        return retValue;
    }

    public MCharge(Ctx ctx, int C_Charge_ID, String trxName) {
        super(ctx, C_Charge_ID, null);
        if (C_Charge_ID == 0) {
            this.setChargeAmt(Env.ZERO);
            this.setIsSameCurrency(false);
            this.setIsSameTax(false);
            this.setIsTaxIncluded(false);
        }
    }

    public MCharge(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord & success) {
            this.insert_Accounting("C_Charge_Acct", "C_AcctSchema_Default", null);
        }
        return success;
    }

    protected boolean beforeDelete() {
        return this.delete_Accounting("C_Charge_Acct");
    }
}

