/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.framework.PO;
import org.compiere.model.MBPartner;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MTax;
import org.compiere.model.X_M_InOutTax;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MInOutTax
extends X_M_InOutTax {
    private static CLogger s_log = CLogger.getCLogger(MInOutTax.class);
    private MTax m_tax = null;
    private Integer m_precision = null;

    public static MInOutTax get(MInOutLine line, int precision, boolean oldTax, String trxName) {
        MInOutTax retValue = null;
        if (line == null || line.getM_InOut_ID() == 0) {
            s_log.fine("No InOut");
            return null;
        }
        int C_Tax_ID = line.getC_Tax_ID();
        if (oldTax && line.is_ValueChanged("C_Tax_ID")) {
            Object old = line.get_ValueOld("C_Tax_ID");
            if (old == null) {
                s_log.fine("No Old Tax");
                return null;
            }
            C_Tax_ID = (Integer)old;
        }
        if (C_Tax_ID == 0) {
            s_log.fine("No Tax");
            return null;
        }
        String sql = "SELECT * FROM M_InOutTax WHERE M_InOut_ID=? AND C_Tax_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, line.getM_InOut_ID());
            pstmt.setInt(2, C_Tax_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MInOutTax(line.getCtx(), rs, trxName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (retValue != null) {
            retValue.setPrecision(precision);
            retValue.set_TrxName(trxName);
            s_log.fine("(old=" + oldTax + ") " + (Object)((Object)retValue));
            return retValue;
        }
        retValue = new MInOutTax(line.getCtx(), 0, trxName);
        retValue.set_TrxName(trxName);
        retValue.setClientOrg((PO)line);
        retValue.setM_InOut_ID(line.getM_InOut_ID());
        retValue.setC_Tax_ID(line.getC_Tax_ID());
        retValue.setPrecision(precision);
        retValue.setIsTaxIncluded(line.isTaxIncluded());
        s_log.fine("(new) " + (Object)((Object)retValue));
        return retValue;
    }

    public MInOutTax(Ctx ctx, int ignored, String trxName) {
        super(ctx, 0, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
        this.setTaxAmt(Env.ZERO);
        this.setTaxBaseAmt(Env.ZERO);
        this.setIsTaxIncluded(false);
    }

    public MInOutTax(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    private int getPrecision() {
        if (this.m_precision == null) {
            return 2;
        }
        return this.m_precision;
    }

    protected void setPrecision(int precision) {
        this.m_precision = new Integer(precision);
    }

    protected MTax getTax() {
        if (this.m_tax == null) {
            this.m_tax = MTax.get(this.getCtx(), this.getC_Tax_ID());
        }
        return this.m_tax;
    }

    public boolean calculateTaxFromLines() {
        BigDecimal taxBaseAmt = Env.ZERO;
        BigDecimal taxAmt = Env.ZERO;
        MInOut inout = new MInOut(this.getCtx(), this.getM_InOut_ID(), this.get_TrxName());
        MBPartner partner = MBPartner.get(this.getCtx(), inout.getC_BPartner_ID());
        boolean documentLevel = this.getTax().isDocumentLevel();
        if (documentLevel) {
            documentLevel = partner.isTaxDocumentLevel(documentLevel);
        }
        MTax tax = this.getTax();
        String sql = "SELECT LineNetAmt FROM M_InOutLine WHERE M_InOut_ID=? AND C_Tax_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getM_InOut_ID());
            pstmt.setInt(2, this.getC_Tax_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                BigDecimal baseAmt = rs.getBigDecimal(1);
                taxBaseAmt = taxBaseAmt.add(baseAmt);
                if (documentLevel) continue;
                taxAmt = taxAmt.add(tax.calculateTax(baseAmt, this.isTaxIncluded(), this.getPrecision(), partner.getTaxRoundModeAsInt()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, this.get_TrxName(), (Throwable)e);
            taxBaseAmt = null;
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (taxBaseAmt == null) {
            return false;
        }
        if (documentLevel) {
            taxAmt = tax.calculateTax(taxBaseAmt, this.isTaxIncluded(), this.getPrecision(), partner.getTaxRoundModeAsInt());
        }
        this.setTaxAmt(taxAmt);
        if (this.isTaxIncluded()) {
            this.setTaxBaseAmt(taxBaseAmt.subtract(taxAmt));
        } else {
            this.setTaxBaseAmt(taxBaseAmt);
        }
        this.log.fine(this.toString());
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MInOutTax[");
        sb.append("M_InOut_ID=").append(this.getM_InOut_ID()).append(",C_Tax_ID=").append(this.getC_Tax_ID()).append(", Base=").append(this.getTaxBaseAmt()).append(",Tax=").append(this.getTaxAmt()).append("]");
        return sb.toString();
    }
}

