/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MInfoColumn;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.X_AD_InfoWindow;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MInfoWindow
extends X_AD_InfoWindow {
    private MInfoColumn[] m_lines = null;
    private String m_tableName = null;

    public MInfoWindow(Ctx ctx, int AD_InfoWindow_ID, String trxName) {
        super(ctx, AD_InfoWindow_ID, trxName);
        if (AD_InfoWindow_ID == 0) {
            this.setEntityType("U");
            this.setIsCustomDefault(false);
        }
    }

    public MInfoWindow(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInfoColumn[] getLines(boolean reload) {
        if (this.m_lines != null && !reload) {
            return this.m_lines;
        }
        String sql = "SELECT * FROM AD_InfoColumn WHERE AD_InfoWindow_ID=? ORDER BY SeqNo";
        ArrayList<MInfoColumn> list = new ArrayList<MInfoColumn>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getAD_InfoWindow_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MInfoColumn(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_lines = new MInfoColumn[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }

    protected String getTableName() {
        if (this.m_tableName == null) {
            MTable table2 = MTable.get((Ctx)this.getCtx(), (int)this.getAD_Table_ID());
            this.m_tableName = table2.get_TableName();
        }
        return this.m_tableName;
    }

    public String getSQL(MRole role) {
        if (this.m_lines == null) {
            this.getLines(true);
        }
        StringBuffer sql = new StringBuffer("SELECT ");
        for (int i = 0; i < this.m_lines.length; ++i) {
            MInfoColumn col = this.m_lines[i];
            if (i > 0) {
                sql.append(",");
            }
            sql.append(col.getSelectClause());
        }
        sql.append(" FROM ").append(this.getFromClause());
        if (role == null) {
            role = MRole.getDefault((Ctx)this.getCtx(), (boolean)false);
        }
        String finalSQL = role.addAccessSQL(sql.toString(), this.getTableName(), true, false);
        this.log.finer(finalSQL);
        return finalSQL;
    }
}

