/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.compiere.api.UICallout;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLineMA;
import org.compiere.model.MProduct;
import org.compiere.model.MStorage;
import org.compiere.model.X_M_InventoryLine;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MInventoryLine
extends X_M_InventoryLine {
    private static CLogger s_log = CLogger.getCLogger(MInventoryLine.class);
    private boolean m_isManualEntry = true;
    private MInventory m_parent = null;
    private MProduct m_product = null;

    public static MInventoryLine get(MInventory inventory, int M_Locator_ID, int M_Product_ID, int M_AttributeSetInstance_ID) {
        MInventoryLine retValue = null;
        String sql = "SELECT * FROM M_InventoryLine WHERE M_Inventory_ID=? AND M_Locator_ID=? AND M_Product_ID=? AND M_AttributeSetInstance_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)inventory.get_TrxName());
            pstmt.setInt(1, inventory.getM_Inventory_ID());
            pstmt.setInt(2, M_Locator_ID);
            pstmt.setInt(3, M_Product_ID);
            pstmt.setInt(4, M_AttributeSetInstance_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MInventoryLine(inventory.getCtx(), rs, inventory.get_TrxName());
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public MInventoryLine(Ctx ctx, int M_InventoryLine_ID, String trxName) {
        super(ctx, M_InventoryLine_ID, trxName);
        if (M_InventoryLine_ID == 0) {
            this.setLine(0);
            this.setM_AttributeSetInstance_ID(0);
            this.setInventoryType("D");
            this.setQtyBook(Env.ZERO);
            this.setQtyCount(Env.ZERO);
            this.setProcessed(false);
        }
    }

    public MInventoryLine(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInventoryLine(MInventory inventory, int M_Locator_ID, int M_Product_ID, int M_AttributeSetInstance_ID, BigDecimal QtyBook, BigDecimal QtyCount) {
        this(inventory.getCtx(), 0, inventory.get_TrxName());
        if (inventory.get_ID() == 0) {
            throw new IllegalArgumentException("Header not saved");
        }
        this.m_parent = inventory;
        this.setM_Inventory_ID(inventory.getM_Inventory_ID());
        this.setClientOrg(inventory.getAD_Client_ID(), inventory.getAD_Org_ID());
        this.setM_Locator_ID(M_Locator_ID);
        this.setM_Product_ID(M_Product_ID);
        this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        if (QtyBook != null) {
            this.setQtyBook(QtyBook);
        }
        if (QtyCount != null && QtyCount.signum() != 0) {
            this.setQtyCount(QtyCount);
        }
        this.m_isManualEntry = false;
    }

    public BigDecimal getQtyBook() {
        BigDecimal bd = super.getQtyBook();
        if (bd == null) {
            bd = Env.ZERO;
        }
        return bd;
    }

    public BigDecimal getQtyCount() {
        BigDecimal bd = super.getQtyCount();
        if (bd == null) {
            bd = Env.ZERO;
        }
        return bd;
    }

    public MProduct getProduct() {
        int M_Product_ID = this.getM_Product_ID();
        if (M_Product_ID == 0) {
            return null;
        }
        if (this.m_product != null && this.m_product.getM_Product_ID() != M_Product_ID) {
            this.m_product = null;
        }
        if (this.m_product == null) {
            this.m_product = MProduct.get(this.getCtx(), M_Product_ID);
        }
        return this.m_product;
    }

    public void setQtyCount(BigDecimal QtyCount) {
        MProduct product;
        if (QtyCount != null && (product = this.getProduct()) != null) {
            int precision = product.getUOMPrecision();
            QtyCount = QtyCount.setScale(precision, 4);
        }
        super.setQtyCount(QtyCount);
    }

    public void setQtyInternalUse(BigDecimal QtyInternalUse) {
        MProduct product;
        if (QtyInternalUse != null && (product = this.getProduct()) != null) {
            int precision = product.getUOMPrecision();
            QtyInternalUse = QtyInternalUse.setScale(precision, 4);
        }
        super.setQtyInternalUse(QtyInternalUse);
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    protected void setParent(MInventory parent) {
        this.m_parent = parent;
    }

    public MInventory getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MInventory(this.getCtx(), this.getM_Inventory_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    @UICallout
    public void setM_Product_ID(String oldM_Product_ID, String newM_Product_ID, int windowNo) throws Exception {
        if (newM_Product_ID == null || newM_Product_ID.length() == 0) {
            return;
        }
        int M_Product_ID = Integer.parseInt(newM_Product_ID);
        super.setM_Product_ID(M_Product_ID);
        if (this.getCtx().getContextAsInt(1113, 1113, "M_Product_ID") == M_Product_ID) {
            int M_AttributeSetInstance_ID = this.getCtx().getContextAsInt(1113, 1113, "M_AttributeSetInstance_ID");
            this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        } else {
            this.setM_AttributeSetInstance_ID(-1);
        }
        this.setQtyBook(windowNo, "M_Product_ID");
    }

    @UICallout
    public void setM_AttributeSetInstance_ID(String oldM_AttributeSetInstance_ID, String newM_AttributeSetInstance_ID, int windowNo) throws Exception {
        if (newM_AttributeSetInstance_ID == null || newM_AttributeSetInstance_ID.length() == 0) {
            return;
        }
        int M_AttributeSetInstance_ID = Integer.parseInt(newM_AttributeSetInstance_ID);
        super.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        this.setQtyBook(windowNo, "M_AttributeSetInstance_ID");
    }

    @UICallout
    public void setM_Locator_ID(String oldM_Locator_ID, String newM_Locator_ID, int windowNo) throws Exception {
        if (newM_Locator_ID == null || newM_Locator_ID.length() == 0) {
            return;
        }
        int M_Locator_ID = Integer.parseInt(newM_Locator_ID);
        super.setM_Locator_ID(M_Locator_ID);
        this.setQtyBook(windowNo, "M_Locator_ID");
    }

    private void setQtyBook(int windowNo, String columnName) {
        int M_Product_ID = this.getM_Product_ID();
        int M_Locator_ID = this.getM_Locator_ID();
        if (M_Product_ID == 0 || M_Locator_ID == 0) {
            this.setQtyBook(Env.ZERO);
            return;
        }
        int M_AttributeSetInstance_ID = this.getM_AttributeSetInstance_ID();
        BigDecimal QtyBook = Env.ZERO;
        String sql = "SELECT QtyOnHand FROM M_Storage WHERE M_Product_ID=? AND M_Locator_ID=? AND M_AttributeSetInstance_ID=?";
        if (M_AttributeSetInstance_ID == 0) {
            sql = "SELECT SUM(QtyOnHand) FROM M_Storage WHERE M_Product_ID=? AND M_Locator_ID=?";
        }
        try {
            ResultSet rs;
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, M_Product_ID);
            pstmt.setInt(2, M_Locator_ID);
            if (M_AttributeSetInstance_ID != 0) {
                pstmt.setInt(3, M_AttributeSetInstance_ID);
            }
            if ((rs = pstmt.executeQuery()).next()) {
                QtyBook = rs.getBigDecimal(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        this.setQtyBook(QtyBook);
        this.log.info("M_Product_ID=" + M_Product_ID + ", M_Locator_ID=" + M_Locator_ID + ", M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID + " - QtyBook=" + QtyBook);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MInventoryLine[");
        sb.append(this.get_ID()).append("-M_Product_ID=").append(this.getM_Product_ID()).append(",QtyCount=").append(this.getQtyCount()).append(",QtyInternalUse=").append(this.getQtyInternalUse()).append(",QtyBook=").append(this.getQtyBook()).append(",M_AttributeSetInstance_ID=").append(this.getM_AttributeSetInstance_ID()).append("]");
        return sb.toString();
    }

    protected boolean beforeSave(boolean newRecord) {
        MAttributeSet mas;
        MProduct product;
        if (newRecord && this.m_isManualEntry && this.getM_AttributeSetInstance_ID() == 0 && (product = MProduct.get(this.getCtx(), this.getM_Product_ID())).getM_AttributeSet_ID() != 0 && (mas = MAttributeSet.get(this.getCtx(), product.getM_AttributeSet_ID())).isInstanceAttribute() && (mas.isMandatory() || mas.isMandatoryAlways())) {
            this.log.saveError("FillMandatory", Msg.getElement((Ctx)this.getCtx(), (String)"M_AttributeSetInstance_ID"));
            return false;
        }
        if (this.getLine() == 0) {
            String sql = "SELECT COALESCE(MAX(Line),0)+10 AS DefaultValue FROM M_InventoryLine WHERE M_Inventory_ID=?";
            int ii = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getM_Inventory_ID());
            this.setLine(ii);
        }
        if (newRecord || this.is_ValueChanged("QtyCount")) {
            this.setQtyCount(this.getQtyCount());
        }
        if (newRecord || this.is_ValueChanged("QtyInternalUse")) {
            this.setQtyInternalUse(this.getQtyInternalUse());
        }
        if (this.isInternalUse() && this.getQtyInternalUse().signum() == 0) {
            this.log.saveError("FillMandatory", Msg.getElement((Ctx)this.getCtx(), (String)"QtyInternalUse"));
            return false;
        }
        if (this.getQtyInternalUse().signum() != 0) {
            if (!"C".equals(this.getInventoryType())) {
                this.setInventoryType("C");
            }
            if (this.getC_Charge_ID() == 0) {
                this.log.saveError("InternalUseNeedsCharge", "");
                return false;
            }
        } else if ("C".equals(this.getInventoryType())) {
            if (this.getC_Charge_ID() == 0) {
                this.log.saveError("FillMandatory", Msg.getElement((Ctx)this.getCtx(), (String)"C_Charge_ID"));
                return false;
            }
        } else if (this.getC_Charge_ID() != 0) {
            this.setC_Charge_ID(0);
        }
        if (this.getC_Charge_ID() == 0) {
            this.setAD_Org_ID(this.getParent().getAD_Org_ID());
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord && success && this.m_isManualEntry && this.getM_AttributeSetInstance_ID() == 0) {
            this.createMA(true);
        }
        return true;
    }

    public void createMA(boolean updateQtyBooked) {
        int delMA = MInventoryLineMA.deleteInventoryLineMA(this.getM_InventoryLine_ID(), this.get_TrxName());
        this.log.info("DeletedMA=" + delMA);
        MStorage[] storages = MStorage.getAll(this.getCtx(), this.getM_Product_ID(), this.getM_Locator_ID(), this.get_TrxName());
        boolean allZeroASI = true;
        for (int i = 0; i < storages.length; ++i) {
            if (storages[i].getM_AttributeSetInstance_ID() == 0) continue;
            allZeroASI = false;
            break;
        }
        if (allZeroASI) {
            return;
        }
        MInventoryLineMA ma = null;
        BigDecimal sum = Env.ZERO;
        for (int i = 0; i < storages.length; ++i) {
            MStorage storage = storages[i];
            if (storage.getQtyOnHand().signum() <= 0) continue;
            if (ma != null && ma.getM_AttributeSetInstance_ID() == storage.getM_AttributeSetInstance_ID()) {
                ma.setMovementQty(ma.getMovementQty().add(storage.getQtyOnHand()));
            } else {
                ma = new MInventoryLineMA(this, storage.getM_AttributeSetInstance_ID(), storage.getQtyOnHand());
            }
            if (!ma.save()) {
                // empty if block
            }
            sum = sum.add(storage.getQtyOnHand());
        }
        if (updateQtyBooked && sum.compareTo(this.getQtyBook()) != 0) {
            this.log.warning("QtyBook=" + this.getQtyBook() + " corrected to Sum of MA=" + sum);
            this.setQtyBook(sum);
        }
    }

    public String getDocStatus() {
        return this.getParent().getDocStatus();
    }
}

