/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.api.UICallout;
import org.compiere.framework.PO;
import org.compiere.model.MBPartner;
import org.compiere.model.MCharge;
import org.compiere.model.MOrg;
import org.compiere.model.MTax;
import org.compiere.model.Tax;
import org.compiere.model.X_C_InvoiceBatchLine;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

public class MInvoiceBatchLine
extends X_C_InvoiceBatchLine {
    public MInvoiceBatchLine(Ctx ctx, int C_InvoiceBatchLine_ID, String trxName) {
        super(ctx, C_InvoiceBatchLine_ID, trxName);
        if (C_InvoiceBatchLine_ID == 0) {
            this.setDateAcct(new Timestamp(System.currentTimeMillis()));
            this.setDateInvoiced(new Timestamp(System.currentTimeMillis()));
            this.setIsTaxIncluded(false);
            this.setLineNetAmt(Env.ZERO);
            this.setLineTotalAmt(Env.ZERO);
            this.setPriceEntered(Env.ZERO);
            this.setQtyEntered(Env.ONE);
            this.setTaxAmt(Env.ZERO);
            this.setProcessed(false);
        }
    }

    public MInvoiceBatchLine(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @UICallout
    public void setC_DocType_ID(String oldC_DocType_ID, String newC_DocType_ID, int windowNo) throws Exception {
        if (newC_DocType_ID == null || newC_DocType_ID.length() == 0) {
            return;
        }
        int C_DocType_ID = Integer.parseInt(newC_DocType_ID);
        this.setC_DocType_ID(C_DocType_ID);
        this.setDocumentNo();
    }

    @UICallout
    public void setDateInvoiced(String oldDateInvoiced, String newDateInvoiced, int windowNo) throws Exception {
        if (newDateInvoiced == null || newDateInvoiced.length() == 0) {
            return;
        }
        Timestamp dateInvoiced = PO.convertToTimestamp((String)newDateInvoiced);
        if (dateInvoiced == null) {
            return;
        }
        this.setDateInvoiced(dateInvoiced);
        this.setDocumentNo();
    }

    public void setDateInvoiced(Timestamp dateOrdered) {
        super.setDateInvoiced(dateOrdered);
        super.setDateAcct(dateOrdered);
    }

    private void setDocumentNo() {
        String sql = "SELECT COALESCE(MAX(C_InvoiceBatchLine_ID),0) FROM C_InvoiceBatchLine WHERE C_InvoiceBatch_ID=?";
        int C_InvoiceBatch_ID = this.getC_InvoiceBatch_ID();
        int C_InvoiceBatchLine_ID = DB.getSQLValue(null, (String)sql, (int)C_InvoiceBatch_ID);
        if (C_InvoiceBatchLine_ID == 0) {
            return;
        }
        MInvoiceBatchLine last = new MInvoiceBatchLine(Env.getCtx(), C_InvoiceBatchLine_ID, null);
        int C_DocType_ID = this.getC_DocType_ID();
        int C_BPartner_ID = this.getC_BPartner_ID();
        if (C_DocType_ID == last.getC_DocType_ID() && C_BPartner_ID == last.getC_BPartner_ID()) {
            return;
        }
        String oldDocNo = last.getDocumentNo();
        if (oldDocNo == null) {
            return;
        }
        int docNo = 0;
        try {
            docNo = Integer.parseInt(oldDocNo);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (docNo == 0) {
            return;
        }
        String newDocNo = String.valueOf(docNo + 1);
        this.setDocumentNo(newDocNo);
    }

    @UICallout
    public void setC_BPartner_ID(String oldC_BPartner_ID, String newC_BPartner_ID, int windowNo) throws Exception {
        if (newC_BPartner_ID == null || newC_BPartner_ID.length() == 0) {
            return;
        }
        int C_BPartner_ID = Integer.parseInt(newC_BPartner_ID);
        if (C_BPartner_ID == 0) {
            return;
        }
        String sql = "SELECT p.AD_Language,p.C_PaymentTerm_ID, COALESCE(p.M_PriceList_ID,g.M_PriceList_ID) AS M_PriceList_ID, p.PaymentRule,p.POReference, p.SO_Description,p.IsDiscountPrinted, p.SO_CreditLimit, p.SO_CreditLimit-p.SO_CreditUsed AS CreditAvailable, l.C_BPartner_Location_ID,c.AD_User_ID, COALESCE(p.PO_PriceList_ID,g.PO_PriceList_ID) AS PO_PriceList_ID, p.PaymentRulePO,p.PO_PaymentTerm_ID FROM C_BPartner p INNER JOIN C_BP_Group g ON (p.C_BP_Group_ID=g.C_BP_Group_ID) LEFT OUTER JOIN C_BPartner_Location l ON (p.C_BPartner_ID=l.C_BPartner_ID AND l.IsBillTo='Y' AND l.IsActive='Y') LEFT OUTER JOIN AD_User c ON (p.C_BPartner_ID=c.C_BPartner_ID) WHERE p.C_BPartner_ID=? AND p.IsActive='Y'";
        boolean IsSOTrx = this.getCtx().isSOTrx(windowNo);
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, C_BPartner_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                BigDecimal CreditLimit;
                int C_BPartner_Location_ID = rs.getInt("C_BPartner_Location_ID");
                if (this.getCtx().getContextAsInt(1113, 1113, "C_BPartner_ID") == C_BPartner_ID) {
                    C_BPartner_Location_ID = this.getCtx().getContextAsInt(1113, 1113, "C_BPartner_Location_ID");
                }
                if (C_BPartner_Location_ID != 0) {
                    this.setC_BPartner_Location_ID(C_BPartner_Location_ID);
                }
                int AD_User_ID = rs.getInt("AD_User_ID");
                if (this.getCtx().getContextAsInt(1113, 1113, "C_BPartner_ID") == C_BPartner_ID) {
                    AD_User_ID = this.getCtx().getContextAsInt(1113, 1113, "AD_User_ID");
                }
                this.setAD_User_ID(AD_User_ID);
                if (IsSOTrx && (CreditLimit = rs.getBigDecimal("SO_CreditLimit")) != null && CreditLimit.signum() != 0) {
                    BigDecimal CreditAvailable = rs.getBigDecimal("CreditAvailable");
                    if (this.p_changeVO != null && CreditAvailable != null && CreditAvailable.signum() < 0) {
                        String msg = Msg.getMsg((Ctx)this.getCtx(), (String)"CreditLimitOver", (Object)DisplayType.getNumberFormat((int)12).format(CreditAvailable));
                        this.p_changeVO.addError(msg);
                    }
                }
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        this.setDocumentNo();
        this.setTax(windowNo, "C_BPartner_ID");
    }

    @UICallout
    public void setC_BPartner_Location_ID(String oldC_BPartner_Location_ID, String newC_BPartner_Location_ID, int windowNo) throws Exception {
        if (newC_BPartner_Location_ID == null || newC_BPartner_Location_ID.length() == 0) {
            return;
        }
        int C_BPartner_Location_ID = Integer.parseInt(newC_BPartner_Location_ID);
        if (C_BPartner_Location_ID == 0) {
            return;
        }
        super.setC_BPartner_Location_ID(C_BPartner_Location_ID);
        this.setTax(windowNo, "C_BPartner_Location_ID");
    }

    @UICallout
    public void setC_Charge_ID(String oldC_Charge_ID, String newC_Charge_ID, int windowNo) throws Exception {
        if (newC_Charge_ID == null || newC_Charge_ID.length() == 0) {
            return;
        }
        int C_Charge_ID = Integer.parseInt(newC_Charge_ID);
        super.setC_Charge_ID(C_Charge_ID);
        MCharge charge = MCharge.get(this.getCtx(), C_Charge_ID);
        this.setPriceEntered(charge.getChargeAmt());
        this.setTax(windowNo, "C_Charge_ID");
    }

    private void setTax(int windowNo, String columnName) {
        int C_Charge_ID = this.getC_Charge_ID();
        this.log.fine("C_Charge_ID=" + C_Charge_ID);
        if (C_Charge_ID == 0) {
            this.setAmt(windowNo, columnName);
            return;
        }
        int C_BPartner_Location_ID = this.getC_BPartner_Location_ID();
        this.log.fine("BP_Location=" + C_BPartner_Location_ID);
        if (C_BPartner_Location_ID == 0) {
            this.setAmt(windowNo, columnName);
            return;
        }
        Timestamp billDate = this.getDateInvoiced();
        this.log.fine("Bill Date=" + billDate);
        Timestamp shipDate = billDate;
        this.log.fine("Ship Date=" + shipDate);
        int AD_Org_ID = this.getAD_Org_ID();
        this.log.fine("Org=" + AD_Org_ID);
        MOrg org = MOrg.get((Ctx)this.getCtx(), (int)AD_Org_ID);
        int M_Warehouse_ID = org.getM_Warehouse_ID();
        this.log.fine("Warehouse=" + M_Warehouse_ID);
        boolean isSOTrx = this.getCtx().isSOTrx(windowNo);
        int C_Tax_ID = Tax.get(this.getCtx(), 0, C_Charge_ID, billDate, shipDate, AD_Org_ID, M_Warehouse_ID, C_BPartner_Location_ID, C_BPartner_Location_ID, isSOTrx);
        this.log.info("Tax ID=" + C_Tax_ID + " - SOTrx=" + isSOTrx);
        if (C_Tax_ID == 0) {
            ValueNamePair pp = CLogger.retrieveError();
            if (pp != null) {
                this.p_changeVO.addError(pp.getValue());
            } else {
                this.p_changeVO.addError("Tax Error");
            }
        } else {
            super.setC_Tax_ID(C_Tax_ID);
        }
        this.setAmt(windowNo, columnName);
    }

    @UICallout
    public void setC_Tax_ID(String oldC_Tax_ID, String newC_Tax_ID, int windowNo) throws Exception {
        if (newC_Tax_ID == null || newC_Tax_ID.length() == 0) {
            return;
        }
        int C_Tax_ID = Integer.parseInt(newC_Tax_ID);
        this.setC_Tax_ID(C_Tax_ID);
        this.setAmt(windowNo, "C_Tax_ID");
    }

    @UICallout
    public void setIsTaxIncluded(String oldIsTaxIncluded, String newIsTaxIncluded, int windowNo) throws Exception {
        boolean IsTaxIncluded = "Y".equals(newIsTaxIncluded);
        this.setIsTaxIncluded(IsTaxIncluded);
        this.setAmt(windowNo, "IsTaxIncluded");
    }

    @UICallout
    public void setPriceEntered(String oldPriceEntered, String newPriceEntered, int windowNo) throws Exception {
        if (newPriceEntered == null || newPriceEntered.length() == 0) {
            return;
        }
        BigDecimal PriceEntered = new BigDecimal(newPriceEntered);
        super.setPriceEntered(PriceEntered);
        this.setAmt(windowNo, "PriceEntered");
    }

    @UICallout
    public void setQtyEntered(String oldQtyEntered, String newQtyEntered, int windowNo) throws Exception {
        if (newQtyEntered == null || newQtyEntered.length() == 0) {
            return;
        }
        BigDecimal QtyEntered = new BigDecimal(newQtyEntered);
        super.setQtyEntered(QtyEntered);
        this.setAmt(windowNo, "QtyEntered");
    }

    private void setAmt(int windowNo, String columnName) {
        MBPartner partner = MBPartner.get(this.getCtx(), this.getC_BPartner_ID());
        BigDecimal QtyEntered = this.getQtyEntered();
        BigDecimal PriceEntered = this.getPriceEntered();
        this.log.fine("QtyEntered=" + QtyEntered + ", PriceEntered=" + PriceEntered);
        if (QtyEntered == null) {
            QtyEntered = Env.ZERO;
        }
        if (PriceEntered == null) {
            PriceEntered = Env.ZERO;
        }
        BigDecimal LineNetAmt = QtyEntered.multiply(PriceEntered);
        int StdPrecision = this.getCtx().getStdPrecision();
        if (LineNetAmt.scale() > StdPrecision) {
            LineNetAmt = LineNetAmt.setScale(StdPrecision, 4);
        }
        boolean IsTaxIncluded = this.isTaxIncluded();
        BigDecimal TaxAmt = null;
        if (columnName.equals("TaxAmt")) {
            TaxAmt = this.getTaxAmt();
        } else {
            int C_Tax_ID = this.getC_Tax_ID();
            if (C_Tax_ID != 0) {
                MTax tax = new MTax(this.getCtx(), C_Tax_ID, null);
                TaxAmt = tax.calculateTax(LineNetAmt, IsTaxIncluded, StdPrecision, partner.getTaxRoundModeAsInt());
                this.setTaxAmt(TaxAmt);
            }
        }
        if (IsTaxIncluded) {
            this.setLineTotalAmt(LineNetAmt);
            this.setLineNetAmt(LineNetAmt.subtract(TaxAmt));
        } else {
            this.setLineNetAmt(LineNetAmt);
            this.setLineTotalAmt(LineNetAmt.add(TaxAmt));
        }
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getPriceEntered().signum() == 0) {
            this.log.saveError("FillMandatory", Msg.getElement((Ctx)this.getCtx(), (String)"PriceEntered"));
            return false;
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (success) {
            String sql = "UPDATE C_InvoiceBatch h SET DocumentAmt = NVL((SELECT SUM(LineTotalAmt) FROM C_InvoiceBatchLine l WHERE h.C_InvoiceBatch_ID=l.C_InvoiceBatch_ID AND l.IsActive='Y'),0) WHERE C_InvoiceBatch_ID=" + this.getC_InvoiceBatch_ID();
            DB.executeUpdate((String)sql, (String)this.get_TrxName());
        }
        return success;
    }
}

