/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import org.compiere.api.UICallout;
import org.compiere.framework.PO;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MElementValue;
import org.compiere.model.MJournal;
import org.compiere.model.X_GL_JournalLine;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MJournalLine
extends X_GL_JournalLine {
    private int m_precision = 2;
    private MAccount m_account = null;
    private MElementValue m_accountElement = null;

    public MJournalLine(Ctx ctx, int GL_JournalLine_ID, String trxName) {
        super(ctx, GL_JournalLine_ID, trxName);
        if (GL_JournalLine_ID == 0) {
            this.setLine(0);
            this.setAmtAcctCr(Env.ZERO);
            this.setAmtAcctDr(Env.ZERO);
            this.setAmtSourceCr(Env.ZERO);
            this.setAmtSourceDr(Env.ZERO);
            this.setCurrencyRate(Env.ONE);
            this.setDateAcct(new Timestamp(System.currentTimeMillis()));
            this.setIsGenerated(true);
        }
    }

    public MJournalLine(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MJournalLine(MJournal parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg((PO)parent);
        this.setGL_Journal_ID(parent.getGL_Journal_ID());
        this.setC_Currency_ID(parent.getC_Currency_ID());
        this.setC_ConversionType_ID(parent.getC_ConversionType_ID());
        this.setDateAcct(parent.getDateAcct());
    }

    public void setCurrency(int C_Currency_ID, int C_ConversionType_ID, BigDecimal CurrencyRate) {
        this.setC_Currency_ID(C_Currency_ID);
        if (C_ConversionType_ID != 0) {
            this.setC_ConversionType_ID(C_ConversionType_ID);
        }
        if (CurrencyRate != null && CurrencyRate.signum() == 0) {
            this.setCurrencyRate(CurrencyRate);
        }
    }

    public void setC_Currency_ID(int C_Currency_ID) {
        if (C_Currency_ID == 0) {
            return;
        }
        super.setC_Currency_ID(C_Currency_ID);
        this.m_precision = MCurrency.getStdPrecision((Ctx)this.getCtx(), (int)C_Currency_ID);
    }

    public int getPrecision() {
        return this.m_precision;
    }

    public void setCurrencyRate(BigDecimal CurrencyRate) {
        if (CurrencyRate == null) {
            this.log.warning("was NULL - set to 1");
            super.setCurrencyRate(Env.ONE);
        } else if (CurrencyRate.signum() < 0) {
            this.log.warning("negative - " + CurrencyRate + " - set to 1");
            super.setCurrencyRate(Env.ONE);
        } else {
            super.setCurrencyRate(CurrencyRate);
        }
    }

    @UICallout
    public void setC_ConversionType_ID(String oldC_ConversionType_ID, String newC_ConversionType_ID, int windowNo) throws Exception {
        if (newC_ConversionType_ID == null || newC_ConversionType_ID.length() == 0) {
            return;
        }
        int C_ConversionType_ID = Integer.parseInt(newC_ConversionType_ID);
        if (C_ConversionType_ID == 0) {
            return;
        }
        this.setC_ConversionType_ID(C_ConversionType_ID);
        this.setRate(windowNo);
    }

    @UICallout
    public void setC_Currency_ID(String oldC_Currency_ID, String newC_Currency_ID, int windowNo) throws Exception {
        if (newC_Currency_ID == null || newC_Currency_ID.length() == 0) {
            return;
        }
        int C_Currency_ID = Integer.parseInt(newC_Currency_ID);
        if (C_Currency_ID == 0) {
            return;
        }
        this.setC_Currency_ID(C_Currency_ID);
        this.setRate(windowNo);
    }

    private void setRate(int windowNo) {
        int C_Currency_ID = this.getC_Currency_ID();
        int C_ConversionType_ID = this.getC_ConversionType_ID();
        if (C_Currency_ID == 0 || C_ConversionType_ID == 0) {
            return;
        }
        Timestamp DateAcct = this.getDateAcct();
        if (DateAcct == null) {
            DateAcct = new Timestamp(System.currentTimeMillis());
        }
        int C_AcctSchema_ID = this.getCtx().getContextAsInt(windowNo, "C_AcctSchema_ID");
        MAcctSchema as = MAcctSchema.get((Ctx)this.getCtx(), (int)C_AcctSchema_ID);
        int AD_Client_ID = this.getAD_Client_ID();
        int AD_Org_ID = this.getAD_Org_ID();
        BigDecimal CurrencyRate = MConversionRate.getRate((int)C_Currency_ID, (int)as.getC_Currency_ID(), (Timestamp)DateAcct, (int)C_ConversionType_ID, (int)AD_Client_ID, (int)AD_Org_ID);
        this.log.fine("rate = " + CurrencyRate);
        if (CurrencyRate == null) {
            CurrencyRate = Env.ZERO;
        }
        this.setCurrencyRate(CurrencyRate);
        this.setAmt(windowNo);
    }

    public void setAmtAcct(BigDecimal AmtAcctDr, BigDecimal AmtAcctCr) {
        double rateDR = 0.0;
        if (AmtAcctDr != null && AmtAcctDr.signum() != 0) {
            rateDR = AmtAcctDr.doubleValue() / this.getAmtSourceDr().doubleValue();
            super.setAmtAcctDr(AmtAcctDr);
        }
        double rateCR = 0.0;
        if (AmtAcctCr != null && AmtAcctCr.signum() != 0) {
            rateCR = AmtAcctCr.doubleValue() / this.getAmtSourceCr().doubleValue();
            super.setAmtAcctCr(AmtAcctCr);
        }
        if (rateDR != 0.0 && rateCR != 0.0 && rateDR != rateCR) {
            this.log.warning("Rates Different DR=" + rateDR + "(used) <> CR=" + rateCR + "(ignored)");
            rateCR = 0.0;
        }
        if (rateDR < 0.0 || Double.isInfinite(rateDR) || Double.isNaN(rateDR)) {
            this.log.warning("DR Rate ignored - " + rateDR);
            return;
        }
        if (rateCR < 0.0 || Double.isInfinite(rateCR) || Double.isNaN(rateCR)) {
            this.log.warning("CR Rate ignored - " + rateCR);
            return;
        }
        if (rateDR != 0.0) {
            this.setCurrencyRate(new BigDecimal(rateDR));
        }
        if (rateCR != 0.0) {
            this.setCurrencyRate(new BigDecimal(rateCR));
        }
    }

    @UICallout
    public void setAmtSourceCr(String oldAmtSourceCr, String newAmtSourceCr, int windowNo) throws Exception {
        if (newAmtSourceCr == null || newAmtSourceCr.length() == 0) {
            return;
        }
        BigDecimal AmtSourceCr = new BigDecimal(newAmtSourceCr);
        super.setAmtSourceCr(AmtSourceCr);
        this.setAmt(windowNo);
    }

    @UICallout
    public void setAmtSourceDr(String oldAmtSourceDr, String newAmtSourceDr, int windowNo) throws Exception {
        if (newAmtSourceDr == null || newAmtSourceDr.length() == 0) {
            return;
        }
        BigDecimal AmtSourceDr = new BigDecimal(newAmtSourceDr);
        super.setAmtSourceDr(AmtSourceDr);
        this.setAmt(windowNo);
    }

    @UICallout
    public void setCurrencyRate(String oldCurrencyRate, String newCurrencyRate, int windowNo) throws Exception {
        if (newCurrencyRate == null || newCurrencyRate.length() == 0) {
            return;
        }
        BigDecimal CurrencyRate = new BigDecimal(newCurrencyRate);
        super.setCurrencyRate(CurrencyRate);
        this.setAmt(windowNo);
    }

    private void setAmt(int windowNo) {
        BigDecimal AmtSourceCr;
        BigDecimal AmtSourceDr;
        int C_AcctSchema_ID = this.getCtx().getContextAsInt(windowNo, "C_AcctSchema_ID");
        MAcctSchema as = MAcctSchema.get((Ctx)this.getCtx(), (int)C_AcctSchema_ID);
        int Precision = as.getStdPrecision();
        BigDecimal CurrencyRate = this.getCurrencyRate();
        if (CurrencyRate == null) {
            CurrencyRate = Env.ONE;
            this.setCurrencyRate(CurrencyRate);
        }
        if ((AmtSourceDr = this.getAmtSourceDr()) == null) {
            AmtSourceDr = Env.ZERO;
        }
        if ((AmtSourceCr = this.getAmtSourceCr()) == null) {
            AmtSourceCr = Env.ZERO;
        }
        BigDecimal AmtAcctDr = AmtSourceDr.multiply(CurrencyRate);
        AmtAcctDr = AmtAcctDr.setScale(Precision, 4);
        this.setAmtAcctDr(AmtAcctDr);
        BigDecimal AmtAcctCr = AmtSourceCr.multiply(CurrencyRate);
        AmtAcctCr = AmtAcctCr.setScale(Precision, 4);
        this.setAmtAcctCr(AmtAcctCr);
    }

    public void setC_ValidCombination_ID(int C_ValidCombination_ID) {
        super.setC_ValidCombination_ID(C_ValidCombination_ID);
        this.m_account = null;
        this.m_accountElement = null;
    }

    public void setC_ValidCombination_ID(MAccount acct) {
        if (acct == null) {
            throw new IllegalArgumentException("Account is null");
        }
        super.setC_ValidCombination_ID(acct.getC_ValidCombination_ID());
        this.m_account = acct;
        this.m_accountElement = null;
    }

    public MAccount getAccount() {
        if (this.m_account == null && this.getC_ValidCombination_ID() != 0) {
            this.m_account = new MAccount(this.getCtx(), this.getC_ValidCombination_ID(), this.get_TrxName());
        }
        return this.m_account;
    }

    public MElementValue getAccountElementValue() {
        MAccount vc;
        if (this.m_accountElement == null && (vc = this.getAccount()) != null && vc.getAccount_ID() != 0) {
            this.m_accountElement = new MElementValue(this.getCtx(), vc.getAccount_ID(), this.get_TrxName());
        }
        return this.m_accountElement;
    }

    public boolean isDocControlled() {
        MElementValue acct = this.getAccountElementValue();
        if (acct == null) {
            this.log.warning("Account not found for C_ValidCombination_ID=" + this.getC_ValidCombination_ID());
            return false;
        }
        return acct.isDocControlled();
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getAccount_ID() != 0 && !this.isGenerated()) {
            MJournal journal = new MJournal(this.getCtx(), this.getGL_Journal_ID(), this.get_TrxName());
            if (!journal.isProcessed()) {
                this.m_account = MAccount.get((Ctx)this.getCtx(), (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID(), (int)journal.getC_AcctSchema_ID(), (int)this.getAccount_ID(), (int)this.getC_SubAcct_ID(), (int)this.getM_Product_ID(), (int)this.getC_BPartner_ID(), (int)this.getAD_OrgTrx_ID(), (int)this.getC_LocFrom_ID(), (int)this.getC_LocTo_ID(), (int)this.getC_SalesRegion_ID(), (int)this.getC_Project_ID(), (int)this.getC_Campaign_ID(), (int)this.getC_Activity_ID(), (int)this.getUser1_ID(), (int)this.getUser2_ID(), (int)this.getUserElement1_ID(), (int)this.getUserElement2_ID());
                this.setC_ValidCombination_ID(this.m_account.getC_ValidCombination_ID());
            }
        } else if (this.getAccount() != null) {
            this.setAccount_ID(this.m_account.getAccount_ID());
            this.setC_SubAcct_ID(this.m_account.getC_SubAcct_ID());
            this.setC_BPartner_ID(this.m_account.getC_BPartner_ID());
            this.setM_Product_ID(this.m_account.getM_Product_ID());
            this.setAD_OrgTrx_ID(this.m_account.getAD_OrgTrx_ID());
            this.setC_Project_ID(this.m_account.getC_Project_ID());
            this.setC_Activity_ID(this.m_account.getC_Activity_ID());
            this.setC_Campaign_ID(this.m_account.getC_Campaign_ID());
            this.setC_SalesRegion_ID(this.m_account.getC_SalesRegion_ID());
            this.setC_LocFrom_ID(this.m_account.getC_LocFrom_ID());
            this.setC_LocTo_ID(this.m_account.getC_LocTo_ID());
            this.setUser1_ID(this.m_account.getUser1_ID());
            this.setUser2_ID(this.m_account.getUser2_ID());
            this.setUserElement1_ID(this.m_account.getUserElement1_ID());
            this.setUserElement2_ID(this.m_account.getUserElement2_ID());
        }
        BigDecimal rate = this.getCurrencyRate();
        BigDecimal amt = rate.multiply(this.getAmtSourceDr());
        if (amt.scale() > this.getPrecision()) {
            amt = amt.setScale(this.getPrecision(), 4);
        }
        this.setAmtAcctDr(amt);
        amt = rate.multiply(this.getAmtSourceCr());
        if (amt.scale() > this.getPrecision()) {
            amt = amt.setScale(this.getPrecision(), 4);
        }
        this.setAmtAcctCr(amt);
        if (newRecord || this.is_ValueChanged("C_ValidCombination_ID") || this.is_ValueChanged("AD_Org_ID")) {
            this.setAD_Org_ID(this.getAccount().getAD_Org_ID());
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        return this.updateJournalTotal();
    }

    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        return this.updateJournalTotal();
    }

    private boolean updateJournalTotal() {
        String sql = "UPDATE GL_Journal j SET (TotalDr, TotalCr) = (SELECT COALESCE(SUM(AmtSourceDr),0), COALESCE(SUM(AmtSourceCr),0) FROM GL_JournalLine jl WHERE jl.IsActive='Y' AND j.GL_Journal_ID=jl.GL_Journal_ID) WHERE GL_Journal_ID=" + this.getGL_Journal_ID();
        int no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        if (no != 1) {
            this.log.warning("afterSave - Update Journal #" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = "UPDATE GL_JournalBatch jb SET (TotalDr, TotalCr) = (SELECT COALESCE(SUM(TotalDr),0), COALESCE(SUM(TotalCr),0) FROM GL_Journal j WHERE jb.GL_JournalBatch_ID=j.GL_JournalBatch_ID) WHERE GL_JournalBatch_ID=(SELECT DISTINCT GL_JournalBatch_ID FROM GL_Journal WHERE GL_Journal_ID=" + this.getGL_Journal_ID() + ")"), (String)this.get_TrxName())) != 1) {
            this.log.warning("Update Batch #" + no);
        }
        return no == 1;
    }
}

