/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttachmentEntry;
import org.compiere.model.MImage;
import org.compiere.model.MMediaDeploy;
import org.compiere.model.MMediaServer;
import org.compiere.model.MWebProject;
import org.compiere.model.X_CM_Media;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MMedia
extends X_CM_Media {
    private static CLogger s_log = CLogger.getCLogger(MMedia.class);
    private MWebProject m_project = null;

    public static MMedia[] getMedia(MWebProject project) {
        ArrayList<MMedia> list = new ArrayList<MMedia>();
        CPreparedStatement pstmt = null;
        String sql = "SELECT * FROM CM_Media WHERE CM_WebProject_ID=? ORDER BY CM_Media_ID";
        try {
            pstmt = DB.prepareStatement((String)sql, (String)project.get_TrxName());
            pstmt.setInt(1, project.getCM_WebProject_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MMedia(project.getCtx(), rs, project.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MMedia[] retValue = new MMedia[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MMedia(Ctx ctx, int CM_Media_ID, String trxName) {
        super(ctx, CM_Media_ID, trxName);
    }

    public MMedia(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MMedia[] getMediaToDeploy(Ctx ctx, int CM_Media_Server_ID, String trxName) {
        ArrayList<MMedia> list = new ArrayList<MMedia>();
        CPreparedStatement pstmt = null;
        String sql = "SELECT CMM.* FROM CM_Media CMM, CM_MediaDeploy CMMD WHERE CMM.CM_Media_ID = CMMD.CM_Media_ID AND CMMD.CM_Media_Server_ID = ? AND CMMD.IsDeployed='N' ORDER BY CMM.CM_Media_ID";
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, CM_Media_Server_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MMedia(ctx, rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MMedia[] retValue = new MMedia[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MMedia getByName(Ctx ctx, String Name, int CM_WebProject_Id, String trxName) {
        MMedia thisMedia = null;
        String sql = "SELECT * FROM CM_Media WHERE (LOWER(Name) LIKE ?) AND CM_WebProject_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setString(1, Name.toLowerCase());
            pstmt.setInt(2, CM_WebProject_Id);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                thisMedia = new MMedia(ctx, rs, trxName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return thisMedia;
    }

    public MWebProject getWebProject() {
        if (this.m_project == null) {
            this.m_project = MWebProject.get(this.getCtx(), this.getCM_WebProject_ID());
        }
        return this.m_project;
    }

    public int getAD_Tree_ID() {
        return this.getWebProject().getAD_TreeCMM_ID();
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.isSummary()) {
            this.setMediaType(null);
            this.setAD_Image_ID(0);
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (newRecord) {
            StringBuffer sb = new StringBuffer("INSERT INTO AD_TreeNodeCMM (AD_Client_ID,AD_Org_ID, IsActive,Created,CreatedBy,Updated,UpdatedBy, AD_Tree_ID, Node_ID, Parent_ID, SeqNo) VALUES (").append(this.getAD_Client_ID()).append(",0, 'Y', SysDate, 0, SysDate, 0,").append(this.getAD_Tree_ID()).append(",").append(this.get_ID()).append(", 0, 999)");
            int no = DB.executeUpdate((String)sb.toString(), (String)this.get_TrxName());
            if (no > 0) {
                this.log.fine("#" + no + " - TreeType=CMM");
            } else {
                this.log.warning("#" + no + " - TreeType=CMM");
            }
            return no > 0;
        }
        MMediaServer[] theseServers = MMediaServer.getMediaServer(this.m_project);
        if (theseServers != null && theseServers.length > 0) {
            for (int i = 0; i < theseServers.length; ++i) {
                MMediaDeploy thisDeploy = MMediaDeploy.getByMedia(this.getCtx(), this.get_ID(), theseServers[i].get_ID(), true, this.get_TrxName());
                if (!thisDeploy.isDeployed()) continue;
                thisDeploy.setIsDeployed(false);
                thisDeploy.save();
            }
        }
        return success;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MMedia[ID=").append(this.get_ID()).append(",FileName=").append(this.get_ID() + this.getExtension()).append("]");
        return sb.toString();
    }

    protected boolean beforeDelete() {
        StringBuffer sb;
        int no;
        MMediaDeploy[] theseDeployers = MMediaDeploy.getByMediaAndProject(this.getCtx(), this.get_IDOld(), this.m_project, false, this.get_TrxName());
        if (theseDeployers != null && theseDeployers.length > 0) {
            for (int i = 0; i < theseDeployers.length; ++i) {
                if (theseDeployers[i].getServer().deleteMediaItem(this)) continue;
                this.log.warning("Could not delete file + " + this.toString() + " from Server: " + (Object)((Object)theseDeployers[i].getServer()));
            }
        }
        if ((no = DB.executeUpdate((String)(sb = new StringBuffer("DELETE FROM CM_MediaDeploy ").append(" WHERE CM_Media_ID=").append(this.get_IDOld())).toString(), (String)this.get_TrxName())) > 0) {
            this.log.fine("#" + no + " - CM_MediaDeploy");
        } else {
            this.log.warning("#" + no + " - CM_MediaDeploy");
        }
        return true;
    }

    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        StringBuffer sb = new StringBuffer("DELETE FROM AD_TreeNodeCMM ").append(" WHERE Node_ID=").append(this.get_IDOld()).append(" AND AD_Tree_ID=").append(this.getAD_Tree_ID());
        int no = DB.executeUpdate((String)sb.toString(), (String)this.get_TrxName());
        if (no > 0) {
            this.log.fine("#" + no + " - TreeType=CMM");
        } else {
            this.log.warning("#" + no + " - TreeType=CMM");
        }
        return no > 0;
    }

    public String getFileName() {
        return this.get_ID() + this.getExtension();
    }

    public String getExtension() {
        String mt = this.getMediaType();
        if ("PDF".equals(mt)) {
            return ".pdf";
        }
        if ("GIF".equals(mt)) {
            return ".gif";
        }
        if ("JPG".equals(mt)) {
            return ".jpg";
        }
        if ("PNG".equals(mt)) {
            return ".png";
        }
        if ("CSS".equals(mt)) {
            return ".css";
        }
        if ("JS".equals(mt)) {
            return ".js";
        }
        return ".dat";
    }

    public MImage getImage() {
        if (this.getAD_Image_ID() != 0) {
            return MImage.get(this.getCtx(), this.getAD_Image_ID());
        }
        return null;
    }

    public byte[] getData() {
        MAttachmentEntry entry;
        MAttachment att;
        byte[] data;
        MImage image = this.getImage();
        if (image != null && ((data = image.getData()) == null || data.length == 0)) {
            this.log.config("No Image Data");
        }
        if ((att = this.getAttachment()) == null || att.getEntryCount() == 0) {
            this.log.config("No Attachment");
            return null;
        }
        if (att.getEntryCount() > 1) {
            this.log.warning(this.getName() + " - more then one attachment - " + att.getEntryCount());
        }
        if ((entry = att.getEntry(0)) == null) {
            this.log.config("No Attachment Entry");
            return null;
        }
        byte[] buffer = entry.getData();
        if (buffer == null || buffer.length == 0) {
            this.log.config("No Attachment Entry Data");
            return null;
        }
        return buffer;
    }

    public InputStream getInputStream() {
        byte[] buffer = this.getData();
        ByteArrayInputStream is = new ByteArrayInputStream(buffer);
        return is;
    }

    public Timestamp getAttachmentUpdated() {
        MAttachment att = this.getAttachment();
        if (att == null) {
            return null;
        }
        return att.getUpdated();
    }
}

