/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.framework.ModelValidationEngine;
import org.compiere.framework.PO;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MMovementConfirm;
import org.compiere.model.MMovementLine;
import org.compiere.model.MMovementLineMA;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.MStorage;
import org.compiere.model.MTransaction;
import org.compiere.model.X_M_Movement;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MMovement
extends X_M_Movement
implements DocAction {
    private MMovementLine[] m_lines = null;
    private MMovementConfirm[] m_confirms = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MMovement(Ctx ctx, int M_Movement_ID, String trxName) {
        super(ctx, M_Movement_ID, trxName);
        if (M_Movement_ID == 0) {
            this.setDocAction("CO");
            this.setDocStatus("DR");
            this.setIsApproved(false);
            this.setIsInTransit(false);
            this.setMovementDate(new Timestamp(System.currentTimeMillis()));
            this.setPosted(false);
            super.setProcessed(false);
        }
    }

    public MMovement(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MMovementLine[] getLines(boolean requery) {
        if (this.m_lines != null && !requery) {
            return this.m_lines;
        }
        ArrayList<MMovementLine> list = new ArrayList<MMovementLine>();
        String sql = "SELECT * FROM M_MovementLine WHERE M_Movement_ID=? ORDER BY Line";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getM_Movement_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MMovementLine(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "getLines", (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_lines = new MMovementLine[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }

    public MMovementConfirm[] getConfirmations(boolean requery) {
        if (this.m_confirms != null && !requery) {
            return this.m_confirms;
        }
        ArrayList<MMovementConfirm> list = new ArrayList<MMovementConfirm>();
        String sql = "SELECT * FROM M_MovementConfirm WHERE M_Movement_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getM_Movement_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MMovementConfirm(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "getConfirmations", (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_confirms = new MMovementConfirm[list.size()];
        list.toArray(this.m_confirms);
        return this.m_confirms;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public String getDocumentInfo() {
        MDocType dt = MDocType.get((Ctx)this.getCtx(), (int)this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getC_DocType_ID() == 0) {
            MDocType[] types = MDocType.getOfDocBaseType((Ctx)this.getCtx(), (String)"MMM");
            if (types.length > 0) {
                this.setC_DocType_ID(types[0].getC_DocType_ID());
            } else {
                this.log.saveError("Error", Msg.parseTranslation((Ctx)this.getCtx(), (String)"@NotFound@ @C_DocType_ID@"));
                return false;
            }
        }
        return true;
    }

    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String sql = "UPDATE M_MovementLine SET Processed='" + (processed ? "Y" : "N") + "' WHERE M_Movement_ID=" + this.getM_Movement_ID();
        int noLine = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        this.m_lines = null;
        this.log.fine("Processed=" + processed + " - Lines=" + noLine);
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        this.log.info(this.toString());
        this.setProcessing(false);
        return true;
    }

    public boolean invalidateIt() {
        this.log.info(this.toString());
        this.setDocAction("PR");
        return true;
    }

    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get((Ctx)this.getCtx(), (int)this.getC_DocType_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.getMovementDate(), dt.getDocBaseType())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        MMovementLine[] lines = this.getLines(false);
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        if (dt.isInTransit()) {
            this.createConfirmation();
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    private void createConfirmation() {
        MMovementConfirm[] confirmations = this.getConfirmations(false);
        if (confirmations.length > 0) {
            return;
        }
        MMovementConfirm.create(this, false);
    }

    public boolean approveIt() {
        this.log.info(this.toString());
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        this.log.info(this.toString());
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        MMovementConfirm[] confirmations = this.getConfirmations(true);
        for (int i = 0; i < confirmations.length; ++i) {
            MMovementConfirm confirm = confirmations[i];
            if (confirm.isProcessed()) continue;
            this.m_processMsg = "Open: @M_MovementConfirm_ID@ - " + confirm.getDocumentNo();
            return "IP";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        MMovementLine[] lines = this.getLines(false);
        for (int i = 0; i < lines.length; ++i) {
            MStorage storageTo;
            MMovementLine line = lines[i];
            this.checkMaterialPolicy(line);
            MTransaction trxFrom = null;
            if (line.getM_AttributeSetInstance_ID() == 0) {
                MMovementLineMA[] mas = MMovementLineMA.get(this.getCtx(), line.getM_MovementLine_ID(), this.get_TrxName());
                for (int j = 0; j < mas.length; ++j) {
                    MStorage storageTo2;
                    MMovementLineMA ma = mas[j];
                    MStorage storageFrom = MStorage.get(this.getCtx(), line.getM_Locator_ID(), line.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), this.get_TrxName());
                    if (storageFrom == null) {
                        storageFrom = MStorage.getCreate(this.getCtx(), line.getM_Locator_ID(), line.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), this.get_TrxName());
                    }
                    if ((storageTo2 = MStorage.get(this.getCtx(), line.getM_LocatorTo_ID(), line.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), this.get_TrxName())) == null) {
                        storageTo2 = MStorage.getCreate(this.getCtx(), line.getM_LocatorTo_ID(), line.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), this.get_TrxName());
                    }
                    storageFrom.setQtyOnHand(storageFrom.getQtyOnHand().subtract(ma.getMovementQty()));
                    if (!storageFrom.save(this.get_TrxName())) {
                        this.m_processMsg = "Storage From not updated (MA)";
                        return "IN";
                    }
                    storageTo2.setQtyOnHand(storageTo2.getQtyOnHand().add(ma.getMovementQty()));
                    if (!storageTo2.save(this.get_TrxName())) {
                        this.m_processMsg = "Storage To not updated (MA)";
                        return "IN";
                    }
                    trxFrom = new MTransaction(this.getCtx(), line.getAD_Org_ID(), "M-", line.getM_Locator_ID(), line.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), ma.getMovementQty().negate(), this.getMovementDate(), this.get_TrxName());
                    trxFrom.setM_MovementLine_ID(line.getM_MovementLine_ID());
                    if (!trxFrom.save()) {
                        this.m_processMsg = "Transaction From not inserted (MA)";
                        return "IN";
                    }
                    MTransaction trxTo = new MTransaction(this.getCtx(), line.getAD_Org_ID(), "M+", line.getM_LocatorTo_ID(), line.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), ma.getMovementQty(), this.getMovementDate(), this.get_TrxName());
                    trxTo.setM_MovementLine_ID(line.getM_MovementLine_ID());
                    if (trxTo.save()) continue;
                    this.m_processMsg = "Transaction To not inserted (MA)";
                    return "IN";
                }
            }
            if (trxFrom != null) continue;
            MStorage storageFrom = MStorage.get(this.getCtx(), line.getM_Locator_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), this.get_TrxName());
            if (storageFrom == null) {
                storageFrom = MStorage.getCreate(this.getCtx(), line.getM_Locator_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), this.get_TrxName());
            }
            if ((storageTo = MStorage.get(this.getCtx(), line.getM_LocatorTo_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstanceTo_ID(), this.get_TrxName())) == null) {
                storageTo = MStorage.getCreate(this.getCtx(), line.getM_LocatorTo_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstanceTo_ID(), this.get_TrxName());
            }
            storageFrom.setQtyOnHand(storageFrom.getQtyOnHand().subtract(line.getMovementQty()));
            if (!storageFrom.save(this.get_TrxName())) {
                this.m_processMsg = "Storage From not updated";
                return "IN";
            }
            storageTo.setQtyOnHand(storageTo.getQtyOnHand().add(line.getMovementQty()));
            if (!storageTo.save(this.get_TrxName())) {
                this.m_processMsg = "Storage To not updated";
                return "IN";
            }
            trxFrom = new MTransaction(this.getCtx(), line.getAD_Org_ID(), "M-", line.getM_Locator_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.getMovementQty().negate(), this.getMovementDate(), this.get_TrxName());
            trxFrom.setM_MovementLine_ID(line.getM_MovementLine_ID());
            if (!trxFrom.save()) {
                this.m_processMsg = "Transaction From not inserted";
                return "IN";
            }
            MTransaction trxTo = new MTransaction(this.getCtx(), line.getAD_Org_ID(), "M+", line.getM_LocatorTo_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstanceTo_ID(), line.getMovementQty(), this.getMovementDate(), this.get_TrxName());
            trxTo.setM_MovementLine_ID(line.getM_MovementLine_ID());
            if (trxTo.save()) continue;
            this.m_processMsg = "Transaction To not inserted";
            return "IN";
        }
        String valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void checkMaterialPolicy() {
        int no = MMovementLineMA.deleteMovementMA(this.getM_Movement_ID(), this.get_TrxName());
        if (no > 0) {
            this.log.config("Delete old #" + no);
        }
        MMovementLine[] lines = this.getLines(false);
        MClient client = MClient.get((Ctx)this.getCtx());
        for (int i = 0; i < lines.length; ++i) {
            MMovementLine line = lines[i];
            boolean needSave = false;
            if (line.getM_AttributeSetInstance_ID() == 0) {
                MProduct product = MProduct.get(this.getCtx(), line.getM_Product_ID());
                MProductCategory pc = MProductCategory.get(this.getCtx(), product.getM_Product_Category_ID());
                String MMPolicy = pc.getMMPolicy();
                if (MMPolicy == null || MMPolicy.length() == 0) {
                    MMPolicy = client.getMMPolicy();
                }
                MStorage[] storages = MStorage.getAllWithASI(this.getCtx(), line.getM_Product_ID(), line.getM_Locator_ID(), "F".equals(MMPolicy), this.get_TrxName());
                BigDecimal qtyToDeliver = line.getMovementQty();
                for (int ii = 0; ii < storages.length; ++ii) {
                    MMovementLineMA ma;
                    MStorage storage = storages[ii];
                    if (ii == 0) {
                        if (storage.getQtyOnHand().compareTo(qtyToDeliver) >= 0) {
                            line.setM_AttributeSetInstance_ID(storage.getM_AttributeSetInstance_ID());
                            needSave = true;
                            this.log.config("Direct - " + (Object)((Object)line));
                            qtyToDeliver = Env.ZERO;
                        } else {
                            this.log.config("Split - " + (Object)((Object)line));
                            ma = new MMovementLineMA(line, storage.getM_AttributeSetInstance_ID(), storage.getQtyOnHand());
                            if (!ma.save()) {
                                // empty if block
                            }
                            qtyToDeliver = qtyToDeliver.subtract(storage.getQtyOnHand());
                            this.log.fine("#" + ii + ": " + (Object)((Object)ma) + ", QtyToDeliver=" + qtyToDeliver);
                        }
                    } else {
                        ma = new MMovementLineMA(line, storage.getM_AttributeSetInstance_ID(), qtyToDeliver);
                        if (storage.getQtyOnHand().compareTo(qtyToDeliver) >= 0) {
                            qtyToDeliver = Env.ZERO;
                        } else {
                            ma.setMovementQty(storage.getQtyOnHand());
                            qtyToDeliver = qtyToDeliver.subtract(storage.getQtyOnHand());
                        }
                        if (!ma.save()) {
                            // empty if block
                        }
                        this.log.fine("#" + ii + ": " + (Object)((Object)ma) + ", QtyToDeliver=" + qtyToDeliver);
                    }
                    if (qtyToDeliver.signum() == 0) break;
                }
                if (qtyToDeliver.signum() != 0) {
                    MMovementLineMA ma = new MMovementLineMA(line, 0, qtyToDeliver);
                    if (!ma.save()) {
                        // empty if block
                    }
                    this.log.fine("##: " + (Object)((Object)ma));
                }
            }
            if (!needSave || line.save()) continue;
            this.log.severe("NOT saved " + (Object)((Object)line));
        }
    }

    private void checkMaterialPolicy(MMovementLine line) {
        int no = MMovementLineMA.deleteMovementLineMA(line.getM_MovementLine_ID(), this.get_TrxName());
        if (no > 0) {
            this.log.config("Delete old #" + no);
        }
        MClient client = MClient.get((Ctx)this.getCtx());
        boolean needSave = false;
        if (line.getM_AttributeSetInstance_ID() == 0) {
            MProduct product = MProduct.get(this.getCtx(), line.getM_Product_ID());
            MProductCategory pc = MProductCategory.get(this.getCtx(), product.getM_Product_Category_ID());
            String MMPolicy = pc.getMMPolicy();
            if (MMPolicy == null || MMPolicy.length() == 0) {
                MMPolicy = client.getMMPolicy();
            }
            MStorage[] storages = MStorage.getAllWithASI(this.getCtx(), line.getM_Product_ID(), line.getM_Locator_ID(), "F".equals(MMPolicy), this.get_TrxName());
            BigDecimal qtyToDeliver = line.getMovementQty();
            for (int ii = 0; ii < storages.length; ++ii) {
                MMovementLineMA ma;
                MStorage storage = storages[ii];
                if (ii == 0) {
                    if (storage.getQtyOnHand().compareTo(qtyToDeliver) >= 0) {
                        line.setM_AttributeSetInstance_ID(storage.getM_AttributeSetInstance_ID());
                        needSave = true;
                        this.log.config("Direct - " + (Object)((Object)line));
                        qtyToDeliver = Env.ZERO;
                    } else {
                        this.log.config("Split - " + (Object)((Object)line));
                        ma = new MMovementLineMA(line, storage.getM_AttributeSetInstance_ID(), storage.getQtyOnHand());
                        if (!ma.save()) {
                            // empty if block
                        }
                        qtyToDeliver = qtyToDeliver.subtract(storage.getQtyOnHand());
                        this.log.fine("#" + ii + ": " + (Object)((Object)ma) + ", QtyToDeliver=" + qtyToDeliver);
                    }
                } else {
                    ma = new MMovementLineMA(line, storage.getM_AttributeSetInstance_ID(), qtyToDeliver);
                    if (storage.getQtyOnHand().compareTo(qtyToDeliver) >= 0) {
                        qtyToDeliver = Env.ZERO;
                    } else {
                        ma.setMovementQty(storage.getQtyOnHand());
                        qtyToDeliver = qtyToDeliver.subtract(storage.getQtyOnHand());
                    }
                    if (!ma.save()) {
                        // empty if block
                    }
                    this.log.fine("#" + ii + ": " + (Object)((Object)ma) + ", QtyToDeliver=" + qtyToDeliver);
                }
                if (qtyToDeliver.signum() == 0) break;
            }
            if (qtyToDeliver.signum() != 0) {
                MMovementLineMA ma = new MMovementLineMA(line, 0, qtyToDeliver);
                if (!ma.save()) {
                    // empty if block
                }
                this.log.fine("##: " + (Object)((Object)ma));
            }
        }
        if (needSave && !line.save()) {
            this.log.severe("NOT saved " + (Object)((Object)line));
        }
    }

    public boolean voidIt() {
        this.log.info(this.toString());
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            return false;
        }
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus())) {
            MMovementLine[] lines = this.getLines(false);
            for (int i = 0; i < lines.length; ++i) {
                MMovementLine line = lines[i];
                BigDecimal old = line.getMovementQty();
                if (old.compareTo(Env.ZERO) == 0) continue;
                line.setMovementQty(Env.ZERO);
                line.addDescription("Void (" + old + ")");
                line.save(this.get_TrxName());
            }
        } else {
            return this.reverseCorrectIt();
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public boolean closeIt() {
        this.log.info(this.toString());
        this.setDocAction("--");
        return true;
    }

    public boolean reverseCorrectIt() {
        this.log.info(this.toString());
        MDocType dt = MDocType.get((Ctx)this.getCtx(), (int)this.getC_DocType_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.getMovementDate(), dt.getDocBaseType())) {
            this.m_processMsg = "@PeriodClosed@";
            return false;
        }
        MMovement reversal = new MMovement(this.getCtx(), 0, this.get_TrxName());
        MMovement.copyValues((PO)this, (PO)reversal, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
        reversal.setDocStatus("DR");
        reversal.setDocAction("CO");
        reversal.setIsApproved(false);
        reversal.setIsInTransit(false);
        reversal.setPosted(false);
        reversal.setProcessed(false);
        reversal.addDescription("{->" + this.getDocumentNo() + ")");
        if (!reversal.save()) {
            this.m_processMsg = "Could not create Movement Reversal";
            return false;
        }
        MMovementLine[] oLines = this.getLines(true);
        for (int i = 0; i < oLines.length; ++i) {
            MMovementLine oLine = oLines[i];
            MMovementLine rLine = new MMovementLine(this.getCtx(), 0, this.get_TrxName());
            MMovement.copyValues((PO)oLine, (PO)rLine, (int)oLine.getAD_Client_ID(), (int)oLine.getAD_Org_ID());
            rLine.setM_Movement_ID(reversal.getM_Movement_ID());
            rLine.setMovementQty(rLine.getMovementQty().negate());
            rLine.setTargetQty(Env.ZERO);
            rLine.setScrappedQty(Env.ZERO);
            rLine.setConfirmedQty(Env.ZERO);
            rLine.setProcessed(false);
            if (rLine.save()) continue;
            this.m_processMsg = "Could not create Movement Reversal Line";
            return false;
        }
        if (!reversal.processIt("CO")) {
            this.m_processMsg = "Reversal ERROR: " + reversal.getProcessMsg();
            return false;
        }
        reversal.closeIt();
        reversal.setDocStatus("RE");
        reversal.setDocAction("--");
        reversal.save();
        this.m_processMsg = reversal.getDocumentNo();
        this.addDescription("(" + reversal.getDocumentNo() + "<-)");
        this.setProcessed(true);
        this.setDocStatus("RE");
        this.setDocAction("--");
        return true;
    }

    public boolean reverseAccrualIt() {
        this.log.info(this.toString());
        return false;
    }

    public boolean reActivateIt() {
        this.log.info(this.toString());
        return false;
    }

    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate((Ctx)this.getCtx(), (String)"ApprovalAmt")).append("=").append(this.getApprovalAmt()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MMovement[");
        sb.append(this.get_ID()).append("-").append(this.getDocumentNo()).append("]");
        return sb.toString();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    public int getC_Currency_ID() {
        return 0;
    }
}

