/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.api.UICallout;
import org.compiere.framework.PO;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.X_C_PaymentAllocate;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MPaymentAllocate
extends X_C_PaymentAllocate {
    private static CLogger s_log = CLogger.getCLogger(MPaymentAllocate.class);
    private MInvoice m_invoice = null;

    public static MPaymentAllocate[] get(MPayment parent) {
        ArrayList<MPaymentAllocate> list = new ArrayList<MPaymentAllocate>();
        String sql = "SELECT * FROM C_PaymentAllocate WHERE C_Payment_ID=? AND IsActive='Y'";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, parent.getC_Payment_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MPaymentAllocate(parent.getCtx(), rs, parent.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MPaymentAllocate[] retValue = new MPaymentAllocate[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MPaymentAllocate(Ctx ctx, int C_PaymentAllocate_ID, String trxName) {
        super(ctx, C_PaymentAllocate_ID, trxName);
        if (C_PaymentAllocate_ID == 0) {
            this.setAmount(Env.ZERO);
            this.setDiscountAmt(Env.ZERO);
            this.setOverUnderAmt(Env.ZERO);
            this.setWriteOffAmt(Env.ZERO);
            this.setInvoiceAmt(Env.ZERO);
        }
    }

    public MPaymentAllocate(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setC_Invoice_ID(int C_Invoice_ID) {
        super.setC_Invoice_ID(C_Invoice_ID);
        this.m_invoice = null;
    }

    public MInvoice getInvoice() {
        if (this.m_invoice == null && this.getC_Invoice_ID() != 0) {
            this.m_invoice = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
        }
        return this.m_invoice;
    }

    public int getC_BPartner_ID() {
        if (this.m_invoice == null) {
            this.getInvoice();
        }
        if (this.m_invoice == null) {
            return 0;
        }
        return this.m_invoice.getC_BPartner_ID();
    }

    @UICallout
    public void setC_Invoice_ID(String oldC_Invoice_ID, String newC_Invoice_ID, int windowNo) throws Exception {
        int currency_ID;
        Timestamp ts;
        if (newC_Invoice_ID == null || newC_Invoice_ID.length() == 0) {
            return;
        }
        int C_Invoice_ID = Integer.parseInt(newC_Invoice_ID);
        this.setC_Invoice_ID(C_Invoice_ID);
        if (C_Invoice_ID == 0) {
            return;
        }
        int C_Payment_ID = this.getC_Payment_ID();
        MPayment payment = new MPayment(this.getCtx(), C_Payment_ID, null);
        if (payment.getC_Charge_ID() != 0 || payment.getC_Invoice_ID() != 0 || payment.getC_Order_ID() != 0) {
            this.p_changeVO.addError(Msg.getMsg((Ctx)this.getCtx(), (String)"PaymentIsAllocated"));
            return;
        }
        this.setDiscountAmt(Env.ZERO);
        this.setWriteOffAmt(Env.ZERO);
        this.setOverUnderAmt(Env.ZERO);
        int C_InvoicePaySchedule_ID = 0;
        if (this.getCtx().getContextAsInt(1113, 1113, "C_Invoice_ID") == C_Invoice_ID && this.getCtx().getContextAsInt(1113, 1113, "C_InvoicePaySchedule_ID") != 0) {
            C_InvoicePaySchedule_ID = this.getCtx().getContextAsInt(1113, 1113, "C_InvoicePaySchedule_ID");
        }
        if ((ts = new Timestamp(this.getCtx().getContextAsTime(windowNo, "DateTrx"))) == null) {
            ts = new Timestamp(System.currentTimeMillis());
        }
        String sql = "SELECT C_BPartner_ID,C_Currency_ID, invoiceOpen(C_Invoice_ID, ?), invoiceDiscount(C_Invoice_ID,?,?), IsSOTrx FROM C_Invoice WHERE C_Invoice_ID=?";
        int C_Currency_ID = 0;
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, C_InvoicePaySchedule_ID);
            pstmt.setTimestamp(2, ts);
            pstmt.setInt(3, C_InvoicePaySchedule_ID);
            pstmt.setInt(4, C_Invoice_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                BigDecimal DiscountAmt;
                C_Currency_ID = rs.getInt(2);
                BigDecimal InvoiceOpen = rs.getBigDecimal(3);
                if (InvoiceOpen == null) {
                    InvoiceOpen = Env.ZERO;
                }
                if ((DiscountAmt = rs.getBigDecimal(4)) == null) {
                    DiscountAmt = Env.ZERO;
                }
                this.setInvoiceAmt(InvoiceOpen);
                this.setAmount(InvoiceOpen.subtract(DiscountAmt));
                this.setDiscountAmt(DiscountAmt);
                this.getCtx().setContext(windowNo, "C_Invoice_ID", C_Invoice_ID);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        if (C_Currency_ID != 0 && (currency_ID = this.getCtx().getContextAsInt(windowNo, "C_Currency_ID")) != C_Currency_ID) {
            String msg = Msg.parseTranslation((Ctx)this.getCtx(), (String)"@C_Currency_ID@: @C_Invoice_ID@ <> @C_Payment_ID@");
            this.p_changeVO.addError(msg);
        }
    }

    @UICallout
    public void setAmount(String oldAmount, String newAmount, int windowNo) throws Exception {
        if (newAmount == null || newAmount.length() == 0) {
            return;
        }
        BigDecimal Amount = PO.convertToBigDecimal((String)newAmount);
        this.setAmount(Amount);
        this.checkAmt(windowNo, "PayAmt");
    }

    @UICallout
    public void setDiscountAmt(String oldDiscountAmt, String newDiscountAmt, int windowNo) throws Exception {
        if (newDiscountAmt == null || newDiscountAmt.length() == 0) {
            return;
        }
        BigDecimal DiscountAmt = PO.convertToBigDecimal((String)newDiscountAmt);
        this.setDiscountAmt(DiscountAmt);
        this.checkAmt(windowNo, "DiscountAmt");
    }

    @UICallout
    public void setOverUnderAmt(String oldOverUnderAmt, String newOverUnderAmt, int windowNo) throws Exception {
        if (newOverUnderAmt == null || newOverUnderAmt.length() == 0) {
            return;
        }
        BigDecimal OverUnderAmt = PO.convertToBigDecimal((String)newOverUnderAmt);
        this.setOverUnderAmt(OverUnderAmt);
        this.checkAmt(windowNo, "OverUnderAmt");
    }

    @UICallout
    public void setWriteOffAmt(String oldWriteOffAmt, String newWriteOffAmt, int windowNo) throws Exception {
        if (newWriteOffAmt == null || newWriteOffAmt.length() == 0) {
            return;
        }
        BigDecimal WriteOffAmt = PO.convertToBigDecimal((String)newWriteOffAmt);
        this.setWriteOffAmt(WriteOffAmt);
        this.checkAmt(windowNo, "WriteOffAmt");
    }

    private void checkAmt(int windowNo, String columnName) {
        int C_Invoice_ID = this.getC_Invoice_ID();
        if (C_Invoice_ID == 0) {
            return;
        }
        BigDecimal Amount = this.getAmount();
        BigDecimal DiscountAmt = this.getDiscountAmt();
        BigDecimal WriteOffAmt = this.getWriteOffAmt();
        BigDecimal OverUnderAmt = this.getOverUnderAmt();
        BigDecimal InvoiceAmt = this.getInvoiceAmt();
        this.log.fine("Amt=" + Amount + ", Discount=" + DiscountAmt + ", WriteOff=" + WriteOffAmt + ", OverUnder=" + OverUnderAmt + ", Invoice=" + InvoiceAmt);
        if (columnName.equals("Amount")) {
            WriteOffAmt = InvoiceAmt.subtract(Amount).subtract(DiscountAmt).subtract(OverUnderAmt);
            this.setWriteOffAmt(WriteOffAmt);
        } else {
            Amount = InvoiceAmt.subtract(DiscountAmt).subtract(WriteOffAmt).subtract(OverUnderAmt);
            this.setAmount(Amount);
        }
    }

    protected boolean beforeSave(boolean newRecord) {
        MPayment payment = new MPayment(this.getCtx(), this.getC_Payment_ID(), this.get_TrxName());
        if ((newRecord || this.is_ValueChanged("C_Invoice_ID")) && (payment.getC_Charge_ID() != 0 || payment.getC_Invoice_ID() != 0 || payment.getC_Order_ID() != 0)) {
            this.log.saveError("PaymentIsAllocated", "");
            return false;
        }
        BigDecimal check = this.getAmount().add(this.getDiscountAmt()).add(this.getWriteOffAmt()).add(this.getOverUnderAmt());
        if (check.compareTo(this.getInvoiceAmt()) != 0) {
            this.log.saveError("Error", Msg.parseTranslation((Ctx)this.getCtx(), (String)("@InvoiceAmt@(" + this.getInvoiceAmt() + ") <> @Totals@(" + check + ")")));
            return false;
        }
        if (newRecord || this.is_ValueChanged("C_Invoice_ID")) {
            this.getInvoice();
            if (this.m_invoice != null) {
                this.setAD_Org_ID(this.m_invoice.getAD_Org_ID());
            }
        }
        return true;
    }
}

