/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.framework.PO;
import org.compiere.model.MCostElement;
import org.compiere.model.X_M_Product_Category_Acct;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MProductCategoryAcct
extends X_M_Product_Category_Acct {
    private static CLogger s_log = CLogger.getCLogger(MProductCategoryAcct.class);

    public static MProductCategoryAcct get(Ctx ctx, int M_Product_Category_ID, int C_AcctSchema_ID, String trxName) {
        MProductCategoryAcct retValue = null;
        CPreparedStatement pstmt = null;
        String sql = "SELECT * FROM  M_Product_Category_Acct WHERE M_Product_Category_ID=? AND C_AcctSchema_ID=?";
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, M_Product_Category_ID);
            pstmt.setInt(2, C_AcctSchema_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MProductCategoryAcct(ctx, rs, trxName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public MProductCategoryAcct(Ctx ctx, int ignored, String trxName) {
        super(ctx, ignored, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
    }

    public MProductCategoryAcct(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void checkCosting() {
        if (this.getCostingMethod() != null && this.getCostingMethod().length() > 0) {
            MCostElement.getMaterialCostElement((PO)this, (String)this.getCostingMethod());
        }
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        this.checkCosting();
        return success;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MProductCategoryAcct[");
        sb.append(this.get_ID()).append(",M_Product_Category_ID=").append(this.getM_Product_Category_ID()).append(",C_AcctSchema_ID=").append(this.getC_AcctSchema_ID()).append(",CostingLevel=").append(this.getCostingLevel()).append(",CostingMethod=").append(this.getCostingMethod()).append("]");
        return sb.toString();
    }
}

