/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.api.UICallout;
import org.compiere.framework.PO;
import org.compiere.model.MProductCategory;
import org.compiere.model.MProductPricing;
import org.compiere.model.MProject;
import org.compiere.model.MProjectIssue;
import org.compiere.model.MProjectPhase;
import org.compiere.model.MProjectTask;
import org.compiere.model.X_C_ProjectLine;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MProjectLine
extends X_C_ProjectLine {
    private MProject m_parent = null;

    public MProjectLine(Ctx ctx, int C_ProjectLine_ID, String trxName) {
        super(ctx, C_ProjectLine_ID, trxName);
        if (C_ProjectLine_ID == 0) {
            this.setLine(0);
            this.setIsPrinted(true);
            this.setProcessed(false);
            this.setInvoicedAmt(Env.ZERO);
            this.setInvoicedQty(Env.ZERO);
            this.setPlannedAmt(Env.ZERO);
            this.setPlannedMarginAmt(Env.ZERO);
            this.setPlannedPrice(Env.ZERO);
            this.setPlannedQty(Env.ONE);
        }
    }

    public MProjectLine(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProjectLine(MProject project) {
        this(project.getCtx(), 0, project.get_TrxName());
        this.setClientOrg((PO)project);
        this.setC_Project_ID(project.getC_Project_ID());
        this.setLine();
    }

    private void setLine() {
        this.setLine(DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT COALESCE(MAX(Line),0)+10 FROM C_ProjectLine WHERE C_Project_ID=?", (int)this.getC_Project_ID()));
    }

    public void setMProjectIssue(MProjectIssue pi) {
        this.setC_ProjectIssue_ID(pi.getC_ProjectIssue_ID());
        this.setM_Product_ID(pi.getM_Product_ID());
        this.setCommittedQty(pi.getMovementQty());
        if (this.getDescription() != null) {
            this.setDescription(pi.getDescription());
        }
    }

    public void setC_OrderPO_ID(int C_OrderPO_ID) {
        super.setC_OrderPO_ID(C_OrderPO_ID);
    }

    public MProject getProject() {
        if (this.m_parent == null && this.getC_Project_ID() != 0) {
            this.m_parent = new MProject(this.getCtx(), this.getC_Project_ID(), this.get_TrxName());
            if (this.get_TrxName() != null) {
                this.m_parent.load(this.get_TrxName());
            }
        }
        return this.m_parent;
    }

    public BigDecimal getLimitPrice() {
        BigDecimal limitPrice = this.getPlannedPrice();
        if (this.getM_Product_ID() == 0) {
            return limitPrice;
        }
        if (this.getProject() == null) {
            return limitPrice;
        }
        boolean isSOTrx = true;
        MProductPricing pp = new MProductPricing(this.getAD_Client_ID(), this.getAD_Org_ID(), this.getM_Product_ID(), this.m_parent.getC_BPartner_ID(), this.getPlannedQty(), isSOTrx);
        pp.setM_PriceList_ID(this.m_parent.getM_PriceList_ID());
        if (pp.calculatePrice()) {
            limitPrice = pp.getPriceLimit();
        }
        return limitPrice;
    }

    protected int getCurPrecision() {
        return 2;
    }

    @UICallout
    public void setM_Product_ID(String oldM_Product_ID, String newM_Product_ID, int windowNo) throws Exception {
        if (newM_Product_ID == null || newM_Product_ID.length() == 0) {
            return;
        }
        int M_Product_ID = Integer.parseInt(newM_Product_ID);
        super.setM_Product_ID(M_Product_ID);
        if (M_Product_ID == 0) {
            return;
        }
        int M_PriceList_Version_ID = this.getCtx().getContextAsInt(windowNo, "M_PriceList_Version_ID");
        if (M_PriceList_Version_ID == 0) {
            return;
        }
        int C_BPartner_ID = this.getCtx().getContextAsInt(windowNo, "C_BPartner_ID");
        BigDecimal Qty = this.getPlannedQty();
        boolean IsSOTrx = true;
        MProductPricing pp = new MProductPricing(this.getAD_Client_ID(), this.getAD_Org_ID(), M_Product_ID, C_BPartner_ID, Qty, IsSOTrx);
        pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
        Timestamp date = this.getPlannedDate();
        if (date == null) {
            date = new Timestamp(this.getCtx().getContextAsTime(windowNo, "DateContract"));
        }
        pp.setPriceDate(date);
        BigDecimal PriceList = pp.getPriceList();
        this.setPriceList(PriceList);
        BigDecimal PlannedPrice = pp.getPriceStd();
        this.setPlannedPrice(PlannedPrice);
        BigDecimal Discount = pp.getDiscount();
        this.setDiscount(Discount);
        BigDecimal PlannedAmt = pp.getLineAmt(this.getCurPrecision());
        this.setPlannedAmt(PlannedAmt);
        this.p_changeVO.setContext(this.getCtx(), windowNo, "StdPrecision", pp.getPrecision());
        this.log.fine("PlannedQty=" + Qty + " * PlannedPrice=" + PlannedPrice + " -> PlannedAmt=" + PlannedAmt);
    }

    @UICallout
    public void setDiscount(String oldDiscount, String newDiscount, int windowNo) throws Exception {
        if (newDiscount == null || newDiscount.length() == 0) {
            return;
        }
        BigDecimal Discount = new BigDecimal(newDiscount);
        super.setDiscount(Discount);
        this.setAmt(windowNo, "Discount");
    }

    @UICallout
    public void setPriceList(String oldPriceList, String newPriceList, int windowNo) throws Exception {
        if (newPriceList == null || newPriceList.length() == 0) {
            return;
        }
        BigDecimal PriceList = new BigDecimal(newPriceList);
        super.setPriceList(PriceList);
        this.setAmt(windowNo, "PriceList");
    }

    @UICallout
    public void setPlannedPrice(String oldPlannedPrice, String newPlannedPrice, int windowNo) throws Exception {
        if (newPlannedPrice == null || newPlannedPrice.length() == 0) {
            return;
        }
        BigDecimal PlannedPrice = new BigDecimal(newPlannedPrice);
        super.setPlannedPrice(PlannedPrice);
        this.setAmt(windowNo, "PlannedPrice");
    }

    @UICallout
    public void setPlannedQty(String oldPlannedQty, String newPlannedQty, int windowNo) throws Exception {
        if (newPlannedQty == null || newPlannedQty.length() == 0) {
            return;
        }
        BigDecimal PlannedQty = new BigDecimal(newPlannedQty);
        super.setPlannedQty(PlannedQty);
        this.setAmt(windowNo, "PlannedQty");
    }

    private void setAmt(int windowNo, String columnName) {
        BigDecimal multiplier;
        BigDecimal Discount;
        BigDecimal PriceList;
        BigDecimal PlannedPrice;
        int curPrecision = this.getCurPrecision();
        int plPrecision = this.getCtx().getContextAsInt(windowNo, "StdPrecision");
        BigDecimal PlannedQty = this.getPlannedQty();
        if (PlannedQty == null) {
            PlannedQty = Env.ONE;
        }
        if ((PlannedPrice = this.getPlannedPrice()) == null) {
            PlannedPrice = Env.ZERO;
        }
        if ((PriceList = this.getPriceList()) == null) {
            PriceList = PlannedPrice;
        }
        if ((Discount = this.getDiscount()) == null) {
            Discount = Env.ZERO;
        }
        if (columnName.equals("PlannedPrice")) {
            if (PriceList.signum() == 0) {
                Discount = Env.ZERO;
            } else {
                multiplier = PlannedPrice.multiply(Env.ONEHUNDRED).divide(PriceList, plPrecision, 4);
                Discount = Env.ONEHUNDRED.subtract(multiplier);
            }
            this.setDiscount(Discount);
            this.log.fine("PriceList=" + PriceList + " - Discount=" + Discount + " -> [PlannedPrice=" + PlannedPrice + "] (Precision=" + plPrecision + ")");
        } else if (columnName.equals("PriceList")) {
            if (PriceList.signum() == 0) {
                Discount = Env.ZERO;
            } else {
                multiplier = PlannedPrice.multiply(Env.ONEHUNDRED).divide(PriceList, plPrecision, 4);
                Discount = Env.ONEHUNDRED.subtract(multiplier);
            }
            this.setDiscount(Discount);
            this.log.fine("[PriceList=" + PriceList + "] - Discount=" + Discount + " -> PlannedPrice=" + PlannedPrice + " (Precision=" + plPrecision + ")");
        } else if (columnName.equals("Discount")) {
            multiplier = Discount.divide(Env.ONEHUNDRED, 10, 4);
            PlannedPrice = PriceList.multiply(multiplier = Env.ONE.subtract(multiplier));
            if (PlannedPrice.scale() > plPrecision) {
                PlannedPrice = PlannedPrice.setScale(plPrecision, 4);
            }
            this.setPlannedPrice(PlannedPrice);
            this.log.fine("PriceList=" + PriceList + " - [Discount=" + Discount + "] -> PlannedPrice=" + PlannedPrice + " (Precision=" + plPrecision + ")");
        }
        BigDecimal PlannedAmt = PlannedQty.multiply(PlannedPrice);
        if (PlannedAmt.scale() > curPrecision) {
            PlannedAmt = PlannedAmt.setScale(curPrecision, 4);
        }
        this.log.fine("PlannedQty=" + PlannedQty + " * PlannedPrice=" + PlannedPrice + " -> PlannedAmt=" + PlannedAmt + " (Precision=" + curPrecision + ")");
        this.setPlannedAmt(PlannedAmt);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MProjectLine[");
        sb.append(this.get_ID()).append("-").append(this.getLine()).append(",C_Project_ID=").append(this.getC_Project_ID()).append(",C_ProjectPhase_ID=").append(this.getC_ProjectPhase_ID()).append(",C_ProjectTask_ID=").append(this.getC_ProjectTask_ID()).append(",C_ProjectIssue_ID=").append(this.getC_ProjectIssue_ID()).append(", M_Product_ID=").append(this.getM_Product_ID()).append(", PlannedQty=").append(this.getPlannedQty()).append("]");
        return sb.toString();
    }

    protected boolean beforeSave(boolean newRecord) {
        BigDecimal PlannedAmt;
        if (this.getLine() == 0) {
            this.setLine();
        }
        if ((PlannedAmt = this.getPlannedQty().multiply(this.getPlannedPrice())).scale() > this.getCurPrecision()) {
            PlannedAmt.setScale(this.getCurPrecision(), 4);
        }
        this.setPlannedAmt(PlannedAmt);
        if (this.is_ValueChanged("M_Product_ID") || this.is_ValueChanged("M_Product_Category_ID") || this.is_ValueChanged("PlannedQty") || this.is_ValueChanged("PlannedPrice")) {
            if (this.getM_Product_ID() != 0) {
                BigDecimal marginEach = this.getPlannedPrice().subtract(this.getLimitPrice());
                this.setPlannedMarginAmt(marginEach.multiply(this.getPlannedQty()));
            } else if (this.getM_Product_Category_ID() != 0) {
                MProductCategory category = MProductCategory.get(this.getCtx(), this.getM_Product_Category_ID());
                BigDecimal marginEach = category.getPlannedMargin();
                this.setPlannedMarginAmt(marginEach.multiply(this.getPlannedQty()));
            }
        }
        if (this.is_ValueChanged("C_ProjectTask_ID") && this.getC_ProjectTask_ID() != 0) {
            MProjectTask pt = new MProjectTask(this.getCtx(), this.getC_ProjectTask_ID(), this.get_TrxName());
            if (pt == null || pt.get_ID() == 0) {
                this.log.warning("Project Task Not Found - ID=" + this.getC_ProjectTask_ID());
                return false;
            }
            this.setC_ProjectPhase_ID(pt.getC_ProjectPhase_ID());
        }
        if (this.is_ValueChanged("C_ProjectPhase_ID") && this.getC_ProjectPhase_ID() != 0) {
            MProjectPhase pp = new MProjectPhase(this.getCtx(), this.getC_ProjectPhase_ID(), this.get_TrxName());
            if (pp == null || pp.get_ID() == 0) {
                this.log.warning("Project Phase Not Found - " + this.getC_ProjectPhase_ID());
                return false;
            }
            this.setC_Project_ID(pp.getC_Project_ID());
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        this.updateHeader();
        return success;
    }

    protected boolean afterDelete(boolean success) {
        this.updateHeader();
        return success;
    }

    private void updateHeader() {
        String sql = "UPDATE C_Project p SET (PlannedAmt,PlannedQty,PlannedMarginAmt,CommittedAmt,CommittedQty,InvoicedAmt, InvoicedQty) = (SELECT COALESCE(SUM(pl.PlannedAmt),0), COALESCE(SUM(pl.PlannedQty),0), COALESCE(SUM(pl.PlannedMarginAmt),0), COALESCE(SUM(pl.CommittedAmt),0), COALESCE(SUM(pl.CommittedQty),0), COALESCE(SUM(pl.InvoicedAmt),0), COALESCE(SUM(pl.InvoicedQty),0) FROM C_ProjectLine pl WHERE pl.C_Project_ID=p.C_Project_ID AND pl.IsActive='Y') WHERE C_Project_ID=" + this.getC_Project_ID();
        int no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        if (no != 1) {
            this.log.log(Level.SEVERE, "updateHeader - #" + no);
        }
    }
}

