/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.api.UICallout;
import org.compiere.framework.PO;
import org.compiere.model.MCharge;
import org.compiere.model.MProductPricing;
import org.compiere.model.MRequisition;
import org.compiere.model.X_M_RequisitionLine;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MRequisitionLine
extends X_M_RequisitionLine {
    private MRequisition m_parent = null;
    private int m_M_PriceList_ID = 0;
    private int m_C_BPartner_ID = 0;

    public MRequisitionLine(Ctx ctx, int M_RequisitionLine_ID, String trxName) {
        super(ctx, M_RequisitionLine_ID, trxName);
        if (M_RequisitionLine_ID == 0) {
            this.setLine(0);
            this.setLineNetAmt(Env.ZERO);
            this.setPriceActual(Env.ZERO);
            this.setQty(Env.ONE);
        }
    }

    public MRequisitionLine(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MRequisitionLine(MRequisition req) {
        this(req.getCtx(), 0, req.get_TrxName());
        this.setClientOrg((PO)req);
        this.setM_Requisition_ID(req.getM_Requisition_ID());
        this.m_M_PriceList_ID = req.getM_PriceList_ID();
        this.m_parent = req;
    }

    public int getC_BPartner_ID() {
        return this.m_C_BPartner_ID;
    }

    public void setC_BPartner_ID(int partner_ID) {
        this.m_C_BPartner_ID = partner_ID;
    }

    public MRequisition getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MRequisition(this.getCtx(), this.getM_Requisition_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public void setPrice() {
        if (this.getC_Charge_ID() != 0) {
            MCharge charge = MCharge.get(this.getCtx(), this.getC_Charge_ID());
            this.setPriceActual(charge.getChargeAmt());
        }
        if (this.getM_Product_ID() == 0) {
            return;
        }
        if (this.m_M_PriceList_ID == 0) {
            this.m_M_PriceList_ID = this.getParent().getM_PriceList_ID();
        }
        if (this.m_M_PriceList_ID == 0) {
            this.log.log(Level.SEVERE, "PriceList unknown!");
            return;
        }
        this.setPrice(this.m_M_PriceList_ID);
    }

    public void setPrice(int M_PriceList_ID) {
        if (this.getM_Product_ID() == 0) {
            return;
        }
        this.log.fine("M_PriceList_ID=" + M_PriceList_ID);
        boolean isSOTrx = false;
        MProductPricing pp = new MProductPricing(this.getAD_Client_ID(), this.getAD_Org_ID(), this.getM_Product_ID(), this.getC_BPartner_ID(), this.getQty(), isSOTrx);
        pp.setM_PriceList_ID(M_PriceList_ID);
        this.setPriceActual(pp.getPriceStd());
    }

    public void setLineNetAmt() {
        BigDecimal lineNetAmt = this.getQty().multiply(this.getPriceActual());
        super.setLineNetAmt(lineNetAmt);
    }

    @UICallout
    public void setM_Product_ID(String oldM_Product_ID, String newM_Product_ID, int windowNo) throws Exception {
        if (newM_Product_ID == null || newM_Product_ID.length() == 0) {
            return;
        }
        int M_Product_ID = Integer.parseInt(newM_Product_ID);
        super.setM_Product_ID(M_Product_ID);
        if (M_Product_ID == 0) {
            this.setM_AttributeSetInstance_ID(0);
            return;
        }
        int M_AttributeSetInstance_ID = this.getCtx().getContextAsInt(1113, 1113, "M_AttributeSetInstance_ID");
        if (this.getCtx().getContextAsInt(1113, 1113, "M_Product_ID") == M_Product_ID && M_AttributeSetInstance_ID != 0) {
            this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        } else {
            this.setM_AttributeSetInstance_ID(0);
        }
        int C_BPartner_ID = this.getC_BPartner_ID();
        BigDecimal Qty = this.getQty();
        boolean isSOTrx = false;
        MProductPricing pp = new MProductPricing(this.getAD_Client_ID(), this.getAD_Org_ID(), M_Product_ID, C_BPartner_ID, Qty, isSOTrx);
        int M_PriceList_ID = this.getCtx().getContextAsInt(windowNo, "M_PriceList_ID");
        pp.setM_PriceList_ID(M_PriceList_ID);
        int M_PriceList_Version_ID = this.getCtx().getContextAsInt(windowNo, "M_PriceList_Version_ID");
        pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
        Timestamp orderDate = new Timestamp(this.getCtx().getContextAsTime(windowNo, "DateRequired"));
        pp.setPriceDate(orderDate);
        this.setPriceActual(pp.getPriceStd());
        this.p_changeVO.setContext(this.getCtx(), windowNo, "EnforcePriceLimit", pp.isEnforcePriceLimit());
        this.p_changeVO.setContext(this.getCtx(), windowNo, "DiscountSchema", pp.isDiscountSchema());
    }

    @UICallout
    public void setPriceActual(String oldPriceActual, String newPriceActual, int windowNo) throws Exception {
        if (newPriceActual == null || newPriceActual.length() == 0) {
            return;
        }
        BigDecimal PriceActual = new BigDecimal(newPriceActual);
        super.setPriceActual(PriceActual);
        this.setAmt(windowNo, "PriceActual");
    }

    @UICallout
    public void setQty(String oldQty, String newQty, int windowNo) throws Exception {
        if (newQty == null || newQty.length() == 0) {
            return;
        }
        BigDecimal Qty = new BigDecimal(newQty);
        super.setQty(Qty);
        this.setAmt(windowNo, "Qty");
    }

    private void setAmt(int windowNo, String columnName) {
        BigDecimal Qty = this.getQty();
        if (columnName.equals("Qty") && "Y".equals(this.getCtx().getContext(windowNo, "DiscountSchema"))) {
            int M_Product_ID = this.getM_Product_ID();
            int C_BPartner_ID = this.getC_BPartner_ID();
            boolean isSOTrx = false;
            MProductPricing pp = new MProductPricing(this.getAD_Client_ID(), this.getAD_Org_ID(), M_Product_ID, C_BPartner_ID, Qty, isSOTrx);
            int M_PriceList_ID = this.getCtx().getContextAsInt(windowNo, "M_PriceList_ID");
            pp.setM_PriceList_ID(M_PriceList_ID);
            int M_PriceList_Version_ID = this.getCtx().getContextAsInt(windowNo, "M_PriceList_Version_ID");
            pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
            Timestamp orderDate = new Timestamp(this.getCtx().getContextAsTime(windowNo, "DateInvoiced"));
            pp.setPriceDate(orderDate);
            this.setPriceActual(pp.getPriceStd());
        }
        int StdPrecision = this.getCtx().getStdPrecision();
        BigDecimal PriceActual = this.getPriceActual();
        this.log.fine("Qty=" + Qty + ", Price=" + PriceActual + ", Precision=" + StdPrecision);
        BigDecimal LineNetAmt = Qty.multiply(PriceActual);
        if (LineNetAmt.scale() > StdPrecision) {
            LineNetAmt = LineNetAmt.setScale(StdPrecision, 4);
        }
        this.setLineNetAmt(LineNetAmt);
        this.log.info("LineNetAmt=" + LineNetAmt);
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getLine() == 0) {
            String sql = "SELECT COALESCE(MAX(Line),0)+10 FROM M_RequisitionLine WHERE M_Requisition_ID=?";
            int ii = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getM_Requisition_ID());
            this.setLine(ii);
        }
        if (this.getM_Product_ID() != 0 && this.getC_Charge_ID() != 0) {
            this.setC_Charge_ID(0);
        }
        if (this.getM_AttributeSetInstance_ID() != 0 && this.getC_Charge_ID() != 0) {
            this.setM_AttributeSetInstance_ID(0);
        }
        if (this.getPriceActual().compareTo(Env.ZERO) == 0) {
            this.setPrice();
        }
        this.setLineNetAmt();
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        return this.updateHeader();
    }

    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        return this.updateHeader();
    }

    private boolean updateHeader() {
        this.log.fine("");
        String sql = "UPDATE M_Requisition r SET TotalLines=(SELECT COALESCE(SUM(LineNetAmt),0) FROM M_RequisitionLine rl WHERE r.M_Requisition_ID=rl.M_Requisition_ID) WHERE M_Requisition_ID=" + this.getM_Requisition_ID();
        int no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        if (no != 1) {
            this.log.log(Level.SEVERE, "Header update #" + no);
        }
        this.m_parent = null;
        return no == 1;
    }
}

