/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MProduct;
import org.compiere.model.MReturnPolicyLine;
import org.compiere.model.X_M_ReturnPolicy;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MReturnPolicy
extends X_M_ReturnPolicy {
    public MReturnPolicy(Ctx ctx, int M_ReturnPolicy_ID, String trxName) {
        super(ctx, M_ReturnPolicy_ID, trxName);
    }

    public MReturnPolicy(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getProductLine(int M_Product_ID) {
        StringBuffer sql = new StringBuffer("SELECT M_ReturnPolicyLine_ID FROM M_ReturnPolicyLine WHERE M_ReturnPolicy_ID =? ");
        int M_ReturnPolicyLine_ID = 0;
        if (M_Product_ID != 0) {
            sql.append("AND M_Product_ID = ?  ");
        }
        CPreparedStatement pstmt = null;
        try {
            ResultSet rs;
            pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
            pstmt.setInt(1, this.getM_ReturnPolicy_ID());
            if (M_Product_ID != 0) {
                pstmt.setInt(2, M_Product_ID);
            }
            if ((rs = pstmt.executeQuery()).next()) {
                M_ReturnPolicyLine_ID = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        return M_ReturnPolicyLine_ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getProductCategoryLine(int M_Product_Category_ID) {
        StringBuffer sql = new StringBuffer("SELECT M_ReturnPolicyLine_ID FROM M_ReturnPolicyLine WHERE M_ReturnPolicy_ID =? ");
        int M_ReturnPolicyLine_ID = 0;
        if (M_Product_Category_ID != 0) {
            sql.append("AND M_Product_ID IS NULL AND M_Product_Category_ID = ?  ");
        }
        CPreparedStatement pstmt = null;
        try {
            ResultSet rs;
            pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
            pstmt.setInt(1, this.getM_ReturnPolicy_ID());
            if (M_Product_Category_ID != 0) {
                pstmt.setInt(2, M_Product_Category_ID);
            }
            if ((rs = pstmt.executeQuery()).next()) {
                M_ReturnPolicyLine_ID = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        return M_ReturnPolicyLine_ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean policyHasLines() {
        StringBuffer sql = new StringBuffer("SELECT count(*) FROM M_ReturnPolicyLine WHERE M_ReturnPolicy_ID =? ");
        int lineCount = 0;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
            pstmt.setInt(1, this.getM_ReturnPolicy_ID());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                lineCount = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        return lineCount != 0;
    }

    public boolean checkReturnPolicy(Timestamp shipDate, Timestamp returnDate) {
        if (this.policyHasLines()) {
            return true;
        }
        long timeFrame = this.getTimeFrame() * 24 * 60 * 60;
        if (timeFrame == 0L) {
            return false;
        }
        this.log.fine("ShipDate : " + shipDate.toString() + " ReturnDate : " + returnDate.toString() + " TimeFrame : " + timeFrame);
        Timestamp allowedDate = new Timestamp(timeFrame * 1000L + shipDate.getTime());
        this.log.fine("Allowed Date : " + allowedDate.toString());
        return !returnDate.after(allowedDate);
    }

    public boolean checkReturnPolicy(Timestamp shipDate, Timestamp returnDate, int M_Product_ID) {
        long timeFrame;
        int M_ReturnPolicyLine_ID = this.getProductLine(M_Product_ID);
        if (M_ReturnPolicyLine_ID == 0) {
            MProduct product = new MProduct(this.getCtx(), M_Product_ID, this.get_TrxName());
            this.getProductCategoryLine(product.getM_Product_Category_ID());
        }
        if (M_ReturnPolicyLine_ID == 0) {
            timeFrame = this.getTimeFrame() * 24 * 60 * 60;
        } else {
            MReturnPolicyLine rpolicyLine = new MReturnPolicyLine(this.getCtx(), M_ReturnPolicyLine_ID, this.get_TrxName());
            timeFrame = rpolicyLine.getTimeFrame() * 24 * 60 * 60;
        }
        if (timeFrame == 0L) {
            return false;
        }
        this.log.fine("ShipDate : " + shipDate.toString() + " ReturnDate : " + returnDate.toString() + " TimeFrame : " + timeFrame);
        Timestamp allowedDate = new Timestamp(timeFrame * 1000L + shipDate.getTime());
        this.log.fine("Allowed Date : " + allowedDate.toString());
        return !returnDate.after(allowedDate);
    }

    public static int getDefault(Ctx ctx) {
        int AD_Client_ID = ctx.getAD_Client_ID();
        int rPolicy_ID = 0;
        CPreparedStatement pstmt = null;
        String sql = "SELECT M_ReturnPolicy_ID FROM M_ReturnPolicy WHERE IsDefault='Y' AND IsActive='Y' AND AD_Client_ID=? ";
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, AD_Client_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                rPolicy_ID = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            // empty catch block
        }
        return rPolicy_ID;
    }
}

