/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.framework.PO;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MRfQ;
import org.compiere.model.MRfQLine;
import org.compiere.model.MRfQResponseLine;
import org.compiere.model.MRfQResponseLineQty;
import org.compiere.model.MRfQTopicSubscriber;
import org.compiere.model.MUser;
import org.compiere.model.X_C_RfQResponse;
import org.compiere.print.ReportEngine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class MRfQResponse
extends X_C_RfQResponse {
    private MRfQ m_rfq = null;
    private MRfQResponseLine[] m_lines = null;

    public MRfQResponse(Ctx ctx, int C_RfQResponse_ID, String trxName) {
        super(ctx, C_RfQResponse_ID, trxName);
        if (C_RfQResponse_ID == 0) {
            this.setIsComplete(false);
            this.setIsSelectedWinner(false);
            this.setIsSelfService(false);
            this.setPrice(Env.ZERO);
            this.setProcessed(false);
            this.setProcessing(false);
        }
    }

    public MRfQResponse(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MRfQResponse(MRfQ rfq, MRfQTopicSubscriber subscriber) {
        this(rfq, subscriber, subscriber.getC_BPartner_ID(), subscriber.getC_BPartner_Location_ID(), subscriber.getAD_User_ID());
    }

    public MRfQResponse(MRfQ rfq, MBPartner partner) {
        this(rfq, null, partner.getC_BPartner_ID(), partner.getPrimaryC_BPartner_Location_ID(), partner.getPrimaryAD_User_ID());
    }

    public MRfQResponse(MRfQ rfq, MRfQTopicSubscriber subscriber, int C_BPartner_ID, int C_BPartner_Location_ID, int AD_User_ID) {
        this(rfq.getCtx(), 0, rfq.get_TrxName());
        this.setClientOrg((PO)rfq);
        this.setC_RfQ_ID(rfq.getC_RfQ_ID());
        this.setC_Currency_ID(rfq.getC_Currency_ID());
        this.setName(rfq.getName());
        this.m_rfq = rfq;
        this.setC_BPartner_ID(C_BPartner_ID);
        this.setC_BPartner_Location_ID(C_BPartner_Location_ID);
        this.setAD_User_ID(AD_User_ID);
        MRfQLine[] lines = rfq.getLines();
        for (int i = 0; i < lines.length; ++i) {
            if (!lines[i].isActive() || subscriber != null && !subscriber.isIncluded(lines[i].getM_Product_ID())) continue;
            if (this.get_ID() == 0) {
                this.save();
            }
            MRfQResponseLine line = new MRfQResponseLine(this, lines[i]);
        }
    }

    public MRfQResponseLine[] getLines(boolean requery) {
        if (this.m_lines != null && !requery) {
            return this.m_lines;
        }
        ArrayList<MRfQResponseLine> list = new ArrayList<MRfQResponseLine>();
        String sql = "SELECT * FROM C_RfQResponseLine WHERE C_RfQResponse_ID=? AND IsActive='Y'";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getC_RfQResponse_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MRfQResponseLine(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "getLines", (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_lines = new MRfQResponseLine[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }

    public MRfQResponseLine[] getLines() {
        return this.getLines(false);
    }

    public MRfQ getRfQ() {
        if (this.m_rfq == null) {
            this.m_rfq = MRfQ.get(this.getCtx(), this.getC_RfQ_ID(), this.get_TrxName());
        }
        return this.m_rfq;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MRfQResponse[");
        sb.append(this.get_ID()).append(",Complete=").append(this.isComplete()).append(",Winner=").append(this.isSelectedWinner()).append("]");
        return sb.toString();
    }

    public boolean sendRfQ() {
        EMail email;
        MUser to = MUser.get((Ctx)this.getCtx(), (int)this.getAD_User_ID());
        if (to.get_ID() == 0 || to.getEMail() == null || to.getEMail().length() == 0) {
            this.log.log(Level.SEVERE, "No User or no EMail - " + to);
            return false;
        }
        MClient client = MClient.get((Ctx)this.getCtx());
        String message = this.getDescription();
        if (message == null || message.length() == 0) {
            message = this.getHelp();
        } else if (this.getHelp() != null) {
            message = message + "\n" + this.getHelp();
        }
        if (message == null) {
            message = this.getName();
        }
        if ((email = client.createEMail(to.getEMail(), to.getName(), "RfQ: " + this.getName(), message)) == null) {
            return false;
        }
        email.addAttachment(this.createPDF());
        if ("OK".equals(email.send())) {
            this.setDateInvited(new Timestamp(System.currentTimeMillis()));
            this.save();
            return true;
        }
        return false;
    }

    public File createPDF() {
        return this.createPDF(null);
    }

    public File createPDF(File file) {
        ReportEngine re = ReportEngine.get((Ctx)this.getCtx(), (int)4, (int)this.getC_RfQResponse_ID());
        if (re == null) {
            return null;
        }
        return re.getPDF(file);
    }

    public String checkComplete() {
        MRfQResponseLine line;
        int i;
        MRfQResponseLine[] lines;
        BigDecimal amt;
        MRfQ rfq;
        String error;
        if (this.isComplete()) {
            this.setIsComplete(false);
        }
        if ((error = (rfq = this.getRfQ()).checkQuoteTotalAmtOnly()) != null && error.length() > 0) {
            return error;
        }
        if ((rfq.isQuoteTotalAmt() || rfq.isQuoteTotalAmtOnly()) && ((amt = this.getPrice()) == null || Env.ZERO.compareTo(amt) >= 0)) {
            return "No Total Amount";
        }
        if (rfq.isQuoteAllLines()) {
            lines = this.getLines(false);
            for (i = 0; i < lines.length; ++i) {
                line = lines[i];
                if (!line.isActive()) {
                    return "Line " + line.getRfQLine().getLine() + ": Not Active";
                }
                boolean validAmt = false;
                MRfQResponseLineQty[] qtys = line.getQtys(false);
                for (int j = 0; j < qtys.length; ++j) {
                    BigDecimal amt2;
                    MRfQResponseLineQty qty = qtys[j];
                    if (!qty.isActive() || (amt2 = qty.getNetAmt()) == null || Env.ZERO.compareTo(amt2) >= 0) continue;
                    validAmt = true;
                    break;
                }
                if (validAmt) continue;
                return "Line " + line.getRfQLine().getLine() + ": No Amount";
            }
        }
        if (rfq.isQuoteAllQty()) {
            lines = this.getLines(false);
            for (i = 0; i < lines.length; ++i) {
                line = lines[i];
                MRfQResponseLineQty[] qtys = line.getQtys(false);
                for (int j = 0; j < qtys.length; ++j) {
                    MRfQResponseLineQty qty = qtys[j];
                    if (!qty.isActive()) {
                        return "Line " + line.getRfQLine().getLine() + " Qty=" + qty.getRfQLineQty().getQty() + ": Not Active";
                    }
                    BigDecimal amt3 = qty.getNetAmt();
                    if (amt3 != null && Env.ZERO.compareTo(amt3) < 0) continue;
                    return "Line " + line.getRfQLine().getLine() + " Qty=" + qty.getRfQLineQty().getQty() + ": No Amount";
                }
            }
        }
        this.setIsComplete(true);
        return null;
    }

    public boolean isQuoteTotalAmtOnly() {
        return this.getRfQ().isQuoteTotalAmtOnly();
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getDateWorkStart() != null && this.getDeliveryDays() != 0) {
            this.setDateWorkComplete(TimeUtil.addDays((Timestamp)this.getDateWorkStart(), (int)this.getDeliveryDays()));
        } else if (this.getDateWorkStart() != null && this.getDeliveryDays() == 0 && this.getDateWorkComplete() != null) {
            this.setDeliveryDays(TimeUtil.getDaysBetween((Timestamp)this.getDateWorkStart(), (Timestamp)this.getDateWorkComplete()));
        } else if (this.getDateWorkStart() == null && this.getDeliveryDays() != 0 && this.getDateWorkComplete() != null) {
            this.setDateWorkStart(TimeUtil.addDays((Timestamp)this.getDateWorkComplete(), (int)(this.getDeliveryDays() * -1)));
        }
        return true;
    }
}

