/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.framework.PO;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MLocator;
import org.compiere.model.MProduct;
import org.compiere.model.MProductLocator;
import org.compiere.model.MWarehouse;
import org.compiere.model.X_M_Storage;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MStorage
extends X_M_Storage {
    private static CLogger s_log = CLogger.getCLogger(MStorage.class);
    private int m_M_Warehouse_ID = 0;

    public static MStorage get(Ctx ctx, int M_Locator_ID, int M_Product_ID, int M_AttributeSetInstance_ID, String trxName) {
        MStorage retValue = null;
        String sql = "SELECT * FROM M_Storage WHERE M_Locator_ID=? AND M_Product_ID=? AND ";
        sql = M_AttributeSetInstance_ID == 0 ? sql + "(M_AttributeSetInstance_ID=? OR M_AttributeSetInstance_ID IS NULL)" : sql + "M_AttributeSetInstance_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, M_Locator_ID);
            pstmt.setInt(2, M_Product_ID);
            pstmt.setInt(3, M_AttributeSetInstance_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MStorage(ctx, rs, trxName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            s_log.log(Level.SEVERE, sql, (Throwable)ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        pstmt = null;
        if (retValue == null) {
            s_log.fine("Not Found - M_Locator_ID=" + M_Locator_ID + ", M_Product_ID=" + M_Product_ID + ", M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID);
        } else {
            s_log.fine("M_Locator_ID=" + M_Locator_ID + ", M_Product_ID=" + M_Product_ID + ", M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID);
        }
        return retValue;
    }

    public static MStorage[] getAllWithASI(Ctx ctx, int M_Product_ID, int M_Locator_ID, boolean FiFo, String trxName) {
        ArrayList<MStorage> list = new ArrayList<MStorage>();
        String sql = "SELECT * FROM M_Storage WHERE M_Product_ID=? AND M_Locator_ID=? AND M_AttributeSetInstance_ID > 0 AND QtyOnHand > 0 ORDER BY M_AttributeSetInstance_ID";
        if (!FiFo) {
            sql = sql + " DESC";
        }
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, M_Product_ID);
            pstmt.setInt(2, M_Locator_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MStorage(ctx, rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            s_log.log(Level.SEVERE, sql, (Throwable)ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        pstmt = null;
        MStorage[] retValue = new MStorage[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MStorage[] getAll(Ctx ctx, int M_Product_ID, int M_Locator_ID, String trxName) {
        ArrayList<MStorage> list = new ArrayList<MStorage>();
        String sql = "SELECT * FROM M_Storage WHERE M_Product_ID=? AND M_Locator_ID=? AND QtyOnHand <> 0 ORDER BY M_AttributeSetInstance_ID";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, M_Product_ID);
            pstmt.setInt(2, M_Locator_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MStorage(ctx, rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            s_log.log(Level.SEVERE, sql, (Throwable)ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        pstmt = null;
        MStorage[] retValue = new MStorage[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MStorage[] getOfProduct(Ctx ctx, int M_Product_ID, String trxName) {
        ArrayList<MStorage> list = new ArrayList<MStorage>();
        String sql = "SELECT * FROM M_Storage WHERE M_Product_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, M_Product_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MStorage(ctx, rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            s_log.log(Level.SEVERE, sql, (Throwable)ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        pstmt = null;
        MStorage[] retValue = new MStorage[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MStorage[] getWarehouse(Ctx ctx, int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_AttributeSet_ID, boolean allAttributeInstances, Timestamp minGuaranteeDate, boolean FiFo, String trxName) {
        if (M_Warehouse_ID == 0 || M_Product_ID == 0) {
            return new MStorage[0];
        }
        if (M_AttributeSet_ID == 0) {
            allAttributeInstances = true;
        } else {
            MAttributeSet mas = MAttributeSet.get(ctx, M_AttributeSet_ID);
            if (!mas.isInstanceAttribute()) {
                allAttributeInstances = true;
            }
        }
        ArrayList<MStorage> list = new ArrayList<MStorage>();
        String sql = "SELECT s.M_Product_ID,s.M_Locator_ID,s.M_AttributeSetInstance_ID,s.AD_Client_ID,s.AD_Org_ID,s.IsActive,s.Created,s.CreatedBy,s.Updated,s.UpdatedBy,s.QtyOnHand,s.QtyReserved,s.QtyOrdered,s.DateLastInventory FROM M_Storage s INNER JOIN M_Locator l ON (l.M_Locator_ID=s.M_Locator_ID) WHERE l.M_Warehouse_ID=? AND s.M_Product_ID=? AND COALESCE(s.M_AttributeSetInstance_ID,0)=? ORDER BY l.PriorityNo DESC, M_AttributeSetInstance_ID";
        if (!FiFo) {
            sql = sql + " DESC";
        }
        if (allAttributeInstances) {
            sql = "SELECT s.M_Product_ID,s.M_Locator_ID,s.M_AttributeSetInstance_ID,s.AD_Client_ID,s.AD_Org_ID,s.IsActive,s.Created,s.CreatedBy,s.Updated,s.UpdatedBy,s.QtyOnHand,s.QtyReserved,s.QtyOrdered,s.DateLastInventory FROM M_Storage s INNER JOIN M_Locator l ON (l.M_Locator_ID=s.M_Locator_ID) LEFT OUTER JOIN M_AttributeSetInstance asi ON (s.M_AttributeSetInstance_ID=asi.M_AttributeSetInstance_ID) WHERE l.M_Warehouse_ID=? AND s.M_Product_ID=? ";
            if (minGuaranteeDate != null) {
                sql = sql + "AND (asi.GuaranteeDate IS NULL OR asi.GuaranteeDate>?) ORDER BY asi.GuaranteeDate, M_AttributeSetInstance_ID";
                if (!FiFo) {
                    sql = sql + " DESC";
                }
                sql = sql + ", l.PriorityNo DESC, s.QtyOnHand DESC";
            } else {
                sql = sql + "ORDER BY l.PriorityNo DESC, l.M_Locator_ID, s.M_AttributeSetInstance_ID";
                if (!FiFo) {
                    sql = sql + " DESC";
                }
                sql = sql + ", s.QtyOnHand DESC";
            }
        }
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, M_Warehouse_ID);
            pstmt.setInt(2, M_Product_ID);
            if (!allAttributeInstances) {
                pstmt.setInt(3, M_AttributeSetInstance_ID);
            } else if (minGuaranteeDate != null) {
                pstmt.setTimestamp(3, minGuaranteeDate);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MStorage(ctx, rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MStorage[] retValue = new MStorage[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MStorage getCreate(Ctx ctx, int M_Locator_ID, int M_Product_ID, int M_AttributeSetInstance_ID, String trxName) {
        if (M_Locator_ID == 0) {
            throw new IllegalArgumentException("M_Locator_ID=0");
        }
        if (M_Product_ID == 0) {
            throw new IllegalArgumentException("M_Product_ID=0");
        }
        MStorage retValue = MStorage.get(ctx, M_Locator_ID, M_Product_ID, M_AttributeSetInstance_ID, trxName);
        if (retValue != null) {
            return retValue;
        }
        MLocator locator = new MLocator(ctx, M_Locator_ID, trxName);
        if (locator.get_ID() != M_Locator_ID) {
            throw new IllegalArgumentException("Not found M_Locator_ID=" + M_Locator_ID);
        }
        retValue = new MStorage(locator, M_Product_ID, M_AttributeSetInstance_ID);
        retValue.save(trxName);
        s_log.fine("New " + (Object)((Object)retValue));
        return retValue;
    }

    public static boolean add(Ctx ctx, int M_Warehouse_ID, int M_Locator_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int reservationAttributeSetInstance_ID, BigDecimal diffQtyOnHand, BigDecimal diffQtyReserved, BigDecimal diffQtyOrdered, String trxName) {
        MStorage storage = null;
        StringBuffer diffText = new StringBuffer("(");
        if (storage == null) {
            storage = MStorage.getCreate(ctx, M_Locator_ID, M_Product_ID, M_AttributeSetInstance_ID, trxName);
        }
        if (storage.getM_Locator_ID() != M_Locator_ID && storage.getM_Product_ID() != M_Product_ID && storage.getM_AttributeSetInstance_ID() != M_AttributeSetInstance_ID) {
            s_log.severe("No Storage found - M_Locator_ID=" + M_Locator_ID + ",M_Product_ID=" + M_Product_ID + ",ASI=" + M_AttributeSetInstance_ID);
            return false;
        }
        MStorage storageASI = null;
        if (M_AttributeSetInstance_ID != reservationAttributeSetInstance_ID) {
            int reservationM_Locator_ID = M_Locator_ID;
            if (reservationAttributeSetInstance_ID == 0) {
                MWarehouse wh = MWarehouse.get((Ctx)ctx, (int)M_Warehouse_ID);
                reservationM_Locator_ID = wh.getDefaultM_Locator_ID();
            }
            if ((storageASI = MStorage.get(ctx, reservationM_Locator_ID, M_Product_ID, reservationAttributeSetInstance_ID, trxName)) == null) {
                MProduct product = MProduct.get(ctx, M_Product_ID);
                int xM_Locator_ID = MProductLocator.getFirstM_Locator_ID(product, M_Warehouse_ID);
                if (xM_Locator_ID == 0) {
                    MWarehouse wh = MWarehouse.get((Ctx)ctx, (int)M_Warehouse_ID);
                    xM_Locator_ID = wh.getDefaultM_Locator_ID();
                }
                storageASI = MStorage.getCreate(ctx, xM_Locator_ID, M_Product_ID, reservationAttributeSetInstance_ID, trxName);
            }
        }
        boolean changed = false;
        if (diffQtyOnHand != null && diffQtyOnHand.signum() != 0) {
            storage.setQtyOnHand(storage.getQtyOnHand().add(diffQtyOnHand));
            diffText.append("OnHand=").append(diffQtyOnHand);
            changed = true;
        }
        if (diffQtyReserved != null && diffQtyReserved.signum() != 0) {
            if (storageASI == null) {
                storage.setQtyReserved(storage.getQtyReserved().add(diffQtyReserved));
            } else {
                storageASI.setQtyReserved(storageASI.getQtyReserved().add(diffQtyReserved));
            }
            diffText.append(" Reserved=").append(diffQtyReserved);
            changed = true;
        }
        if (diffQtyOrdered != null && diffQtyOrdered.signum() != 0) {
            if (storageASI == null) {
                storage.setQtyOrdered(storage.getQtyOrdered().add(diffQtyOrdered));
            } else {
                storageASI.setQtyOrdered(storageASI.getQtyOrdered().add(diffQtyOrdered));
            }
            diffText.append(" Ordered=").append(diffQtyOrdered);
            changed = true;
        }
        if (changed) {
            diffText.append(") -> ").append(storage.toString());
            s_log.fine(diffText.toString());
            if (storageASI != null) {
                storageASI.save(trxName);
            }
            return storage.save(trxName);
        }
        return true;
    }

    public static int getM_Locator_ID(int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID, BigDecimal Qty, String trxName) {
        int M_Locator_ID = 0;
        int firstM_Locator_ID = 0;
        String sql = "SELECT s.M_Locator_ID, s.QtyOnHand FROM M_Storage s INNER JOIN M_Locator l ON (s.M_Locator_ID=l.M_Locator_ID) INNER JOIN M_Product p ON (s.M_Product_ID=p.M_Product_ID) LEFT OUTER JOIN M_AttributeSet mas ON (p.M_AttributeSet_ID=mas.M_AttributeSet_ID) WHERE l.M_Warehouse_ID=? AND s.M_Product_ID=? AND (mas.IsInstanceAttribute IS NULL OR mas.IsInstanceAttribute='N' OR s.M_AttributeSetInstance_ID=?) AND l.IsActive='Y' ORDER BY l.PriorityNo DESC, s.QtyOnHand DESC";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, M_Warehouse_ID);
            pstmt.setInt(2, M_Product_ID);
            pstmt.setInt(3, M_AttributeSetInstance_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                BigDecimal QtyOnHand = rs.getBigDecimal(2);
                if (QtyOnHand != null && Qty.compareTo(QtyOnHand) <= 0) {
                    M_Locator_ID = rs.getInt(1);
                    break;
                }
                if (firstM_Locator_ID != 0) continue;
                firstM_Locator_ID = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            s_log.log(Level.SEVERE, sql, (Throwable)ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        pstmt = null;
        if (M_Locator_ID != 0) {
            return M_Locator_ID;
        }
        return firstM_Locator_ID;
    }

    public static BigDecimal getQtyAvailable(int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID, String trxName) {
        BigDecimal retValue = null;
        CPreparedStatement pstmt = null;
        String sql = "SELECT SUM(QtyOnHand-QtyReserved) FROM M_Storage s INNER JOIN M_Locator l ON (s.M_Locator_ID=l.M_Locator_ID) WHERE s.M_Product_ID=? AND l.M_Warehouse_ID=?";
        if (M_AttributeSetInstance_ID != 0) {
            sql = sql + " AND M_AttributeSetInstance_ID=?";
        }
        try {
            ResultSet rs;
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, M_Product_ID);
            pstmt.setInt(2, M_Warehouse_ID);
            if (M_AttributeSetInstance_ID != 0) {
                pstmt.setInt(3, M_AttributeSetInstance_ID);
            }
            if ((rs = pstmt.executeQuery()).next()) {
                retValue = rs.getBigDecimal(1);
                if (rs.wasNull()) {
                    retValue = null;
                }
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        s_log.fine("M_Warehouse_ID=" + M_Warehouse_ID + ",M_Product_ID=" + M_Product_ID + " = " + retValue);
        return retValue;
    }

    public MStorage(Ctx ctx, int ignored, String trxName) {
        super(ctx, 0, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
        this.setQtyOnHand(Env.ZERO);
        this.setQtyOrdered(Env.ZERO);
        this.setQtyReserved(Env.ZERO);
    }

    public MStorage(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    private MStorage(MLocator locator, int M_Product_ID, int M_AttributeSetInstance_ID) {
        this(locator.getCtx(), 0, locator.get_TrxName());
        this.setClientOrg((PO)locator);
        this.setM_Locator_ID(locator.getM_Locator_ID());
        this.setM_Product_ID(M_Product_ID);
        this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
    }

    public void changeQtyOnHand(BigDecimal qty, boolean add) {
        if (qty == null || qty.signum() == 0) {
            return;
        }
        if (add) {
            this.setQtyOnHand(this.getQtyOnHand().add(qty));
        } else {
            this.setQtyOnHand(this.getQtyOnHand().subtract(qty));
        }
    }

    public int getM_Warehouse_ID() {
        if (this.m_M_Warehouse_ID == 0) {
            MLocator loc = MLocator.get((Ctx)this.getCtx(), (int)this.getM_Locator_ID());
            this.m_M_Warehouse_ID = loc.getM_Warehouse_ID();
        }
        return this.m_M_Warehouse_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MStorage[").append("M_Locator_ID=").append(this.getM_Locator_ID()).append(",M_Product_ID=").append(this.getM_Product_ID()).append(",M_AttributeSetInstance_ID=").append(this.getM_AttributeSetInstance_ID()).append(": OnHand=").append(this.getQtyOnHand()).append(",Reserved=").append(this.getQtyReserved()).append(",Ordered=").append(this.getQtyOrdered()).append("]");
        return sb.toString();
    }
}

