/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MTaxPostal;
import org.compiere.model.X_C_Tax;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class MTax
extends X_C_Tax {
    private static CCache<Integer, MTax> s_cache = new CCache("C_Tax", 5);
    private static CCache<Integer, MTax[]> s_cacheAll = new CCache("C_Tax", 5);
    private static CLogger s_log = CLogger.getCLogger(MTax.class);
    private static BigDecimal ONEHUNDRED = new BigDecimal(100);
    private MTax[] m_childTaxes = null;
    private MTaxPostal[] m_postals = null;

    public static MTax[] getAll(Ctx ctx) {
        int AD_Client_ID = ctx.getAD_Client_ID();
        Integer key = new Integer(AD_Client_ID);
        MTax[] retValue = (MTax[])s_cacheAll.get((Object)key);
        if (retValue != null) {
            return retValue;
        }
        String sql = "SELECT * FROM C_Tax WHERE AD_Client_ID=? ORDER BY C_Country_ID, C_Region_ID, To_Country_ID, To_Region_ID";
        ArrayList<MTax> list = new ArrayList<MTax>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, AD_Client_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MTax tax = new MTax(ctx, rs, null);
                s_cache.put((Object)new Integer(tax.getC_Tax_ID()), (Object)tax);
                list.add(tax);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        retValue = new MTax[list.size()];
        list.toArray(retValue);
        s_cacheAll.put((Object)key, (Object)retValue);
        return retValue;
    }

    public static MTax get(Ctx ctx, int C_Tax_ID) {
        Integer key = new Integer(C_Tax_ID);
        MTax retValue = (MTax)((Object)s_cache.get((Object)key));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MTax(ctx, C_Tax_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)key, (Object)retValue);
        }
        return retValue;
    }

    public MTax(Ctx ctx, int C_Tax_ID, String trxName) {
        super(ctx, C_Tax_ID, trxName);
        if (C_Tax_ID == 0) {
            this.setIsDefault(false);
            this.setIsDocumentLevel(true);
            this.setIsSummary(false);
            this.setIsTaxExempt(false);
            this.setRate(Env.ZERO);
            this.setRequiresTaxCertificate(false);
            this.setSOPOType("B");
            this.setValidFrom(TimeUtil.getDay((int)1990, (int)1, (int)1));
            this.setIsSalesTax(false);
        }
    }

    public MTax(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MTax(Ctx ctx, String Name, BigDecimal Rate, int C_TaxCategory_ID, String trxName) {
        this(ctx, 0, trxName);
        this.setName(Name);
        this.setRate(Rate == null ? Env.ZERO : Rate);
        this.setC_TaxCategory_ID(C_TaxCategory_ID);
    }

    public MTax[] getChildTaxes(boolean requery) {
        if (!this.isSummary()) {
            return null;
        }
        if (this.m_childTaxes != null && !requery) {
            return this.m_childTaxes;
        }
        String sql = "SELECT * FROM C_Tax WHERE Parent_Tax_ID=?";
        ArrayList<MTax> list = new ArrayList<MTax>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getC_Tax_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MTax(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_childTaxes = new MTax[list.size()];
        list.toArray(this.m_childTaxes);
        return this.m_childTaxes;
    }

    public MTaxPostal[] getPostals(boolean requery) {
        if (this.m_postals != null && !requery) {
            return this.m_postals;
        }
        String sql = "SELECT * FROM C_TaxPostal WHERE C_Tax_ID=? ORDER BY Postal, Postal_To";
        ArrayList list = new ArrayList();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getC_Tax_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_postals = new MTaxPostal[list.size()];
        list.toArray(this.m_postals);
        return this.m_postals;
    }

    public boolean isPostal() {
        return this.getPostals(false).length > 0;
    }

    public boolean isZeroTax() {
        return Env.ZERO.compareTo(this.getRate()) == 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MTax[");
        sb.append(this.get_ID()).append(",").append(this.getName()).append(", SO/PO=").append(this.getSOPOType()).append(",Rate=").append(this.getRate()).append(",C_TaxCategory_ID=").append(this.getC_TaxCategory_ID()).append(",Summary=").append(this.isSummary()).append(",Parent=").append(this.getParent_Tax_ID()).append(",Country=").append(this.getC_Country_ID()).append("|").append(this.getTo_Country_ID()).append(",Region=").append(this.getC_Region_ID()).append("|").append(this.getTo_Region_ID()).append(",From=").append(this.getValidFrom()).append("]");
        return sb.toString();
    }

    public BigDecimal calculateTax(BigDecimal amount, boolean taxIncluded, int scale, int roundingMode) {
        if (this.isZeroTax()) {
            return Env.ZERO;
        }
        if (roundingMode < 0 || roundingMode > 7) {
            roundingMode = 4;
        }
        BigDecimal multiplier = this.getRate().divide(ONEHUNDRED, 12, 4);
        BigDecimal tax = null;
        if (!taxIncluded) {
            tax = amount.multiply(multiplier);
        } else {
            multiplier = multiplier.add(Env.ONE);
            BigDecimal base = amount.divide(multiplier, 12, 4);
            tax = amount.subtract(base);
        }
        BigDecimal finalTax = tax.setScale(scale, roundingMode);
        this.log.fine("calculateTax " + amount + " (incl=" + taxIncluded + ",mult=" + multiplier + ",scale=" + scale + ",roundingMode=" + roundingMode + ") = " + finalTax + " [" + tax + "]");
        return finalTax;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord & success) {
            this.insert_Accounting("C_Tax_Acct", "C_AcctSchema_Default", null);
        }
        return success;
    }

    protected boolean beforeDelete() {
        return this.delete_Accounting("C_Tax_Acct");
    }
}

