/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.api.UICallout;
import org.compiere.model.MConversionRate;
import org.compiere.model.MProductPricing;
import org.compiere.model.MResourceAssignment;
import org.compiere.model.MTimeExpense;
import org.compiere.model.X_S_TimeExpenseLine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MTimeExpenseLine
extends X_S_TimeExpenseLine {
    private int m_C_Currency_Report_ID = 0;

    public MTimeExpenseLine(Ctx ctx, int S_TimeExpenseLine_ID, String trxName) {
        super(ctx, S_TimeExpenseLine_ID, trxName);
        if (S_TimeExpenseLine_ID == 0) {
            this.setQty(Env.ONE);
            this.setQtyInvoiced(Env.ZERO);
            this.setQtyReimbursed(Env.ZERO);
            this.setExpenseAmt(Env.ZERO);
            this.setConvertedAmt(Env.ZERO);
            this.setPriceReimbursed(Env.ZERO);
            this.setInvoicePrice(Env.ZERO);
            this.setPriceInvoiced(Env.ZERO);
            this.setDateExpense(new Timestamp(System.currentTimeMillis()));
            this.setIsInvoiced(false);
            this.setIsTimeReport(false);
            this.setLine(10);
            this.setProcessed(false);
        }
    }

    public MTimeExpenseLine(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public BigDecimal getQtyInvoiced() {
        BigDecimal bd = super.getQtyInvoiced();
        if (Env.ZERO.compareTo(bd) == 0) {
            return this.getQty();
        }
        return bd;
    }

    public BigDecimal getQtyReimbursed() {
        BigDecimal bd = super.getQtyReimbursed();
        if (Env.ZERO.compareTo(bd) == 0) {
            return this.getQty();
        }
        return bd;
    }

    public BigDecimal getPriceInvoiced() {
        BigDecimal bd = super.getPriceInvoiced();
        if (Env.ZERO.compareTo(bd) == 0) {
            return this.getInvoicePrice();
        }
        return bd;
    }

    public BigDecimal getPriceReimbursed() {
        BigDecimal bd = super.getPriceReimbursed();
        if (Env.ZERO.compareTo(bd) == 0) {
            return this.getConvertedAmt();
        }
        return bd;
    }

    public BigDecimal getApprovalAmt() {
        return this.getQty().multiply(this.getConvertedAmt());
    }

    public int getC_Currency_Report_ID() {
        if (this.m_C_Currency_Report_ID != 0) {
            return this.m_C_Currency_Report_ID;
        }
        MTimeExpense te = new MTimeExpense(this.getCtx(), this.getS_TimeExpense_ID(), this.get_TrxName());
        this.m_C_Currency_Report_ID = te.getC_Currency_ID();
        return this.m_C_Currency_Report_ID;
    }

    protected void setC_Currency_Report_ID(int C_Currency_ID) {
        this.m_C_Currency_Report_ID = C_Currency_ID;
    }

    @UICallout
    public void setS_ResourceAssignment_ID(String oldS_ResourceAssignment_ID, String newS_ResourceAssignment_ID, int windowNo) throws Exception {
        if (newS_ResourceAssignment_ID == null || newS_ResourceAssignment_ID.length() == 0) {
            return;
        }
        int S_ResourceAssignment_ID = Integer.parseInt(newS_ResourceAssignment_ID);
        if (S_ResourceAssignment_ID == 0) {
            return;
        }
        super.setS_ResourceAssignment_ID(S_ResourceAssignment_ID);
        int M_Product_ID = 0;
        String Name = null;
        String Description = null;
        BigDecimal Qty = null;
        String sql = "SELECT p.M_Product_ID, ra.Name, ra.Description, ra.Qty FROM S_ResourceAssignment ra INNER JOIN M_Product p ON (p.S_Resource_ID=ra.S_Resource_ID) WHERE ra.S_ResourceAssignment_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, S_ResourceAssignment_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                M_Product_ID = rs.getInt(1);
                Name = rs.getString(2);
                Description = rs.getString(3);
                Qty = rs.getBigDecimal(4);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        this.log.fine("S_ResourceAssignment_ID=" + S_ResourceAssignment_ID + " - M_Product_ID=" + M_Product_ID);
        if (M_Product_ID != 0) {
            this.setM_Product_ID(M_Product_ID);
            if (Description != null) {
                Name = Name + " (" + Description + ")";
            }
            if (!".".equals(Name)) {
                this.setDescription(Name);
            }
            if (Qty != null) {
                this.setQty(Qty);
            }
        }
    }

    @UICallout
    public void setM_Product_ID(String oldM_Product_ID, String newM_Product_ID, int windowNo) throws Exception {
        if (newM_Product_ID == null || newM_Product_ID.length() == 0) {
            return;
        }
        int M_Product_ID = Integer.parseInt(newM_Product_ID);
        super.setM_Product_ID(M_Product_ID);
        if (M_Product_ID == 0) {
            return;
        }
        MTimeExpense hdr = new MTimeExpense(this.getCtx(), this.getS_TimeExpense_ID(), null);
        int C_BPartner_ID = hdr.getC_BPartner_ID();
        BigDecimal Qty = this.getQty();
        boolean IsSOTrx = true;
        MProductPricing pp = new MProductPricing(this.getAD_Client_ID(), this.getAD_Org_ID(), M_Product_ID, C_BPartner_ID, Qty, IsSOTrx);
        int M_PriceList_ID = hdr.getM_PriceList_ID();
        pp.setM_PriceList_ID(M_PriceList_ID);
        Timestamp orderDate = this.getDateExpense();
        pp.setPriceDate(orderDate);
        this.setExpenseAmt(pp.getPriceStd());
        this.setC_Currency_ID(pp.getC_Currency_ID());
        this.setAmt(windowNo, "M_Product_ID");
    }

    @UICallout
    public void setC_Currency_ID(String oldC_Currency_ID, String newC_Currency_ID, int windowNo) throws Exception {
        if (newC_Currency_ID == null || newC_Currency_ID.length() == 0) {
            return;
        }
        int C_Currency_ID = Integer.parseInt(newC_Currency_ID);
        super.setC_Currency_ID(C_Currency_ID);
        this.setAmt(windowNo, "C_Currency_ID");
    }

    @UICallout
    public void setExpenseAmt(String oldExpenseAmt, String newExpenseAmt, int windowNo) throws Exception {
        if (newExpenseAmt == null || newExpenseAmt.length() == 0) {
            return;
        }
        BigDecimal ExpenseAmt = new BigDecimal(newExpenseAmt);
        super.setExpenseAmt(ExpenseAmt);
        this.setAmt(windowNo, "ExpenseAmt");
    }

    private void setAmt(int windowNo, String columnName) {
        BigDecimal ExpenseAmt = this.getExpenseAmt();
        int C_Currency_From_ID = this.getC_Currency_ID();
        int C_Currency_To_ID = this.getCtx().getContextAsInt("$C_Currency_ID");
        Timestamp DateExpense = this.getDateExpense();
        this.log.fine("Amt=" + ExpenseAmt + ", C_Currency_ID=" + C_Currency_From_ID);
        BigDecimal ConvertedAmt = ExpenseAmt;
        if (ConvertedAmt.signum() != 0 && C_Currency_To_ID != C_Currency_From_ID) {
            ConvertedAmt = MConversionRate.convert((Ctx)this.getCtx(), (BigDecimal)ConvertedAmt, (int)C_Currency_From_ID, (int)C_Currency_To_ID, (Timestamp)DateExpense, (int)0, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
        }
        this.setConvertedAmt(ConvertedAmt);
        this.log.fine("ConvertedAmt=" + ConvertedAmt);
    }

    protected boolean beforeSave(boolean newRecord) {
        if (newRecord || this.is_ValueChanged("ExpenseAmt") || this.is_ValueChanged("C_Currency_ID")) {
            if (this.getC_Currency_ID() == this.getC_Currency_Report_ID()) {
                this.setConvertedAmt(this.getExpenseAmt());
            } else {
                this.setConvertedAmt(MConversionRate.convert((Ctx)this.getCtx(), (BigDecimal)this.getExpenseAmt(), (int)this.getC_Currency_ID(), (int)this.getC_Currency_Report_ID(), (Timestamp)this.getDateExpense(), (int)0, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID()));
            }
        }
        if (this.isTimeReport()) {
            this.setExpenseAmt(Env.ZERO);
            this.setConvertedAmt(Env.ZERO);
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (success) {
            this.updateHeader();
            if (newRecord || this.is_ValueChanged("S_ResourceAssignment_ID")) {
                Object ii;
                int S_ResourceAssignment_ID = this.getS_ResourceAssignment_ID();
                int old_S_ResourceAssignment_ID = 0;
                if (!newRecord && (ii = this.get_ValueOld("S_ResourceAssignment_ID")) instanceof Integer && (old_S_ResourceAssignment_ID = ((Integer)ii).intValue()) != S_ResourceAssignment_ID && old_S_ResourceAssignment_ID != 0) {
                    MResourceAssignment ra = new MResourceAssignment(this.getCtx(), old_S_ResourceAssignment_ID, this.get_TrxName());
                    ra.delete(false);
                }
                if (S_ResourceAssignment_ID != 0) {
                    MResourceAssignment ra = new MResourceAssignment(this.getCtx(), S_ResourceAssignment_ID, this.get_TrxName());
                    if (this.getQty().compareTo(ra.getQty()) != 0) {
                        ra.setQty(this.getQty());
                        if (this.getDescription() != null && this.getDescription().length() > 0) {
                            ra.setDescription(this.getDescription());
                        }
                        ra.save();
                    }
                }
            }
        }
        return success;
    }

    protected boolean afterDelete(boolean success) {
        if (success) {
            int old_S_ResourceAssignment_ID;
            this.updateHeader();
            Object ii = this.get_ValueOld("S_ResourceAssignment_ID");
            if (ii instanceof Integer && (old_S_ResourceAssignment_ID = ((Integer)ii).intValue()) != 0) {
                MResourceAssignment ra = new MResourceAssignment(this.getCtx(), old_S_ResourceAssignment_ID, this.get_TrxName());
                ra.delete(false);
            }
        }
        return success;
    }

    private void updateHeader() {
        String sql = "UPDATE S_TimeExpense te SET ApprovalAmt = (SELECT SUM(Qty*ConvertedAmt) FROM S_TimeExpenseLine tel WHERE te.S_TimeExpense_ID=tel.S_TimeExpense_ID) WHERE S_TimeExpense_ID=" + this.getS_TimeExpense_ID();
        DB.executeUpdate((String)sql, (String)this.get_TrxName());
    }
}

