/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.compiere.model.MContainer;
import org.compiere.model.MMedia;
import org.compiere.model.X_CM_WikiToken;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MWikiToken
extends X_CM_WikiToken {
    private static final long serialVersionUID = 4980395873969221189L;
    private static CLogger s_log = CLogger.getCLogger(MWikiToken.class);
    private Pattern pattern = null;

    public MWikiToken(Ctx ctx, int CM_WikiToken_ID, String trxName) {
        super(ctx, CM_WikiToken_ID, trxName);
    }

    public MWikiToken(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public Pattern getPattern() {
        if (this.pattern != null) {
            return this.pattern;
        }
        this.pattern = Pattern.compile(this.getName());
        return this.pattern;
    }

    public boolean load(String trxName) {
        this.pattern = null;
        return super.load(trxName);
    }

    public static MWikiToken[] getAllForPreload(Ctx ctx, String trxName) {
        ArrayList<MWikiToken> list = new ArrayList<MWikiToken>();
        String sql = "SELECT * FROM CM_WikiToken WHERE Ad_Client_ID=0 AND isActive='Y' ORDER By SeqNo";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MWikiToken(ctx, rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MWikiToken[] retValue = new MWikiToken[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public StringBuffer processToken(StringBuffer source, int CM_WebProject_ID, String MediaPath) {
        if (this.getTokenType().equals("S")) {
            Matcher matcher = this.getPattern().matcher(source);
            source = new StringBuffer(matcher.replaceAll(this.getMacro()));
        } else if (!this.getTokenType().equals("Q")) {
            if (this.getTokenType().equals("E")) {
                Matcher matcher = this.getPattern().matcher(source);
                source = new StringBuffer(matcher.replaceAll(this.getMacro()));
            } else if (this.getTokenType().equals("I")) {
                Matcher matcher = this.getPattern().matcher(source);
                while (matcher.find()) {
                    if (matcher.group(1).equals("Media:")) {
                        String Name = matcher.group(2);
                        MMedia thisMedia = MMedia.getByName(this.getCtx(), Name, CM_WebProject_ID, null);
                        String replaceString = "";
                        if (thisMedia != null && matcher.groupCount() > 2) {
                            replaceString = "<img src=\"" + MediaPath + thisMedia.getFileName() + "\" alt=\"" + matcher.group(3) + "\"/>";
                        }
                        source = new StringBuffer(matcher.replaceFirst(replaceString));
                        matcher = this.getPattern().matcher(source);
                        continue;
                    }
                    String link = matcher.group(1);
                    MContainer thisContainer = MContainer.getByName(this.getCtx(), link, CM_WebProject_ID, null);
                    if (thisContainer == null) {
                        thisContainer = MContainer.getByTitle(this.getCtx(), link, CM_WebProject_ID, null);
                    }
                    String replaceURL = "/index.html";
                    if (thisContainer != null) {
                        replaceURL = matcher.groupCount() > 1 ? "<a href=\"" + thisContainer.getRelativeURL() + "\">" + matcher.group(2) + "</a>" : "<a href=\"" + thisContainer.getRelativeURL() + "\">" + matcher.group(1) + "</a>";
                    }
                    source = new StringBuffer(matcher.replaceFirst(replaceURL));
                    matcher = this.getPattern().matcher(source);
                }
            }
        }
        return source;
    }
}

