/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MAllocationHdr;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Trx;

public class AllocationReset
extends SvrProcess {
    private int p_C_BP_Group_ID = 0;
    private int p_C_BPartner_ID = 0;
    private Timestamp p_DateAcct_From = null;
    private Timestamp p_DateAcct_To = null;
    private int p_C_AllocationHdr_ID = 0;
    private Trx m_trx = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            this.log.fine("prepare - " + para[i]);
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("C_BP_Group_ID")) {
                this.p_C_BP_Group_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("C_AllocationHdr_ID")) {
                this.p_C_AllocationHdr_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("DateAcct")) {
                this.p_DateAcct_From = (Timestamp)para[i].getParameter();
                this.p_DateAcct_To = (Timestamp)para[i].getParameter_To();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    protected String doIt() throws Exception {
        this.log.info("C_BP_Group_ID=" + this.p_C_BP_Group_ID + ", C_BPartner_ID=" + this.p_C_BPartner_ID + ", DateAcct= " + this.p_DateAcct_From + " - " + this.p_DateAcct_To + ", C_AllocationHdr_ID=" + this.p_C_AllocationHdr_ID);
        this.m_trx = Trx.get((String)Trx.createTrxName((String)"AllocReset"), (boolean)true);
        int count = 0;
        if (this.p_C_AllocationHdr_ID != 0) {
            MAllocationHdr hdr = new MAllocationHdr(this.getCtx(), this.p_C_AllocationHdr_ID, this.m_trx.getTrxName());
            if (this.delete(hdr)) {
                ++count;
            }
            this.m_trx.close();
            return "@Deleted@ #" + count;
        }
        StringBuffer sql = new StringBuffer("SELECT * FROM C_AllocationHdr ah WHERE EXISTS (SELECT * FROM C_AllocationLine al WHERE ah.C_AllocationHdr_ID=al.C_AllocationHdr_ID");
        if (this.p_C_BPartner_ID != 0) {
            sql.append(" AND al.C_BPartner_ID=?");
        } else if (this.p_C_BP_Group_ID != 0) {
            sql.append(" AND EXISTS (SELECT * FROM C_BPartner bp WHERE bp.C_BPartner_ID=al.C_BPartner_ID AND bp.C_BP_Group_ID=?)");
        } else {
            sql.append(" AND AD_Client_ID=?");
        }
        if (this.p_DateAcct_From != null) {
            sql.append(" AND TRIM(ah.DateAcct) >= ?");
        }
        if (this.p_DateAcct_To != null) {
            sql.append(" AND TRIM(ah.DateAcct) <= ?");
        }
        sql.append(" AND al.C_CashLine_ID IS NULL)");
        sql.append(" AND EXISTS (SELECT * FROM C_Period p INNER JOIN C_PeriodControl pc ON (p.C_Period_ID=pc.C_Period_ID AND pc.DocBaseType='CMA') WHERE ah.DateAcct BETWEEN p.StartDate AND p.EndDate)");
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql.toString(), (String)this.m_trx.getTrxName());
            int index = 1;
            if (this.p_C_BPartner_ID != 0) {
                pstmt.setInt(index++, this.p_C_BPartner_ID);
            } else if (this.p_C_BP_Group_ID != 0) {
                pstmt.setInt(index++, this.p_C_BP_Group_ID);
            } else {
                pstmt.setInt(index++, this.getCtx().getAD_Client_ID());
            }
            if (this.p_DateAcct_From != null) {
                pstmt.setTimestamp(index++, this.p_DateAcct_From);
            }
            if (this.p_DateAcct_To != null) {
                pstmt.setTimestamp(index++, this.p_DateAcct_To);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MAllocationHdr hdr = new MAllocationHdr(this.getCtx(), rs, this.m_trx.getTrxName());
                if (!this.delete(hdr)) continue;
                ++count;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
            this.m_trx.rollback();
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_trx.close();
        return "@Deleted@ #" + count;
    }

    private boolean delete(MAllocationHdr hdr) {
        boolean success = false;
        if (hdr.delete(true, this.m_trx.getTrxName())) {
            this.log.fine(hdr.toString());
            success = true;
        }
        if (success) {
            this.m_trx.commit();
        } else {
            this.m_trx.rollback();
        }
        return success;
    }

    private void setBPartner() {
    }
}

