/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MBilling;
import org.compiere.model.MBillingLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoiceSchedule;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPayment;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.TimeUtil;

public class BillingGenerate
extends SvrProcess {
    private boolean p_Selection = false;
    private int p_C_Billing_ID = 0;
    private Timestamp p_DateBilling = null;
    private Timestamp p_DateClosed = null;
    private int p_AD_Org_ID = 0;
    private int p_C_BPartner_ID = 0;
    private String p_IsSOTrx = "Y";
    private String p_docAction = "--";
    private MBilling m_billing = null;
    private int m_created = 0;
    private int m_linecreated = 0;
    private Timestamp p_CutoffDate = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("Selection")) {
                this.p_Selection = "Y".equals(para[i].getParameter());
                continue;
            }
            if (name.equals("DateBilling")) {
                this.p_DateBilling = (Timestamp)para[i].getParameter();
                continue;
            }
            if (name.equals("DateClosed")) {
                this.p_DateClosed = (Timestamp)para[i].getParameter();
                continue;
            }
            if (name.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("IsSOTrx")) {
                this.p_IsSOTrx = (String)para[i].getParameter();
                continue;
            }
            if (name.equals("DocAction")) {
                this.p_docAction = (String)para[i].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        if (this.p_DateBilling == null) {
            this.p_DateBilling = this.getCtx().getContextAsDate("#Date");
        }
        if (this.p_DateBilling == null) {
            this.p_DateBilling = TimeUtil.getDay((long)System.currentTimeMillis());
        }
        if (this.p_DateClosed == null) {
            this.p_DateClosed = this.getCtx().getContextAsDate("#Date");
        }
        if (this.p_DateClosed == null) {
            this.p_DateClosed = TimeUtil.getDay((long)System.currentTimeMillis());
        }
        if (!"CO".equals(this.p_docAction) && !"PR".equals(this.p_docAction)) {
            this.p_docAction = "--";
        }
    }

    protected String doIt() throws Exception {
        this.p_C_Billing_ID = this.getRecord_ID();
        if (this.p_C_Billing_ID != 0) {
            this.m_billing = new MBilling(this.getCtx(), this.p_C_Billing_ID, this.get_TrxName());
            this.p_DateBilling = this.m_billing.getDateBilling();
            this.p_AD_Org_ID = this.m_billing.getAD_Org_ID();
            this.p_C_BPartner_ID = this.m_billing.getC_BPartner_ID();
            this.p_IsSOTrx = this.m_billing.isSOTrx() ? "Y" : "N";
        }
        this.log.info("Selection=" + this.p_Selection + ", DateBilling=" + this.p_DateBilling + ", AD_Org_ID=" + this.p_AD_Org_ID + ", C_BPartner_ID=" + this.p_C_BPartner_ID + ", DocAction=" + this.p_docAction);
        String sql = null;
        if (this.p_Selection) {
            sql = "SELECT i.* FROM C_Invoice i, C_BPartner bp WHERE i.C_BPartner_ID=bp.C_BPartner_ID AND i.IsSelected='Y' AND i.DocStatus IN ('CO', 'CL') AND IsPaid='N' AND i.IsSOTrx='" + this.p_IsSOTrx + "' " + "ORDER BY bp.C_BPartner_ID, i.C_Invoice_ID";
        } else {
            sql = "SELECT i.* FROM C_Invoice i, C_BPartner bp   WHERE i.C_BPartner_ID=bp.C_BPartner_ID AND i.DocStatus IN('CO','CL') AND i.IsPaid='N' AND i.IsSOTrx='" + this.p_IsSOTrx + "'";
            if (this.p_AD_Org_ID != 0) {
                sql = sql + " AND i.AD_Org_ID=?";
            }
            if (this.p_C_BPartner_ID != 0) {
                sql = sql + " AND ( bp.C_BPartner_ID=? )";
            }
            if (this.p_DateClosed != null) {
                sql = sql + " AND ( i.DateInvoiced<=? )";
            }
            sql = sql + " AND EXISTS (SELECT * FROM C_InvoiceLine il WHERE i.C_Invoice_ID=il.C_Invoice_ID AND il.IsBilled='N'AND NOT EXISTS (SELECT * FROM C_BillingLine bl, C_Billing b WHERE bl.C_Billing_ID=b.C_Billing_ID AND bl.C_InvoiceLine_ID=il.C_InvoiceLine_ID AND b.DocStatus NOT IN ('VO', 'RE'))  ) ORDER BY bp.C_BPartner_ID, i.C_Invoice_ID";
        }
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            int index = 1;
            if (!this.p_Selection && this.p_AD_Org_ID != 0) {
                pstmt.setInt(index++, this.p_AD_Org_ID);
            }
            if (!this.p_Selection && this.p_C_BPartner_ID != 0) {
                pstmt.setInt(index++, this.p_C_BPartner_ID);
            }
            if (!this.p_Selection && this.p_DateClosed != null) {
                pstmt.setTimestamp(index++, this.p_DateClosed);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        return this.generate((PreparedStatement)pstmt);
    }

    private String generate(PreparedStatement pstmt) {
        MBPartner m_bp = null;
        try {
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MInvoiceLine invoiceLine;
                MInvoiceLine[] invoiceLines;
                MInvoice invoice = new MInvoice(this.getCtx(), rs, this.get_TrxName());
                m_bp = new MBPartner(this.getCtx(), invoice.getC_BPartner_ID(), this.get_TrxName());
                MOrder m_o = new MOrder(this.getCtx(), invoice.getC_Order_ID(), this.get_TrxName());
                if (this.p_C_Billing_ID == 0 && this.m_billing != null && this.m_billing.getC_BPartner_Location_ID() != m_bp.getPrimaryC_BPartner_Location_ID()) {
                    this.completeBilling();
                }
                this.p_CutoffDate = null;
                boolean doInvoice = false;
                if ("S".equals(m_bp.getInvoiceRule())) {
                    if (m_bp.getC_InvoiceSchedule_ID() == 0) {
                        doInvoice = true;
                    } else {
                        MInvoiceSchedule is = MInvoiceSchedule.get(this.getCtx(), m_bp.getC_InvoiceSchedule_ID(), this.get_TrxName());
                        this.p_CutoffDate = is.getCutoffDate(this.p_DateBilling, this.p_DateClosed);
                        Timestamp invoicabledate = invoice.getDateInvoiced();
                        if (!is.canInvoice(invoicabledate, this.p_DateBilling, this.p_DateClosed, invoice.getGrandTotal())) continue;
                        doInvoice = true;
                    }
                }
                if (doInvoice || "D".equals(m_bp.getInvoiceRule())) {
                    invoiceLines = invoice.getLines();
                    for (int i = 0; i < invoiceLines.length; ++i) {
                        invoiceLine = invoiceLines[i];
                        if (invoiceLine.isBilled() || invoiceLine.isDescription()) continue;
                        this.createLine(m_bp, invoice, invoiceLine);
                    }
                    continue;
                }
                if ("O".equals(m_bp.getInvoiceRule())) {
                    invoiceLines = invoice.getLines();
                    for (int i = 0; i < invoiceLines.length; ++i) {
                        invoiceLine = invoiceLines[i];
                        if (invoiceLine.isBilled() || invoiceLine.isDescription()) continue;
                        if (invoiceLine.getC_OrderLine_ID() > 0) {
                            MOrderLine orderline = new MOrderLine(this.getCtx(), invoiceLine.getC_OrderLine_ID(), this.get_TrxName());
                            MOrder order = new MOrder(this.getCtx(), orderline.getC_Order_ID(), this.get_TrxName());
                            MOrderLine[] orderlines = order.getLines();
                            boolean completeOrder = true;
                            for (int j = 0; j < orderlines.length; ++j) {
                                boolean fullyDelivered;
                                orderline = orderlines[j];
                                boolean bl = fullyDelivered = orderline.getQtyOrdered().compareTo(orderline.getQtyDelivered()) == 0;
                                if (fullyDelivered) continue;
                                this.log.fine("Failed CompleteOrder - " + (Object)((Object)invoiceLine));
                                completeOrder = false;
                                break;
                            }
                            if (!completeOrder) continue;
                            this.createLine(m_bp, invoice, invoiceLine);
                            continue;
                        }
                        this.createLine(m_bp, invoice, invoiceLine);
                    }
                    continue;
                }
                if ("I".equals(m_bp.getInvoiceRule())) {
                    invoiceLines = invoice.getLines();
                    for (int i = 0; i < invoiceLines.length; ++i) {
                        invoiceLine = invoiceLines[i];
                        if (invoiceLine.isBilled()) continue;
                        this.createLine(m_bp, invoice, invoiceLine);
                    }
                    continue;
                }
                this.log.fine("Failed: " + m_bp.getInvoiceRule() + " - " + (Object)((Object)invoice));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.completeBilling();
        return "@Created@ = " + this.m_created + ", @Lines@ = " + this.m_linecreated;
    }

    private void createLine(MBPartner partner, MInvoice invoice, MInvoiceLine invoiceLine) {
        if (this.m_billing == null) {
            this.m_billing = new MBilling(partner, invoice, 0, this.p_DateBilling);
            if (this.p_CutoffDate != null) {
                this.m_billing.setDateAcct(this.p_CutoffDate);
            }
            if (!this.m_billing.save()) {
                throw new IllegalStateException("Could not create Billing (o)");
            }
        }
        MBillingLine line = new MBillingLine(this.m_billing);
        line.setInvoiceLine(invoice, invoiceLine);
        if (!line.save()) {
            throw new IllegalStateException("Could not create Billing Line (o)");
        }
        ++this.m_linecreated;
        this.log.fine(line.toString());
    }

    private void completeBilling() {
        if (this.m_billing != null) {
            if (!this.m_billing.isAdjusted()) {
                MBilling lastBilling = MBilling.getLastBilling(this.getCtx(), this.m_billing.getC_BPartner_ID(), this.m_billing.getDateBilling(), this.m_billing.get_TrxName());
                BigDecimal lastInvoicedAmt = BigDecimal.ZERO;
                Timestamp lastDateBilling = this.m_billing.getDateBilling();
                if (lastBilling != null) {
                    lastInvoicedAmt = lastBilling.getTotalInvoiceAmt();
                    this.m_billing.setLastInvoicedAmt(lastBilling.getTotalInvoiceAmt());
                    lastDateBilling = lastBilling.getDateBilling();
                } else {
                    Calendar lastBillingCal = TimeUtil.getToday();
                    if (lastBillingCal != null) {
                        lastBillingCal.setTimeInMillis(this.m_billing.getDateBilling().getTime());
                        lastBillingCal.set(14, 0);
                        lastBillingCal.set(13, 0);
                        lastBillingCal.set(12, 0);
                        lastBillingCal.set(11, 0);
                        lastBillingCal.add(5, -1);
                        lastDateBilling = new Timestamp(lastBillingCal.getTimeInMillis());
                    }
                }
                BigDecimal lastPaid = MPayment.getSumOfBPartner(this.getCtx(), this.m_billing.getC_BPartner_ID(), lastDateBilling, this.m_billing.getDateBilling(), this.m_billing.get_TrxName());
                this.m_billing.setLastPaidAmt(lastPaid);
                this.m_billing.setAdjustAmt(BigDecimal.ZERO);
                BigDecimal lastTansferedAmt = lastInvoicedAmt.subtract(lastPaid);
                this.m_billing.setLastTransferedAmt(lastTansferedAmt);
            }
            if (!"--".equals(this.p_docAction) && !this.m_billing.processIt(this.p_docAction)) {
                this.log.warning("completeBilling - failed: " + (Object)((Object)this.m_billing));
            }
            this.m_billing.save();
            this.commit();
            this.addLog(this.m_billing.getC_Billing_ID(), this.m_billing.getDateBilling(), new BigDecimal(this.m_linecreated), this.m_billing.getDocumentNo());
            ++this.m_created;
        }
        this.m_billing = null;
    }
}

