/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.db.CConnection;
import org.compiere.interfaces.Server;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class FactAcctRepost
extends SvrProcess {
    private int p_AD_Client_ID = 0;
    private int p_AD_Table_ID = 0;
    private Timestamp p_DateAcct_From = null;
    private Timestamp p_DateAcct_To = null;
    private int m_countRepost = 0;
    private int m_countError = 0;
    private static int s_serverTries = 0;
    private static Server s_server = null;
    private static CLogger log = CLogger.getCLogger(FactAcctRepost.class);

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("AD_Client_ID")) {
                this.p_AD_Client_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("AD_Table_ID")) {
                this.p_AD_Table_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("DateAcct")) {
                this.p_DateAcct_From = (Timestamp)para[i].getParameter();
                this.p_DateAcct_To = (Timestamp)para[i].getParameter_To();
                if (this.p_DateAcct_From == null) {
                    this.p_DateAcct_From = this.p_DateAcct_To;
                }
                if (this.p_DateAcct_To != null) continue;
                this.p_DateAcct_To = this.p_DateAcct_From;
                continue;
            }
            log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    protected String doIt() throws Exception {
        log.info("AD_Client_ID=" + this.p_AD_Client_ID + ", AD_Table_ID=" + this.p_AD_Table_ID + ", DateAcct_From=" + this.p_DateAcct_From + ", DateAcct_To" + this.p_DateAcct_To);
        String sql = "SELECT AD_Table_ID, TableName FROM AD_Table t WHERE t.IsView='N'";
        if (this.p_AD_Table_ID > 0) {
            sql = sql + " AND t.AD_Table_ID=" + this.p_AD_Table_ID;
        }
        sql = sql + " AND EXISTS (SELECT * FROM AD_Column c WHERE t.AD_Table_ID=c.AD_Table_ID AND c.ColumnName='Posted' AND c.IsActive='Y')";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int AD_Table_ID = rs.getInt(1);
                String TableName = rs.getString(2);
                this.repost(TableName, AD_Table_ID);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return "@Posted@ = " + this.m_countRepost + " @Error@ = " + this.m_countError;
    }

    private void repost(String TableName, int AD_Table_ID) {
        String sql = "SELECT " + TableName + "_ID, DATEACCT " + " FROM " + TableName + " WHERE AD_Client_ID=" + this.p_AD_Client_ID + " AND Processed='Y' AND Posted='Y' ";
        sql = "C_BANKSTATEMENT".equalsIgnoreCase(TableName) ? sql + " AND StatementDate>=? AND StatementDate<=? " : sql + " AND DateAcct>=? AND DateAcct<=? ";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setTimestamp(1, this.p_DateAcct_From);
            pstmt.setTimestamp(2, this.p_DateAcct_To);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int Record_ID = rs.getInt(1);
                Timestamp DateAcct = rs.getTimestamp(2);
                String error = FactAcctRepost.postImmediate(this.p_AD_Client_ID, AD_Table_ID, Record_ID, true);
                if ("".equals(error) || error == null) {
                    log.info(TableName + ": Posted :" + Record_ID);
                    ++this.m_countRepost;
                } else {
                    log.warning(TableName + ": Error :" + Record_ID);
                    ++this.m_countError;
                }
                this.commit();
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
    }

    public static String postImmediate(int AD_Client_ID, int AD_Table_ID, int Record_ID, boolean force) {
        log.config("AD_Table_ID=" + AD_Table_ID + "/" + Record_ID + ", Force=" + force);
        String error = null;
        if (FactAcctRepost.isServerActive()) {
            log.config("trying server");
            try {
                s_server = CConnection.get().getServer();
                if (s_server == null) {
                    return "NoAppsServer";
                }
                error = s_server.postImmediate(Env.getCtx(), AD_Client_ID, AD_Table_ID, Record_ID, force, null);
                log.config("from Server: " + error == null ? "OK" : error);
            }
            catch (RemoteException e) {
                log.log(Level.WARNING, "(RE)", (Throwable)e);
                error = e.getMessage();
                s_server = null;
            }
            catch (Exception e) {
                log.log(Level.WARNING, "ex", (Throwable)e);
                error = e.getMessage();
                s_server = null;
            }
        } else {
            return "NoAppsServer";
        }
        return error;
    }

    public static boolean isServerActive() {
        boolean contactAgain = s_server == null && s_serverTries == 0;
        boolean ok = CConnection.get().isAppsServerOK(contactAgain);
        if (ok) {
            s_serverTries = 0;
            return true;
        }
        if (s_serverTries > 1) {
            return false;
        }
        CLogMgt.enable((boolean)false);
        try {
            log.config("try #" + ++s_serverTries);
            ok = CConnection.get().isAppsServerOK(true);
            if (ok) {
                s_serverTries = 0;
            }
        }
        catch (Exception ex) {
            ok = false;
            s_server = null;
        }
        CLogMgt.enable((boolean)true);
        return ok;
    }
}

