/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoiceSchedule;
import org.compiere.model.MLocation;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;

public class InvoiceGenerate
extends SvrProcess {
    private boolean p_Selection = false;
    private Timestamp p_DateInvoiced = null;
    private int p_AD_Client_ID = 0;
    private int p_AD_Org_ID = 0;
    private int p_C_BPartner_ID = 0;
    private int p_C_Order_ID = 0;
    private boolean p_ConsolidateDocument = true;
    private String p_docAction = "CO";
    private MInvoice m_invoice = null;
    private MInOut m_ship = null;
    private int m_created = 0;
    private int m_line = 0;
    private MBPartner m_bp = null;

    protected void prepare() {
        this.p_AD_Client_ID = this.getCtx().getContextAsInt("#AD_Client_ID");
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("Selection")) {
                this.p_Selection = "Y".equals(para[i].getParameter());
                continue;
            }
            if (name.equals("DateInvoiced")) {
                this.p_DateInvoiced = (Timestamp)para[i].getParameter();
                continue;
            }
            if (name.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("C_Order_ID")) {
                this.p_C_Order_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("ConsolidateDocument")) {
                this.p_ConsolidateDocument = "Y".equals(para[i].getParameter());
                continue;
            }
            if (name.equals("DocAction")) {
                this.p_docAction = (String)para[i].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        if (this.p_DateInvoiced == null) {
            this.p_DateInvoiced = new Timestamp(this.getCtx().getContextAsTime("#Date"));
        }
        if (!"CO".equals(this.p_docAction)) {
            this.p_docAction = "PR";
        }
    }

    protected String doIt() throws Exception {
        this.log.info("Selection=" + this.p_Selection + ", DateInvoiced=" + this.p_DateInvoiced + ", AD_Org_ID=" + this.p_AD_Org_ID + ", C_BPartner_ID=" + this.p_C_BPartner_ID + ", C_Order_ID=" + this.p_C_Order_ID + ", DocAction=" + this.p_docAction + ", Consolidate=" + this.p_ConsolidateDocument);
        String sql = null;
        if (this.p_Selection) {
            sql = "SELECT * FROM C_Order WHERE IsSelected='Y' AND DocStatus='CO' AND IsSOTrx='Y' ORDER BY M_Warehouse_ID, PriorityRule, C_BPartner_ID, C_PaymentTerm_ID, C_Order_ID";
        } else {
            sql = "SELECT * FROM C_Order o WHERE DocStatus IN('CO','CL') AND IsSOTrx='Y'";
            if (this.p_AD_Org_ID != 0) {
                sql = sql + " AND AD_Org_ID=?";
            }
            if (this.p_C_BPartner_ID != 0) {
                sql = sql + " AND C_BPartner_ID=?";
            }
            if (this.p_C_Order_ID != 0) {
                sql = sql + " AND C_Order_ID=?";
            }
            sql = sql + " AND EXISTS (SELECT * FROM C_OrderLine ol WHERE o.C_Order_ID=ol.C_Order_ID AND ol.QtyOrdered<>ol.QtyInvoiced) ORDER BY M_Warehouse_ID, PriorityRule, C_BPartner_ID, C_PaymentTerm_ID, C_Order_ID";
        }
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            int index = 1;
            if (!this.p_Selection && this.p_AD_Org_ID != 0) {
                pstmt.setInt(index++, this.p_AD_Org_ID);
            }
            if (!this.p_Selection && this.p_C_BPartner_ID != 0) {
                pstmt.setInt(index++, this.p_C_BPartner_ID);
            }
            if (!this.p_Selection && this.p_C_Order_ID != 0) {
                pstmt.setInt(index++, this.p_C_Order_ID);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        MClientInfo clientinfo = new MClientInfo(this.getCtx(), this.p_AD_Client_ID, this.get_TrxName());
        if (!clientinfo.isInvoiceRevenueSplit()) {
            return this.generate((PreparedStatement)pstmt);
        }
        return this.generateRevenue((PreparedStatement)pstmt);
    }

    private String generate(PreparedStatement pstmt) {
        try {
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MOrder order = new MOrder(this.getCtx(), rs, this.get_TrxName());
                if (!this.p_ConsolidateDocument || this.m_invoice != null && (this.m_invoice.getC_BPartner_Location_ID() != order.getBill_Location_ID() || this.m_invoice.getC_PaymentTerm_ID() != order.getC_PaymentTerm_ID())) {
                    this.completeInvoice();
                }
                boolean completeOrder = "O".equals(order.getInvoiceRule());
                boolean doInvoice = false;
                if ("S".equals(order.getInvoiceRule())) {
                    this.m_bp = new MBPartner(this.getCtx(), order.getBill_BPartner_ID(), null);
                    if (this.m_bp.getC_InvoiceSchedule_ID() == 0) {
                        this.log.warning("BPartner has no Schedule - set to After Delivery");
                        order.setInvoiceRule("D");
                        order.save();
                    } else {
                        MInvoiceSchedule is = MInvoiceSchedule.get(this.getCtx(), this.m_bp.getC_InvoiceSchedule_ID(), this.get_TrxName());
                        if (!is.canInvoice(order.getDateOrdered(), order.getGrandTotal())) continue;
                        doInvoice = true;
                    }
                }
                if (doInvoice || "D".equals(order.getInvoiceRule())) {
                    MInOut shipment = null;
                    MInOutLine[] shipmentLines = order.getShipmentLines();
                    for (int i = 0; i < shipmentLines.length; ++i) {
                        MInOutLine shipLine = shipmentLines[i];
                        if (shipLine.isInvoiced()) continue;
                        if (shipment == null || shipment.getM_InOut_ID() != shipLine.getM_InOut_ID()) {
                            shipment = new MInOut(this.getCtx(), shipLine.getM_InOut_ID(), this.get_TrxName());
                        }
                        if (!shipment.isComplete() || shipment.getDocStatus().equals("RE")) continue;
                        this.createLine(order, shipment, shipLine);
                    }
                    this.m_line += 1000;
                } else {
                    MOrderLine[] oLines = order.getLines(true, null);
                    for (int i = 0; i < oLines.length; ++i) {
                        boolean fullyDelivered;
                        MOrderLine oLine = oLines[i];
                        BigDecimal toInvoice = oLine.getQtyOrdered().subtract(oLine.getQtyInvoiced());
                        if (toInvoice.compareTo(Env.ZERO) == 0 && oLine.getM_Product_ID() != 0) continue;
                        boolean bl = fullyDelivered = oLine.getQtyOrdered().compareTo(oLine.getQtyDelivered()) == 0;
                        if (completeOrder && !fullyDelivered) {
                            this.log.fine("Failed CompleteOrder - " + (Object)((Object)oLine));
                            completeOrder = false;
                            break;
                        }
                        if ("I".equals(order.getInvoiceRule())) {
                            this.log.fine("Immediate - ToInvoice=" + toInvoice + " - " + (Object)((Object)oLine));
                            BigDecimal qtyEntered = toInvoice;
                            if (oLine.getQtyEntered().compareTo(oLine.getQtyOrdered()) != 0) {
                                qtyEntered = toInvoice.multiply(oLine.getQtyEntered()).divide(oLine.getQtyOrdered(), 12, 4);
                            }
                            this.createLine(order, oLine, toInvoice, qtyEntered);
                            this.log.info("ID " + oLine.get_ID() + "Qty Ordered " + oLine.getQtyOrdered() + " Qty Invoiced " + oLine.getQtyInvoiced());
                            continue;
                        }
                        this.log.fine("Failed: " + order.getInvoiceRule() + " - ToInvoice=" + toInvoice + " - " + (Object)((Object)oLine));
                    }
                    if ("I".equals(order.getInvoiceRule())) {
                        this.m_line += 1000;
                    }
                }
                if (!completeOrder || !"O".equals(order.getInvoiceRule())) continue;
                MInOut[] shipments = order.getShipments(true);
                for (int i = 0; i < shipments.length; ++i) {
                    MInOut ship = shipments[i];
                    if (!ship.isComplete() || ship.getDocStatus().equals("RE")) continue;
                    MInOutLine[] shipLines = ship.getLines(false);
                    for (int j = 0; j < shipLines.length; ++j) {
                        MInOutLine shipLine = shipLines[j];
                        if (!order.isOrderLine(shipLine.getC_OrderLine_ID()) || shipLine.isInvoiced()) continue;
                        this.createLine(order, ship, shipLine);
                    }
                    this.m_line += 1000;
                }
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.completeInvoice();
        return "@Created@ = " + this.m_created;
    }

    private void createLine(MOrder order, MOrderLine orderLine, BigDecimal qtyInvoiced, BigDecimal qtyEntered) {
        if (this.m_invoice == null) {
            this.m_invoice = new MInvoice(order, 0, this.p_DateInvoiced);
            if (!this.m_invoice.save()) {
                throw new IllegalStateException("Could not create Invoice (o)");
            }
        }
        MInvoiceLine line = new MInvoiceLine(this.m_invoice);
        line.setOrderLine(orderLine);
        line.setQtyInvoiced(qtyInvoiced);
        this.log.info("Qty Invoiced" + line.getQtyInvoiced());
        line.setQtyEntered(qtyEntered);
        line.setLine(this.m_line + orderLine.getLine());
        if (!line.save()) {
            throw new IllegalStateException("Could not create Invoice Line (o)");
        }
        this.log.fine(line.toString());
    }

    private void createLine(MOrder order, MInOut ship, MInOutLine sLine) {
        if (this.m_invoice == null) {
            this.m_invoice = new MInvoice(order, 0, this.p_DateInvoiced);
            if (!this.m_invoice.save()) {
                throw new IllegalStateException("Could not create Invoice (s)");
            }
        }
        if (this.m_ship == null || this.m_ship.getM_InOut_ID() != ship.getM_InOut_ID()) {
            MDocType dt = MDocType.get((Ctx)this.getCtx(), (int)ship.getC_DocType_ID());
            if (this.m_bp == null || this.m_bp.getC_BPartner_ID() != ship.getC_BPartner_ID()) {
                this.m_bp = new MBPartner(this.getCtx(), ship.getC_BPartner_ID(), this.get_TrxName());
            }
            MClient client = MClient.get((Ctx)this.getCtx(), (int)order.getAD_Client_ID());
            String AD_Language = client.getAD_Language();
            if (client.isMultiLingualDocument() && this.m_bp.getAD_Language() != null) {
                AD_Language = this.m_bp.getAD_Language();
            }
            if (AD_Language == null) {
                AD_Language = Language.getBaseAD_Language();
            }
            SimpleDateFormat format = DisplayType.getDateFormat((int)15, (Language)Language.getLanguage((String)AD_Language));
            String reference = dt.getPrintName(this.m_bp.getAD_Language()) + ": " + ship.getDocumentNo() + " - " + format.format(ship.getMovementDate());
            this.m_ship = ship;
            MInvoiceLine line = new MInvoiceLine(this.m_invoice);
            line.setIsDescription(true);
            line.setDescription(reference);
            line.setLine(this.m_line + sLine.getLine() - 2);
            if (!line.save()) {
                throw new IllegalStateException("Could not create Invoice Comment Line (sh)");
            }
            if (order.getBill_Location_ID() != ship.getC_BPartner_Location_ID()) {
                MLocation addr = MLocation.getBPLocation((Ctx)this.getCtx(), (int)ship.getC_BPartner_Location_ID(), null);
                line = new MInvoiceLine(this.m_invoice);
                line.setIsDescription(true);
                line.setDescription(addr.toString());
                line.setLine(this.m_line + sLine.getLine() - 1);
                if (!line.save()) {
                    throw new IllegalStateException("Could not create Invoice Comment Line 2 (sh)");
                }
            }
        }
        MInvoiceLine line = new MInvoiceLine(this.m_invoice);
        line.setShipLine(sLine);
        line.setQtyEntered(sLine.getQtyEntered());
        line.setQtyInvoiced(sLine.getMovementQty());
        line.setLine(this.m_line + sLine.getLine());
        line.setM_AttributeSetInstance_ID(sLine.getM_AttributeSetInstance_ID());
        if (!line.save()) {
            throw new IllegalStateException("Could not create Invoice Line (s)");
        }
        sLine.setIsInvoiced(true);
        if (!sLine.save()) {
            throw new IllegalStateException("Could not update Shipment Line");
        }
        this.log.fine(line.toString());
    }

    private void createLineWithoutComment(MOrder order, MInOut ship, MInOutLine sLine) {
        if (this.m_invoice == null) {
            this.m_invoice = new MInvoice(order, 0, this.p_DateInvoiced);
            if (!this.m_invoice.save()) {
                throw new IllegalStateException("Could not create Invoice (s)");
            }
        }
        MInvoiceLine line = new MInvoiceLine(this.m_invoice);
        line.setShipLine(sLine);
        line.setQtyEntered(sLine.getQtyEntered());
        line.setQtyInvoiced(sLine.getMovementQty());
        line.setLine(this.m_line + sLine.getLine());
        line.setM_AttributeSetInstance_ID(sLine.getM_AttributeSetInstance_ID());
        if (!line.save()) {
            throw new IllegalStateException("Could not create Invoice Line (s)");
        }
        sLine.setIsInvoiced(true);
        if (!sLine.save()) {
            throw new IllegalStateException("Could not update Shipment Line");
        }
        this.log.fine(line.toString());
    }

    private void completeInvoice() {
        if (this.m_invoice != null) {
            if (!this.m_invoice.processIt(this.p_docAction)) {
                this.log.warning("completeInvoice - failed: " + (Object)((Object)this.m_invoice));
            }
            this.m_invoice.save();
            this.commit();
            this.addLog(this.m_invoice.getC_Invoice_ID(), this.m_invoice.getDateInvoiced(), null, this.m_invoice.getDocumentNo());
            ++this.m_created;
        }
        this.m_invoice = null;
        this.m_ship = null;
        this.m_line = 0;
    }

    private String generateRevenue(PreparedStatement pstmt) {
        try {
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MOrder order = new MOrder(this.getCtx(), rs, this.get_TrxName());
                if (this.m_invoice != null) {
                    this.completeInvoice();
                }
                boolean doInvoice = false;
                if ("S".equals(order.getInvoiceRule())) {
                    doInvoice = true;
                }
                if (doInvoice || "D".equals(order.getInvoiceRule())) {
                    MInOut shipment = null;
                    MInOutLine[] shipmentLines = order.getShipmentLines();
                    for (int i = 0; i < shipmentLines.length; ++i) {
                        MInOutLine shipLine = shipmentLines[i];
                        if (shipLine.isInvoiced()) continue;
                        if (shipment == null || shipment.getM_InOut_ID() != shipLine.getM_InOut_ID()) {
                            shipment = new MInOut(this.getCtx(), shipLine.getM_InOut_ID(), this.get_TrxName());
                            if (this.m_invoice != null) {
                                this.completeInvoice();
                            }
                        }
                        if (!shipment.isComplete() || shipment.getDocStatus().equals("RE")) continue;
                        this.createLineWithoutComment(order, shipment, shipLine);
                        this.m_invoice.setDateAcct(shipment.getDateAcct());
                        this.m_invoice.setDateInvoiced(shipment.getMovementDate());
                    }
                    continue;
                }
                if ("O".equals(order.getInvoiceRule())) {
                    MInOut[] shipments = order.getShipments(false);
                    for (int i = 0; i < shipments.length; ++i) {
                        MInOut ship = shipments[i];
                        if (!ship.isComplete() || ship.getDocStatus().equals("RE")) continue;
                        MInOutLine[] shipLines = ship.getLines(false);
                        for (int j = 0; j < shipLines.length; ++j) {
                            MInOutLine shipLine = shipLines[j];
                            if (!order.isOrderLine(shipLine.getC_OrderLine_ID()) || shipLine.isInvoiced()) continue;
                            this.createLineWithoutComment(order, ship, shipLine);
                        }
                        this.m_invoice.setDateAcct(ship.getDateAcct());
                        this.m_invoice.setDateInvoiced(ship.getMovementDate());
                        this.completeInvoice();
                    }
                    continue;
                }
                MOrderLine[] oLines = order.getLines(true, null);
                for (int i = 0; i < oLines.length; ++i) {
                    MOrderLine oLine = oLines[i];
                    BigDecimal toInvoice = oLine.getQtyOrdered().subtract(oLine.getQtyInvoiced());
                    if (toInvoice.compareTo(Env.ZERO) == 0 && oLine.getM_Product_ID() != 0) continue;
                    BigDecimal notInvoicedShipment = oLine.getQtyDelivered().subtract(oLine.getQtyInvoiced());
                    if ("I".equals(order.getInvoiceRule())) {
                        this.log.fine("Immediate - ToInvoice=" + toInvoice + " - " + (Object)((Object)oLine));
                        BigDecimal qtyEntered = toInvoice;
                        if (oLine.getQtyEntered().compareTo(oLine.getQtyOrdered()) != 0) {
                            qtyEntered = toInvoice.multiply(oLine.getQtyEntered()).divide(oLine.getQtyOrdered(), 12, 4);
                        }
                        this.createLine(order, oLine, toInvoice, qtyEntered);
                        continue;
                    }
                    this.log.fine("Failed: " + order.getInvoiceRule() + " - ToInvoice=" + toInvoice + " - " + (Object)((Object)oLine));
                }
                if (!"I".equals(order.getInvoiceRule())) continue;
                this.m_line += 1000;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.completeInvoice();
        return "@Created@ = " + this.m_created;
    }
}

