/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MPaySelectionLine;
import org.compiere.model.MPayment;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CompiereUserException;

public class PaySelectionCreateCheck
extends SvrProcess {
    private String p_ProcessAction = "Prepare";
    private boolean p_IsPaymentVoid = false;
    private String p_PaymentRule = null;
    private int p_C_PaySelection_ID = 0;
    private ArrayList<MPaySelectionCheck> m_list = new ArrayList();

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("PaymentRule")) {
                this.p_PaymentRule = (String)para[i].getParameter();
                continue;
            }
            if (name.equals("Action")) {
                this.p_ProcessAction = (String)para[i].getParameter();
                continue;
            }
            if (name.equals("IsPaymentVoid")) {
                this.p_IsPaymentVoid = "Y".equals(para[i].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_C_PaySelection_ID = this.getRecord_ID();
        if (this.p_PaymentRule != null && this.p_PaymentRule.equals("D")) {
            this.p_PaymentRule = null;
        }
    }

    protected String doIt() throws Exception {
        this.log.info("C_PaySelection_ID=" + this.p_C_PaySelection_ID + ", PaymentRule=" + this.p_PaymentRule);
        MPaySelection psel = new MPaySelection(this.getCtx(), this.p_C_PaySelection_ID, this.get_TrxName());
        if (psel.get_ID() == 0) {
            throw new IllegalArgumentException("Not found C_PaySelection_ID=" + this.p_C_PaySelection_ID);
        }
        if ("P".equals(this.p_ProcessAction)) {
            if (psel.isProcessed()) {
                throw new IllegalArgumentException("@Processed@");
            }
            MPaySelectionLine[] lines = psel.getLines(false);
            for (int i = 0; i < lines.length; ++i) {
                MPaySelectionLine line = lines[i];
                if (!line.isActive() || line.isProcessed()) continue;
                this.createCheck(line);
            }
            psel.setProcessed(true);
            psel.save();
        } else if ("U".equals(this.p_ProcessAction)) {
            int i;
            if (!psel.isProcessed()) {
                throw new IllegalArgumentException("@NotProcessed@");
            }
            boolean paymentExist = false;
            boolean paymentClosed = false;
            MPaySelectionCheck[] checks = psel.getChecks(false);
            for (int i2 = 0; i2 < checks.length; ++i2) {
                MPaySelectionCheck check = checks[i2];
                if (!check.isActive() || check.getC_Payment_ID() == 0) continue;
                paymentExist = true;
                MPayment payment = new MPayment(this.getCtx(), check.getC_Payment_ID(), this.get_TrxName());
                if (!"CL".equals(payment.getDocStatus())) continue;
                paymentClosed = true;
            }
            if (!this.p_IsPaymentVoid && paymentExist) {
                throw new IllegalArgumentException("@Payment@ @AlreadyExists@");
            }
            if (this.p_IsPaymentVoid && paymentClosed) {
                throw new IllegalArgumentException("@PaymentProcessed@");
            }
            MPaySelectionLine[] lines = psel.getLines(false);
            for (i = 0; i < lines.length; ++i) {
                MPaySelectionLine line = lines[i];
                line.setProcessed(false);
                line.setC_PaySelectionCheck_ID(0);
                line.save();
            }
            for (i = checks.length - 1; i >= 0; --i) {
                MPaySelectionCheck check = checks[i];
                if (check.getC_Payment_ID() != 0) {
                    paymentExist = true;
                    MPayment payment = new MPayment(this.getCtx(), check.getC_Payment_ID(), this.get_TrxName());
                    if (!payment.processIt("VO")) {
                        throw new IllegalArgumentException("@PaymentError@");
                    }
                    payment.save();
                }
                if (check.delete(true, this.get_TrxName())) continue;
                throw new IllegalArgumentException("@DeleteError@");
            }
            psel.setProcessed(false);
            psel.save();
        }
        return "@C_PaySelectionCheck_ID@ - #" + this.m_list.size();
    }

    private void createCheck(MPaySelectionLine line) throws Exception {
        MPaySelectionCheck check;
        for (int i = 0; i < this.m_list.size(); ++i) {
            check = this.m_list.get(i);
            if (check.getC_BPartner_ID() != line.getInvoice().getC_BPartner_ID()) continue;
            check.addLine(line);
            if (!check.save()) {
                throw new IllegalStateException("Cannot save MPaySelectionCheck");
            }
            line.setC_PaySelectionCheck_ID(check.getC_PaySelectionCheck_ID());
            line.setProcessed(true);
            if (!line.save()) {
                throw new IllegalStateException("Cannot save MPaySelectionLine");
            }
            return;
        }
        String PaymentRule = line.getPaymentRule();
        if (this.p_PaymentRule != null && !"D".equals(PaymentRule)) {
            PaymentRule = this.p_PaymentRule;
        }
        if (!(check = new MPaySelectionCheck(line, PaymentRule)).isValid()) {
            int C_BPartner_ID = check.getC_BPartner_ID();
            MBPartner bp = MBPartner.get(this.getCtx(), C_BPartner_ID);
            String msg = "@NotFound@ @C_BP_BankAccount@: " + bp.getName();
            throw new CompiereUserException(msg);
        }
        if (!check.save()) {
            throw new IllegalStateException("Cannot save MPaySelectionCheck");
        }
        line.setC_PaySelectionCheck_ID(check.getC_PaySelectionCheck_ID());
        line.setProcessed(true);
        if (!line.save()) {
            throw new IllegalStateException("Cannot save MPaySelectionLine");
        }
        this.m_list.add(check);
    }
}

