/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MTable;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.ASyncProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ViewCreate
extends SvrProcess
implements ASyncProcess {
    private String p_EntityType = "D";
    private int m_count = 0;

    public ViewCreate() {
    }

    public ViewCreate(String entityType) {
        if (entityType == null) {
            this.p_EntityType = "";
            this.log.log(Level.SEVERE, "Entity Type is NULL!");
        } else {
            this.p_EntityType = entityType;
        }
    }

    public void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("EntityType")) {
                this.p_EntityType = (String)para[i].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    public String doIt() throws Exception {
        boolean retval = true;
        this.log.info("EntityType=" + this.p_EntityType);
        CPreparedStatement pstmt = null;
        String sql = "SELECT * FROM AD_Table WHERE IsActive='Y' AND IsView='Y'";
        ArrayList<MTable> list = new ArrayList<MTable>();
        if (this.p_EntityType != null) {
            sql = sql + " AND EntityType in ('" + this.p_EntityType + "')";
        }
        sql = sql + " ORDER BY LoadSeq";
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MTable table2 = new MTable(Env.getCtx(), rs, null);
                list.add(table2);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
            return "Fail. Error to get view definition.";
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        String errViews = null;
        for (MTable mt : list) {
            String vcsql = mt.getViewCreate(true);
            if (vcsql != null && vcsql.length() > 0) {
                try {
                    int no = -1;
                    if (DB.isMSSQLServer()) {
                        try {
                            no = DB.executeUpdate((String)("DROP VIEW " + mt.getTableName()), null, (boolean)true, null);
                        }
                        catch (Exception ee) {
                            // empty catch block
                        }
                        vcsql = vcsql.replace(" OR REPLACE ", " ");
                    }
                    if ((no = DB.executeUpdate((String)vcsql, null)) != -1) {
                        ++this.m_count;
                        this.log.log(Level.INFO, "Created view " + mt.getTableName());
                        continue;
                    }
                    this.log.log(Level.SEVERE, vcsql);
                    retval = false;
                    errViews = errViews + mt.getTableName() + ", ";
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, vcsql, (Throwable)e);
                    retval = false;
                }
                continue;
            }
            this.log.log(Level.SEVERE, "Fail to get view create sql for " + mt.getTableName());
            retval = false;
        }
        if (!retval) {
            return "Fail. Error to create views: " + errViews + " created view #" + this.m_count;
        }
        return "Created view #" + this.m_count;
    }

    public void lockUI(ProcessInfo pi) {
    }

    public void unlockUI(ProcessInfo pi) {
    }

    public boolean isUILocked() {
        return false;
    }

    public void executeASync(ProcessInfo pi) {
        this.log.config("-");
    }

    public void executeRefresh() {
    }
}

