/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.report.FinBalance;
import org.compiere.report.FinReportPeriod;
import org.compiere.report.MReport;
import org.compiere.report.MReportColumn;
import org.compiere.report.MReportLine;
import org.compiere.report.MReportTree;
import org.compiere.util.CLogMgt;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.CompiereUserException;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.TimeUtil;

public class FinReport
extends SvrProcess {
    private int p_C_Period_ID = 0;
    private int p_Org_ID = 0;
    private int p_OrgTrx_ID = 0;
    private int p_C_BPartner_ID = 0;
    private int p_M_Product_ID = 0;
    private int p_C_Project_ID = 0;
    private int p_C_Activity_ID = 0;
    private int p_C_SalesRegion_ID = 0;
    private int p_C_Campaign_ID = 0;
    private boolean p_UpdateBalances = true;
    private boolean p_DetailsSourceFirst = false;
    private int p_PA_Hierarchy_ID = 0;
    private long m_start = System.currentTimeMillis();
    private MReport m_report = null;
    private FinReportPeriod[] m_periods = null;
    private int m_reportPeriod = -1;
    private StringBuffer m_parameterWhere = new StringBuffer();
    private MReportColumn[] m_columns;
    private MReportLine[] m_lines;

    protected void prepare() {
        StringBuffer sb = new StringBuffer("Record_ID=").append(this.getRecord_ID());
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("C_Period_ID")) {
                this.p_C_Period_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("PA_Hierarchy_ID")) {
                this.p_PA_Hierarchy_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("Org_ID")) {
                this.p_Org_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("AD_OrgTrx_ID")) {
                this.p_OrgTrx_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("M_Product_ID")) {
                this.p_M_Product_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_Project_ID")) {
                this.p_C_Project_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_Activity_ID")) {
                this.p_C_Activity_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_SalesRegion_ID")) {
                this.p_C_SalesRegion_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_Campaign_ID")) {
                this.p_C_Campaign_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("UpdateBalances")) {
                this.p_UpdateBalances = "Y".equals(para[i].getParameter());
                continue;
            }
            if (name.equals("DetailsSourceFirst")) {
                this.p_DetailsSourceFirst = "Y".equals(para[i].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        if (this.p_Org_ID != 0) {
            this.m_parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.p_PA_Hierarchy_ID, "OO", this.p_Org_ID));
        }
        if (this.p_Org_ID != 0) {
            this.m_parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.p_PA_Hierarchy_ID, "OT", this.p_OrgTrx_ID));
        }
        if (this.p_C_BPartner_ID != 0) {
            this.m_parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.p_PA_Hierarchy_ID, "BP", this.p_C_BPartner_ID));
        }
        if (this.p_M_Product_ID != 0) {
            this.m_parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.p_PA_Hierarchy_ID, "PR", this.p_M_Product_ID));
        }
        if (this.p_C_Project_ID != 0) {
            this.m_parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.p_PA_Hierarchy_ID, "PJ", this.p_C_Project_ID));
        }
        if (this.p_C_Activity_ID != 0) {
            this.m_parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.p_PA_Hierarchy_ID, "AY", this.p_C_Activity_ID));
        }
        if (this.p_C_Campaign_ID != 0) {
            this.m_parameterWhere.append(" AND C_Campaign_ID=").append(this.p_C_Campaign_ID);
        }
        if (this.p_C_SalesRegion_ID != 0) {
            this.m_parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.p_PA_Hierarchy_ID, "SR", this.p_C_SalesRegion_ID));
        }
        this.m_report = new MReport(this.getCtx(), this.getRecord_ID(), null);
        sb.append(" - ").append((Object)this.m_report);
        this.setPeriods();
        sb.append(" - C_Period_ID=").append(this.p_C_Period_ID).append(" - ").append(this.m_parameterWhere);
        this.log.info(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPeriods() {
        this.log.info("C_Calendar_ID=" + this.m_report.getC_Calendar_ID());
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        ArrayList<FinReportPeriod> list = new ArrayList<FinReportPeriod>();
        String sql = "SELECT p.C_Period_ID, p.Name, p.StartDate, p.EndDate, MIN(p1.StartDate) FROM C_Period p  INNER JOIN C_Year y ON (p.C_Year_ID=y.C_Year_ID), C_Period p1 WHERE y.C_Calendar_ID=? AND p.PeriodType='S'  AND p1.C_Year_ID=y.C_Year_ID AND p1.PeriodType='S' GROUP BY p.C_Period_ID, p.Name, p.StartDate, p.EndDate ORDER BY p.StartDate";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, this.m_report.getC_Calendar_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                FinReportPeriod frp = new FinReportPeriod(rs.getInt(1), rs.getString(2), rs.getTimestamp(3), rs.getTimestamp(4), rs.getTimestamp(5));
                list.add(frp);
                if (this.p_C_Period_ID != 0 || !frp.inPeriod(today)) continue;
                this.p_C_Period_ID = frp.getC_Period_ID();
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        this.m_periods = new FinReportPeriod[list.size()];
        list.toArray(this.m_periods);
        if (this.p_C_Period_ID == 0) {
            this.m_reportPeriod = this.m_periods.length - 1;
            this.p_C_Period_ID = this.m_periods[this.m_reportPeriod].getC_Period_ID();
        }
    }

    protected String doIt() throws Exception {
        this.log.info("AD_PInstance_ID=" + this.getAD_PInstance_ID());
        int PA_ReportLineSet_ID = this.m_report.getLineSet().getPA_ReportLineSet_ID();
        StringBuffer sql = new StringBuffer("INSERT INTO T_Report (AD_PInstance_ID, PA_ReportLine_ID, Record_ID,Fact_Acct_ID, SeqNo,LevelNo, Name,Description) SELECT ").append(this.getAD_PInstance_ID()).append(", PA_ReportLine_ID, 0,0, SeqNo,0, Name,Description FROM PA_ReportLine WHERE IsActive='Y' AND PA_ReportLineSet_ID=").append(PA_ReportLineSet_ID);
        int no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Report Lines = " + no);
        if (this.p_UpdateBalances) {
            FinBalance.updateBalance(this.m_report.getC_AcctSchema_ID(), false);
        }
        this.m_columns = this.m_report.getColumnSet().getColumns();
        if (this.m_columns.length == 0) {
            throw new CompiereUserException("@No@ @PA_ReportColumn_ID@");
        }
        this.m_lines = this.m_report.getLineSet().getLiness();
        if (this.m_lines.length == 0) {
            throw new CompiereUserException("@No@ @PA_ReportLine_ID@");
        }
        for (int line = 0; line < this.m_lines.length; ++line) {
            if (!this.m_lines[line].isLineTypeSegmentValue()) continue;
            this.insertLine(line);
        }
        this.insertLineDetail();
        this.doCalculations();
        this.deleteUnprintedLines();
        if (Ini.isClient()) {
            this.getProcessInfo().setTransientObject((Object)this.getPrintFormat());
        } else {
            this.getProcessInfo().setSerializableObject((Serializable)this.getPrintFormat());
        }
        this.log.fine(System.currentTimeMillis() - this.m_start + " ms");
        return "";
    }

    private void insertLine(int line) {
        this.log.info("" + (Object)((Object)this.m_lines[line]));
        if (this.m_lines[line] == null || this.m_lines[line].getSources().length == 0) {
            this.log.warning("No Source lines: " + (Object)((Object)this.m_lines[line]));
            return;
        }
        StringBuffer update = new StringBuffer();
        for (int col = 0; col < this.m_columns.length; ++col) {
            String PostingType;
            String sql;
            String sql2;
            if (this.m_columns[col].isColumnTypeCalculation()) continue;
            StringBuffer info = new StringBuffer();
            info.append("Line=").append(line).append(",Col=").append(col);
            StringBuffer select = new StringBuffer("SELECT ");
            if (this.m_lines[line].getAmountType() != null) {
                sql2 = this.m_lines[line].getSelectClause(true);
                select.append(sql2);
                info.append(": LineAmtType=").append(this.m_lines[line].getAmountType());
            } else if (this.m_columns[col].getAmountType() != null) {
                sql2 = this.m_columns[col].getSelectClause(true);
                select.append(sql2);
                info.append(": ColumnAmtType=").append(this.m_columns[col].getAmountType());
            } else {
                this.log.warning("No Amount Type in line: " + (Object)((Object)this.m_lines[line]) + " or column: " + (Object)((Object)this.m_columns[col]));
                continue;
            }
            select.append(" FROM Fact_Acct_Balance WHERE DateAcct ");
            BigDecimal relativeOffset = null;
            if (this.m_columns[col].isColumnTypeRelativePeriod() || this.m_columns[col].isColumnTypeSegmentValue()) {
                relativeOffset = this.m_columns[col].getRelativePeriod();
            }
            FinReportPeriod frp = this.getPeriod(relativeOffset);
            if (this.m_lines[line].getAmountType() != null) {
                info.append(" - LineDateAcct=");
                if (this.m_lines[line].isPeriod()) {
                    sql = frp.getPeriodWhere();
                    info.append("Period");
                    select.append(sql);
                } else if (this.m_lines[line].isYear()) {
                    sql = frp.getYearWhere();
                    info.append("Year");
                    select.append(sql);
                } else if (this.m_lines[line].isTotal()) {
                    sql = frp.getTotalWhere();
                    info.append("Total");
                    select.append(sql);
                } else {
                    this.log.log(Level.SEVERE, "No valid Line AmountType");
                    select.append("=0");
                }
            } else if (this.m_columns[col].getAmountType() != null) {
                info.append(" - ColumnDateAcct=");
                if (this.m_columns[col].isPeriod()) {
                    sql = frp.getPeriodWhere();
                    info.append("Period");
                    select.append(sql);
                } else if (this.m_columns[col].isYear()) {
                    sql = frp.getYearWhere();
                    info.append("Year");
                    select.append(sql);
                } else if (this.m_columns[col].isTotal()) {
                    sql = frp.getTotalWhere();
                    info.append("Total");
                    select.append(sql);
                } else {
                    this.log.log(Level.SEVERE, "No valid Column AmountType");
                    select.append("=0");
                }
            }
            String s = this.m_lines[line].getWhereClause(this.p_PA_Hierarchy_ID);
            if (s != null && s.length() > 0) {
                select.append(" AND ").append(s);
            }
            if ((s = this.m_report.getWhereClause()) != null && s.length() > 0) {
                select.append(" AND ").append(s);
            }
            if (!this.m_lines[line].isPostingType() && (PostingType = this.m_columns[col].getPostingType()) != null && PostingType.length() > 0) {
                select.append(" AND PostingType='").append(PostingType).append("'");
            }
            if (this.m_columns[col].isColumnTypeSegmentValue()) {
                select.append(this.m_columns[col].getWhereClause(this.p_PA_Hierarchy_ID));
            }
            select.append(this.m_parameterWhere);
            this.log.finest("Line=" + line + ",Col=" + line + ": " + select);
            if (update.length() > 0) {
                update.append(", ");
            }
            update.append("Col_").append(col).append(" = (").append(select).append(")");
            this.log.finest(info.toString());
        }
        if (update.length() > 0) {
            update.insert(0, "UPDATE T_Report SET ");
            update.append(" WHERE AD_PInstance_ID=").append(this.getAD_PInstance_ID()).append(" AND PA_ReportLine_ID=").append(this.m_lines[line].getPA_ReportLine_ID()).append(" AND ABS(LevelNo)<2");
            int no = DB.executeUpdate((String)update.toString(), (String)this.get_TrxName());
            if (no != 1) {
                this.log.log(Level.SEVERE, "#=" + no + " for " + update);
            }
            this.log.finest(update.toString());
        }
    }

    private void doCalculations() {
        int no;
        for (int line = 0; line < this.m_lines.length; ++line) {
            int col;
            int col2;
            StringBuffer sb;
            if (!this.m_lines[line].isLineTypeCalculation()) continue;
            int oper_1 = this.m_lines[line].getOper_1_ID();
            int oper_2 = this.m_lines[line].getOper_2_ID();
            this.log.fine("Line " + line + " = #" + oper_1 + " " + this.m_lines[line].getCalculationType() + " #" + oper_2);
            if (this.m_lines[line].isCalculationTypeAdd() || this.m_lines[line].isCalculationTypeRange()) {
                if (oper_1 > oper_2) {
                    int temp = oper_1;
                    oper_1 = oper_2;
                    oper_2 = temp;
                }
                sb = new StringBuffer("UPDATE T_Report SET (");
                for (col2 = 0; col2 < this.m_columns.length; ++col2) {
                    if (col2 > 0) {
                        sb.append(",");
                    }
                    sb.append("Col_").append(col2);
                }
                sb.append(") = (SELECT ");
                for (col2 = 0; col2 < this.m_columns.length; ++col2) {
                    if (col2 > 0) {
                        sb.append(", ");
                    }
                    sb.append("COALESCE(SUM(Col_").append(col2).append("),0)");
                }
                sb.append(" FROM T_Report WHERE AD_PInstance_ID=").append(this.getAD_PInstance_ID()).append(" AND PA_ReportLine_ID IN (");
                if (this.m_lines[line].isCalculationTypeAdd()) {
                    sb.append(oper_1).append(",").append(oper_2);
                } else {
                    sb.append(this.getLineIDs(oper_1, oper_2));
                }
                sb.append(") AND ABS(LevelNo)<1) WHERE AD_PInstance_ID=").append(this.getAD_PInstance_ID()).append(" AND PA_ReportLine_ID=").append(this.m_lines[line].getPA_ReportLine_ID()).append(" AND ABS(LevelNo)<1");
                no = DB.executeUpdate((String)sb.toString(), (String)this.get_TrxName());
                if (no != 1) {
                    this.log.log(Level.SEVERE, "(+) #=" + no + " for " + (Object)((Object)this.m_lines[line]) + " - " + sb.toString());
                    continue;
                }
                this.log.fine("(+) Line=" + line + " - " + (Object)((Object)this.m_lines[line]));
                this.log.finest("(+) " + sb.toString());
                continue;
            }
            sb = new StringBuffer("UPDATE T_Report SET (");
            for (col2 = 0; col2 < this.m_columns.length; ++col2) {
                if (col2 > 0) {
                    sb.append(",");
                }
                sb.append("Col_").append(col2);
            }
            sb.append(") = (SELECT ");
            for (col2 = 0; col2 < this.m_columns.length; ++col2) {
                if (col2 > 0) {
                    sb.append(", ");
                }
                sb.append("COALESCE(r2.Col_").append(col2).append(",0)");
            }
            sb.append(" FROM T_Report r2 WHERE r2.AD_PInstance_ID=").append(this.getAD_PInstance_ID()).append(" AND r2.PA_ReportLine_ID=").append(oper_1).append(" AND r2.Record_ID=0 AND r2.Fact_Acct_ID=0) WHERE AD_PInstance_ID=").append(this.getAD_PInstance_ID()).append(" AND PA_ReportLine_ID=").append(this.m_lines[line].getPA_ReportLine_ID()).append(" AND ABS(LevelNo)<1");
            no = DB.executeUpdate((String)sb.toString(), (String)this.get_TrxName());
            if (no != 1) {
                this.log.severe("(x) #=" + no + " for " + (Object)((Object)this.m_lines[line]) + " - " + sb.toString());
                continue;
            }
            sb = new StringBuffer("UPDATE T_Report r1 SET (");
            for (col = 0; col < this.m_columns.length; ++col) {
                if (col > 0) {
                    sb.append(",");
                }
                sb.append("Col_").append(col);
            }
            sb.append(") = (SELECT ");
            for (col = 0; col < this.m_columns.length; ++col) {
                if (col > 0) {
                    sb.append(",  ");
                }
                sb.append("COALESCE(r1.Col_").append(col).append(",0)");
                if (this.m_lines[line].isCalculationTypeSubtract()) {
                    sb.append("-");
                } else {
                    sb.append("/");
                }
                sb.append("COALESCE(r2.Col_").append(col).append(",0.000000001)");
                if (!this.m_lines[line].isCalculationTypePercent()) continue;
                sb.append(" *100");
            }
            sb.append(" FROM T_Report r2 WHERE r2.AD_PInstance_ID=").append(this.getAD_PInstance_ID()).append(" AND r2.PA_ReportLine_ID=").append(oper_2).append(" AND r2.Record_ID=0 AND r2.Fact_Acct_ID=0) WHERE AD_PInstance_ID=").append(this.getAD_PInstance_ID()).append(" AND PA_ReportLine_ID=").append(this.m_lines[line].getPA_ReportLine_ID()).append(" AND ABS(LevelNo)<1");
            no = DB.executeUpdate((String)sb.toString(), (String)this.get_TrxName());
            if (no != 1) {
                this.log.severe("(x) #=" + no + " for " + (Object)((Object)this.m_lines[line]) + " - " + sb.toString());
                continue;
            }
            this.log.fine("(x) Line=" + line + " - " + (Object)((Object)this.m_lines[line]));
            this.log.finest(sb.toString());
        }
        for (int col = 0; col < this.m_columns.length; ++col) {
            if (!this.m_columns[col].isColumnTypeCalculation()) continue;
            StringBuffer sb = new StringBuffer("UPDATE T_Report SET ");
            sb.append("Col_").append(col).append("=");
            int ii_1 = this.getColumnIndex(this.m_columns[col].getOper_1_ID());
            if (ii_1 < 0) {
                this.log.log(Level.SEVERE, "Column Index for Operator 1 not found - " + (Object)((Object)this.m_columns[col]));
                continue;
            }
            int ii_2 = this.getColumnIndex(this.m_columns[col].getOper_2_ID());
            if (ii_2 < 0) {
                this.log.log(Level.SEVERE, "Column Index for Operator 2 not found - " + (Object)((Object)this.m_columns[col]));
                continue;
            }
            this.log.fine("Column " + col + " = #" + ii_1 + " " + this.m_columns[col].getCalculationType() + " #" + ii_2);
            if (ii_1 > ii_2 && this.m_columns[col].isCalculationTypeRange()) {
                this.log.fine("Swap operands from " + ii_1 + " op " + ii_2);
                int temp = ii_1;
                ii_1 = ii_2;
                ii_2 = temp;
            }
            if (this.m_columns[col].isCalculationTypeAdd()) {
                sb.append("COALESCE(Col_").append(ii_1).append(",0)").append("+").append("COALESCE(Col_").append(ii_2).append(",0)");
            } else if (this.m_columns[col].isCalculationTypeSubtract()) {
                sb.append("COALESCE(Col_").append(ii_1).append(",0)").append("-").append("COALESCE(Col_").append(ii_2).append(",0)");
            }
            if (this.m_columns[col].isCalculationTypePercent()) {
                sb.append("CASE WHEN COALESCE(Col_").append(ii_2).append(",0)=0 THEN NULL ELSE ").append("COALESCE(Col_").append(ii_1).append(",0)").append("/").append("Col_").append(ii_2).append("*100 END");
            } else if (this.m_columns[col].isCalculationTypeRange()) {
                sb.append("COALESCE(Col_").append(ii_1).append(",0)");
                for (int ii = ii_1 + 1; ii <= ii_2; ++ii) {
                    sb.append("+COALESCE(Col_").append(ii).append(",0)");
                }
            }
            sb.append(" WHERE AD_PInstance_ID=").append(this.getAD_PInstance_ID()).append(" AND ABS(LevelNo)<2");
            no = DB.executeUpdate((String)sb.toString(), (String)this.get_TrxName());
            if (no < 1) {
                this.log.severe("#=" + no + " for " + (Object)((Object)this.m_columns[col]) + " - " + sb.toString());
                continue;
            }
            this.log.fine("Col=" + col + " - " + (Object)((Object)this.m_columns[col]));
            this.log.finest(sb.toString());
        }
    }

    private String getLineIDs(int fromID, int toID) {
        this.log.finest("From=" + fromID + " To=" + toID);
        StringBuffer sb = new StringBuffer();
        sb.append(fromID);
        boolean addToList = false;
        for (int line = 0; line < this.m_lines.length; ++line) {
            int PA_ReportLine_ID = this.m_lines[line].getPA_ReportLine_ID();
            this.log.finest("Add=" + addToList + " ID=" + PA_ReportLine_ID + " - " + (Object)((Object)this.m_lines[line]));
            if (addToList) {
                sb.append(",").append(PA_ReportLine_ID);
                if (PA_ReportLine_ID != toID) continue;
                break;
            }
            if (PA_ReportLine_ID != fromID) continue;
            addToList = true;
        }
        return sb.toString();
    }

    private int getColumnIndex(int PA_ReportColumn_ID) {
        for (int i = 0; i < this.m_columns.length; ++i) {
            if (this.m_columns[i].getPA_ReportColumn_ID() != PA_ReportColumn_ID) continue;
            return i;
        }
        return -1;
    }

    private FinReportPeriod getPeriod(BigDecimal relativeOffset) {
        if (relativeOffset == null) {
            return this.getPeriod(0);
        }
        return this.getPeriod(relativeOffset.intValue());
    }

    private FinReportPeriod getPeriod(int relativeOffset) {
        if (this.m_reportPeriod < 0) {
            for (int i = 0; i < this.m_periods.length; ++i) {
                if (this.p_C_Period_ID != this.m_periods[i].getC_Period_ID()) continue;
                this.m_reportPeriod = i;
                break;
            }
        }
        if (this.m_reportPeriod < 0 || this.m_reportPeriod >= this.m_periods.length) {
            throw new UnsupportedOperationException("Period index not found - ReportPeriod=" + this.m_reportPeriod + ", C_Period_ID=" + this.p_C_Period_ID);
        }
        int index = this.m_reportPeriod + relativeOffset;
        if (index < 0) {
            this.log.log(Level.SEVERE, "Relative Offset(" + relativeOffset + ") not valid for selected Period(" + this.m_reportPeriod + ")");
            index = 0;
        } else if (index >= this.m_periods.length) {
            this.log.log(Level.SEVERE, "Relative Offset(" + relativeOffset + ") not valid for selected Period(" + this.m_reportPeriod + ")");
            index = this.m_periods.length - 1;
        }
        return this.m_periods[index];
    }

    private void insertLineDetail() {
        if (!this.m_report.isListSources()) {
            return;
        }
        this.log.info("");
        for (int line = 0; line < this.m_lines.length; ++line) {
            if (!this.m_lines[line].isLineTypeSegmentValue()) continue;
            this.insertLineSource(line);
        }
        StringBuffer sql = new StringBuffer("DELETE FROM T_Report WHERE LevelNo<>0").append(" AND Col_0 IS NULL AND Col_1 IS NULL AND Col_2 IS NULL AND Col_3 IS NULL AND Col_4 IS NULL AND Col_5 IS NULL AND Col_6 IS NULL AND Col_7 IS NULL AND Col_8 IS NULL AND Col_9 IS NULL").append(" AND Col_10 IS NULL AND Col_11 IS NULL AND Col_12 IS NULL AND Col_13 IS NULL AND Col_14 IS NULL AND Col_15 IS NULL AND Col_16 IS NULL AND Col_17 IS NULL AND Col_18 IS NULL AND Col_19 IS NULL AND Col_20 IS NULL");
        int no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Deleted empty #=" + no);
        sql = new StringBuffer("UPDATE T_Report r1 SET SeqNo = (SELECT SeqNo FROM T_Report r2 WHERE r1.AD_PInstance_ID=r2.AD_PInstance_ID AND r1.PA_ReportLine_ID=r2.PA_ReportLine_ID AND r2.Record_ID=0 AND r2.Fact_Acct_ID=0)WHERE SeqNo IS NULL");
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("SeqNo #=" + no);
        if (!this.m_report.isListTrx()) {
            return;
        }
        String sql_select = "SELECT e.Name, fa.Description FROM Fact_Acct fa INNER JOIN AD_Table t ON (fa.AD_Table_ID=t.AD_Table_ID) INNER JOIN AD_Element e ON (t.TableName||'_ID'=e.ColumnName) WHERE r.Fact_Acct_ID=fa.Fact_Acct_ID";
        sql = new StringBuffer("UPDATE T_Report r SET (Name,Description)=(").append(sql_select).append(") WHERE Fact_Acct_ID <> 0 AND AD_PInstance_ID=").append(this.getAD_PInstance_ID());
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (CLogMgt.isLevelFinest()) {
            this.log.fine("Trx Name #=" + no + " - " + sql.toString());
        }
    }

    private void insertLineSource(int line) {
        int col;
        this.log.info("Line=" + line + " - " + (Object)((Object)this.m_lines[line]));
        if (this.m_lines[line] == null || this.m_lines[line].getSources().length == 0) {
            return;
        }
        String variable = this.m_lines[line].getSourceColumnName();
        if (variable == null) {
            return;
        }
        this.log.fine("Variable=" + variable);
        StringBuffer insert = new StringBuffer("INSERT INTO T_Report (AD_PInstance_ID, PA_ReportLine_ID, Record_ID,Fact_Acct_ID,LevelNo ");
        for (col = 0; col < this.m_columns.length; ++col) {
            insert.append(",Col_").append(col);
        }
        insert.append(") SELECT ").append(this.getAD_PInstance_ID()).append(",").append(this.m_lines[line].getPA_ReportLine_ID()).append(",").append(variable).append(",0,");
        if (this.p_DetailsSourceFirst) {
            insert.append("-1 ");
        } else {
            insert.append("1 ");
        }
        for (col = 0; col < this.m_columns.length; ++col) {
            String s;
            String PostingType;
            insert.append(", ");
            if (this.m_columns[col].isColumnTypeCalculation()) {
                insert.append("NULL");
                continue;
            }
            StringBuffer select = new StringBuffer("SELECT ");
            if (this.m_lines[line].getAmountType() != null) {
                select.append(this.m_lines[line].getSelectClause(true));
            } else if (this.m_columns[col].getAmountType() != null) {
                select.append(this.m_columns[col].getSelectClause(true));
            } else {
                insert.append("NULL");
                continue;
            }
            select.append(" FROM Fact_Acct_Balance fb WHERE DateAcct ");
            FinReportPeriod frp = this.getPeriod(this.m_columns[col].getRelativePeriod());
            if (this.m_lines[line].getAmountType() != null) {
                if (this.m_lines[line].isPeriod()) {
                    select.append(frp.getPeriodWhere());
                } else if (this.m_lines[line].isYear()) {
                    select.append(frp.getYearWhere());
                } else {
                    select.append(frp.getTotalWhere());
                }
            } else if (this.m_columns[col].getAmountType() != null) {
                if (this.m_columns[col].isPeriod()) {
                    select.append(frp.getPeriodWhere());
                } else if (this.m_columns[col].isYear()) {
                    select.append(frp.getYearWhere());
                } else {
                    select.append(frp.getTotalWhere());
                }
            }
            select.append(" AND fb.").append(variable).append("=x.").append(variable);
            if (!this.m_lines[line].isPostingType() && (PostingType = this.m_columns[col].getPostingType()) != null && PostingType.length() > 0) {
                select.append(" AND fb.PostingType='").append(PostingType).append("'");
            }
            if ((s = this.m_report.getWhereClause()) != null && s.length() > 0) {
                select.append(" AND ").append(s);
            }
            if (this.m_columns[col].isColumnTypeSegmentValue()) {
                select.append(this.m_columns[col].getWhereClause(this.p_PA_Hierarchy_ID));
            }
            select.append(this.m_parameterWhere);
            insert.append("(").append(select).append(")");
        }
        StringBuffer where = new StringBuffer(this.m_lines[line].getWhereClause(this.p_PA_Hierarchy_ID));
        String s = this.m_report.getWhereClause();
        if (s != null && s.length() > 0) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append(s);
        }
        if (where.length() > 0) {
            where.append(" AND ");
        }
        where.append(variable).append(" IS NOT NULL");
        insert.append(" FROM Fact_Acct_Balance x WHERE ").append(where);
        insert.append(this.m_parameterWhere).append(" GROUP BY ").append(variable);
        int no = DB.executeUpdate((String)insert.toString(), (String)this.get_TrxName());
        if (CLogMgt.isLevelFinest()) {
            this.log.fine("Source #=" + no + " - " + insert);
        }
        if (no == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer("UPDATE T_Report SET (Name,Description)=(").append(this.m_lines[line].getSourceValueQuery()).append("Record_ID) WHERE Record_ID <> 0 AND AD_PInstance_ID=").append(this.getAD_PInstance_ID()).append(" AND PA_ReportLine_ID=").append(this.m_lines[line].getPA_ReportLine_ID()).append(" AND Fact_Acct_ID=0");
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (CLogMgt.isLevelFinest()) {
            this.log.fine("Name #=" + no + " - " + sql.toString());
        }
        if (this.m_report.isListTrx()) {
            this.insertLineTrx(line, variable);
        }
    }

    private void insertLineTrx(int line, String variable) {
        int col;
        this.log.info("Line=" + line + " - Variable=" + variable);
        MReportLine rLine = this.m_lines[line];
        StringBuffer insert = new StringBuffer("INSERT INTO T_Report (AD_PInstance_ID, PA_ReportLine_ID, Record_ID,Fact_Acct_ID,LevelNo ");
        for (col = 0; col < this.m_columns.length; ++col) {
            insert.append(",Col_").append(col);
        }
        insert.append(") SELECT ").append(this.getAD_PInstance_ID()).append(",").append(rLine.getPA_ReportLine_ID()).append(",").append(variable).append(",Fact_Acct_ID, ");
        if (this.p_DetailsSourceFirst) {
            insert.append("-2 ");
        } else {
            insert.append("2 ");
        }
        for (col = 0; col < this.m_columns.length; ++col) {
            insert.append(", ");
            MReportColumn column = this.m_columns[col];
            if (column.isColumnTypeSegmentValue()) {
                // empty if block
            }
            if (!column.isColumnTypeRelativePeriod() || column.getRelativePeriodAsInt() != 0) {
                insert.append("NULL");
                continue;
            }
            if (rLine.getAmountType() != null) {
                insert.append(rLine.getSelectClause(false));
                continue;
            }
            if (column.getAmountType() != null) {
                insert.append(column.getSelectClause(false));
                continue;
            }
            insert.append("NULL");
        }
        StringBuffer where = new StringBuffer(rLine.getWhereClause(this.p_PA_Hierarchy_ID));
        String s = this.m_report.getWhereClause();
        if (s != null && s.length() > 0) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append(s);
        }
        FinReportPeriod frp = this.getPeriod(0);
        if (where.length() > 0) {
            where.append(" AND ");
        }
        where.append(" DateAcct ").append(frp.getPeriodWhere());
        where.append(" AND ").append(variable).append(" IS NOT NULL");
        insert.append(" FROM Fact_Acct WHERE ").append(where);
        int no = DB.executeUpdate((String)insert.toString(), (String)this.get_TrxName());
        this.log.finest("Trx #=" + no + " - " + insert);
        if (no == 0) {
            return;
        }
    }

    private void deleteUnprintedLines() {
        for (int line = 0; line < this.m_lines.length; ++line) {
            String sql;
            int no;
            if (this.m_lines[line].isPrinted() || (no = DB.executeUpdate((String)(sql = "DELETE FROM T_Report WHERE AD_PInstance_ID=" + this.getAD_PInstance_ID() + " AND PA_ReportLine_ID=" + this.m_lines[line].getPA_ReportLine_ID()), (String)this.get_TrxName())) <= 0) continue;
            this.log.fine(this.m_lines[line].getName() + " - #" + no);
        }
    }

    private MPrintFormat getPrintFormat() {
        boolean createNew;
        int AD_PrintFormat_ID = this.m_report.getAD_PrintFormat_ID();
        this.log.info("AD_PrintFormat_ID=" + AD_PrintFormat_ID);
        MPrintFormat pf = null;
        boolean bl = createNew = AD_PrintFormat_ID == 0;
        if (createNew) {
            int AD_Table_ID = 544;
            pf = MPrintFormat.createFromTable((Ctx)Env.getCtx(), (int)AD_Table_ID);
            AD_PrintFormat_ID = pf.getAD_PrintFormat_ID();
            this.m_report.setAD_PrintFormat_ID(AD_PrintFormat_ID);
            this.m_report.save();
        } else {
            pf = MPrintFormat.get((Ctx)this.getCtx(), (int)AD_PrintFormat_ID, (boolean)false);
        }
        if (!this.m_report.getName().equals(pf.getName())) {
            pf.setName(this.m_report.getName());
        }
        if (this.m_report.getDescription() == null) {
            if (pf.getDescription() != null) {
                pf.setDescription(null);
            }
        } else if (!this.m_report.getDescription().equals(pf.getDescription())) {
            pf.setDescription(this.m_report.getDescription());
        }
        pf.save();
        this.log.fine(pf + " - #" + pf.getItemCount());
        int count = pf.getItemCount();
        for (int i = 0; i < count; ++i) {
            MPrintFormatItem pfi = pf.getItem(i);
            String ColumnName = pfi.getColumnName();
            if (ColumnName == null) {
                this.log.log(Level.SEVERE, "No ColumnName for #" + i + " - " + pfi);
                if (pfi.isPrinted()) {
                    pfi.setIsPrinted(false);
                }
                if (pfi.isOrderBy()) {
                    pfi.setIsOrderBy(false);
                }
                if (pfi.getSortNo() != 0) {
                    pfi.setSortNo(0);
                }
            } else if (ColumnName.startsWith("Col")) {
                int index = Integer.parseInt(ColumnName.substring(4));
                if (index < this.m_columns.length) {
                    pfi.setIsPrinted(this.m_columns[index].isPrinted());
                    String s = this.m_columns[index].getName();
                    if (!pfi.getName().equals(s)) {
                        pfi.setName(s);
                        pfi.setPrintName(s);
                    }
                    int seq = 30 + index;
                    if (pfi.getSeqNo() != seq) {
                        pfi.setSeqNo(seq);
                    }
                } else if (pfi.isPrinted()) {
                    pfi.setIsPrinted(false);
                }
                if (pfi.isOrderBy()) {
                    pfi.setIsOrderBy(false);
                }
                if (pfi.getSortNo() != 0) {
                    pfi.setSortNo(0);
                }
            } else if (ColumnName.equals("SeqNo")) {
                if (pfi.isPrinted()) {
                    pfi.setIsPrinted(false);
                }
                if (!pfi.isOrderBy()) {
                    pfi.setIsOrderBy(true);
                }
                if (pfi.getSortNo() != 10) {
                    pfi.setSortNo(10);
                }
            } else if (ColumnName.equals("LevelNo")) {
                if (pfi.isPrinted()) {
                    pfi.setIsPrinted(false);
                }
                if (!pfi.isOrderBy()) {
                    pfi.setIsOrderBy(true);
                }
                if (pfi.getSortNo() != 20) {
                    pfi.setSortNo(20);
                }
            } else if (ColumnName.equals("Name")) {
                if (pfi.getSeqNo() != 10) {
                    pfi.setSeqNo(10);
                }
                if (!pfi.isPrinted()) {
                    pfi.setIsPrinted(true);
                }
                if (!pfi.isOrderBy()) {
                    pfi.setIsOrderBy(true);
                }
                if (pfi.getSortNo() != 30) {
                    pfi.setSortNo(30);
                }
            } else if (ColumnName.equals("Description")) {
                if (pfi.getSeqNo() != 20) {
                    pfi.setSeqNo(20);
                }
                if (!pfi.isPrinted()) {
                    pfi.setIsPrinted(true);
                }
                if (pfi.isOrderBy()) {
                    pfi.setIsOrderBy(false);
                }
                if (pfi.getSortNo() != 0) {
                    pfi.setSortNo(0);
                }
            } else {
                if (pfi.isPrinted()) {
                    pfi.setIsPrinted(false);
                }
                if (pfi.isOrderBy()) {
                    pfi.setIsOrderBy(false);
                }
                if (pfi.getSortNo() != 0) {
                    pfi.setSortNo(0);
                }
            }
            pfi.save();
            this.log.fine(pfi.toString());
        }
        pf.setTranslation();
        if (createNew) {
            pf = MPrintFormat.get((Ctx)this.getCtx(), (int)AD_PrintFormat_ID, (boolean)false);
        }
        return pf;
    }
}

