/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.X_PA_ReportLineSet;
import org.compiere.report.MReportLine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MReportLineSet
extends X_PA_ReportLineSet {
    private MReportLine[] m_lines = null;

    public MReportLineSet(Ctx ctx, int PA_ReportLineSet_ID, String trxName) {
        super(ctx, PA_ReportLineSet_ID, trxName);
        if (PA_ReportLineSet_ID != 0) {
            this.loadLines();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLines() {
        ArrayList<MReportLine> list = new ArrayList<MReportLine>();
        String sql = "SELECT * FROM PA_ReportLine WHERE PA_ReportLineSet_ID=? AND IsActive='Y' ORDER BY SeqNo";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getPA_ReportLineSet_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MReportLine(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        this.m_lines = new MReportLine[list.size()];
        list.toArray(this.m_lines);
        this.log.finest("ID=" + this.getPA_ReportLineSet_ID() + " - Size=" + list.size());
    }

    public MReportLine[] getLiness() {
        return this.m_lines;
    }

    public void list() {
        System.out.println(this.toString());
        if (this.m_lines == null) {
            return;
        }
        for (int i = 0; i < this.m_lines.length; ++i) {
            this.m_lines[i].list();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MReportLineSet[").append(this.get_ID()).append(" - ").append(this.getName()).append("]");
        return sb.toString();
    }
}

