/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report.core;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.compiere.model.MLookupFactory;
import org.compiere.util.Ctx;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;

public class RColumn {
    private String m_colHeader;
    private String m_colSQL;
    private Class m_colClass;
    private int m_displayType = 0;
    private int m_colSize = 30;
    private boolean m_readOnly = true;
    private boolean m_colorColumn = false;
    private boolean m_isIDcol = false;

    public RColumn(Ctx ctx, String columnName, int displayType) {
        this(ctx, columnName, displayType, null, 0, null);
    }

    public RColumn(Ctx ctx, String columnName, int displayType, int AD_Reference_Value_ID) {
        this(ctx, columnName, displayType, null, AD_Reference_Value_ID, null);
    }

    public RColumn(Ctx ctx, String columnName, int displayType, String sql) {
        this(ctx, columnName, displayType, sql, 0, null);
    }

    public RColumn(Ctx ctx, String columnName, int displayType, String sql, int AD_Reference_Value_ID, String refColumnName) {
        this.m_colHeader = Msg.translate((Ctx)ctx, (String)columnName);
        if (refColumnName != null) {
            this.m_colHeader = Msg.translate((Ctx)ctx, (String)refColumnName);
        }
        this.m_displayType = displayType;
        this.m_colSQL = sql;
        if (this.m_colSQL == null || this.m_colSQL.length() == 0) {
            this.m_colSQL = columnName;
        }
        if (DisplayType.isText((int)displayType)) {
            this.m_colClass = String.class;
        } else if (displayType == 12) {
            this.m_colClass = BigDecimal.class;
            this.m_colSize = 70;
        } else if (displayType == 20) {
            this.m_colClass = Boolean.class;
        } else if (DisplayType.isDate((int)displayType)) {
            this.m_colClass = Timestamp.class;
        } else if (displayType == 29 || displayType == 22 || displayType == 37) {
            this.m_colClass = Double.class;
            this.m_colSize = 70;
        } else if (displayType == 11) {
            this.m_colClass = Integer.class;
        } else if (displayType == 17) {
            Language language = Language.getLanguage((String)Env.getAD_Language((Ctx)ctx));
            this.m_colSQL = "(" + MLookupFactory.getLookup_ListEmbed((Language)language, (int)AD_Reference_Value_ID, (String)columnName) + ")";
            this.m_colClass = String.class;
            this.m_isIDcol = false;
        } else {
            this.m_colClass = String.class;
            Language language = Language.getLanguage((String)Env.getAD_Language((Ctx)ctx));
            if (columnName.equals("Account_ID") || columnName.equals("User1_ID") || columnName.equals("User2_ID")) {
                this.m_colSQL = this.m_colSQL + ",(" + MLookupFactory.getLookup_TableDirEmbed((Language)language, (String)"C_ElementValue_ID", (String)"zz", (String)columnName) + ")";
                this.m_isIDcol = true;
            } else if (columnName.startsWith("UserElement") && refColumnName != null) {
                this.m_colSQL = this.m_colSQL + ",(" + MLookupFactory.getLookup_TableDirEmbed((Language)language, (String)refColumnName, (String)"zz", (String)columnName) + ")";
                this.m_isIDcol = true;
            } else if (columnName.equals("C_LocFrom_ID") || columnName.equals("C_LocTo_ID")) {
                this.m_colSQL = this.m_colSQL + ",(" + MLookupFactory.getLookup_TableDirEmbed((Language)language, (String)"C_Location_ID", (String)"zz", (String)columnName) + ")";
                this.m_isIDcol = true;
            } else if (columnName.equals("AD_OrgTrx_ID")) {
                this.m_colSQL = this.m_colSQL + ",(" + MLookupFactory.getLookup_TableDirEmbed((Language)language, (String)"AD_Org_ID", (String)"zz", (String)columnName) + ")";
                this.m_isIDcol = true;
            } else if (displayType == 19) {
                this.m_colSQL = this.m_colSQL + ",(" + MLookupFactory.getLookup_TableDirEmbed((Language)language, (String)columnName, (String)"zz") + ")";
                this.m_isIDcol = true;
            }
        }
    }

    public RColumn(String colHeader, String colSQL, Class colClass) {
        this.m_colHeader = colHeader;
        this.m_colSQL = colSQL;
        this.m_colClass = colClass;
    }

    public String getColHeader() {
        return this.m_colHeader;
    }

    public void setColHeader(String colHeader) {
        this.m_colHeader = colHeader;
    }

    public String getColSQL() {
        return this.m_colSQL;
    }

    public void setColSQL(String colSQL) {
        this.m_colSQL = colSQL;
    }

    public boolean isIDcol() {
        return this.m_isIDcol;
    }

    public Class getColClass() {
        return this.m_colClass;
    }

    public void setColClass(Class colClass) {
        this.m_colClass = colClass;
    }

    public int getColSize() {
        return this.m_colSize;
    }

    public void setColSize(int colSize) {
        this.m_colSize = colSize;
    }

    public int getDisplayType() {
        return this.m_displayType;
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.m_readOnly = readOnly;
    }

    public void setColorColumn(boolean colorColumn) {
        this.m_colorColumn = colorColumn;
    }

    public boolean isColorColumn() {
        return this.m_colorColumn;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("RColumn[");
        sb.append(this.m_colSQL).append("=").append(this.m_colHeader).append("]");
        return sb.toString();
    }
}

