/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report.core;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import org.compiere.model.MRole;
import org.compiere.report.core.RColumn;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;

class RModelData {
    public ArrayList<ArrayList<Object>> rows = new ArrayList();
    private ArrayList<ArrayList<Object>> m_rows = new ArrayList();
    public ArrayList<Object> rowsMeta = new ArrayList();
    public ArrayList<RColumn> cols = new ArrayList();
    private String m_TableName;
    public HashMap<Integer, String> functions = new HashMap();
    public ArrayList<Integer> groups = new ArrayList();
    private ArrayList<Integer> m_groupRows = new ArrayList();
    private ArrayList<Boolean> m_groupRowsIndicator = null;
    private static final BigDecimal ONE = new BigDecimal(1.0);
    private static CLogger log = CLogger.getCLogger(RModelData.class);

    public RModelData(String TableName) {
        this.m_TableName = TableName;
    }

    public void dispose() {
        this.rows.clear();
        this.m_rows.clear();
        this.rowsMeta.clear();
        this.cols.clear();
    }

    public void query(Ctx ctx, String whereClause, String orderClause) {
        RColumn rc = null;
        StringBuffer sql = new StringBuffer("SELECT ");
        int size = this.cols.size();
        for (int i = 0; i < size; ++i) {
            rc = this.cols.get(i);
            if (i > 0) {
                sql.append(",");
            }
            sql.append(rc.getColSQL());
        }
        sql.append(" FROM ").append(this.m_TableName).append(" ").append("zz");
        if (whereClause != null && whereClause.length() > 0) {
            sql.append(" WHERE ").append(whereClause);
        }
        String finalSQL = MRole.getDefault((Ctx)ctx, (boolean)false).addAccessSQL(sql.toString(), "zz", true, false);
        if (orderClause != null && orderClause.length() > 0) {
            finalSQL = finalSQL + " ORDER BY " + orderClause;
        }
        log.fine(finalSQL);
        int index = 0;
        this.m_rows.clear();
        try {
            Statement stmt = DB.createStatement();
            ResultSet rs = stmt.executeQuery(finalSQL);
            while (rs.next()) {
                ArrayList<Object> row = new ArrayList<Object>(size);
                index = 1;
                for (int i = 0; i < size; ++i) {
                    rc = this.cols.get(i);
                    if (rc.isIDcol()) {
                        row.add(new KeyNamePair(rs.getInt(index++), rs.getString(index++)));
                        continue;
                    }
                    if (rs.getObject(index) == null) {
                        ++index;
                        row.add(null);
                        continue;
                    }
                    if (rc.getColClass() == String.class) {
                        row.add(rs.getString(index++));
                        continue;
                    }
                    if (rc.getColClass() == BigDecimal.class) {
                        row.add(rs.getBigDecimal(index++));
                        continue;
                    }
                    if (rc.getColClass() == Double.class) {
                        row.add(new Double(rs.getDouble(index++)));
                        continue;
                    }
                    if (rc.getColClass() == Integer.class) {
                        row.add(new Integer(rs.getInt(index++)));
                        continue;
                    }
                    if (rc.getColClass() == Timestamp.class) {
                        row.add(rs.getTimestamp(index++));
                        continue;
                    }
                    if (rc.getColClass() == Boolean.class) {
                        row.add(new Boolean("Y".equals(rs.getString(index++))));
                        continue;
                    }
                    row.add(rs.getString(index++));
                }
                this.m_rows.add(row);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            if (index == 0) {
                log.log(Level.SEVERE, finalSQL, (Throwable)e);
            } else {
                log.log(Level.SEVERE, "Index=" + index + "," + rc, (Throwable)e);
            }
            e.printStackTrace();
        }
        this.process();
    }

    private void process() {
        int fc;
        log.fine("Start Rows=" + this.m_rows.size());
        int gSize = this.groups.size();
        int[] groupBys = new int[gSize];
        Object[] groupBysValue = new Object[gSize];
        Object INITVALUE = new Object();
        for (int i = 0; i < gSize; ++i) {
            groupBys[i] = this.groups.get(i);
            groupBysValue[i] = INITVALUE;
            log.fine("GroupBy level=" + i + " col=" + groupBys[i]);
        }
        if (gSize > 0) {
            ArrayList<String> newRow = new ArrayList<String>();
            for (int c = 0; c < this.cols.size(); ++c) {
                newRow.add("");
            }
            this.m_rows.add(newRow);
        }
        int fSize = this.functions.size();
        int[] funcCols = new int[fSize];
        String[] funcFuns = new String[fSize];
        int index = 0;
        for (Integer key : this.functions.keySet()) {
            funcCols[index] = key;
            funcFuns[index] = this.functions.get(key).toString();
            log.fine("Function " + funcFuns[index] + " col=" + funcCols[index]);
            ++index;
        }
        BigDecimal[][] funcVals = new BigDecimal[fSize][gSize + 1];
        int totalIndex = gSize;
        log.fine("FunctionValues = [ " + fSize + " * " + (gSize + 1) + " ]");
        for (int f = 0; f < fSize; ++f) {
            for (int g = 0; g < gSize + 1; ++g) {
                funcVals[f][g] = Env.ZERO;
            }
        }
        this.rows.clear();
        for (int r = 0; r < this.m_rows.size(); ++r) {
            int idx;
            int level;
            ArrayList<Object> row = this.m_rows.get(r);
            boolean[] haveBreak = new boolean[groupBys.length];
            for (level = 0; level < groupBys.length; ++level) {
                idx = groupBys[level];
                haveBreak[level] = groupBysValue[level] == INITVALUE ? false : !groupBysValue[level].equals(row.get(idx));
                if (level <= 0 || !haveBreak[level - 1]) continue;
                haveBreak[level] = true;
            }
            for (level = groupBys.length - 1; level >= 0; --level) {
                idx = groupBys[level];
                if (groupBysValue[level] == INITVALUE) {
                    groupBysValue[level] = row.get(idx);
                    continue;
                }
                if (!haveBreak[level]) continue;
                ArrayList<Object> newRow = new ArrayList<Object>();
                for (int c = 0; c < this.cols.size(); ++c) {
                    if (c == idx) {
                        if (groupBysValue[c] == null || groupBysValue[c].toString().length() == 0) {
                            newRow.add("=");
                            continue;
                        }
                        newRow.add(groupBysValue[c]);
                        continue;
                    }
                    boolean found = false;
                    for (int fc2 = 0; fc2 < funcCols.length; ++fc2) {
                        if (c != funcCols[fc2]) continue;
                        newRow.add(funcVals[fc2][level]);
                        funcVals[fc2][level] = Env.ZERO;
                        found = true;
                    }
                    if (found) continue;
                    newRow.add(null);
                }
                this.m_groupRows.add(new Integer(this.rows.size()));
                this.rows.add(newRow);
                groupBysValue[level] = row.get(idx);
            }
            for (fc = 0; fc < funcCols.length; ++fc) {
                int col = funcCols[fc];
                Object value = row.get(col);
                BigDecimal bd = Env.ZERO;
                if (value != null) {
                    if (value instanceof BigDecimal) {
                        bd = (BigDecimal)value;
                    } else {
                        try {
                            bd = new BigDecimal(value.toString());
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                for (int level2 = 0; level2 < gSize + 1; ++level2) {
                    if (funcFuns[fc].equals("Sum")) {
                        funcVals[fc][level2] = funcVals[fc][level2].add(bd);
                        continue;
                    }
                    if (!funcFuns[fc].equals("Count")) continue;
                    funcVals[fc][level2] = funcVals[fc][level2].add(ONE);
                }
            }
            this.rows.add(row);
        }
        if (this.functions.size() > 0) {
            ArrayList<BigDecimal> newRow = new ArrayList<BigDecimal>();
            for (int c = 0; c < this.cols.size(); ++c) {
                boolean found = false;
                for (fc = 0; fc < funcCols.length; ++fc) {
                    if (c != funcCols[fc]) continue;
                    newRow.add(funcVals[fc][totalIndex]);
                    found = true;
                }
                if (found) continue;
                newRow.add(null);
            }
            if (gSize > 0) {
                this.rows.remove(this.rows.size() - 1);
            }
            this.m_groupRows.add(new Integer(this.rows.size()));
            this.rows.add(newRow);
        }
        log.fine("End Rows=" + this.rows.size());
        this.m_rows.clear();
    }

    public boolean isGroupRow(int row) {
        if (this.m_groupRowsIndicator == null) {
            this.m_groupRowsIndicator = new ArrayList(this.rows.size());
            for (int r = 0; r < this.rows.size(); ++r) {
                this.m_groupRowsIndicator.add(new Boolean(this.m_groupRows.contains(new Integer(r))));
            }
        }
        if (row < 0 || row >= this.m_groupRowsIndicator.size()) {
            return false;
        }
        return this.m_groupRowsIndicator.get(row);
    }

    public void moveRow(int from, int to) {
        if (from < 0 || to >= this.rows.size()) {
            throw new IllegalArgumentException("Row from invalid");
        }
        if (to < 0 || to >= this.rows.size()) {
            throw new IllegalArgumentException("Row to invalid");
        }
        ArrayList<Object> temp = this.rows.get(from);
        this.rows.remove(from);
        this.rows.add(to, temp);
        if (this.m_groupRowsIndicator != null) {
            Boolean tempB = this.m_groupRowsIndicator.get(from);
            this.m_groupRowsIndicator.remove(from);
            this.m_groupRowsIndicator.add(to, tempB);
        }
    }

    public String getTableName() {
        return this.m_TableName;
    }
}

