/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.b;
import org.apache.ecs.xhtml.body;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.h1;
import org.apache.ecs.xhtml.head;
import org.apache.ecs.xhtml.html;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.link;
import org.apache.ecs.xhtml.meta;
import org.apache.ecs.xhtml.p;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.title;
import org.apache.ecs.xhtml.tr;
import org.compiere.util.Ctx;
import org.compiere.util.Msg;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

public class WebDoc {
    public static final String NBSP = "&nbsp;";
    private html m_html = new html();
    private head m_head = new head();
    private body m_body = new body();
    private table m_table = null;
    private tr m_topRow = null;
    private td m_topRight = null;
    private td m_topLeft = null;

    public static WebDoc create(boolean plain, String title, boolean javaClient) {
        return WebDoc.create(plain, title, javaClient, null);
    }

    public static WebDoc create(boolean plain, String title, boolean javaClient, HttpServletRequest request) {
        WebDoc doc = new WebDoc();
        doc.setUp(plain, javaClient, title, request);
        return doc;
    }

    public static WebDoc create(boolean plain) {
        return WebDoc.create(plain, null, false);
    }

    public static WebDoc createPopup(String title) {
        return WebDoc.createPopup(title, null);
    }

    public static WebDoc createPopup(String title, HttpServletRequest request) {
        WebDoc doc = WebDoc.create(title, request);
        doc.getHead().addElement((Element)new script((Element)null, "js/window.js"));
        doc.getHead().addElement((Element)new script((Element)null, "js/session.js"));
        doc.getHead().addElement((Element)new link("css/import.css", "stylesheet", "text/css"));
        doc.getHead().addElement((Element)new link("css/popup.css", "stylesheet", "text/css"));
        return doc;
    }

    public static WebDoc createWindow(String title) {
        return WebDoc.createWindow(title, null);
    }

    public static WebDoc createWindow(String title, HttpServletRequest request) {
        WebDoc doc = WebDoc.create(title, request);
        if (request == null || request != null && request.getAttribute("IS_POPUP_WINDOW") == null) {
            doc.getHead().addElement((Element)new link("css/import.css", "stylesheet", "text/css"));
        } else {
            doc.getHead().addElement((Element)new link("css/import_popup.css", "stylesheet", "text/css"));
        }
        doc.getHead().addElement((Element)new link("css/window.css", "stylesheet", "text/css"));
        doc.getHead().addElement((Element)new link("js/window.css", "stylesheet", "text/css"));
        doc.getHead().addElement((Element)new link(WebEnv.getBaseDirectory("js/zoomMenu.css"), "stylesheet", "text/css"));
        doc.getHead().addElement((Element)new script((Element)null, "js/window.js"));
        doc.getHead().addElement((Element)new script((Element)null, "js/wmenu.js"));
        doc.getHead().addElement((Element)new script((Element)null, "js/tigra_calculator/calculator.js"));
        doc.getHead().addElement((Element)new link("js/yui_2.6.0/yui/build/menu/assets/skins/sam/menu.css", "stylesheet", "text/css"));
        doc.getHead().addElement((Element)new script((Element)null, "js/yui_2.6.0/yui/build/yahoo-dom-event/yahoo-dom-event.js"));
        doc.getHead().addElement((Element)new script((Element)null, "js/yui_2.6.0/yui/build/container/container_core.js"));
        doc.getHead().addElement((Element)new script((Element)null, "js/yui_2.6.0/yui/build/menu/menu.js"));
        doc.setClasses("windowTable", "windowHeader");
        return doc;
    }

    public static WebDoc create(String title) {
        return WebDoc.create(false, title, false, null);
    }

    public static WebDoc create(String title, HttpServletRequest request) {
        return WebDoc.create(false, title, false, request);
    }

    private WebDoc() {
    }

    private void setUp(boolean plain, boolean javaClient, String title2, HttpServletRequest request) {
        String secondDivId;
        this.m_html.addElement((Element)this.m_head);
        this.m_html.addElement((Element)this.m_body);
        this.m_body.setID("main");
        if (request != null && request.getAttribute("BODY_ID") != null) {
            this.m_body.setID((String)request.getAttribute("BODY_ID"));
            if ("menu".equals(request.getAttribute("BODY_ID"))) {
                this.m_body.setOnLoad(WebDoc.getMenuOnLoadScript());
            }
        }
        div divSecond = null;
        if (request != null && (secondDivId = (String)request.getAttribute("SECOND_DIV_ID")) != null) {
            divSecond = (div)new div().setID(secondDivId);
            this.m_body.addElement((Element)divSecond);
        }
        if (divSecond != null) {
            divSecond.addElement((Element)new a().setName("top"));
        } else {
            this.m_body.addElement((Element)new a().setName("top"));
        }
        if (title2 != null) {
            this.m_head.addElement((Element)new title(title2));
        }
        if (plain) {
            return;
        }
        if (javaClient) {
            this.m_head.addElement((Element)new link("http://www.compiere.org/standard.css", "stylesheet", "text/css"));
        } else {
            this.m_head.addElement((Element)new script((Element)null, WebEnv.getBaseDirectory("js/standard.js")));
            this.m_head.addElement((Element)new script((Element)null, WebEnv.getBaseDirectory("js/yui_2.6.0/yui/build/yahoo/yahoo.js")));
            this.m_head.addElement((Element)new script((Element)null, WebEnv.getBaseDirectory("js/yui_2.6.0/yui/build/event/event.js")));
            this.m_head.addElement((Element)new script((Element)null, WebEnv.getBaseDirectory("js/yui_2.6.0/yui/build/connection/connection.js")));
            this.m_head.addElement((Element)new script((Element)null, WebEnv.getBaseDirectory("ajax/js/prototype-1.4.0.js")));
            this.m_head.addElement((Element)new script((Element)null, WebEnv.getBaseDirectory("js/zoomMenu.js")));
            this.m_head.addElement((Element)new script((Element)null, WebEnv.getBaseDirectory("js/session.js")));
            this.m_head.addElement((Element)new script(WebDoc.getWindowOnUnloadScript()));
        }
        this.m_head.addElement((Element)new meta().setHttpEquiv("Content-Type", "text/html; charset=UTF-8"));
        this.m_head.addElement((Element)new meta().setName("description", "Compiere HTML UI"));
        this.m_table = new table("0", "0", "0", "100%", null);
        this.m_topRow = new tr();
        this.m_topLeft = new td().setColSpan(2);
        this.m_topLeft.setClass("windowHeader");
        if (title2 == null) {
            this.m_topLeft.addElement(NBSP);
            this.m_topRow.addElement((Element)this.m_topLeft);
        } else {
            div divHeader = (div)new div().setID("header");
            divHeader.setStyle("white-space: nowrap;");
            if (request != null && "menu".equals(request.getAttribute("BODY_ID"))) {
                divHeader.addElement(new h1(title2).setID("top"));
                p loginInfo = new p();
                loginInfo.setStyle("padding:0px 0px 5px 0px");
                loginInfo.setTagText((String)request.getAttribute("LOGIN_INFO"));
                divHeader.addElement((Element)loginInfo);
                WebSessionCtx wsc = WebSessionCtx.get(request);
                img imageButton = new img("/compiere/ampiere/images/Multi16.png");
                imageButton.setStyle("border: solid 1px #e5e5e5;cursor: pointer;");
                imageButton.setOnClick("shotMenuControl();");
                imageButton.setTitle(Msg.getMsg((Ctx)wsc.ctx, (String)"Multi"));
                divHeader.addElement((Element)imageButton);
                input menuSearch = new input("text", "menuSearch", "");
                menuSearch.setID("menuSearch");
                menuSearch.setOnKeyPress("findMenu(event);");
                menuSearch.setStyle("width:100px");
                divHeader.addElement(Msg.translate((Ctx)wsc.ctx, (String)"TreeSearch"));
                divHeader.addElement((Element)menuSearch);
                imageButton = new img("/compiere/ampiere/images/ExpandAll16.gif");
                imageButton.setStyle("border: solid 1px #e5e5e5;cursor: pointer;");
                imageButton.setOnClick("menuControl(true);");
                imageButton.setTitle(Msg.getMsg((Ctx)wsc.ctx, (String)"ExpandTree"));
                divHeader.addElement((Element)imageButton);
                imageButton = new img("/compiere/ampiere/images/CollapseAll16.gif");
                imageButton.setStyle("border: solid 1px #e5e5e5;cursor: pointer;");
                imageButton.setOnClick("menuControl(false);");
                imageButton.setTitle(Msg.getMsg((Ctx)wsc.ctx, (String)"CollapseTree"));
                divHeader.addElement((Element)imageButton);
            } else {
                divHeader.addElement((Element)new h1(title2));
            }
            this.m_topLeft.addElement((Element)divHeader);
            this.m_topRow.addElement((Element)this.m_topLeft);
        }
        this.m_topRight = new td().setAlign("right");
        this.m_topRight.setClass("windowHeader");
        if (javaClient) {
            this.m_topRight.addElement((Element)new img("http://www.compiere.org/images/Compiere64x32.png").setAlign("right").setAlt("&copy; Jorg Janke/Compiere"));
        } else {
            this.m_topRight.addElement(NBSP);
        }
        this.m_table.addElement((Element)this.m_topRow);
        if (divSecond != null) {
            divSecond.addElement((Element)this.m_table);
        } else {
            this.m_body.addElement((Element)this.m_table);
        }
    }

    public void setClasses(String tableClass, String tdClass) {
        if (this.m_table != null && tableClass != null) {
            this.m_table.setClass(tableClass);
        }
        if (this.m_topLeft != null && tdClass != null) {
            this.m_topLeft.setClass(tdClass);
        }
        if (this.m_topRight != null && tdClass != null) {
            this.m_topRight.setClass(tdClass);
        }
    }

    public body getBody() {
        return this.m_body;
    }

    public head getHead() {
        return this.m_head;
    }

    public table getTable() {
        return this.m_table;
    }

    public tr getTopRow() {
        return this.m_topRow;
    }

    public td getTopLeft() {
        return this.m_topLeft;
    }

    public td getTopRight() {
        return this.m_topRight;
    }

    public String toString() {
        return this.m_html.toString();
    }

    public void output(OutputStream out) {
        this.m_html.output(out);
    }

    public void output(PrintWriter out) {
        this.m_html.output(out);
    }

    public td addPopupCenter(boolean nowrap) {
        if (this.m_table == null) {
            return null;
        }
        td center = new td("popupCenter", "center", "middle", nowrap);
        center.setColSpan(2);
        this.m_table.addElement((Element)new tr().addElement((Element)center));
        return center;
    }

    public td[] addPopupClose() {
        input button2 = WebUtil.createClosePopupButton();
        p buttonP = (p)new p().setClass("align-right");
        buttonP.addElement((Element)button2);
        if (this.m_table == null) {
            this.m_body.addElement((Element)button2);
            return null;
        }
        td right = new td(null, "right", "middle", false, (Element)buttonP).setColSpan(2);
        div msgDiv = (div)new div().setClass("topMsgLeft");
        msgDiv.addElement((Element)new tr().addElement((Element)right));
        this.m_table.addElement((Element)msgDiv);
        return new td[]{right};
    }

    public td addWindowCenter(boolean nowrap) {
        if (this.m_table == null) {
            return null;
        }
        td center = new td("windowCenter", "center", "middle", nowrap);
        center.setColSpan(2);
        this.m_table.addElement((Element)new tr().addElement((Element)center));
        return center;
    }

    public td addTd() {
        return this.addTd(1);
    }

    public td addTd(int colSpan) {
        if (this.m_table == null) {
            return null;
        }
        td newTd = new td().setColSpan(colSpan);
        this.m_table.addElement((Element)new tr().addElement((Element)newTd));
        return newTd;
    }

    public td[] addWindowFooters() {
        if (this.m_table == null) {
            return null;
        }
        td left = new td("windowFooter", "left", "middle", false);
        td right = new td("windowFooter", "right", "middle", false);
        this.m_table.addElement((Element)new tr().addElement((Element)left).addElement((Element)right));
        return new td[]{left, right};
    }

    public td addWindowFooter() {
        if (this.m_table == null) {
            return null;
        }
        td center = new td("windowFooter", "center", "middle", false);
        this.m_table.addElement((Element)new tr().addElement((Element)center));
        return center;
    }

    public static void main(String[] args) {
        WebDoc doc = WebDoc.create("Test");
        doc.getBody().addElement((Element)new b("111 <<< >>> &&& \\\\ \u0100 \ufffd"));
        form f = new form("myaction");
        f.addElement((Element)new input());
        doc.getBody().addElement((Element)f);
    }

    public static String makeAjaxProgressGIF(String pID, boolean hasImg4NN) {
        StringBuffer rtVal = new StringBuffer();
        img img2 = new img().setSrc(WebEnv.getBaseDirectory("ajax/img/indicator.gif"));
        img2.setID("progress" + pID);
        img2.setStyle("display:none;");
        if (hasImg4NN) {
            img img4NN = new img().setSrc(WebEnv.getBaseDirectory("ajax/img/h.gif"));
            rtVal.append(img4NN).append(img2);
        } else {
            rtVal.append(img2);
        }
        return rtVal.toString();
    }

    public static String getMenuOnLoadScript() {
        StringBuffer sb = new StringBuffer();
        sb.append("top.frames['WWindow'].location.href='/compiere/ampiere/WPerformanceMeter';");
        return sb.toString();
    }

    public static String getWindowOnUnloadScript() {
        StringBuffer sb = new StringBuffer();
        sb.append("window.onunload =makeSessionCleanRequest;");
        return sb.toString();
    }
}

