/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.tc5.sso;

import java.security.Principal;
import org.apache.catalina.Session;
import org.apache.catalina.SessionListener;
import org.apache.catalina.authenticator.SingleSignOn;

class SingleSignOnEntry {
    private String authType = null;
    private String password = null;
    private Principal principal = null;
    private Session[] sessions = new Session[0];
    private String username = null;
    private boolean canReauthenticate = false;

    SingleSignOnEntry(Principal principal, String authType, String username, String password) {
        this.updateCredentials(principal, authType, username, password);
    }

    synchronized boolean addSession(SingleSignOn sso, Session session) {
        for (int i = 0; i < this.sessions.length; ++i) {
            if (session != this.sessions[i]) continue;
            return false;
        }
        Session[] results = new Session[this.sessions.length + 1];
        System.arraycopy(this.sessions, 0, results, 0, this.sessions.length);
        results[this.sessions.length] = session;
        this.sessions = results;
        session.addSessionListener((SessionListener)sso);
        return true;
    }

    synchronized boolean removeSession(Session session) {
        if (this.sessions.length == 0) {
            return false;
        }
        boolean removed = false;
        Session[] nsessions = new Session[this.sessions.length - 1];
        int j = 0;
        for (int i = 0; i < this.sessions.length; ++i) {
            if (session == this.sessions[i]) {
                removed = true;
                continue;
            }
            if (!removed && i == nsessions.length) break;
            nsessions[j++] = this.sessions[i];
        }
        this.sessions = nsessions;
        if (removed) {
            this.sessions = nsessions;
        }
        return removed;
    }

    synchronized Session[] findSessions() {
        return this.sessions;
    }

    String getAuthType() {
        return this.authType;
    }

    boolean getCanReauthenticate() {
        return this.canReauthenticate;
    }

    String getPassword() {
        return this.password;
    }

    Principal getPrincipal() {
        return this.principal;
    }

    void setPrincipal(Principal principal) {
        this.principal = principal;
    }

    int getSessionCount() {
        return this.sessions.length;
    }

    String getUsername() {
        return this.username;
    }

    synchronized boolean updateCredentials(Principal principal, String authType, String username, String password) {
        boolean changed = this.safeEquals(this.principal, principal) || this.safeEquals(this.authType, authType) || this.safeEquals(this.username, username) || this.safeEquals(this.password, password);
        this.principal = principal;
        this.authType = authType;
        this.username = username;
        this.password = password;
        this.canReauthenticate = "BASIC".equals(authType) || "FORM".equals(authType);
        return changed;
    }

    private boolean safeEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b) || b != null && b.equals(a);
    }
}

