/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.model;

/** Generated Model - DO NOT CHANGE */
import java.sql.*;
import java.math.*;
import org.compiere.framework.*;
import org.compiere.util.*;
/** Generated Model for AD_AccessLog
 *  @author Jorg Janke (generated) 
 *  @version Release J3.0.0_A03 - $Id: X_AD_AccessLog.java,v 1.5.2.1 2010/08/07 08:01:05 jrmt Exp $ */
public class X_AD_AccessLog extends PO
{
/** Standard Constructor
@param ctx context
@param AD_AccessLog_ID id
@param trxName transaction
*/
public X_AD_AccessLog (Ctx ctx, int AD_AccessLog_ID, String trxName)
{
super (ctx, AD_AccessLog_ID, trxName);
/** if (AD_AccessLog_ID == 0)
{
setAD_AccessLog_ID (0);
setAssetServiceDate (0);
}
 */
}
/** Load Constructor 
@param ctx context
@param rs result set 
@param trxName transaction
*/
public X_AD_AccessLog (Ctx ctx, ResultSet rs, String trxName)
{
super (ctx, rs, trxName);
}
/** Serial Version No */
static final long serialVersionUID = 27538239774789L;
/** Last Updated Timestamp 2009-10-21 17:40:58.0 */
public static final long updatedMS = 1256114458000L;
/** AD_Table_ID=717 */
public static final int Table_ID=717;

/** TableName=AD_AccessLog */
public static final String Table_Name="AD_AccessLog";

protected static KeyNamePair Model = new KeyNamePair(717,"AD_AccessLog");

protected BigDecimal accessLevel = new BigDecimal(6);
/** AccessLevel
@return 6 - System - Client 
*/
protected int get_AccessLevel()
{
return accessLevel.intValue();
}
/** Load Meta Data
@param ctx context
@return PO Info
*/
protected POInfo initPO (Ctx ctx)
{
POInfo poi = POInfo.getPOInfo (ctx, Table_ID);
return poi;
}
/** Info
@return info
*/
public String toString()
{
StringBuffer sb = new StringBuffer ("X_AD_AccessLog[").append(get_ID()).append("]");
return sb.toString();
}
/** Set Access Log.
@param AD_AccessLog_ID Log of Access to the System */
public void setAD_AccessLog_ID (int AD_AccessLog_ID)
{
if (AD_AccessLog_ID < 1) throw new IllegalArgumentException ("AD_AccessLog_ID is mandatory.");
set_ValueNoCheck ("AD_AccessLog_ID", new Integer(AD_AccessLog_ID));
}
/** Get Access Log.
@return Log of Access to the System */
public int getAD_AccessLog_ID() 
{
Integer ii = (Integer)get_Value("AD_AccessLog_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Column.
@param AD_Column_ID Column in the table */
public void setAD_Column_ID (int AD_Column_ID)
{
if (AD_Column_ID <= 0) set_Value ("AD_Column_ID", null);
else
set_Value ("AD_Column_ID", new Integer(AD_Column_ID));
}
/** Get Column.
@return Column in the table */
public int getAD_Column_ID() 
{
Integer ii = (Integer)get_Value("AD_Column_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Table.
@param AD_Table_ID Database Table information */
public void setAD_Table_ID (int AD_Table_ID)
{
if (AD_Table_ID <= 0) set_Value ("AD_Table_ID", null);
else
set_Value ("AD_Table_ID", new Integer(AD_Table_ID));
}
/** Get Table.
@return Database Table information */
public int getAD_Table_ID() 
{
Integer ii = (Integer)get_Value("AD_Table_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set User/Contact.
@param AD_User_ID User within the system - Internal or Business Partner Contact */
public void setAD_User_ID (int AD_User_ID)
{
if (AD_User_ID <= 0) set_Value ("AD_User_ID", null);
else
set_Value ("AD_User_ID", new Integer(AD_User_ID));
}
/** Get User/Contact.
@return User within the system - Internal or Business Partner Contact */
public int getAD_User_ID() 
{
Integer ii = (Integer)get_Value("AD_User_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set In Service Date.
@param AssetServiceDate Date when Asset was put into service */
public void setAssetServiceDate (int AssetServiceDate)
{
set_ValueNoCheck ("AssetServiceDate", new Integer(AssetServiceDate));
}
/** Get In Service Date.
@return Date when Asset was put into service */
public int getAssetServiceDate() 
{
Integer ii = (Integer)get_Value("AssetServiceDate");
if (ii == null) return 0;
return ii.intValue();
}
/** Get Record ID/ColumnName
@return ID/ColumnName pair */
public KeyNamePair getKeyNamePair() 
{
return new KeyNamePair(get_ID(), String.valueOf(getAssetServiceDate()));
}
/** Set Lead.
@param C_Lead_ID Business Lead */
public void setC_Lead_ID (int C_Lead_ID)
{
if (C_Lead_ID <= 0) set_Value ("C_Lead_ID", null);
else
set_Value ("C_Lead_ID", new Integer(C_Lead_ID));
}
/** Get Lead.
@return Business Lead */
public int getC_Lead_ID() 
{
Integer ii = (Integer)get_Value("C_Lead_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Description.
@param Description Optional short description of the record */
public void setDescription (String Description)
{
if (Description != null && Description.length() > 255)
{
log.warning("Length > 255 - truncated");
Description = Description.substring(0,255);
}
set_Value ("Description", Description);
}
/** Get Description.
@return Optional short description of the record */
public String getDescription() 
{
return (String)get_Value("Description");
}
/** Set Record ID.
@param Record_ID Direct internal record ID */
public void setRecord_ID (int Record_ID)
{
if (Record_ID <= 0) set_Value ("Record_ID", null);
else
set_Value ("Record_ID", new Integer(Record_ID));
}
/** Get Record ID.
@return Direct internal record ID */
public int getRecord_ID() 
{
Integer ii = (Integer)get_Value("Record_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Remote Addr.
@param Remote_Addr Remote Address */
public void setRemote_Addr (String Remote_Addr)
{
if (Remote_Addr != null && Remote_Addr.length() > 60)
{
log.warning("Length > 60 - truncated");
Remote_Addr = Remote_Addr.substring(0,60);
}
set_Value ("Remote_Addr", Remote_Addr);
}
/** Get Remote Addr.
@return Remote Address */
public String getRemote_Addr() 
{
return (String)get_Value("Remote_Addr");
}
/** Set Remote Host.
@param Remote_Host Remote host Info */
public void setRemote_Host (String Remote_Host)
{
if (Remote_Host != null && Remote_Host.length() > 60)
{
log.warning("Length > 60 - truncated");
Remote_Host = Remote_Host.substring(0,60);
}
set_Value ("Remote_Host", Remote_Host);
}
/** Get Remote Host.
@return Remote host Info */
public String getRemote_Host() 
{
return (String)get_Value("Remote_Host");
}
/** Set Reply.
@param Reply Reply or Answer */
public void setReply (String Reply)
{
if (Reply != null && Reply.length() > 2000)
{
log.warning("Length > 2000 - truncated");
Reply = Reply.substring(0,2000);
}
set_Value ("Reply", Reply);
}
/** Get Reply.
@return Reply or Answer */
public String getReply() 
{
return (String)get_Value("Reply");
}
/** Set Text Message.
@param TextMsg Text Message */
public void setTextMsg (String TextMsg)
{
if (TextMsg != null && TextMsg.length() > 2000)
{
log.warning("Length > 2000 - truncated");
TextMsg = TextMsg.substring(0,2000);
}
set_Value ("TextMsg", TextMsg);
}
/** Get Text Message.
@return Text Message */
public String getTextMsg() 
{
return (String)get_Value("TextMsg");
}
}
