/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.model;

/** Generated Model - DO NOT CHANGE */
import java.sql.*;
import java.math.*;
import org.compiere.framework.*;
import org.compiere.util.*;
/** Generated Model for AD_AssignSet
 *  @author Jorg Janke (generated) 
 *  @version Release J3.0.0_A03 - $Id: X_AD_AssignSet.java,v 1.5.2.1 2010/08/07 08:01:10 jrmt Exp $ */
public class X_AD_AssignSet extends PO
{
/** Standard Constructor
@param ctx context
@param AD_AssignSet_ID id
@param trxName transaction
*/
public X_AD_AssignSet (Ctx ctx, int AD_AssignSet_ID, String trxName)
{
super (ctx, AD_AssignSet_ID, trxName);
/** if (AD_AssignSet_ID == 0)
{
setAD_AssignSet_ID (0);
setAD_Table_ID (0);
setAutoAssignRule (null);
setName (null);
}
 */
}
/** Load Constructor 
@param ctx context
@param rs result set 
@param trxName transaction
*/
public X_AD_AssignSet (Ctx ctx, ResultSet rs, String trxName)
{
super (ctx, rs, trxName);
}
/** Serial Version No */
static final long serialVersionUID = 27462259668789L;
/** Last Updated Timestamp 2007-05-26 08:05:52.0 */
public static final long updatedMS = 1180134352000L;
/** AD_Table_ID=930 */
public static final int Table_ID=930;

/** TableName=AD_AssignSet */
public static final String Table_Name="AD_AssignSet";

protected static KeyNamePair Model = new KeyNamePair(930,"AD_AssignSet");

protected BigDecimal accessLevel = new BigDecimal(6);
/** AccessLevel
@return 6 - System - Client 
*/
protected int get_AccessLevel()
{
return accessLevel.intValue();
}
/** Load Meta Data
@param ctx context
@return PO Info
*/
protected POInfo initPO (Ctx ctx)
{
POInfo poi = POInfo.getPOInfo (ctx, Table_ID);
return poi;
}
/** Info
@return info
*/
public String toString()
{
StringBuffer sb = new StringBuffer ("X_AD_AssignSet[").append(get_ID()).append("]");
return sb.toString();
}
/** Set Auto Assignment.
@param AD_AssignSet_ID Automatic Assignment of values */
public void setAD_AssignSet_ID (int AD_AssignSet_ID)
{
if (AD_AssignSet_ID < 1) throw new IllegalArgumentException ("AD_AssignSet_ID is mandatory.");
set_ValueNoCheck ("AD_AssignSet_ID", new Integer(AD_AssignSet_ID));
}
/** Get Auto Assignment.
@return Automatic Assignment of values */
public int getAD_AssignSet_ID() 
{
Integer ii = (Integer)get_Value("AD_AssignSet_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Table.
@param AD_Table_ID Database Table information */
public void setAD_Table_ID (int AD_Table_ID)
{
if (AD_Table_ID < 1) throw new IllegalArgumentException ("AD_Table_ID is mandatory.");
set_Value ("AD_Table_ID", new Integer(AD_Table_ID));
}
/** Get Table.
@return Database Table information */
public int getAD_Table_ID() 
{
Integer ii = (Integer)get_Value("AD_Table_ID");
if (ii == null) return 0;
return ii.intValue();
}

/** AutoAssignRule AD_Reference_ID=424 */
public static final int AUTOASSIGNRULE_AD_Reference_ID=424;
/** Create and Update = B */
public static final String AUTOASSIGNRULE_CreateAndUpdate = "B";
/** Create only = C */
public static final String AUTOASSIGNRULE_CreateOnly = "C";
/** Create and Update if not Processed = P */
public static final String AUTOASSIGNRULE_CreateAndUpdateIfNotProcessed = "P";
/** Update if not Processed = Q */
public static final String AUTOASSIGNRULE_UpdateIfNotProcessed = "Q";
/** Update only = U */
public static final String AUTOASSIGNRULE_UpdateOnly = "U";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isAutoAssignRuleValid (String test)
{
return test.equals("B") || test.equals("C") || test.equals("P") || test.equals("Q") || test.equals("U");
}
/** Set Auto Assign Rule.
@param AutoAssignRule Timing of automatic assignment */
public void setAutoAssignRule (String AutoAssignRule)
{
if (AutoAssignRule == null) throw new IllegalArgumentException ("AutoAssignRule is mandatory");
if (!isAutoAssignRuleValid(AutoAssignRule))
throw new IllegalArgumentException ("AutoAssignRule Invalid value - " + AutoAssignRule + " - Reference_ID=424 - B - C - P - Q - U");
if (AutoAssignRule.length() > 1)
{
log.warning("Length > 1 - truncated");
AutoAssignRule = AutoAssignRule.substring(0,1);
}
set_Value ("AutoAssignRule", AutoAssignRule);
}
/** Get Auto Assign Rule.
@return Timing of automatic assignment */
public String getAutoAssignRule() 
{
return (String)get_Value("AutoAssignRule");
}
/** Set Description.
@param Description Optional short description of the record */
public void setDescription (String Description)
{
if (Description != null && Description.length() > 255)
{
log.warning("Length > 255 - truncated");
Description = Description.substring(0,255);
}
set_Value ("Description", Description);
}
/** Get Description.
@return Optional short description of the record */
public String getDescription() 
{
return (String)get_Value("Description");
}
/** Set Comment.
@param Help Comment, Help or Hint */
public void setHelp (String Help)
{
if (Help != null && Help.length() > 2000)
{
log.warning("Length > 2000 - truncated");
Help = Help.substring(0,2000);
}
set_Value ("Help", Help);
}
/** Get Comment.
@return Comment, Help or Hint */
public String getHelp() 
{
return (String)get_Value("Help");
}
/** Set Name.
@param Name Alphanumeric identifier of the entity */
public void setName (String Name)
{
if (Name == null) throw new IllegalArgumentException ("Name is mandatory.");
if (Name.length() > 60)
{
log.warning("Length > 60 - truncated");
Name = Name.substring(0,60);
}
set_Value ("Name", Name);
}
/** Get Name.
@return Alphanumeric identifier of the entity */
public String getName() 
{
return (String)get_Value("Name");
}
/** Get Record ID/ColumnName
@return ID/ColumnName pair */
public KeyNamePair getKeyNamePair() 
{
return new KeyNamePair(get_ID(), getName());
}
}
