/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.model;

/** Generated Model - DO NOT CHANGE */
import java.sql.*;
import java.math.*;
import org.compiere.framework.*;
import org.compiere.util.*;
/** Generated Model for AD_Color
 *  @author Jorg Janke (generated) 
 *  @version Release J3.0.0_A03 - $Id: X_AD_Color.java,v 1.5.2.1 2010/08/07 08:01:04 jrmt Exp $ */
public class X_AD_Color extends PO
{
/** Standard Constructor
@param ctx context
@param AD_Color_ID id
@param trxName transaction
*/
public X_AD_Color (Ctx ctx, int AD_Color_ID, String trxName)
{
super (ctx, AD_Color_ID, trxName);
/** if (AD_Color_ID == 0)
{
setAD_Color_ID (0);
setAlpha (0);
setBlue (0);
setColorType (null);
setGreen (0);
setImageAlpha (Env.ZERO);
setIsDefault (false);
setName (null);
setRed (0);
}
 */
}
/** Load Constructor 
@param ctx context
@param rs result set 
@param trxName transaction
*/
public X_AD_Color (Ctx ctx, ResultSet rs, String trxName)
{
super (ctx, rs, trxName);
}
/** Serial Version No */
static final long serialVersionUID = 27459138862789L;
/** Last Updated Timestamp 2007-04-20 05:12:26.0 */
public static final long updatedMS = 1177013546000L;
/** AD_Table_ID=457 */
public static final int Table_ID=457;

/** TableName=AD_Color */
public static final String Table_Name="AD_Color";

protected static KeyNamePair Model = new KeyNamePair(457,"AD_Color");

protected BigDecimal accessLevel = new BigDecimal(4);
/** AccessLevel
@return 4 - System 
*/
protected int get_AccessLevel()
{
return accessLevel.intValue();
}
/** Load Meta Data
@param ctx context
@return PO Info
*/
protected POInfo initPO (Ctx ctx)
{
POInfo poi = POInfo.getPOInfo (ctx, Table_ID);
return poi;
}
/** Info
@return info
*/
public String toString()
{
StringBuffer sb = new StringBuffer ("X_AD_Color[").append(get_ID()).append("]");
return sb.toString();
}
/** Set System Color.
@param AD_Color_ID Color for backgrounds or indicators */
public void setAD_Color_ID (int AD_Color_ID)
{
if (AD_Color_ID < 1) throw new IllegalArgumentException ("AD_Color_ID is mandatory.");
set_ValueNoCheck ("AD_Color_ID", new Integer(AD_Color_ID));
}
/** Get System Color.
@return Color for backgrounds or indicators */
public int getAD_Color_ID() 
{
Integer ii = (Integer)get_Value("AD_Color_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Image.
@param AD_Image_ID Image or Icon */
public void setAD_Image_ID (int AD_Image_ID)
{
if (AD_Image_ID <= 0) set_Value ("AD_Image_ID", null);
else
set_Value ("AD_Image_ID", new Integer(AD_Image_ID));
}
/** Get Image.
@return Image or Icon */
public int getAD_Image_ID() 
{
Integer ii = (Integer)get_Value("AD_Image_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Alpha.
@param Alpha Color Alpha value 0-255 */
public void setAlpha (int Alpha)
{
set_Value ("Alpha", new Integer(Alpha));
}
/** Get Alpha.
@return Color Alpha value 0-255 */
public int getAlpha() 
{
Integer ii = (Integer)get_Value("Alpha");
if (ii == null) return 0;
return ii.intValue();
}
/** Set 2nd Alpha.
@param Alpha_1 Alpha value for second color */
public void setAlpha_1 (int Alpha_1)
{
set_Value ("Alpha_1", new Integer(Alpha_1));
}
/** Get 2nd Alpha.
@return Alpha value for second color */
public int getAlpha_1() 
{
Integer ii = (Integer)get_Value("Alpha_1");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Blue.
@param Blue Color RGB blue value */
public void setBlue (int Blue)
{
set_Value ("Blue", new Integer(Blue));
}
/** Get Blue.
@return Color RGB blue value */
public int getBlue() 
{
Integer ii = (Integer)get_Value("Blue");
if (ii == null) return 0;
return ii.intValue();
}
/** Set 2nd Blue.
@param Blue_1 RGB value for second color */
public void setBlue_1 (int Blue_1)
{
set_Value ("Blue_1", new Integer(Blue_1));
}
/** Get 2nd Blue.
@return RGB value for second color */
public int getBlue_1() 
{
Integer ii = (Integer)get_Value("Blue_1");
if (ii == null) return 0;
return ii.intValue();
}

/** ColorType AD_Reference_ID=243 */
public static final int COLORTYPE_AD_Reference_ID=243;
/** Normal (Flat) = F */
public static final String COLORTYPE_NormalFlat = "F";
/** Gradient = G */
public static final String COLORTYPE_Gradient = "G";
/** Line = L */
public static final String COLORTYPE_Line = "L";
/** Texture (Picture) = T */
public static final String COLORTYPE_TexturePicture = "T";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isColorTypeValid (String test)
{
return test.equals("F") || test.equals("G") || test.equals("L") || test.equals("T");
}
/** Set Color Type.
@param ColorType Color presentation for this color */
public void setColorType (String ColorType)
{
if (ColorType == null) throw new IllegalArgumentException ("ColorType is mandatory");
if (!isColorTypeValid(ColorType))
throw new IllegalArgumentException ("ColorType Invalid value - " + ColorType + " - Reference_ID=243 - F - G - L - T");
if (ColorType.length() > 1)
{
log.warning("Length > 1 - truncated");
ColorType = ColorType.substring(0,1);
}
set_Value ("ColorType", ColorType);
}
/** Get Color Type.
@return Color presentation for this color */
public String getColorType() 
{
return (String)get_Value("ColorType");
}
/** Set Green.
@param Green RGB value  */
public void setGreen (int Green)
{
set_Value ("Green", new Integer(Green));
}
/** Get Green.
@return RGB value  */
public int getGreen() 
{
Integer ii = (Integer)get_Value("Green");
if (ii == null) return 0;
return ii.intValue();
}
/** Set 2nd Green.
@param Green_1 RGB value for second color */
public void setGreen_1 (int Green_1)
{
set_Value ("Green_1", new Integer(Green_1));
}
/** Get 2nd Green.
@return RGB value for second color */
public int getGreen_1() 
{
Integer ii = (Integer)get_Value("Green_1");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Image Alpha .
@param ImageAlpha Image Texture Composite Alpha */
public void setImageAlpha (BigDecimal ImageAlpha)
{
if (ImageAlpha == null) throw new IllegalArgumentException ("ImageAlpha is mandatory.");
set_Value ("ImageAlpha", ImageAlpha);
}
/** Get Image Alpha .
@return Image Texture Composite Alpha */
public BigDecimal getImageAlpha() 
{
BigDecimal bd = (BigDecimal)get_Value("ImageAlpha");
if (bd == null) return Env.ZERO;
return bd;
}
/** Set Default.
@param IsDefault Default value */
public void setIsDefault (boolean IsDefault)
{
set_Value ("IsDefault", new Boolean(IsDefault));
}
/** Get Default.
@return Default value */
public boolean isDefault() 
{
Object oo = get_Value("IsDefault");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Line Distance.
@param LineDistance Distance between lines */
public void setLineDistance (int LineDistance)
{
set_Value ("LineDistance", new Integer(LineDistance));
}
/** Get Line Distance.
@return Distance between lines */
public int getLineDistance() 
{
Integer ii = (Integer)get_Value("LineDistance");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Line Width.
@param LineWidth Width of the lines */
public void setLineWidth (int LineWidth)
{
set_Value ("LineWidth", new Integer(LineWidth));
}
/** Get Line Width.
@return Width of the lines */
public int getLineWidth() 
{
Integer ii = (Integer)get_Value("LineWidth");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Name.
@param Name Alphanumeric identifier of the entity */
public void setName (String Name)
{
if (Name == null) throw new IllegalArgumentException ("Name is mandatory.");
if (Name.length() > 60)
{
log.warning("Length > 60 - truncated");
Name = Name.substring(0,60);
}
set_Value ("Name", Name);
}
/** Get Name.
@return Alphanumeric identifier of the entity */
public String getName() 
{
return (String)get_Value("Name");
}
/** Get Record ID/ColumnName
@return ID/ColumnName pair */
public KeyNamePair getKeyNamePair() 
{
return new KeyNamePair(get_ID(), getName());
}
/** Set Red.
@param Red RGB value */
public void setRed (int Red)
{
set_Value ("Red", new Integer(Red));
}
/** Get Red.
@return RGB value */
public int getRed() 
{
Integer ii = (Integer)get_Value("Red");
if (ii == null) return 0;
return ii.intValue();
}
/** Set 2nd Red.
@param Red_1 RGB value for second color */
public void setRed_1 (int Red_1)
{
set_Value ("Red_1", new Integer(Red_1));
}
/** Get 2nd Red.
@return RGB value for second color */
public int getRed_1() 
{
Integer ii = (Integer)get_Value("Red_1");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Repeat Distance.
@param RepeatDistance Distance in points to repeat gradient color - or zero */
public void setRepeatDistance (int RepeatDistance)
{
set_Value ("RepeatDistance", new Integer(RepeatDistance));
}
/** Get Repeat Distance.
@return Distance in points to repeat gradient color - or zero */
public int getRepeatDistance() 
{
Integer ii = (Integer)get_Value("RepeatDistance");
if (ii == null) return 0;
return ii.intValue();
}

/** StartPoint AD_Reference_ID=248 */
public static final int STARTPOINT_AD_Reference_ID=248;
/** North = 1 */
public static final String STARTPOINT_North = "1";
/** North East = 2 */
public static final String STARTPOINT_NorthEast = "2";
/** East = 3 */
public static final String STARTPOINT_East = "3";
/** South East = 4 */
public static final String STARTPOINT_SouthEast = "4";
/** South = 5 */
public static final String STARTPOINT_South = "5";
/** South West = 6 */
public static final String STARTPOINT_SouthWest = "6";
/** West = 7 */
public static final String STARTPOINT_West = "7";
/** North West = 8 */
public static final String STARTPOINT_NorthWest = "8";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isStartPointValid (String test)
{
return test == null || test.equals("1") || test.equals("2") || test.equals("3") || test.equals("4") || test.equals("5") || test.equals("6") || test.equals("7") || test.equals("8");
}
/** Set Start Point.
@param StartPoint Start point of the gradient colors */
public void setStartPoint (String StartPoint)
{
if (!isStartPointValid(StartPoint))
throw new IllegalArgumentException ("StartPoint Invalid value - " + StartPoint + " - Reference_ID=248 - 1 - 2 - 3 - 4 - 5 - 6 - 7 - 8");
if (StartPoint != null && StartPoint.length() > 1)
{
log.warning("Length > 1 - truncated");
StartPoint = StartPoint.substring(0,1);
}
set_Value ("StartPoint", StartPoint);
}
/** Get Start Point.
@return Start point of the gradient colors */
public String getStartPoint() 
{
return (String)get_Value("StartPoint");
}
}
