/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.model;

/** Generated Model - DO NOT CHANGE */
import java.sql.*;
import java.math.*;
import org.compiere.framework.*;
import org.compiere.util.*;
/** Generated Model for C_BPartner_Location
 *  @author Jorg Janke (generated) 
 *  @version Release J3.0.0_A03 - $Id: X_C_BPartner_Location.java,v 1.5.2.1 2010/08/07 08:00:58 jrmt Exp $ */
public class X_C_BPartner_Location extends PO
{
/** Standard Constructor
@param ctx context
@param C_BPartner_Location_ID id
@param trxName transaction
*/
public X_C_BPartner_Location (Ctx ctx, int C_BPartner_Location_ID, String trxName)
{
super (ctx, C_BPartner_Location_ID, trxName);
/** if (C_BPartner_Location_ID == 0)
{
setC_BPartner_ID (0);
setC_BPartner_Location_ID (0);
setC_Location_ID (0);
setIsBillTo (true);	// Y
setIsPayFrom (true);	// Y
setIsRemitTo (true);	// Y
setIsShipTo (true);	// Y
setName (null);	// .
}
 */
}
/** Load Constructor 
@param ctx context
@param rs result set 
@param trxName transaction
*/
public X_C_BPartner_Location (Ctx ctx, ResultSet rs, String trxName)
{
super (ctx, rs, trxName);
}
/** Serial Version No */
static final long serialVersionUID = 27482612774789L;
/** Last Updated Timestamp 2008-01-16 21:44:18.0 */
public static final long updatedMS = 1200487458000L;
/** AD_Table_ID=293 */
public static final int Table_ID=293;

/** TableName=C_BPartner_Location */
public static final String Table_Name="C_BPartner_Location";

protected static KeyNamePair Model = new KeyNamePair(293,"C_BPartner_Location");

protected BigDecimal accessLevel = new BigDecimal(3);
/** AccessLevel
@return 3 - Client - Org 
*/
protected int get_AccessLevel()
{
return accessLevel.intValue();
}
/** Load Meta Data
@param ctx context
@return PO Info
*/
protected POInfo initPO (Ctx ctx)
{
POInfo poi = POInfo.getPOInfo (ctx, Table_ID);
return poi;
}
/** Info
@return info
*/
public String toString()
{
StringBuffer sb = new StringBuffer ("X_C_BPartner_Location[").append(get_ID()).append("]");
return sb.toString();
}
/** Set AddressKana.
@param AddressKana AddressKana */
public void setAddressKana (String AddressKana)
{
if (AddressKana != null && AddressKana.length() > 160)
{
log.warning("Length > 160 - truncated");
AddressKana = AddressKana.substring(0,160);
}
set_Value ("AddressKana", AddressKana);
}
/** Get AddressKana.
@return AddressKana */
public String getAddressKana() 
{
return (String)get_Value("AddressKana");
}
/** Set Business Partner .
@param C_BPartner_ID Identifies a Business Partner */
public void setC_BPartner_ID (int C_BPartner_ID)
{
if (C_BPartner_ID < 1) throw new IllegalArgumentException ("C_BPartner_ID is mandatory.");
set_ValueNoCheck ("C_BPartner_ID", new Integer(C_BPartner_ID));
}
/** Get Business Partner .
@return Identifies a Business Partner */
public int getC_BPartner_ID() 
{
Integer ii = (Integer)get_Value("C_BPartner_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Partner Location.
@param C_BPartner_Location_ID Identifies the (ship to) address for this Business Partner */
public void setC_BPartner_Location_ID (int C_BPartner_Location_ID)
{
if (C_BPartner_Location_ID < 1) throw new IllegalArgumentException ("C_BPartner_Location_ID is mandatory.");
set_ValueNoCheck ("C_BPartner_Location_ID", new Integer(C_BPartner_Location_ID));
}
/** Get Partner Location.
@return Identifies the (ship to) address for this Business Partner */
public int getC_BPartner_Location_ID() 
{
Integer ii = (Integer)get_Value("C_BPartner_Location_ID");
if (ii == null) return 0;
return ii.intValue();
}

/** C_LocationType AD_Reference_ID=1000000 */
public static final int C_LOCATIONTYPE_AD_Reference_ID=1000000;
/** Home = Home */
public static final String C_LOCATIONTYPE_Home = "Home";
/** Other = Other */
public static final String C_LOCATIONTYPE_Other = "Other";
/** Work = Work */
public static final String C_LOCATIONTYPE_Work = "Work";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isC_LocationTypeValid (String test)
{
return test == null || test.equals("Home") || test.equals("Other") || test.equals("Work");
}
/** Set C_LocationType.
@param C_LocationType C_LocationType */
public void setC_LocationType (String C_LocationType)
{
if (!isC_LocationTypeValid(C_LocationType))
throw new IllegalArgumentException ("C_LocationType Invalid value - " + C_LocationType + " - Reference_ID=1000000 - Home - Other - Work");
if (C_LocationType != null && C_LocationType.length() > 16)
{
log.warning("Length > 16 - truncated");
C_LocationType = C_LocationType.substring(0,16);
}
set_Value ("C_LocationType", C_LocationType);
}
/** Get C_LocationType.
@return C_LocationType */
public String getC_LocationType() 
{
return (String)get_Value("C_LocationType");
}
/** Set Address.
@param C_Location_ID Location or Address */
public void setC_Location_ID (int C_Location_ID)
{
if (C_Location_ID < 1) throw new IllegalArgumentException ("C_Location_ID is mandatory.");
set_Value ("C_Location_ID", new Integer(C_Location_ID));
}
/** Get Address.
@return Location or Address */
public int getC_Location_ID() 
{
Integer ii = (Integer)get_Value("C_Location_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Sales Region.
@param C_SalesRegion_ID Sales coverage region */
public void setC_SalesRegion_ID (int C_SalesRegion_ID)
{
if (C_SalesRegion_ID <= 0) set_Value ("C_SalesRegion_ID", null);
else
set_Value ("C_SalesRegion_ID", new Integer(C_SalesRegion_ID));
}
/** Get Sales Region.
@return Sales coverage region */
public int getC_SalesRegion_ID() 
{
Integer ii = (Integer)get_Value("C_SalesRegion_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Fax.
@param Fax Facsimile number */
public void setFax (String Fax)
{
if (Fax != null && Fax.length() > 40)
{
log.warning("Length > 40 - truncated");
Fax = Fax.substring(0,40);
}
set_Value ("Fax", Fax);
}
/** Get Fax.
@return Facsimile number */
public String getFax() 
{
return (String)get_Value("Fax");
}
/** Set ISDN.
@param ISDN ISDN or modem line */
public void setISDN (String ISDN)
{
if (ISDN != null && ISDN.length() > 40)
{
log.warning("Length > 40 - truncated");
ISDN = ISDN.substring(0,40);
}
set_Value ("ISDN", ISDN);
}
/** Get ISDN.
@return ISDN or modem line */
public String getISDN() 
{
return (String)get_Value("ISDN");
}
/** Set Invoice Address.
@param IsBillTo Business Partner Invoice/Bill Address */
public void setIsBillTo (boolean IsBillTo)
{
set_Value ("IsBillTo", new Boolean(IsBillTo));
}
/** Get Invoice Address.
@return Business Partner Invoice/Bill Address */
public boolean isBillTo() 
{
Object oo = get_Value("IsBillTo");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Pay-From Address.
@param IsPayFrom Business Partner pays from that address and we'll send dunning letters there */
public void setIsPayFrom (boolean IsPayFrom)
{
set_Value ("IsPayFrom", new Boolean(IsPayFrom));
}
/** Get Pay-From Address.
@return Business Partner pays from that address and we'll send dunning letters there */
public boolean isPayFrom() 
{
Object oo = get_Value("IsPayFrom");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Remit-To Address.
@param IsRemitTo Business Partner payment address */
public void setIsRemitTo (boolean IsRemitTo)
{
set_Value ("IsRemitTo", new Boolean(IsRemitTo));
}
/** Get Remit-To Address.
@return Business Partner payment address */
public boolean isRemitTo() 
{
Object oo = get_Value("IsRemitTo");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Ship Address.
@param IsShipTo Business Partner Shipment Address */
public void setIsShipTo (boolean IsShipTo)
{
set_Value ("IsShipTo", new Boolean(IsShipTo));
}
/** Get Ship Address.
@return Business Partner Shipment Address */
public boolean isShipTo() 
{
Object oo = get_Value("IsShipTo");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Name.
@param Name Alphanumeric identifier of the entity */
public void setName (String Name)
{
if (Name == null) throw new IllegalArgumentException ("Name is mandatory.");
if (Name.length() > 60)
{
log.warning("Length > 60 - truncated");
Name = Name.substring(0,60);
}
set_Value ("Name", Name);
}
/** Get Name.
@return Alphanumeric identifier of the entity */
public String getName() 
{
return (String)get_Value("Name");
}
/** Get Record ID/ColumnName
@return ID/ColumnName pair */
public KeyNamePair getKeyNamePair() 
{
return new KeyNamePair(get_ID(), getName());
}
/** Set Phone.
@param Phone Identifies a telephone number */
public void setPhone (String Phone)
{
if (Phone != null && Phone.length() > 40)
{
log.warning("Length > 40 - truncated");
Phone = Phone.substring(0,40);
}
set_Value ("Phone", Phone);
}
/** Get Phone.
@return Identifies a telephone number */
public String getPhone() 
{
return (String)get_Value("Phone");
}
/** Set 2nd Phone.
@param Phone2 Identifies an alternate telephone number. */
public void setPhone2 (String Phone2)
{
if (Phone2 != null && Phone2.length() > 40)
{
log.warning("Length > 40 - truncated");
Phone2 = Phone2.substring(0,40);
}
set_Value ("Phone2", Phone2);
}
/** Get 2nd Phone.
@return Identifies an alternate telephone number. */
public String getPhone2() 
{
return (String)get_Value("Phone2");
}
}
