/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.model;

/** Generated Model - DO NOT CHANGE */
import java.sql.*;
import java.math.*;
import org.compiere.framework.*;
import org.compiere.util.*;
/** Generated Model for C_ProjectType
 *  @author Jorg Janke (generated) 
 *  @version Release J3.0.0_A03 - $Id: X_C_ProjectType.java,v 1.5.2.1 2010/08/07 08:01:17 jrmt Exp $ */
public class X_C_ProjectType extends PO
{
/** Standard Constructor
@param ctx context
@param C_ProjectType_ID id
@param trxName transaction
*/
public X_C_ProjectType (Ctx ctx, int C_ProjectType_ID, String trxName)
{
super (ctx, C_ProjectType_ID, trxName);
/** if (C_ProjectType_ID == 0)
{
setC_ProjectType_ID (0);
setName (null);
setProjectCategory (null);	// N
}
 */
}
/** Load Constructor 
@param ctx context
@param rs result set 
@param trxName transaction
*/
public X_C_ProjectType (Ctx ctx, ResultSet rs, String trxName)
{
super (ctx, rs, trxName);
}
/** Serial Version No */
static final long serialVersionUID = 27228925316789L;
/** Last Updated Timestamp 2000-01-02 17:00:00.0 */
public static final long updatedMS = 946800000000L;
/** AD_Table_ID=575 */
public static final int Table_ID=575;

/** TableName=C_ProjectType */
public static final String Table_Name="C_ProjectType";

protected static KeyNamePair Model = new KeyNamePair(575,"C_ProjectType");

protected BigDecimal accessLevel = new BigDecimal(3);
/** AccessLevel
@return 3 - Client - Org 
*/
protected int get_AccessLevel()
{
return accessLevel.intValue();
}
/** Load Meta Data
@param ctx context
@return PO Info
*/
protected POInfo initPO (Ctx ctx)
{
POInfo poi = POInfo.getPOInfo (ctx, Table_ID);
return poi;
}
/** Info
@return info
*/
public String toString()
{
StringBuffer sb = new StringBuffer ("X_C_ProjectType[").append(get_ID()).append("]");
return sb.toString();
}
/** Set Project Type.
@param C_ProjectType_ID Type of the project */
public void setC_ProjectType_ID (int C_ProjectType_ID)
{
if (C_ProjectType_ID < 1) throw new IllegalArgumentException ("C_ProjectType_ID is mandatory.");
set_ValueNoCheck ("C_ProjectType_ID", new Integer(C_ProjectType_ID));
}
/** Get Project Type.
@return Type of the project */
public int getC_ProjectType_ID() 
{
Integer ii = (Integer)get_Value("C_ProjectType_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Description.
@param Description Optional short description of the record */
public void setDescription (String Description)
{
if (Description != null && Description.length() > 255)
{
log.warning("Length > 255 - truncated");
Description = Description.substring(0,255);
}
set_Value ("Description", Description);
}
/** Get Description.
@return Optional short description of the record */
public String getDescription() 
{
return (String)get_Value("Description");
}
/** Set Comment.
@param Help Comment, Help or Hint */
public void setHelp (String Help)
{
if (Help != null && Help.length() > 2000)
{
log.warning("Length > 2000 - truncated");
Help = Help.substring(0,2000);
}
set_Value ("Help", Help);
}
/** Get Comment.
@return Comment, Help or Hint */
public String getHelp() 
{
return (String)get_Value("Help");
}
/** Set Name.
@param Name Alphanumeric identifier of the entity */
public void setName (String Name)
{
if (Name == null) throw new IllegalArgumentException ("Name is mandatory.");
if (Name.length() > 60)
{
log.warning("Length > 60 - truncated");
Name = Name.substring(0,60);
}
set_Value ("Name", Name);
}
/** Get Name.
@return Alphanumeric identifier of the entity */
public String getName() 
{
return (String)get_Value("Name");
}
/** Get Record ID/ColumnName
@return ID/ColumnName pair */
public KeyNamePair getKeyNamePair() 
{
return new KeyNamePair(get_ID(), getName());
}

/** ProjectCategory AD_Reference_ID=288 */
public static final int PROJECTCATEGORY_AD_Reference_ID=288;
/** Asset Project = A */
public static final String PROJECTCATEGORY_AssetProject = "A";
/** General = N */
public static final String PROJECTCATEGORY_General = "N";
/** Service (Charge) Project = S */
public static final String PROJECTCATEGORY_ServiceChargeProject = "S";
/** Work Order (Job) = W */
public static final String PROJECTCATEGORY_WorkOrderJob = "W";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isProjectCategoryValid (String test)
{
return test.equals("A") || test.equals("N") || test.equals("S") || test.equals("W");
}
/** Set Project Category.
@param ProjectCategory Project Category */
public void setProjectCategory (String ProjectCategory)
{
if (ProjectCategory == null) throw new IllegalArgumentException ("ProjectCategory is mandatory");
if (!isProjectCategoryValid(ProjectCategory))
throw new IllegalArgumentException ("ProjectCategory Invalid value - " + ProjectCategory + " - Reference_ID=288 - A - N - S - W");
if (ProjectCategory.length() > 1)
{
log.warning("Length > 1 - truncated");
ProjectCategory = ProjectCategory.substring(0,1);
}
set_ValueNoCheck ("ProjectCategory", ProjectCategory);
}
/** Get Project Category.
@return Project Category */
public String getProjectCategory() 
{
return (String)get_Value("ProjectCategory");
}
}
