/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.model;

import java.math.*;
import java.sql.*;
import java.util.logging.*;
import org.compiere.util.*;


/**
 *	Bank Statement Callout	
 *	
 *  @author Jorg Janke
 *  @version $Id: CalloutBankStatement.java,v 1.2 2010/04/09 09:16:36 jrmt Exp $
 *  @deprecated
 */
public class CalloutBankStatement extends CalloutEngine
{
	/**
	 * 	Bank Account Changed.
	 * 	Update Beginning Balance
	 *	@param ctx context
	 *	@param WindowNo window no
	 *	@param mTab tab
	 *	@param mField field
	 *	@param value value
	 *	@return null or error message
	 */
	public String bankAccount (Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value)
	{
		if (value == null)
			return "";
		int C_BankAccount_ID = ((Integer)value).intValue();
		MBankAccount ba = MBankAccount.get(ctx, C_BankAccount_ID);
		mTab.setValue("BeginningBalance", ba.getCurrentBalance());
		return "";
	}	//	bankAccount
	
	/**
	 *	BankStmt - Amount.
	 *  Calculate ChargeAmt = StmtAmt - TrxAmt - InterestAmt
	 *    or id Charge is entered - InterestAmt = StmtAmt - TrxAmt - ChargeAmt
	 *	@param ctx context
	 *	@param WindowNo window no
	 *	@param mTab tab
	 *	@param mField field
	 *	@param value value
	 *	@return null or error message
	 */
	public String amount (Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value)
	{
		if (isCalloutActive())
			return "";
		setCalloutActive(true);

		//  Get Stmt & Trx
		BigDecimal stmt = (BigDecimal)mTab.getValue("StmtAmt");
		if (stmt == null)
			stmt = Env.ZERO;
		BigDecimal trx = (BigDecimal)mTab.getValue("TrxAmt");
		if (trx == null)
			trx = Env.ZERO;
		BigDecimal bd = stmt.subtract(trx);

		//  Charge - calculate Interest
		// if (mField.getColumnName().equals("ChargeAmt"))
		// {
		//	BigDecimal charge = (BigDecimal)mTab.getValue("ChargeAmt");
		//	if (charge == null)
		//		charge = Env.ZERO;
		//	bd = bd.subtract(charge);
		//	log.trace(log.l5_DData, "Interest (" + bd + ") = Stmt(" + stmt + ") - Trx(" + trx + ") - Charge(" + charge + ")");
		//	mTab.setValue("InterestAmt", bd);
		// }
		//  Calculate Charge
		// else
		// {
		// 	BigDecimal interest = (BigDecimal)mTab.getValue("InterestAmt");
		// 	if (interest == null)
		//		interest = Env.ZERO;
		//	bd = bd.subtract(interest);
		//	log.trace(log.l5_DData, "Charge (" + bd + ") = Stmt(" + stmt + ") - Trx(" + trx + ") - Interest(" + interest + ")");
		//	mTab.setValue("ChargeAmt", bd);
		// }
			
		// Jirimuto modified --start 2010/04/08
		//  Others - calculate Interest Amt
		if (!mField.getColumnName().equals("InterestAmt"))
		{
			BigDecimal charge = (BigDecimal)mTab.getValue("ChargeAmt");
			if (charge == null)
				charge = Env.ZERO;
			bd = bd.subtract(charge);
			// log.trace(log.l5_DData, "Interest (" + bd + ") = Stmt(" + stmt + ") - Trx(" + trx + ") - Charge(" + charge + ")");
			mTab.setValue("InterestAmt", bd);
		}
		//  Calculate Trx
		else
		{
			Integer C_Payment_ID = (Integer)mTab.getValue("C_Payment_ID");
			if( C_Payment_ID==null || C_Payment_ID.intValue() == 0 ){
				BigDecimal interest = (BigDecimal)mTab.getValue("InterestAmt");
			 	if (interest == null)
					interest = Env.ZERO;
				bd = stmt.subtract(interest);
				BigDecimal charge = (BigDecimal)mTab.getValue("ChargeAmt");
				if (charge == null)
					charge = Env.ZERO;
				bd = bd.subtract(charge);
				// log.trace(log.l5_DData, "Charge (" + bd + ") = Stmt(" + stmt + ") - Trx(" + trx + ") - Interest(" + interest + ")");
				mTab.setValue("TrxAmt", bd);
				
			} else {
				
				BigDecimal interest = (BigDecimal)mTab.getValue("InterestAmt");
			 	if (interest == null)
					interest = Env.ZERO;
				bd = trx.add(interest);
				BigDecimal charge = (BigDecimal)mTab.getValue("ChargeAmt");
				if (charge == null)
					charge = Env.ZERO;
				bd = bd.add(charge);
				// log.trace(log.l5_DData, "Charge (" + bd + ") = Stmt(" + stmt + ") - Trx(" + trx + ") - Interest(" + interest + ")");
				mTab.setValue("StmtAmt", bd);
			}				
		}
		
		setCalloutActive(false);
		return "";
	}   //  amount


	/**
	 *	BankStmt - Payment.
	 *  Update Transaction Amount when payment is selected
	 *	@param ctx context
	 *	@param WindowNo window no
	 *	@param mTab tab
	 *	@param mField field
	 *	@param value value
	 *	@return null or error message
	 */
	public String payment (Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value)
	{
		Integer C_Payment_ID = (Integer)value;
		if (C_Payment_ID == null || C_Payment_ID.intValue() == 0)
			return "";
		//
		BigDecimal stmt = (BigDecimal)mTab.getValue("StmtAmt");
		if (stmt == null)
			stmt = Env.ZERO;

		String sql = "SELECT PayAmt, DateTrx FROM C_Payment_v WHERE C_Payment_ID=?";		//	1
		try
		{
			PreparedStatement pstmt = DB.prepareStatement(sql, null);
			pstmt.setInt(1, C_Payment_ID.intValue());
			ResultSet rs = pstmt.executeQuery();
			if (rs.next())
			{
				BigDecimal bd = rs.getBigDecimal(1);
				mTab.setValue("TrxAmt", bd);
				if (stmt.compareTo(Env.ZERO) == 0)
					mTab.setValue("StmtAmt", bd);
				// Jirimuto added for adding Acct date --start 2010/04/08
				Timestamp dateTrx = rs.getTimestamp(2);
				mTab.setValue("StatementLineDate", dateTrx);
				// Jirimuto added for adding Acct date --end 2010/04/08
			}
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			log.log(Level.SEVERE, "BankStmt_Payment", e);
			return e.getLocalizedMessage();
		}
		//  Recalculate Amounts
		amount (ctx, WindowNo, mTab, mField, value);
		return "";
	}	//	payment

	/**
	 * @param ctx
	 * @param WindowNo
	 * @param mTab
	 * @param mField
	 * @param value
	 * @return
	 */
	public String charge (Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value)
	{
		Integer C_Charge_ID = (Integer)value;
		if (C_Charge_ID == null || C_Charge_ID.intValue() == 0)
			return "";
		setCalloutActive(true);
		
		String sql = "SELECT IsTaxIncluded, ChargeAmt FROM C_Charge "
			+ "WHERE C_Charge_ID=? AND IsActive='Y' ";

		try
		{
			PreparedStatement pstmt = DB.prepareStatement(sql, null);
			pstmt.setInt(1, C_Charge_ID.intValue());
			ResultSet rs = pstmt.executeQuery();
			if (rs.next())
			{	
				BigDecimal chargeAmt = rs.getBigDecimal("ChargeAmt");
				if( chargeAmt != null && chargeAmt.floatValue()!=0.0f)
					mTab.setValue("ChargeAmt", chargeAmt);
				
				mTab.setValue("IsTaxIncluded", new Boolean("Y".equals(rs.getString("IsTaxIncluded"))));
			}
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			log.log(Level.SEVERE, sql, e);
			setCalloutActive(false);
			return e.getLocalizedMessage();
		}
		setCalloutActive(false);
		
		return tax(ctx, WindowNo, mTab, mField, value);
		
	}	//	charge
	
	/**
	 * @param ctx
	 * @param WindowNo
	 * @param mTab
	 * @param mField
	 * @param value
	 * @return
	 */
	public String tax (Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value)
	{
		Integer C_Tax_ID = (Integer)mTab.getValue("C_Tax_ID");
		if( C_Tax_ID==null || C_Tax_ID == 0 )
			return "";
		
		setCalloutActive(true);

		MTax tax = MTax.get(ctx, C_Tax_ID);
		int C_Currency_ID = ctx.getContextAsInt( WindowNo, "C_Currency_ID");
		if( C_Currency_ID == 0 ){
			MClient client = MClient.get(ctx);
			C_Currency_ID = client.getC_Currency_ID();
		}
		int scale = MCurrency.getStdPrecision(ctx, C_Currency_ID);
		BigDecimal chargeAmt = (BigDecimal)mTab.getValue("ChargeAmt");
		if( chargeAmt == null )
			chargeAmt = BigDecimal.ZERO;
		
		boolean isTaxIncluded = true;
		Object obj = mTab.getValue("IsTaxIncluded");
		// if( obj instanceof String)
		//	isTaxIncluded = "Y".equals((String)obj);
		// else if( obj instanceof Boolean)
			isTaxIncluded = ((Boolean)obj).booleanValue();
		
		BigDecimal taxAmt = BigDecimal.ZERO;
		Integer C_BPartner_ID = (Integer)mTab.getValue("C_BPartner_ID");
		if( C_BPartner_ID!=null && C_BPartner_ID!=0 ) {
			MBPartner bpartner = MBPartner.get(ctx, C_BPartner_ID);		
			taxAmt = tax.calculateTax(chargeAmt, isTaxIncluded, scale, bpartner.getTaxRoundModeAsInt());
		} else {
			taxAmt = tax.calculateTax(chargeAmt, isTaxIncluded, scale, BigDecimal.ROUND_HALF_UP);
		}
		mTab.setValue("TaxAmt", taxAmt);
		if( !isTaxIncluded ){
			BigDecimal totalAmt = chargeAmt.add( taxAmt );
			mTab.setValue("TotalAmt", totalAmt);
		} else {
			mTab.setValue("TotalAmt", chargeAmt);
		}
		setCalloutActive(false);
		
		return "";
		
	}	// tax
	
}	//	CalloutBankStatement
