/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.model;

import java.math.*;
import java.sql.*;
import java.util.logging.*;

import org.compiere.util.*;


/**
 *	Shipment/Receipt Callouts	
 *	
 *  @author Jorg Janke
 *  @version $Id: CalloutInOut.java,v 1.4 2010/05/05 12:23:05 jrmt Exp $
 *  @deprecated
 */
public class CalloutInOut extends CalloutEngine
{
	/**	Debug Steps			*/
	private boolean steps = false;
	
	/**
	 * 	C_Order - Order Defaults.
	 *	@param ctx
	 *	@param WindowNo
	 *	@param mTab
	 *	@param mField
	 *	@param value
	 *	@return error message or ""
	 */
	public String order (Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value)
	{
		Integer C_Order_ID = (Integer)value;
		if (C_Order_ID == null || C_Order_ID.intValue() == 0)
			return "";
		//	No Callout Active to fire dependent values
		if (isCalloutActive())	//	prevent recursive
			return "";
		
		setCalloutActive(true);

		MOrder order = new MOrder (ctx, C_Order_ID.intValue(), null);
		
		if (order.get_ID() != 0)
		{
			MDocType docType = new MDocType(ctx, order.getC_DocType_ID(), null);
			if( docType != null )
				mTab.setValue("C_DocType_ID", docType.getC_DocTypeShipment_ID());
			mTab.setValue("DateOrdered", order.getDateOrdered());
			mTab.setValue("POReference", order.getPOReference());
			mTab.setValue("AD_Org_ID", new Integer(order.getAD_Org_ID()));
			//
			mTab.setValue("DeliveryRule", order.getDeliveryRule());
			mTab.setValue("DeliveryViaRule", order.getDeliveryViaRule());
			if( order.getM_Shipper_ID() !=0 )
				mTab.setValue("M_Shipper_ID", new Integer(order.getM_Shipper_ID()));
			mTab.setValue("FreightCostRule", order.getFreightCostRule());
			mTab.setValue("FreightAmt", order.getFreightAmt());

			mTab.setValue("C_BPartner_ID", new Integer(order.getC_BPartner_ID()));
			//sraval: source forge bug # 1503219 - added to default ship to location
			mTab.setValue("C_BPartner_Location_ID", new Integer(order.getC_BPartner_Location_ID()));
			
			if( order.getAD_OrgTrx_ID() !=0 )
				mTab.setValue("AD_OrgTrx_ID", new Integer(order.getAD_OrgTrx_ID()));
			if( order.getC_Activity_ID() !=0 )
				mTab.setValue("C_Activity_ID", new Integer(order.getC_Activity_ID()));
			if( order.getC_Campaign_ID() !=0 )
				mTab.setValue("C_Campaign_ID", new Integer(order.getC_Campaign_ID()));
			if( order.getC_Campaign_ID() !=0 )
				mTab.setValue("C_Project_ID", new Integer(order.getC_Project_ID()));
			if( order.getUser1_ID() !=0 )
				mTab.setValue("User1_ID", new Integer(order.getUser1_ID()));
			if( order.getUser2_ID() !=0 )
				mTab.setValue("User2_ID", new Integer(order.getUser2_ID()));
			if( order.getM_Warehouse_ID() !=0 )
				mTab.setValue("M_Warehouse_ID", new Integer(order.getM_Warehouse_ID()));

			
			// Jirimuto added 2010/03/18 start
			mTab.setValue("DeliveryRule", order.getDeliveryRule());
			mTab.setValue("DeliveryViaRule", order.getDeliveryViaRule());
			
			mTab.setValue("FreightCostRule", order.getFreightCostRule());
			mTab.setValue("FreightAmt", order.getFreightAmt());
			
			mTab.setValue("M_PriceList_ID", new Integer(order.getM_PriceList_ID()));
			mTab.setValue("C_Currency_ID", new Integer(order.getC_Currency_ID()));
			mTab.setValue("IsTaxIncluded", new Boolean(order.isTaxIncluded()));

			mTab.setValue("IsDropShip", order.isDropShip());
			mTab.setValue("DeliveryTo_ID", order.getDeliveryTo_ID());
			mTab.setValue("DeliveryToLoc_ID", order.getDeliveryToLoc_ID());
			mTab.setValue("DeliverTo", order.getDeliverTo());
			mTab.setValue("DeliverToPostal", order.getDeliverToPostal());
			mTab.setValue("DeliverToAddress", order.getDeliverToAddress());
			mTab.setValue("DeliverToPhone", order.getDeliverToPhone());
			mTab.setValue("DeliverToFax", order.getDeliverToFax());
			mTab.setValue("Description", order.getDescription());
			if (order.getDatePromised() != null )
			{
				// if DatePromised is not null...
				mTab.setValue("DateArrival", order.getDatePromised());				
			}

			// Jirimuto added 2010/03/18 end

			boolean isReturnTrx = (Boolean)mTab.getValue("IsReturnTrx");
			if(isReturnTrx)
			{
				mTab.setValue("Orig_Order_ID", order.getOrig_Order_ID());
				mTab.setValue("Orig_InOut_ID", order.getOrig_InOut_ID());
			}
		}
		
		setCalloutActive(false);
		
		Integer C_DocType_ID = (Integer)mTab.getValue("C_DocType_ID");
		
		return docType (ctx, WindowNo, mTab, mField, C_DocType_ID);
	}	//	order
	
	/**
	 *	InOut - DocType.
	 *			- sets MovementType
	 *			- gets DocNo
	 *	@param ctx
	 *	@param WindowNo
	 *	@param mTab
	 *	@param mField
	 *	@param value
	 *	@return error message or ""
	 */
	public String docType (Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value)
	{
		Integer C_DocType_ID = (Integer)value;
		if (C_DocType_ID == null || C_DocType_ID.intValue() == 0)
			return "";
		
		if (isCalloutActive())	//	prevent recursive
			return "";
		
		setCalloutActive(true);

		String sql = "SELECT d.DocBaseType, d.IsDocNoControlled, s.CurrentNext, d.IsReturnTrx "
			+ "FROM C_DocType d, AD_Sequence s "
			+ "WHERE C_DocType_ID=?"		//	1
			+ " AND d.DocNoSequence_ID=s.AD_Sequence_ID(+)";
		try
		{
			ctx.setContext( WindowNo, "C_DocTypeTarget_ID", C_DocType_ID.intValue());
			PreparedStatement pstmt = DB.prepareStatement(sql, null);
			pstmt.setInt(1, C_DocType_ID.intValue());
			ResultSet rs = pstmt.executeQuery();
			if (rs.next())
			{
				//	Set Movement Type
				String DocBaseType = rs.getString("DocBaseType");
				Boolean isReturnTrx = rs.getString("IsReturnTrx").equals("Y");
				if (DocBaseType.equals("MMS") && !isReturnTrx)					//	Material Shipments
					mTab.setValue("MovementType", "C-");				//	Customer Shipments
				else if (DocBaseType.equals("MMS") && isReturnTrx)				//	Material Shipments
					mTab.setValue("MovementType", "C+");				//	Customer Returns
				else if (DocBaseType.equals("MMR") && !isReturnTrx)				//	Material Receipts
					mTab.setValue("MovementType", "V+");				//	Vendor Receipts
				else if (DocBaseType.equals("MMR") && isReturnTrx)				//	Material Receipts
				mTab.setValue("MovementType", "V-");					//	Return to Vendor

				//	DocumentNo
				if (rs.getString("IsDocNoControlled").equals("Y"))
					mTab.setValue("DocumentNo", "<" + rs.getString("CurrentNext") + ">");
			}
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			log.log(Level.SEVERE, sql, e);
			setCalloutActive(false);
			return e.getLocalizedMessage();
		}
		setCalloutActive(false);
		
		return "";
	}	//	docType

	/**
	 *	M_InOut - Defaults for BPartner.
	 *			- Location
	 *			- Contact
	 *	@param ctx
	 *	@param WindowNo
	 *	@param mTab
	 *	@param mField
	 *	@param value
	 *	@return error message or ""
	 */
	public String bpartner (Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value)
	{
		Integer C_BPartner_ID = (Integer)value;
		if (C_BPartner_ID == null || C_BPartner_ID.intValue() == 0)
			return "";
		
		if (isCalloutActive())	//	prevent recursive
			return "";
		
		setCalloutActive(true);
		
		boolean isReturnTrx = (Boolean)mTab.getValue("IsReturnTrx");
		
		//	sraval: source forge bug # 1503219
		Integer order = (Integer)mTab.getValue("C_Order_ID");
		
		String sql = "SELECT p.Name,p.AD_Language, p.POReference,"
			+ "p.M_PriceList_ID,p.PO_PriceList_ID,p.PaymentRule,p.POReference,"
			+ "p.SO_Description,p.IsDiscountPrinted,"
			+ "SO_CreditLimit, p.SO_CreditLimit-p.SO_CreditUsed AS CreditAvailable,"
			+ "l.C_BPartner_Location_ID, l.Phone, l.Fax, l.C_Location_ID, c.AD_User_ID "
			+ "FROM C_BPartner p"
			+ " LEFT OUTER JOIN C_BPartner_Location l ON (p.C_BPartner_ID=l.C_BPartner_ID)"
			+ " LEFT OUTER JOIN AD_User c ON (p.C_BPartner_ID=c.C_BPartner_ID) "
			+ "WHERE p.C_BPartner_ID=?";		//	1

		boolean IsSOTrx = ctx.isSOTrx(WindowNo);
		boolean IsDropShip = "Y".equals(ctx.getContext(WindowNo, "IsDropShip"));
		
		try
		{
			PreparedStatement pstmt = DB.prepareStatement(sql, null);
			pstmt.setInt(1, C_BPartner_ID.intValue());
			ResultSet rs = pstmt.executeQuery();

			if (rs.next())
			{
				//	Location
				Integer ii = new Integer(rs.getInt("C_BPartner_Location_ID"));
				// sraval: source forge bug # 1503219 - default location for material receipt
				if (order == null){
					if (rs.wasNull())
						mTab.setValue("C_BPartner_Location_ID", null);
					else
						mTab.setValue("C_BPartner_Location_ID", ii);
				}
				
				//	Jirimuto added. --start 2010/03/18
				Integer priceList = new Integer(rs.getInt(IsSOTrx ? "M_PriceList_ID" : "PO_PriceList_ID"));
				if (!rs.wasNull())
					mTab.setValue("M_PriceList_ID", priceList);
				else
				{	//	get default PriceList
					int i = ctx.getContextAsInt("#M_PriceList_ID");
					if (i != 0)
						mTab.setValue("M_PriceList_ID", new Integer(i));
				}
				mTab.setValue("Deliveryto_ID", C_BPartner_ID);
				if (ii == 0)
					mTab.setValue("DeliveryToLoc_ID", null);
				else
					mTab.setValue("DeliveryToLoc_ID", new Integer(ii));
				
				
				if( IsSOTrx && !IsDropShip ) {
					String name = rs.getString("Name");
					mTab.setValue("DeliverTo", name);
					
					int C_Location_ID = rs.getInt("C_Location_ID");
					String phone = rs.getString("Phone");
					String fax = rs.getString("Phone");
					MLocation location = new MLocation(ctx, C_Location_ID, null);
					String postal = location.getPostalConcated();
					String address = location.getAddressConcated();
					
					mTab.setValue("DeliverToPostal", postal);
					mTab.setValue("DeliverToAddress", address);
					mTab.setValue("DeliverToPhone", phone);
					mTab.setValue("DeliverToFax", fax);
				}
				//	Jirimuto added. --end 2010/03/18
				
				//	Contact
				ii = new Integer(rs.getInt("AD_User_ID"));
				if (rs.wasNull())
					mTab.setValue("AD_User_ID", null);
				else
					mTab.setValue("AD_User_ID", ii);

				// Skip credit check for returns
				if(!isReturnTrx)
				{
					//	CreditAvailable
					double CreditAvailable = rs.getDouble("CreditAvailable");
					if (!rs.wasNull() && CreditAvailable < 0)
						mTab.fireDataStatusEEvent("CreditLimitOver",
								DisplayType.getNumberFormat(DisplayType.Amount).format(CreditAvailable),
								false);
				}
			}
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			log.log(Level.SEVERE, sql, e);
			setCalloutActive(false);
			return e.getLocalizedMessage();
		}
		
		setCalloutActive(false);

		return "";
	}	//	bpartner

	/**
	 *	M_InOut - BPartner Location.
	 *  @param ctx      Context
	 *  @param WindowNo current Window No
	 *  @param mTab     Model Tab
	 *  @param mField   Model Field
	 *  @param value    The new value
	 *  @return Error message or ""
	 */
	// Jirimuto added 2010/03/18
	public String bPartnerLocation (Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value)
	{
		if (isCalloutActive())
			return "";		
		
		Integer C_BPartner_Location_ID = (Integer)value;
		if (C_BPartner_Location_ID == null || C_BPartner_Location_ID.intValue() == 0)
			return "";
		setCalloutActive(true);

		mTab.setValue("DeliverToLoc_ID", C_BPartner_Location_ID);
		
		boolean IsSOTrx = ctx.isSOTrx(WindowNo);
		boolean IsDropShip = "Y".equals(ctx.getContext(WindowNo, "IsDropShip"));
		
		if( IsSOTrx && !IsDropShip ){
			String sql = "SELECT C_Location_ID, Phone, Fax "
				+ " FROM C_BPartner_Location "
				+ "WHERE C_BPartner_Location_ID=? ";		//	#1
			
			try
			{
				PreparedStatement pstmt = DB.prepareStatement(sql, null);
				pstmt.setInt(1, C_BPartner_Location_ID.intValue());
				ResultSet rs = pstmt.executeQuery();
				if (rs.next())
				{
					//	Get Address Info
					int C_Location_ID = rs.getInt("C_Location_ID");
					String phone = rs.getString("Phone");
					String fax = rs.getString("Fax");
					MLocation location = new MLocation(ctx, C_Location_ID, null);
					String postal = location.getPostalConcated();
					String address = location.getAddressConcated();
					
					mTab.setValue("DeliverToPostal", postal);
					mTab.setValue("DeliverToAddress", address);
					mTab.setValue("DeliverToPhone", phone);
					mTab.setValue("DeliverToFax", fax);
				}
				rs.close();
				pstmt.close();
			}
			catch (SQLException e)
			{
				log.log(Level.SEVERE, sql, e);
				setCalloutActive(false);
				return e.getLocalizedMessage();
			}
		}
		setCalloutActive(false);
		return "";
	}	//	bPartnerLocation
	
	/**
	 * Order Header - BPartner. - DeliverTo
	 * 
	 * @param ctx Context
	 * @param WindowNo current Window No
	 * @param mTab Model Tab
	 * @param mField Model Field
	 * @param value The new value
	 * @return Error message or ""
	 */
	// Jirimuto added 2010/03/18
	public String bPartnerDeliverTo(Ctx ctx, int WindowNo, GridTab mTab,
			GridField mField, Object value) {
		
		if (isCalloutActive())
			return "";
		
		Integer C_BPartner_ID = (Integer) value;
		if (C_BPartner_ID == null || C_BPartner_ID.intValue() == 0)
			return "";
			
		setCalloutActive(true);

		String sql = "SELECT p.Name, "
				+ " lship.C_Location_ID, lship.Phone, lship.Fax, lship.C_BPartner_Location_ID "
				+ "FROM C_BPartner p"
				+ " LEFT OUTER JOIN C_BPartner_Location lship ON (p.C_BPartner_ID=lship.C_BPartner_ID AND lship.IsShipTo='Y' AND lship.IsActive='Y')"
				+ "WHERE p.C_BPartner_ID=? AND p.IsActive='Y'";
		
		boolean IsSOTrx = ctx.isSOTrx(WindowNo);
		boolean IsDropShip = "Y".equals(ctx.getContext(WindowNo, "IsDropShip"));

		try {
			PreparedStatement pstmt = DB.prepareStatement(sql, null);
			pstmt.setInt(1, C_BPartner_ID.intValue());
			ResultSet rs = pstmt.executeQuery();
			if (rs.next()) {
				int shipTo_ID = rs.getInt("C_BPartner_Location_ID");
				if (shipTo_ID == 0)
					mTab.setValue("DeliveryToLoc_ID", null);
				else
					mTab.setValue("DeliveryToLoc_ID", new Integer(shipTo_ID));

				if( (IsSOTrx && !IsDropShip) || (!IsSOTrx && IsDropShip)){
					String name = rs.getString("Name");
					mTab.setValue("DeliverTo", name);
					int C_Location_ID = rs.getInt("C_Location_ID");
					String phone = rs.getString("Phone");
					String fax = rs.getString("Fax");
					MLocation location = new MLocation(ctx, C_Location_ID, null);
					String postal = location.getPostalConcated();
					String address = location.getAddressConcated();
	
					mTab.setValue("DeliverToPostal", postal);
					mTab.setValue("DeliverToAddress", address);
					mTab.setValue("DeliverToPhone", phone);
					mTab.setValue("DeliverToFax", fax);
				}
			}
			rs.close();
			pstmt.close();
		} catch (SQLException e) {
			log.log(Level.SEVERE, sql, e);
			setCalloutActive(false);
			return e.getLocalizedMessage();
		}
		setCalloutActive(false);
		return "";
	} // bPartnerDeliverTo

	/**
	 * Order Header - BPartner Location.
	 * 
	 * @param ctx Context
	 * @param WindowNo current Window No
	 * @param mTab Model Tab
	 * @param mField Model Field
	 * @param value The new value
	 * @return Error message or ""
	 */
	// Jirimuto added 2010/03/18
	public String bPartnerDeliverToLocation(Ctx ctx, int WindowNo, GridTab mTab,
			GridField mField, Object value) {
		if (isCalloutActive())
			return "";
		Integer C_BPartner_Location_ID = (Integer) value;
		if (C_BPartner_Location_ID == null
				|| C_BPartner_Location_ID.intValue() == 0)
			return "";
		
		boolean IsSOTrx = ctx.isSOTrx(WindowNo);
		boolean IsDropShip = "Y".equals(ctx.getContext(WindowNo, "IsDropShip"));

		if( (IsSOTrx && !IsDropShip) || (!IsSOTrx && IsDropShip)){
			setCalloutActive(true);
	
			String sql = "SELECT C_Location_ID, Phone, Fax "
					+ " FROM C_BPartner_Location "
					+ "WHERE C_BPartner_Location_ID=? "; // #1
	
			try {
				PreparedStatement pstmt = DB.prepareStatement(sql, null);
				pstmt.setInt(1, C_BPartner_Location_ID.intValue());
				ResultSet rs = pstmt.executeQuery();
				if (rs.next()) {
					// Get Address Info
					int C_Location_ID = rs.getInt("C_Location_ID");
					String phone = rs.getString("Phone");
					String fax = rs.getString("Fax");
					MLocation location = new MLocation(ctx, C_Location_ID, null);
					String postal = location.getPostalConcated();
					String address = location.getAddressConcated();
	
					mTab.setValue("DeliverToPostal", postal);
					mTab.setValue("DeliverToAddress", address);
					mTab.setValue("DeliverToPhone", phone);
					mTab.setValue("DeliverToFax", fax);
				}
				rs.close();
				pstmt.close();
			} catch (SQLException e) {
				log.log(Level.SEVERE, sql, e);
				setCalloutActive(false);
				return e.getLocalizedMessage();
			}
			setCalloutActive(false);
		}
		return "";
	} // bPartnerDeliverToLocation

	/**
	 *	M_Warehouse.
	 *		Set Organization and Default Locator
	 *	@param ctx
	 *	@param WindowNo
	 *	@param mTab
	 *	@param mField
	 *	@param value
	 *	@return error message or ""
	 */
	public String warehouse (Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value)
	{
		if (isCalloutActive())
			return "";
		Integer M_Warehouse_ID = (Integer)value;
		if (M_Warehouse_ID == null || M_Warehouse_ID.intValue() == 0)
			return "";
		setCalloutActive(true);

		String sql = "SELECT w.AD_Org_ID, l.M_Locator_ID, o.Name, "
			+ " w.C_Location_ID, w.Phone, w.Fax "
			+ "FROM AD_Org o, M_Warehouse w"
			+ " LEFT OUTER JOIN M_Locator l ON (l.M_Warehouse_ID=w.M_Warehouse_ID AND l.IsDefault='Y') "
			+ "WHERE w.AD_ORG_ID=o.AD_ORG_ID AND w.M_Warehouse_ID=?";		//	1

		boolean IsSOTrx = "Y".equals(ctx.getContext(WindowNo, "IsSOTrx"));
		boolean IsDropShip = "Y".equals(ctx.getContext(WindowNo, "IsDropShip"));
				
		try
		{
			PreparedStatement pstmt = DB.prepareStatement(sql, null);
			pstmt.setInt(1, M_Warehouse_ID.intValue());
			ResultSet rs = pstmt.executeQuery();

			if (rs.next())
			{
				//	Org
				Integer ii = new Integer(rs.getInt(1));
				int AD_Org_ID = ctx.getContextAsInt( WindowNo, "AD_Org_ID");
				if (AD_Org_ID != ii.intValue())
					mTab.setValue("AD_Org_ID", ii);
				//	Locator
				ii = new Integer(rs.getInt(2));
				if (rs.wasNull())
					ctx.setContext( WindowNo, 0, "M_Locator_ID", null);
				else
				{
					log.config("M_Locator_ID=" + ii);
					ctx.setContext( WindowNo, "M_Locator_ID", ii.intValue());
				}
				// Jirimuto added --start 2010/03/18
				if( !IsSOTrx && !IsDropShip ){
					String name = rs.getString("Name");
					mTab.setValue("DeliverTo", name);
					int C_Location_ID = rs.getInt("C_Location_ID");
					if( C_Location_ID != 0 ){
						String phone = rs.getString("Phone");
						String fax = rs.getString("Fax");
						MLocation location = new MLocation(ctx, C_Location_ID, null);
						String postal = location.getPostalConcated();
						String address = location.getAddressConcated();
						
						mTab.setValue("DeliverToPostal", postal);
						mTab.setValue("DeliverToAddress", address);
						mTab.setValue("DeliverToPhone", phone);
						mTab.setValue("DeliverToFax", fax);
					}
				}
				// Jirimuto added --end 2010/03/18
				
			}
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			log.log(Level.SEVERE, sql, e);
			setCalloutActive(false);
			return e.getLocalizedMessage();
		}

		setCalloutActive(false);
		return "";
	}	//	warehouse

	
	/**************************************************************************
	 * 	OrderLine Callout
	 *	@param ctx context
	 *	@param WindowNo window no
	 *	@param mTab tab model
	 *	@param mField field model
	 *	@param value new value
	 *	@return error message or ""
	 */
	public String orderLine (Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value)
	{
		if (isCalloutActive())
			return "";
		
		Integer C_OrderLine_ID = (Integer)value;
		if (C_OrderLine_ID == null || C_OrderLine_ID.intValue() == 0)
			return "";
		setCalloutActive(true);
		
		//	Get Details
		MOrderLine ol = new MOrderLine (ctx, C_OrderLine_ID.intValue(), null);

		//	Get Details
		if (ol.get_ID() != 0)
		{
			mTab.setValue("M_Product_ID", new Integer(ol.getM_Product_ID()));
			if( ol.getM_AttributeSetInstance_ID()!=0 )
				mTab.setValue("M_AttributeSetInstance_ID", new Integer(ol.getM_AttributeSetInstance_ID()));
			//
			mTab.setValue("C_UOM_ID", new Integer(ol.getC_UOM_ID()));
			BigDecimal MovementQty = ol.getQtyOrdered().subtract(ol.getQtyDelivered());
			
			//	Jirimuto added. --start 2010/03/18
			BigDecimal shippingQty = MInOutLine.getShippingQty(ctx, C_OrderLine_ID, null);
			MovementQty = MovementQty.subtract(shippingQty);
			//	Jirimuto added. --end 2010/03/18
			
			mTab.setValue("MovementQty", MovementQty);
			BigDecimal QtyEntered = MovementQty;
			if (ol.getQtyEntered().compareTo(ol.getQtyOrdered()) != 0)
				QtyEntered = QtyEntered.multiply(ol.getQtyEntered())
					.divide(ol.getQtyOrdered(), 12, BigDecimal.ROUND_HALF_UP);
			mTab.setValue("QtyEntered", QtyEntered);
			//
			if( ol.getC_Activity_ID()!=0 )
				mTab.setValue("C_Activity_ID", new Integer(ol.getC_Activity_ID()));
			if( ol.getC_Campaign_ID()!=0 )
				mTab.setValue("C_Campaign_ID", new Integer(ol.getC_Campaign_ID()));
			if( ol.getC_Project_ID()!=0 )
				mTab.setValue("C_Project_ID", new Integer(ol.getC_Project_ID()));
			if( ol.getC_ProjectPhase_ID()!=0 )
				mTab.setValue("C_ProjectPhase_ID", new Integer(ol.getC_ProjectPhase_ID()));
			if( ol.getC_ProjectTask_ID()!=0 )
				mTab.setValue("C_ProjectTask_ID", new Integer(ol.getC_ProjectTask_ID()));
			if( ol.getAD_OrgTrx_ID()!=0 )
				mTab.setValue("AD_OrgTrx_ID", new Integer(ol.getAD_OrgTrx_ID()));
			if( ol.getUser1_ID()!=0 )
				mTab.setValue("User1_ID", new Integer(ol.getUser1_ID()));
			if( ol.getUser2_ID()!=0 )
				mTab.setValue("User2_ID", new Integer(ol.getUser2_ID()));
			
			if(ol.getParent().isReturnTrx())
			{
				mTab.setValue("Orig_OrderLine_ID", new Integer(ol.getOrig_OrderLine_ID()));
				MInOutLine ioLine = new MInOutLine (ctx, ol.getOrig_InOutLine_ID(), null);	
				mTab.setValue("M_Locator_ID", ioLine.getM_Locator_ID());
			}
			
			//	Jirimuto added. --start 2010/03/18
			if( ol.getC_Currency_ID()!=0 )
				mTab.setValue("C_Currency_ID", new Integer(ol.getC_Currency_ID()));
			if( ol.getC_Tax_ID()!=0 )
				mTab.setValue("C_Tax_ID", new Integer(ol.getC_Tax_ID()));			
			mTab.setValue("PriceEntered", ol.getPriceEntered());
			mTab.setValue("PriceActual", ol.getPriceActual());
			mTab.setValue("PriceCost", ol.getPriceCost());
			mTab.setValue("PriceLimit", ol.getPriceLimit());
			mTab.setValue("PriceList", ol.getPriceList());
			mTab.setValue("Discount", ol.getDiscount());
			
			if( ol.getPriceActual() != null ){
				BigDecimal lineNetAmt = MovementQty.multiply(ol.getPriceActual());
				mTab.setValue("LineNetAmt", lineNetAmt);
			} else {
				mTab.setValue("LineNetAmt", ol.getLineNetAmt());
			}
			// Jirimuto added. 2010/03/18
			
		}
		setCalloutActive(false);
		return "";
	}	//	orderLine

	/**
	 *	Order Header - priceList.
	 *	(used also in Invoice)
	 *		- C_Currency_ID
	 *		- IsTaxIncluded
	 *	Window Context:
	 *		- EnforcePriceLimit
	 *		- StdPrecision
	 *		- M_PriceList_Version_ID
	 *  @param ctx context
	 *  @param WindowNo current Window No
	 *  @param mTab Grid Tab
	 *  @param mField Grid Field
	 *  @param value New Value
	 *  @return null or error message
	 */
	// Jirimuto added. 2010/03/18
	public String pricelist (Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value)
	{
		Integer M_PriceList_ID = (Integer)value;
		if (M_PriceList_ID == null || M_PriceList_ID.intValue()== 0)
			return "";
		
		//	No Callout Active to fire dependent values
		if (isCalloutActive())	//	prevent recursive
			return "";
		
		setCalloutActive(true);

		if (steps) log.warning("init");

		String sql = "SELECT pl.IsTaxIncluded,pl.EnforcePriceLimit,pl.C_Currency_ID,c.StdPrecision,"
			+ "plv.M_PriceList_Version_ID,plv.ValidFrom "
			+ "FROM M_PriceList pl,C_Currency c,M_PriceList_Version plv "
			+ "WHERE pl.C_Currency_ID=c.C_Currency_ID"
			+ " AND pl.M_PriceList_ID=plv.M_PriceList_ID"
			+ " AND pl.M_PriceList_ID=? "						//	1
			+ "ORDER BY plv.ValidFrom DESC";
		//	Use newest price list - may not be future
		try
		{
			PreparedStatement pstmt = DB.prepareStatement(sql, null);
			pstmt.setInt(1, M_PriceList_ID.intValue());
			ResultSet rs = pstmt.executeQuery();
			if (rs.next())
			{
				//	Tax Included
				mTab.setValue("IsTaxIncluded", new Boolean("Y".equals(rs.getString(1))));
				//	Price Limit Enforce
				ctx.setContext(WindowNo, "EnforcePriceLimit", rs.getString(2));
				//	Currency
				Integer ii = new Integer(rs.getInt(3));
				mTab.setValue("C_Currency_ID", ii);
				//	PriceList Version
				ctx.setContext(WindowNo, "M_PriceList_Version_ID", rs.getInt(5));
			}
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			log.log(Level.SEVERE, sql, e);
			setCalloutActive(false);
			return e.getLocalizedMessage();
		}
		if (steps) log.warning("fini");
		
		setCalloutActive(false);

		return "";
	}	//	priceList

	/**
	 *	M_InOutLine - Default UOM/Locator for Product.
	 *	@param ctx context
	 *	@param WindowNo window no
	 *	@param mTab tab model
	 *	@param mField field model
	 *	@param value new value
	 *	@return error message or ""
	 */
	public String product (Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value)
	{
		if (isCalloutActive())
			return "";
		Integer M_Product_ID = (Integer)value;
		if (M_Product_ID == null || M_Product_ID.intValue() == 0)
			return "";
		setCalloutActive(true);
		
		//	Set Attribute & Locator
		int M_Locator_ID = 0;
		if (ctx.getContextAsInt( Env.WINDOW_INFO, Env.TAB_INFO, "M_Product_ID") == M_Product_ID.intValue()
			&& ctx.getContextAsInt( Env.WINDOW_INFO, Env.TAB_INFO, "M_AttributeSetInstance_ID") != 0)
		{
			mTab.setValue("M_AttributeSetInstance_ID", 
				new Integer(ctx.getContextAsInt( Env.WINDOW_INFO, Env.TAB_INFO, "M_AttributeSetInstance_ID")));
			//	Locator from Info Window - ASI
			M_Locator_ID = ctx.getContextAsInt( Env.WINDOW_INFO, Env.TAB_INFO, "M_Locator_ID");
			if (M_Locator_ID != 0)
				mTab.setValue("M_Locator_ID", new Integer(M_Locator_ID));
		}
		else
			mTab.setValue("M_AttributeSetInstance_ID", null);
		//
		boolean IsSOTrx = ctx.isSOTrx(WindowNo);
		
		// Jirimuto added. --strat 2010/03/18
		int C_BPartner_ID = ctx.getContextAsInt(WindowNo, "C_BPartner_ID");
		BigDecimal Qty = (BigDecimal)mTab.getValue("MovementQty");
		
		int AD_Client_ID = ctx.getContextAsInt(WindowNo, "AD_Client_ID");
		int AD_Org_ID = ctx.getContextAsInt(WindowNo, "AD_Org_ID");
		MProductPricing pp = new MProductPricing (AD_Client_ID, AD_Org_ID, M_Product_ID.intValue(), C_BPartner_ID, Qty, IsSOTrx);
		//
		int M_PriceList_ID = ctx.getContextAsInt(WindowNo, "M_PriceList_ID");
		pp.setM_PriceList_ID(M_PriceList_ID);
		/** PLV is only accurate if PL selected in header */
		int M_PriceList_Version_ID = ctx.getContextAsInt(WindowNo, "M_PriceList_Version_ID");
		pp.setM_PriceList_Version_ID(M_PriceList_Version_ID); 
		Timestamp movementDate = (Timestamp)mTab.getValue("MovementDate");
		pp.setPriceDate(movementDate);
		//
		mTab.setValue("PriceList", pp.getPriceList());
		mTab.setValue("PriceLimit", pp.getPriceLimit());
		mTab.setValue("PriceActual", pp.getPriceStd());
		mTab.setValue("PriceEntered", pp.getPriceStd());
		mTab.setValue("C_Currency_ID", new Integer(pp.getC_Currency_ID()));
		mTab.setValue("Discount", pp.getDiscount());
		ctx.setContext(WindowNo, "EnforcePriceLimit", pp.isEnforcePriceLimit() ? "Y" : "N");
		ctx.setContext(WindowNo, "DiscountSchema", pp.isDiscountSchema() ? "Y" : "N");
		// Jirimuto added. --end 2010/03/18
		
		if (IsSOTrx)
		{
			setCalloutActive(false);
			return "";
		}

		//	PO - Set UOM/Locator/Qty
		MProduct product = MProduct.get(ctx, M_Product_ID.intValue());
		mTab.setValue("C_UOM_ID", new Integer (product.getC_UOM_ID()));
		BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
		mTab.setValue("MovementQty", QtyEntered);
		if (M_Locator_ID != 0)
			;		//	already set via ASI
		else
		{
			int M_Warehouse_ID = ctx.getContextAsInt( WindowNo, "M_Warehouse_ID");
			M_Locator_ID = MProductLocator.getFirstM_Locator_ID (product, M_Warehouse_ID);
			if (M_Locator_ID != 0)
				mTab.setValue("M_Locator_ID", new Integer (M_Locator_ID));
			else
			{
				MWarehouse wh = MWarehouse.get (ctx, M_Warehouse_ID);
				mTab.setValue("M_Locator_ID", new Integer (wh.getDefaultM_Locator_ID()));
			}
		}
		setCalloutActive(false);
		return "";
	}	//	product

	/**
	 *	InOut Line - Tax.
	 *		- basis: Product, Charge, BPartner Location
	 *		- sets C_Tax_ID
	 *  Calles Amount
	 *  @param ctx context
	 *  @param WindowNo current Window No
	 *  @param mTab Grid Tab
	 *  @param mField Grid Field
	 *  @param value New Value
	 *  @return null or error message
	 */
	// Jirimuto added 2010/03/18
	public String tax (Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value)
	{
		String column = mField.getColumnName();
		if (value == null)
			return "";
		if (steps) log.warning("init");
		
		//	Check Product
		int M_Product_ID = 0;
		if (column.equals("M_Product_ID"))
			M_Product_ID = ((Integer)value).intValue();
		else
			M_Product_ID = ctx.getContextAsInt(WindowNo, "M_Product_ID");
		int C_Charge_ID = 0;
		if (column.equals("C_Charge_ID"))
			C_Charge_ID = ((Integer)value).intValue();
		else
			C_Charge_ID = ctx.getContextAsInt(WindowNo, "C_Charge_ID");
		log.fine("Product=" + M_Product_ID + ", C_Charge_ID=" + C_Charge_ID);
		if (M_Product_ID == 0 && C_Charge_ID == 0)
			return amt(ctx, WindowNo, mTab, mField, value);		//

		//	Check Partner Location
		int shipC_BPartner_Location_ID = 0;
		if (column.equals("C_BPartner_Location_ID"))
			shipC_BPartner_Location_ID = ((Integer)value).intValue();
		else
			shipC_BPartner_Location_ID = ctx.getContextAsInt(WindowNo, "C_BPartner_Location_ID");
		if (shipC_BPartner_Location_ID == 0)
			return amt(ctx, WindowNo, mTab, mField, value);		//
		log.fine("Ship BP_Location=" + shipC_BPartner_Location_ID);

		//
		Timestamp orderDate = ctx.getContextAsDate(WindowNo, "DateOrdered");
		log.fine("Order Date=" + orderDate);

		Timestamp movementDate = ctx.getContextAsDate(WindowNo, "MovementDate");
		log.fine("Ship Date=" + movementDate);

		int AD_Org_ID = ctx.getContextAsInt(WindowNo, "AD_Org_ID");
		log.fine("Org=" + AD_Org_ID);

		int M_Warehouse_ID = ctx.getContextAsInt(WindowNo, "M_Warehouse_ID");
		log.fine("Warehouse=" + M_Warehouse_ID);

		int billC_BPartner_Location_ID = ctx.getContextAsInt(WindowNo, "Bill_Location_ID");
		if (billC_BPartner_Location_ID == 0)
			billC_BPartner_Location_ID = shipC_BPartner_Location_ID;
		log.fine("Bill BP_Location=" + billC_BPartner_Location_ID);

		//
		int C_Tax_ID = Tax.get (ctx, M_Product_ID, C_Charge_ID, orderDate, movementDate,
			AD_Org_ID, M_Warehouse_ID, billC_BPartner_Location_ID, shipC_BPartner_Location_ID,
			"Y".equals(ctx.getContext(WindowNo, "IsSOTrx")));
		log.info("Tax ID=" + C_Tax_ID);
		//
		if (C_Tax_ID == 0)
			mTab.fireDataStatusEEvent(CLogger.retrieveError());
		else
			mTab.setValue("C_Tax_ID", new Integer(C_Tax_ID));
		//
		if (steps) log.warning("fini");
		return amt(ctx, WindowNo, mTab, mField, value);
	}	//	tax
	
	/**
	 *	InOut Line - Amount.
	 *		- called from QtyOrdered, Discount and PriceActual
	 *		- calculates Discount or Actual Amount
	 *		- calculates LineNetAmt
	 *		- enforces PriceLimit
	 *  @param ctx context
	 *  @param WindowNo current Window No
	 *  @param mTab Grid Tab
	 *  @param mField Grid Field
	 *  @param value New Value
	 *  @return null or error message
	 */
	// Jirimuto added 2010/03/18
	public String amt (Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value)
	{
		if (isCalloutActive() || value == null)
			return "";
		setCalloutActive(true);

		if (steps) log.warning("init");
		int C_UOM_To_ID = ctx.getContextAsInt(WindowNo, "C_UOM_ID");
		int M_Product_ID = ctx.getContextAsInt(WindowNo, "M_Product_ID");
		int M_PriceList_ID = ctx.getContextAsInt(WindowNo, "M_PriceList_ID");
		Timestamp MovementDate = ctx.getContextAsDate(WindowNo, "MovementDate");
		int StdPrecision = MPriceList.getPricePrecision(ctx, M_PriceList_ID);
		BigDecimal QtyEntered, MovementQty, PriceEntered, PriceActual, PriceLimit, Discount, PriceList;
		//	get values
		QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
		MovementQty = (BigDecimal)mTab.getValue("MovementQty");
		log.fine("QtyEntered=" + QtyEntered + ", movement=" + MovementQty + ", UOM=" + C_UOM_To_ID);
		//
		PriceEntered = (BigDecimal)mTab.getValue("PriceEntered");
		PriceActual = (BigDecimal)mTab.getValue("PriceActual");
		Discount = (BigDecimal)mTab.getValue("Discount");
		PriceLimit = (BigDecimal)mTab.getValue("PriceLimit");
		PriceList = (BigDecimal)mTab.getValue("PriceList");
		log.fine("PriceList=" + PriceList + ", Limit=" + PriceLimit + ", Precision=" + StdPrecision);
		log.fine("PriceEntered=" + PriceEntered + ", Actual=" + PriceActual + ", Discount=" + Discount);

		//	Qty changed - recalc price
		if ((mField.getColumnName().equals("MovementQty") 
			|| mField.getColumnName().equals("QtyEntered")
			|| mField.getColumnName().equals("M_Product_ID")) 
			&& !"N".equals(ctx.getContext(WindowNo, "DiscountSchema")))
		{
			int C_BPartner_ID = ctx.getContextAsInt(WindowNo, "C_BPartner_ID");
			if (mField.getColumnName().equals("QtyEntered"))
				MovementQty = MUOMConversion.convertProductTo (ctx, M_Product_ID, 
					C_UOM_To_ID, QtyEntered);
			if (MovementQty == null)
				MovementQty = QtyEntered;
			boolean IsSOTrx = ctx.getContext(WindowNo, "IsSOTrx").equals("Y");
			int AD_Client_ID = ctx.getContextAsInt(WindowNo, "AD_Client_ID");
			int AD_Org_ID = ctx.getContextAsInt(WindowNo, "AD_Org_ID");
			MProductPricing pp = new MProductPricing (AD_Client_ID, AD_Org_ID, M_Product_ID, C_BPartner_ID, MovementQty, IsSOTrx);
			pp.setM_PriceList_ID(M_PriceList_ID);
			int M_PriceList_Version_ID = ctx.getContextAsInt(WindowNo, "M_PriceList_Version_ID");
			pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
			pp.setPriceDate(MovementDate);
			//
			PriceEntered = MUOMConversion.convertProductFrom (ctx, M_Product_ID, 
				C_UOM_To_ID, pp.getPriceStd());
			if (PriceEntered == null)
				PriceEntered = pp.getPriceStd();
			//
			log.fine("QtyChanged -> PriceActual=" + pp.getPriceStd() 
				+ ", PriceEntered=" + PriceEntered + ", Discount=" + pp.getDiscount());
			PriceActual = pp.getPriceStd();
			mTab.setValue("PriceActual", PriceActual);
			mTab.setValue("Discount", pp.getDiscount());
			mTab.setValue("PriceEntered", PriceEntered);
			ctx.setContext(WindowNo, "DiscountSchema", pp.isDiscountSchema() ? "Y" : "N");
		}
		else if (mField.getColumnName().equals("PriceActual"))
		{
			PriceActual = (BigDecimal)value;
			PriceEntered = MUOMConversion.convertProductFrom (ctx, M_Product_ID, 
				C_UOM_To_ID, PriceActual);
			if (PriceEntered == null)
				PriceEntered = PriceActual;
			//
			log.fine("PriceActual=" + PriceActual 
				+ " -> PriceEntered=" + PriceEntered);
			mTab.setValue("PriceEntered", PriceEntered);
		}
		else if (mField.getColumnName().equals("PriceEntered"))
		{
			PriceEntered = (BigDecimal)value;
			PriceActual = MUOMConversion.convertProductTo (ctx, M_Product_ID, 
				C_UOM_To_ID, PriceEntered);
			if (PriceActual == null)
				PriceActual = PriceEntered;
			//
			log.fine("PriceEntered=" + PriceEntered 
				+ " -> PriceActual=" + PriceActual);
			mTab.setValue("PriceActual", PriceActual);
		}
		
		//  Discount entered - Calculate Actual/Entered
		if (mField.getColumnName().equals("Discount"))
		{
			PriceActual = new BigDecimal ((100.0 - Discount.doubleValue()) 
				/ 100.0 * PriceList.doubleValue());
			if (PriceActual.scale() > StdPrecision)
				PriceActual = PriceActual.setScale(StdPrecision, BigDecimal.ROUND_HALF_UP);
			PriceEntered = MUOMConversion.convertProductFrom (ctx, M_Product_ID, 
				C_UOM_To_ID, PriceActual);
			if (PriceEntered == null)
				PriceEntered = PriceActual;
			mTab.setValue("PriceActual", PriceActual);
			mTab.setValue("PriceEntered", PriceEntered);
		}
		//	calculate Discount
		else
		{
			if (PriceList.intValue() == 0)
				Discount = Env.ZERO;
			else
				Discount = new BigDecimal ((PriceList.doubleValue() - PriceActual.doubleValue()) / PriceList.doubleValue() * 100.0);
			if (Discount.scale() > 2)
				Discount = Discount.setScale(2, BigDecimal.ROUND_HALF_UP);
			mTab.setValue("Discount", Discount);
		}
		log.fine("PriceEntered=" + PriceEntered + ", Actual=" + PriceActual + ", Discount=" + Discount);

		//	Check PriceLimit
		String epl = ctx.getContext(WindowNo, "EnforcePriceLimit");
		boolean enforce = ctx.isSOTrx(WindowNo) && epl != null && epl.equals("Y");
		if (enforce && MRole.getDefault().isOverwritePriceLimit())
			enforce = false;
		//	Check Price Limit?
		if (enforce && PriceLimit.doubleValue() != 0.0
		  && PriceActual.compareTo(PriceLimit) < 0)
		{
			PriceActual = PriceLimit;
			PriceEntered = MUOMConversion.convertProductFrom (ctx, M_Product_ID, 
				C_UOM_To_ID, PriceLimit);
			if (PriceEntered == null)
				PriceEntered = PriceLimit;
			log.fine("(under) PriceEntered=" + PriceEntered + ", Actual" + PriceLimit);
			mTab.setValue ("PriceActual", PriceLimit);
			mTab.setValue ("PriceEntered", PriceEntered);
			mTab.fireDataStatusEEvent ("UnderLimitPrice", "", false);
			//	Repeat Discount calc
			if (PriceList.intValue() != 0)
			{
				Discount = new BigDecimal ((PriceList.doubleValue () - PriceActual.doubleValue ()) / PriceList.doubleValue () * 100.0);
				if (Discount.scale () > 2)
					Discount = Discount.setScale (2, BigDecimal.ROUND_HALF_UP);
				mTab.setValue ("Discount", Discount);
			}
		} else {
			
			PriceEntered = MUOMConversion.convertProductFrom (ctx, M_Product_ID, 
				C_UOM_To_ID, PriceActual);
			if (PriceEntered == null)
				PriceEntered = PriceLimit;
			log.fine("(under) PriceEntered=" + PriceEntered + ", Actual" + PriceLimit);
			mTab.setValue ("PriceEntered", PriceEntered);
			//	Repeat Discount calc
			if (PriceList.intValue() != 0)
			{
				Discount = new BigDecimal ((PriceList.doubleValue () - PriceActual.doubleValue ()) / PriceList.doubleValue () * 100.0);
				if (Discount.scale () > 2)
					Discount = Discount.setScale (2, BigDecimal.ROUND_HALF_UP);
				mTab.setValue ("Discount", Discount);
			}
		}

		//	Line Net Amt
		BigDecimal LineNetAmt = MovementQty.multiply(PriceActual);
		if (LineNetAmt.scale() > StdPrecision)
			LineNetAmt = LineNetAmt.setScale(StdPrecision, BigDecimal.ROUND_HALF_UP);
		log.info("LineNetAmt=" + LineNetAmt);
		mTab.setValue("LineNetAmt", LineNetAmt);
		//
		setCalloutActive(false);
		return "";
	}	//	amt

	/**
	 *	InOut Line - Quantity.
	 *		- called from C_UOM_ID, QtyEntered, MovementQty
	 *		- enforces qty UOM relationship
	 *	@param ctx context
	 *	@param WindowNo window no
	 *	@param mTab tab model
	 *	@param mField field model
	 *	@param value new value
	 *	@return error message or ""
	 */
	public String qty (Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value)
	{
		if (isCalloutActive() || value == null)
			return "";
		setCalloutActive(true);

		int M_Product_ID = ctx.getContextAsInt( WindowNo, "M_Product_ID");
		//	log.log(Level.WARNING,"qty - init - M_Product_ID=" + M_Product_ID);
		BigDecimal MovementQty, QtyEntered;
		
		//	No Product
		if (M_Product_ID == 0)
		{
			QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
			mTab.setValue("MovementQty", QtyEntered);
		}
		//	UOM Changed - convert from Entered -> Product
		else if (mField.getColumnName().equals("C_UOM_ID"))
		{
			int C_UOM_To_ID = ((Integer)value).intValue();
			QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
			BigDecimal QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision(ctx, C_UOM_To_ID), BigDecimal.ROUND_HALF_UP);
			if (QtyEntered.compareTo(QtyEntered1) != 0)
			{
				log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID 
					+ "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);  
				QtyEntered = QtyEntered1;
				mTab.setValue("QtyEntered", QtyEntered);
			}
			MovementQty = MUOMConversion.convertProductFrom (ctx, M_Product_ID, 
				C_UOM_To_ID, QtyEntered);
			if (MovementQty == null)
				MovementQty = QtyEntered;
			boolean conversion = QtyEntered.compareTo(MovementQty) != 0;
			log.fine("UOM=" + C_UOM_To_ID 
				+ ", QtyEntered=" + QtyEntered
				+ " -> " + conversion 
				+ " MovementQty=" + MovementQty);
			ctx.setContext( WindowNo, "UOMConversion", conversion ? "Y" : "N");
			mTab.setValue("MovementQty", MovementQty);
		}
		//	No UOM defined
		else if (ctx.getContextAsInt( WindowNo, "C_UOM_ID") == 0)
		{
			QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
			mTab.setValue("MovementQty", QtyEntered);
		}
		//	QtyEntered changed - calculate MovementQty
		else if (mField.getColumnName().equals("QtyEntered"))
		{
			int C_UOM_To_ID = ctx.getContextAsInt( WindowNo, "C_UOM_ID");
			QtyEntered = (BigDecimal)value;
			BigDecimal QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision(ctx, C_UOM_To_ID), BigDecimal.ROUND_HALF_UP);
			if (QtyEntered.compareTo(QtyEntered1) != 0)
			{
				log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID 
					+ "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);  
				QtyEntered = QtyEntered1;
				mTab.setValue("QtyEntered", QtyEntered);
			}
			MovementQty = MUOMConversion.convertProductFrom (ctx, M_Product_ID, 
				C_UOM_To_ID, QtyEntered);
			if (MovementQty == null)
				MovementQty = QtyEntered;
			boolean conversion = QtyEntered.compareTo(MovementQty) != 0;
			log.fine("UOM=" + C_UOM_To_ID 
				+ ", QtyEntered=" + QtyEntered
				+ " -> " + conversion 
				+ " MovementQty=" + MovementQty);
			ctx.setContext( WindowNo, "UOMConversion", conversion ? "Y" : "N");
			mTab.setValue("MovementQty", MovementQty);
		}
		//	MovementQty changed - calculate QtyEntered (should not happen)
		else if (mField.getColumnName().equals("MovementQty"))
		{
			int C_UOM_To_ID = ctx.getContextAsInt( WindowNo, "C_UOM_ID");
			MovementQty = (BigDecimal)value;
			int precision = MProduct.get(ctx, M_Product_ID).getUOMPrecision(); 
			BigDecimal MovementQty1 = MovementQty.setScale(precision, BigDecimal.ROUND_HALF_UP);
			if (MovementQty.compareTo(MovementQty1) != 0)
			{
				log.fine("Corrected MovementQty " 
					+ MovementQty + "->" + MovementQty1);  
				MovementQty = MovementQty1;
				mTab.setValue("MovementQty", MovementQty);
			}
			QtyEntered = MUOMConversion.convertProductTo (ctx, M_Product_ID, 
				C_UOM_To_ID, MovementQty);
			if (QtyEntered == null)
				QtyEntered = MovementQty;
			boolean conversion = MovementQty.compareTo(QtyEntered) != 0;
			log.fine("UOM=" + C_UOM_To_ID 
				+ ", MovementQty=" + MovementQty
				+ " -> " + conversion 
				+ " QtyEntered=" + QtyEntered);
			ctx.setContext( WindowNo, "UOMConversion", conversion ? "Y" : "N");
			mTab.setValue("QtyEntered", QtyEntered);
		}
		
		// Check for RMA
		boolean isReturnTrx = "Y".equals(ctx.getContext(WindowNo, "IsReturnTrx"));		
		if(M_Product_ID != 0 
			&& isReturnTrx) 
		{
			Integer oLine_ID = (Integer)mTab.getValue("C_OrderLine_ID");
			MOrderLine oLine = new MOrderLine (ctx, oLine_ID, null);
			if (oLine.get_ID() != 0)
			{
				Integer orig_IOLine_ID = oLine.getOrig_InOutLine_ID();
				if(orig_IOLine_ID != 0)
				{
					MInOutLine orig_IOLine = new MInOutLine (ctx, orig_IOLine_ID, null);
					BigDecimal shippedQty = orig_IOLine.getMovementQty();
					MovementQty = (BigDecimal)mTab.getValue("MovementQty");
					if(shippedQty.compareTo(MovementQty)<0)
					{
						if(ctx.isSOTrx(WindowNo))
							mTab.fireDataStatusEEvent ("QtyShippedLessThanQtyReturned", shippedQty.toString(), false);
						else
							mTab.fireDataStatusEEvent ("QtyReceivedLessThanQtyReturned", shippedQty.toString(), false);
						mTab.setValue ("MovementQty",shippedQty);
						MovementQty = shippedQty;
					
						int C_UOM_To_ID = ctx.getContextAsInt( WindowNo, "C_UOM_ID");
						QtyEntered = MUOMConversion.convertProductTo (ctx, M_Product_ID, 
								C_UOM_To_ID, MovementQty);
						if (QtyEntered == null)
							QtyEntered = MovementQty;
						mTab.setValue ("QtyEntered",QtyEntered);
						mTab.setValue ("MovementQty",MovementQty);
						log.fine("QtyEntered : "+ QtyEntered.toString() +
									"MovementQty : " + MovementQty.toString());
					}
				}
			}
		}

		//
		setCalloutActive(false);
		return "";
	}	//	qty

	/**
	 *	M_InOutLine - ASI.
	 *	@param ctx context
	 *	@param WindowNo window no
	 *	@param mTab tab model
	 *	@param mField field model
	 *	@param value new value
	 *	@return error message or ""
	 */
	public String asi (Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value)
	{
		if (isCalloutActive())
			return "";
		Integer M_ASI_ID = (Integer)value;
		if (M_ASI_ID == null || M_ASI_ID.intValue() == 0)
			return "";
		setCalloutActive(true);
		//
		int M_Product_ID = ctx.getContextAsInt( WindowNo, "M_Product_ID");
		int M_Warehouse_ID = ctx.getContextAsInt( WindowNo, "M_Warehouse_ID");
		int M_Locator_ID = ctx.getContextAsInt( WindowNo, "M_Locator_ID");
		log.fine("M_Product_ID=" + M_Product_ID
			+ ", M_ASI_ID=" + M_ASI_ID
			+ " - M_Warehouse_ID=" + M_Warehouse_ID 
			+ ", M_Locator_ID=" + M_Locator_ID);
		//	Check Selection
		int M_AttributeSetInstance_ID =	Env.getCtx().getContextAsInt(Env.WINDOW_INFO, Env.TAB_INFO, "M_AttributeSetInstance_ID");
		if (M_ASI_ID.intValue() == M_AttributeSetInstance_ID)
		{
			int selectedM_Locator_ID = Env.getCtx().getContextAsInt(Env.WINDOW_INFO, Env.TAB_INFO, "M_Locator_ID");
			if (selectedM_Locator_ID != 0)
			{
				log.fine("Selected M_Locator_ID=" + selectedM_Locator_ID);
				mTab.setValue("M_Locator_ID", new Integer (selectedM_Locator_ID));
			}
		}
		setCalloutActive(false);
		return "";
	}	//	asi

}	//	CalloutInOut
