/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2006 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software; you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program; if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 2620 Augustine Dr. #245, Santa Clara, CA 95054, USA        *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;

import org.compiere.util.Ctx;
import org.compiere.util.DB;

/**
 * @author Bao
 *
 */
public class MBankStatementCharge extends X_C_BankStatementCharge {

	/**
	 * @param ctx
	 * @param C_BankStatementCharge_ID
	 * @param trxName
	 */
	public MBankStatementCharge(Ctx ctx, int C_BankStatementCharge_ID, String trxName) {
		super(ctx, C_BankStatementCharge_ID, trxName);
	}	//	MBankStatementCharge

	/**
	 * @param ctx
	 * @param rs
	 * @param trxName
	 */
	public MBankStatementCharge(Ctx ctx, ResultSet rs, String trxName) {
		super(ctx, rs, trxName);
	}	//	MBankStatementCharge
	
	/**
	 * 	Parent Constructor
	 * 	@param statement Bank Statement that the line is part of
	 */
	public MBankStatementCharge(MBankStatementLine statementLine)
	{
		this (statementLine.getCtx(), 0, statementLine.get_TrxName());
//		setClientOrg(statementLine);
		setC_BankStatement_ID(statementLine.getC_BankStatement_ID());
		setC_BankStatementLine_ID(statementLine.getC_BankStatementLine_ID());
	}	//	MBankStatementCharge

	/**
	 * 	Before Save
	 *	@param newRecord new
	 *	@return true
	 */
	protected boolean beforeSave (boolean newRecord)
	{

		//	Get Line No
		if (getLine() == 0)
		{
			String sql = "SELECT COALESCE(MAX(Line),0)+10 FROM C_BankStatementCharge WHERE C_BankStatementLine_ID=?";
			int ii = DB.getSQLValue (get_TrxName(), sql, getC_BankStatementLine_ID());
			setLine (ii);
		}
		
		BigDecimal chargeAmt = getChargeAmt();
		Ctx ctx = getCtx();
		MCharge charge = MCharge.get(ctx, getC_Charge_ID());
		setIsTaxIncluded( charge.isTaxIncluded() );
		
		MTax tax = MTax.get(ctx, getC_Tax_ID());
		MBPartner bartner = MBPartner.get(ctx, getC_BPartner_ID());
		MBankStatementLine bsl = new MBankStatementLine(ctx, getC_BankStatementLine_ID(), get_TrxName());
		MCurrency currency = MCurrency.get(ctx, bsl.getC_Currency_ID());
		
		boolean taxIncluded = isTaxIncluded();
		
		BigDecimal taxAmt = tax.calculateTax(chargeAmt, taxIncluded, currency.getStdPrecision(), bartner.getTaxRoundModeAsInt());
		setTaxAmt(taxAmt);
		
		if( isTaxIncluded() ){
			setTotalAmt(chargeAmt);
		} else {
			setTotalAmt(chargeAmt.add(taxAmt));
		}
		
		return true;
	}

	/**
	 * 	After Save
	 *	@param newRecord new
	 *	@param success success
	 *	@return success
	 */
	protected boolean afterSave (boolean newRecord, boolean success)
	{
		updateChargeAmt();
		MBankStatementLine bsl = new MBankStatementLine(getCtx(), getC_BankStatementLine_ID(), get_TrxName());
		updateTrxAmt(bsl);
		
		return success;
	}	// afterSave
	
	/**
	 * 	After Delete
	 *	@param success success
	 *	@return success
	 */
	protected boolean afterDelete (boolean success)
	{
		updateChargeAmt();
		MBankStatementLine bsl = new MBankStatementLine(getCtx(), getC_BankStatementLine_ID(), get_TrxName());
		updateTrxAmt(bsl);
		
		return success;
	}	//	afterDelete
	
	/**
	 * Update ChargeAmt on BankStatementLine
	 */
	private void updateChargeAmt()
	{
		// Update ChargeAmount
		String sql = "UPDATE C_BankStatementLine bsl"
			+ " SET ChargeAmt=(SELECT NVL(SUM(TotalAmt),0) FROM C_BankStatementCharge bsc " 
			+ "WHERE bsc.C_BankStatementLine_ID = " + getC_BankStatementLine_ID() + ") "
			+ "WHERE bsl.C_BankStatementLine_ID = " + getC_BankStatementLine_ID() + " ";
		DB.executeUpdate(sql, get_TrxName());
		
	}	// updateChargeAmt

	/**
	 * Update TrxAmt on BankStatementLine
	 */
	private void updateTrxAmt(MBankStatementLine bsl)
	{
		// Update ChargeAmount
		if( bsl.getC_Payment_ID() == 0 ){
			bsl.setTrxAmt(bsl.getStmtAmt().subtract(bsl.getChargeAmt()).subtract(bsl.getInterestAmt()));
		} else {
			MPayment payment = new MPayment(getCtx(), bsl.getC_Payment_ID(), get_TrxName());
			if( !payment.isProcessed() ){
			  bsl.setTrxAmt(bsl.getStmtAmt().subtract(bsl.getChargeAmt()).subtract(bsl.getInterestAmt()));
			  payment.setPayAmt(bsl.getTrxAmt().abs());
			  payment.save();
			} else {
				bsl.setInterestAmt(bsl.getStmtAmt().subtract(bsl.getChargeAmt()).subtract(bsl.getTrxAmt()));
			}
		}
		bsl.save();
	}	
}
