/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.process;

import java.util.*;
import java.util.logging.*;
import org.compiere.model.*;
import org.compiere.util.CompiereUserException;

/**
 *	Create Checks from Payment Selection Line
 *	
 *  @author Jorg Janke
 *  @version $Id: PaySelectionCreateCheck.java,v 1.2 2010/04/09 09:23:13 jrmt Exp $
 */
public class PaySelectionCreateCheck extends SvrProcess
{
	/**	Action			*/
	private String		p_ProcessAction = "Prepare";
	/**	Action			*/
	private boolean		p_IsPaymentVoid = false;
	
	/**	Target Payment Rule			*/
	private String		p_PaymentRule = null;
	/**	Payment Selection			*/
	private int			p_C_PaySelection_ID = 0;
	/** The checks					*/
	private ArrayList<MPaySelectionCheck>	m_list = new ArrayList<MPaySelectionCheck>();
	
	/**
	 *  Prepare - e.g., get Parameters.
	 */
	protected void prepare()
	{
		ProcessInfoParameter[] para = getParameter();
		for (int i = 0; i < para.length; i++)
		{
			String name = para[i].getParameterName();
			if (para[i].getParameter() == null)
				;
			else if (name.equals("PaymentRule"))
				p_PaymentRule = (String)para[i].getParameter();
			else if (name.equals("Action"))
				p_ProcessAction = (String)para[i].getParameter();
			else if (name.equals("IsPaymentVoid"))
				p_IsPaymentVoid = "Y".equals(para[i].getParameter());
			else
				log.log(Level.SEVERE, "Unknown Parameter: " + name);
		}
		p_C_PaySelection_ID = getRecord_ID();
		if (p_PaymentRule != null && p_PaymentRule.equals(X_C_Order.PAYMENTRULE_DirectDebit))
			p_PaymentRule = null;
	}	//	prepare

	/**
	 *  Perrform process.
	 *  @return Message (clear text)
	 *  @throws Exception if not successful
	 */
	protected String doIt () throws Exception
	{
		log.info ("C_PaySelection_ID=" + p_C_PaySelection_ID
			+ ", PaymentRule=" + p_PaymentRule);
		
		MPaySelection psel = new MPaySelection (getCtx(), p_C_PaySelection_ID, get_TrxName());
		if (psel.get_ID() == 0)
			throw new IllegalArgumentException("Not found C_PaySelection_ID=" + p_C_PaySelection_ID);
		
		// Jirimuto modified for Payment Selection Optimize. --start 2010/04/02
		if( "P".equals(p_ProcessAction) )
		{
			if (psel.isProcessed())
				throw new IllegalArgumentException("@Processed@");
			//
			MPaySelectionLine[] lines = psel.getLines(false);
			for (int i = 0; i < lines.length; i++)
			{
				MPaySelectionLine line = lines[i];
				if (!line.isActive() || line.isProcessed())
					continue;
				createCheck (line);
			}
			//
			psel.setProcessed(true);
			psel.save();
			
			
		} else if("U".equals(p_ProcessAction) ) {
			
			if (!psel.isProcessed())
				throw new IllegalArgumentException("@NotProcessed@");
			
			boolean paymentExist = false;
			boolean paymentClosed = false;
			// check if payment exist ?
			MPaySelectionCheck[] checks = psel.getChecks(false);
			for (int i = 0; i < checks.length; i++)
			{
				MPaySelectionCheck check = checks[i];
				if (!check.isActive() )
					continue;
				
				if( check.getC_Payment_ID() != 0 ){
					paymentExist = true;
					MPayment payment = new MPayment(getCtx(), check.getC_Payment_ID(), get_TrxName());
					if( MPayment.DOCSTATUS_Closed.equals(payment.getDocStatus())){
						paymentClosed = true;
					}
				}
			}
			if( !p_IsPaymentVoid && paymentExist )
				throw new IllegalArgumentException("@Payment@ @AlreadyExists@");
			
			if( p_IsPaymentVoid && paymentClosed )
				throw new IllegalArgumentException("@PaymentProcessed@");

			//
			MPaySelectionLine[] lines = psel.getLines(false);
			for (int i = 0; i < lines.length; i++)
			{
				MPaySelectionLine line = lines[i];
				line.setProcessed(false);
				line.setC_PaySelectionCheck_ID(0);
				line.save();
			}
			
			for (int i = checks.length-1; i>=0; i--)
			{
				MPaySelectionCheck check = checks[i];
				
				if( check.getC_Payment_ID() != 0 ){
					paymentExist = true;
					MPayment payment = new MPayment(getCtx(), check.getC_Payment_ID(), get_TrxName());
					if( !payment.processIt(MPayment.DOCACTION_Void) )
						throw new IllegalArgumentException("@PaymentError@");
					payment.save();
				}
				if( !check.delete(true, get_TrxName()))
					throw new IllegalArgumentException("@DeleteError@");
			}

			//
			psel.setProcessed(false);
			psel.save();
			
			//
			// psel.setProcessed(false);
			// psel.save();
			
		} else {
			;
		}
		// Jirimuto modified for Payment Selection Optimize. --end 2010/04/02
		
		return "@C_PaySelectionCheck_ID@ - #" + m_list.size();
	}	//	doIt

	/**
	 * 	Create Check from line
	 *	@param line
	 *	@throws Exception for invalid bank accounts
	 */
	private void createCheck (MPaySelectionLine line) throws Exception
	{
		//	Try to find one
		for (int i = 0; i < m_list.size(); i++)
		{
			MPaySelectionCheck check = (MPaySelectionCheck)m_list.get(i);
			//	Add to existing
			if (check.getC_BPartner_ID() == line.getInvoice().getC_BPartner_ID())
			{
				check.addLine(line);
				if (!check.save())
					throw new IllegalStateException("Cannot save MPaySelectionCheck");
				line.setC_PaySelectionCheck_ID(check.getC_PaySelectionCheck_ID());
				line.setProcessed(true);
				if (!line.save())
					throw new IllegalStateException("Cannot save MPaySelectionLine");
				return;
			}
		}
		//	Create new
		String PaymentRule = line.getPaymentRule();
		if (p_PaymentRule != null)
		{
			if (!X_C_Order.PAYMENTRULE_DirectDebit.equals(PaymentRule))
				PaymentRule = p_PaymentRule;
		}
		MPaySelectionCheck check = new MPaySelectionCheck(line, PaymentRule);
		if (!check.isValid())
		{
			int C_BPartner_ID = check.getC_BPartner_ID();
			MBPartner bp = MBPartner.get(getCtx(), C_BPartner_ID);
			String msg = "@NotFound@ @C_BP_BankAccount@: " + bp.getName();
			throw new CompiereUserException(msg);
		}
		if (!check.save())
			throw new IllegalStateException("Cannot save MPaySelectionCheck");
		line.setC_PaySelectionCheck_ID(check.getC_PaySelectionCheck_ID());
		line.setProcessed(true);
		if (!line.save())
			throw new IllegalStateException("Cannot save MPaySelectionLine");
		m_list.add(check);
	}	//	createCheck
	
}	//	PaySelectionCreateCheck
