/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.process;

import java.sql.PreparedStatement;
import java.util.logging.*;

import org.compiere.util.*;

/**
 *	Copy Tab Fields
 *	
 *  @author Jorg Janke
 *  @version $Id: TabMRowSeqNoCopy.java,v 1.1 2010/05/04 02:34:28 jrmt Exp $
 */
public class TabMRowSeqNoCopy extends SvrProcess
{
	/**	Window No					*/
	private int			p_AD_Window_ID = 0;
	/**	Tab No				*/
	private int			p_AD_Tab_ID = 0;

	/**
	 *  Prepare - e.g., get Parameters.
	 */
	protected void prepare()
	{
		ProcessInfoParameter[] para = getParameter();
		for (int i = 0; i < para.length; i++)
		{
			String name = para[i].getParameterName();
			if (para[i].getParameter() == null)
				;
			else if (name.equals("AD_Window_ID"))
				p_AD_Window_ID = para[i].getParameterAsInt();
			else if (name.equals("AD_Window_ID"))
				p_AD_Tab_ID = para[i].getParameterAsInt();
			else
				log.log(Level.SEVERE, "Unknown Parameter: " + name);
		}
		if ( p_AD_Tab_ID ==0 ){
			p_AD_Tab_ID = getRecord_ID();
		}
	}	//	prepare

	/**
	 * 	Process
	 *	@return message
	 *	@throws Exception
	 */
	protected String doIt() throws Exception
	{
		log.info("Copy AD_Window_ID=" + p_AD_Window_ID + ", AD_Tab_ID=" + p_AD_Tab_ID);
		
		String sql = "UPDATE AD_FIELD SET MRSEQNO = SEQNO WHERE AD_TAB_ID=" + p_AD_Tab_ID;
		int count = executesql("Update AD_Field MRSeqNo with SeqNo", sql,  " fields updated: ");
		
		return "@Copied@ #" + count;
	}	//	doIt

	private int executesql(String msg, String sql, String pmsg)
	{
		int result = 0;
		PreparedStatement pstmt = null;
		log.info(msg);
		try
		{
			pstmt = DB.prepareStatement(sql, get_TrxName());
			result = pstmt.executeUpdate();
			log.info(pmsg + result);

			pstmt.close();
			pstmt = null;
		}
		catch (Exception e)
		{
			log.log(Level.SEVERE, sql, e);
			result = -1;
		}
		try
		{
			if (pstmt != null)
				pstmt.close();
			pstmt = null;
		}
		catch (Exception e)
		{
			pstmt = null;
		}

		return result;
	}

}	//	TabCopy
