/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.util;

import java.io.OutputStream;
import java.io.PrintWriter;

import javax.servlet.http.HttpServletRequest;

import org.apache.ecs.AlignType;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.b;
import org.apache.ecs.xhtml.body;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.h1;
import org.apache.ecs.xhtml.head;
import org.apache.ecs.xhtml.html;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.link;
import org.apache.ecs.xhtml.meta;
import org.apache.ecs.xhtml.p;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.title;
import org.apache.ecs.xhtml.tr;
/**
 *  XHTML Document.
 *
 *  @author Jorg Janke
 *  @version  $Id: WebDoc.java,v 1.18 2010/05/06 05:19:20 siqin Exp $
 */
public class WebDoc
{
	/**
	 *  Create styled Document with Title
	 *  @param plain if true adds standard.css and standard.js
	 *  @param title optional header title and h1 
	 *  @param javaClient true if Java Client - browser otherwise
	 *  @return Document
	 */
	//clmg
	public static WebDoc create (boolean plain, String title, boolean javaClient){
		return create (plain, title, javaClient, null);
	}
	//
	
	public static WebDoc create (boolean plain, String title, boolean javaClient, HttpServletRequest request)
	{
		WebDoc doc = new WebDoc();
		doc.setUp (plain, javaClient, title, request);
		return doc;
	}   //  create
	
	/**
	 *  Create Document
	 *  @param plain if true adds stylesheet and standard js
	 *  @return Document
	 */
	public static WebDoc create (boolean plain)
	{
		return create (plain, null, false);
	}   //  create
	
	/**
	 *  Create styled popup Document with Title
	 *  @param title header title and h1 
	 *  @return Document
	 */
	public static WebDoc createPopup (String title){
		return createPopup(title, null);
	}
	public static WebDoc createPopup (String title, HttpServletRequest request)
	{
		WebDoc doc = create (title, request);
		doc.getHead().addElement(new script((Element)null, "js/window.js"));
		doc.getHead().addElement(new script((Element)null, "js/session.js"));
		doc.getHead().addElement(new link("css/import.css", link.REL_STYLESHEET, link.TYPE_CSS));//clmg 2009/02/16
		doc.getHead().addElement(new link("css/popup.css", link.REL_STYLESHEET, link.TYPE_CSS));//clmg 2009/02/16
//		doc.setClasses ("popupTable", "popupHeader"); //clmg 2009/02/16
//		doc.getTable().setCellSpacing(5);//clmg 2009/02/16
		return doc;
	}   //  createPopup


	//clmg
	public static WebDoc createWindow (String title){
		return createWindow(title, null);
	}
	//
	/**
	 *  Create styled window Document with Title
	 *  @param title header title and h1 
	 *  @return Document
	 */
	public static WebDoc createWindow (String title, HttpServletRequest request)
	{
		WebDoc doc = create (title, request);
		//clmg 2009/02/24
		if(request==null || request!=null && request.getAttribute("IS_POPUP_WINDOW")==null){
			doc.getHead().addElement(new link("css/import.css", link.REL_STYLESHEET, link.TYPE_CSS));
		}else{
			doc.getHead().addElement(new link("css/import_popup.css", link.REL_STYLESHEET, link.TYPE_CSS));
		}
		//
		doc.getHead().addElement(new link("css/window.css", link.REL_STYLESHEET, link.TYPE_CSS));
		doc.getHead().addElement(new link("js/window.css", link.REL_STYLESHEET, link.TYPE_CSS));

		doc.getHead().addElement(new link(WebEnv.getBaseDirectory("js/zoomMenu.css"), link.REL_STYLESHEET, link.TYPE_CSS));//zoom

		doc.getHead().addElement(new script((Element)null, "js/window.js"));
		doc.getHead().addElement(new script((Element)null, "js/wmenu.js"));
		doc.getHead().addElement(new script((Element)null, "js/tigra_calculator/calculator.js"));

		doc.getHead().addElement(new link("js/yui_2.6.0/yui/build/menu/assets/skins/sam/menu.css", link.REL_STYLESHEET, link.TYPE_CSS));
		doc.getHead().addElement(new script((Element)null, "js/yui_2.6.0/yui/build/yahoo-dom-event/yahoo-dom-event.js"));
		doc.getHead().addElement(new script((Element)null, "js/yui_2.6.0/yui/build/container/container_core.js"));
		doc.getHead().addElement(new script((Element)null, "js/yui_2.6.0/yui/build/menu/menu.js"));

		doc.setClasses ("windowTable", "windowHeader");
//		doc.getTable().setCellSpacing(5); //clmg 2009/02/10
		return doc;
	}   //  createWindow
	
	/**
	 *  Create styled web Document with Title
	 *  @param title optional header title and h1 
	 *  @return Document
	 */
	//clmg
	public static WebDoc create (String title)
	{
		return create (false, title, false, null);
	}   //  create
	//
	
	public static WebDoc create (String title, HttpServletRequest request)
	{
		return create (false, title, false, request);
	}   //  create

	/** Non brealing Space					*/
	public static final String	NBSP	= "&nbsp;";
	
	
	/**************************************************************************
	 *  Create new XHTML Document structure
	 */
	private WebDoc ()
	{
	}   //  WDoc

	private html    m_html = new html();
	private head    m_head = new head();
	private body    m_body = new body();
	private table	m_table = null;
	private tr		m_topRow = null;
	private td		m_topRight = null;
	private td		m_topLeft = null;

	//
	private void setUp (boolean plain, boolean javaClient, String title, HttpServletRequest request)
	{
		m_html.addElement(m_head);
		m_html.addElement(m_body);
		//<body id="main">
		m_body.setID("main");
		if(request!=null){
			if(request.getAttribute("BODY_ID")!=null){
				m_body.setID((String)request.getAttribute("BODY_ID"));
				//menuの場合（実はログイン直後）
				if("menu".equals(request.getAttribute("BODY_ID"))){
					m_body.setOnLoad(getMenuOnLoadScript());
				}
			}
		}
		//clmg 2009/01/28
		div divSecond = null;
		if(request!=null){
			String secondDivId = (String)request.getAttribute("SECOND_DIV_ID");
			if(secondDivId!=null){
				divSecond = (div)new div().setID(secondDivId); //	<div id="login">
				m_body.addElement(divSecond);
			}
		}

		if(divSecond!=null){
			divSecond.addElement(new a().setName("top"));
		}else{
			m_body.addElement(new a().setName("top"));
		}
		//
		if (title != null)
			m_head.addElement(new title(title));
		if (plain)
			return;
		
		//	css, js
		if (javaClient)
			m_head.addElement(new link("http://www.compiere.org/standard.css", link.REL_STYLESHEET, link.TYPE_CSS));
		else
		{
//			m_head.addElement(new link(WebEnv.getStylesheetURL(), link.REL_STYLESHEET, link.TYPE_CSS)); //新しいデザインstandard.cssを使っていません。clmg 2009/02/10
			//m_head.addElement(new script((Element)null, WebEnv.getBaseDirectory("standard.js")));
			m_head.addElement(new script((Element)null, WebEnv.getBaseDirectory("js/standard.js")));
			//yahoo UI , modi by clmg
			m_head.addElement(new script((Element)null, WebEnv.getBaseDirectory("js/yui_2.6.0/yui/build/yahoo/yahoo.js")));
			m_head.addElement(new script((Element)null, WebEnv.getBaseDirectory("js/yui_2.6.0/yui/build/event/event.js")));
			m_head.addElement(new script((Element)null, WebEnv.getBaseDirectory("js/yui_2.6.0/yui/build/connection/connection.js")));
			//Hidden function
			m_head.addElement(new script((Element)null, WebEnv.getBaseDirectory("ajax/js/prototype-1.4.0.js")));
			//for zoom
			m_head.addElement(new script((Element)null, WebEnv.getBaseDirectory("js/zoomMenu.js")));
			//clean corresponding session entry before closing the window
			m_head.addElement(new script((Element)null, WebEnv.getBaseDirectory("js/session.js")));
			m_head.addElement(new script(getWindowOnUnloadScript()));
			
//			m_head.addElement(new link(WebEnv.getBaseDirectory("js/yui_2.6.0/yui/build/fonts/fonts-min.css"), link.REL_STYLESHEET, link.TYPE_CSS));
//			m_head.addElement(new link(WebEnv.getBaseDirectory("js/yui_2.6.0/yui/build/menu/assets/skins/sam/menu.css"), link.REL_STYLESHEET, link.TYPE_CSS));
//			m_head.addElement(new script((Element)null, WebEnv.getBaseDirectory("js/yui_2.6.0/yui/build/yahoo-dom-event/yahoo-dom-event.js")));
//			m_head.addElement(new script((Element)null, WebEnv.getBaseDirectory("js/yui_2.6.0/yui/build/container/container_core-min.js")));
//			m_head.addElement(new script((Element)null, WebEnv.getBaseDirectory("js/yui_2.6.0/yui/build/menu/menu-min.js")));
		
		}
		m_head.addElement(new meta().setHttpEquiv("Content-Type", "text/html; charset=UTF-8"));
		m_head.addElement(new meta().setName("description", "Compiere HTML UI"));

//		m_table = new table("0", "2", "0", "100%", null);	//	spacing 2 //clmg 2009/02/10
		m_table = new table("0", "0", "0", "100%", null);	//	spacing 0 //clmg 2009/02/10
		m_topRow = new tr();
		//	Title
		m_topLeft = new td().setColSpan(2);//clmg 2009/03/06
		m_topLeft.setClass("windowHeader");//clmg 2009/03/06
		if (title == null){
			m_topLeft.addElement(NBSP);
			m_topRow.addElement(m_topLeft);
		}
		else{
			//clmg
			//m_topLeft.addElement(new h1(title));
			div divHeader = (div)new div().setID("header"); //	<div id="header">
			divHeader.setStyle( "white-space: nowrap;" );
			//divHeader.addElement(new h1(title));
			//clmg
			if(request!=null && "menu".equals(request.getAttribute("BODY_ID"))){
				divHeader.addElement(new h1(title).setID("top"));
				p loginInfo = new p();
				loginInfo.setStyle( "padding:0px 0px 5px 0px" );
				loginInfo.setTagText((String)request.getAttribute("LOGIN_INFO"));
				divHeader.addElement(loginInfo);

				WebSessionCtx wsc = WebSessionCtx.get(request);


				img imageButton = new img( WebEnv.DIR_BASE + "/images/Multi16.png" );
				imageButton.setStyle( "border: solid 1px #e5e5e5;cursor: pointer;" );
				imageButton.setOnClick( "shotMenuControl();" );
				imageButton.setTitle( Msg.getMsg(wsc.ctx, "Multi") );
				divHeader.addElement( imageButton );

				input menuSearch = new input("text","menuSearch","");
				menuSearch.setID( "menuSearch" );
				menuSearch.setOnKeyPress("findMenu(event);");
				menuSearch.setStyle( "width:100px" );
				divHeader.addElement( Msg.translate(wsc.ctx, "TreeSearch") );
				divHeader.addElement( menuSearch );

				imageButton = new img( WebEnv.DIR_BASE + "/images/ExpandAll16.gif" );
				imageButton.setStyle( "border: solid 1px #e5e5e5;cursor: pointer;" );
				imageButton.setOnClick( "menuControl(true);" );
				imageButton.setTitle( Msg.getMsg(wsc.ctx, "ExpandTree") );
				divHeader.addElement( imageButton );

				imageButton = new img( WebEnv.DIR_BASE + "/images/CollapseAll16.gif" );
				imageButton.setStyle( "border: solid 1px #e5e5e5;cursor: pointer;" );
				imageButton.setOnClick( "menuControl(false);" );
				imageButton.setTitle( Msg.getMsg(wsc.ctx, "CollapseTree") );
				divHeader.addElement( imageButton );

			}else{
				divHeader.addElement(new h1(title));
			}
			//
			m_topLeft.addElement(divHeader);			
			m_topRow.addElement(m_topLeft);
//			divHeader.addElement(m_topLeft);			
//			m_topRow.addElement(divHeader);
			//
		}
			
		//m_topRow.addElement(m_topLeft);
		//	Logo
		m_topRight = new td().setAlign("right");
		m_topRight.setClass("windowHeader");//clmg 2009/03/06
		/** Removing/modifying the Compiere logo is a violation of the license	*/
		if (javaClient)
			m_topRight.addElement(new img("http://www.compiere.org/images/Compiere64x32.png")
				//	Changing the copyright notice in any way violates the license 
				//	and you'll be held liable for any damage claims
				.setAlign(AlignType.RIGHT).setAlt("&copy; Jorg Janke/Compiere"));
		else
			m_topRight.addElement(NBSP);
//			m_topRight.addElement(WebEnv.getLogo());
		{
//			td trLogo = new td(new img(WebEnv.getLogoURL())).setWidth(64);
//			td trProg = new td(makeAjaxProgressGIF(WebEnv.PROGRESS_ID,false)).setNoWrap(true)
//							.setVAlign(AlignType.MIDDLE);
//			tr trLP = new tr().addElement(trLogo).addElement(trProg);
//			table tableLP = new table().setWidth(81)
//							.setCellPadding(0).setCellSpacing(0).setBorder(0)
//							.addElement(trLP);
//			m_topRight.addElement(tableLP);
		}
//		m_topRow.addElement(m_topRight); //clmg 2009/03/06
		m_table.addElement(m_topRow);
		//clmg
		if(divSecond!=null){
			divSecond.addElement(m_table);
		}else{
			m_body.addElement(m_table);
		}
	}   //  setUp

	/**
	 * 	Set css Classes
	 *	@param tableClass optional class for table
	 *	@param tdClass optional class for left/right td
	 */
	public void setClasses (String tableClass, String tdClass)
	{
		if (m_table != null && tableClass != null)
			m_table.setClass(tableClass);
		if (m_topLeft != null && tdClass != null)
			m_topLeft.setClass(tdClass);
		if (m_topRight != null && tdClass != null)
			m_topRight.setClass(tdClass);
	}	//	setClasses

	
	/**
	 *  Get Body
	 *  @return Body
	 */
	public body getBody()
	{
		return m_body;
	}   //  getBody

	/**
	 *  Get Head
	 *  @return Header
	 */
	public head getHead()
	{
		return m_head;
	}   //  getHead

	/**
	 * 	Get Table (no class set)
	 *	@return table
	 */
	public table getTable()
	{
		return m_table;
	}	//	getTable

	/**
	 * 	Get Table Row (no class set)
	 *	@return table row
	 */
	public tr getTopRow()
	{
		return m_topRow;
	}	//	getTopRow
	/**
	 * 	Get Table Data Left (no class set)
	 *	@return table data
	 */
	public td getTopLeft()
	{
		return m_topLeft;
	}	//	getTopLeft
	
	/**
	 * 	Get Table Data Right (no class set)
	 *	@return table data
	 */
	public td getTopRight()
	{
		return m_topRight;
	}	//	getTopRight
	
	/**
	 *  String representation
	 *  @return String
	 */
	public String toString()
	{
		return m_html.toString();
	}   //  toString

	/**
	 *  Output Document
	 *  @param out out
	 */
	public void output (OutputStream out)
	{
		m_html.output(out);
	}   //  output

	/**
	 *  Output Document
	 *  @param out out
	 */
	public void output (PrintWriter out)
	{
		m_html.output(out);
	}   //  output

	/**
	 * 	Add Popup Center
	 * 	@param nowrap set nowrap in td
	 *	@return null or center single td
	 */
	public td addPopupCenter(boolean nowrap)
	{
		if (m_table == null)
			return null;
		//
		td center = new td ("popupCenter", AlignType.CENTER, AlignType.MIDDLE, nowrap);
		center.setColSpan(2);
		m_table.addElement(new tr()
			.addElement(center));
		return center;
	}	//	addPopupCenter

	/**
	 * 	Add Popup Close Footer
	 *	@return null or array with left/right td
	 */
	public td[] addPopupClose()
	{
		input button = WebUtil.createClosePopupButton(); 
		p buttonP = (p)new p().setClass("align-right");//clmg 2009/02/16
		buttonP.addElement(button);//clmg 2009/02/16
		if (m_table == null)
		{
			m_body.addElement(button);
			return null;
		}
		//
//		td left = new td(null, AlignType.LEFT, AlignType.MIDDLE, false, null);//clmg 2009/02/16
		td right = new td(null, AlignType.RIGHT, AlignType.MIDDLE, false, buttonP).setColSpan(2); //clmg 2009/02/16
		div msgDiv = (div) new div().setClass("topMsgLeft"); //clmg 2009/02/16
		msgDiv.addElement(new tr()//clmg 2009/02/16
			//.addElement(left)
			.addElement(right));
		m_table.addElement(msgDiv);//clmg 2009/02/16
//		return new td[] {left, right};
		return new td[] { right};//clmg 2009/02/24
	}	//	addPopupClose
	

	/**
	 * 	Add Window Center
	 * 	@param nowrap set nowrap in td
	 *	@return empty single center td
	 */
	public td addWindowCenter(boolean nowrap)
	{
		if (m_table == null)
			return null;
		//
		td center = new td ("windowCenter", AlignType.CENTER, AlignType.MIDDLE, nowrap);
		center.setColSpan(2);
		m_table.addElement(new tr()
			.addElement(center));
		return center;
	}	//	addWindowCenter
	
	/**
	 * 	Add Window Center//clmg 2009/02/11
	 * 	@param nowrap set nowrap in td
	 *	@return empty single center td
	 */
	public td addTd(){
		return addTd(1);
	}
	public td addTd(int colSpan)
	{
		if (m_table == null)
			return null;
		//
		td newTd = new td ().setColSpan(colSpan);
		m_table.addElement(new tr()
			.addElement(newTd));
		return newTd;
	}	//	addWindowCenter

	/**
	 * 	Add Window Footer
	 *	@return null or array with empty left/right td
	 */
	public td[] addWindowFooters()
	{
		if (m_table == null)
			return null;
		//
		td left = new td("windowFooter", AlignType.LEFT, AlignType.MIDDLE, false);
		td right = new td("windowFooter", AlignType.RIGHT, AlignType.MIDDLE, false); 
		m_table.addElement(new tr()
			.addElement(left)
			.addElement(right));
		return new td[] {left, right};
	}	//	addWindowFooters

	/**
	 * 	Add Window Footer
	 *	@return empty single center td
	 */
	public td addWindowFooter()
	{
		if (m_table == null)
			return null;
		//
		td center = new td("windowFooter", AlignType.CENTER, AlignType.MIDDLE, false);
		m_table.addElement(new tr()
			.addElement(center));
		return center;
	}	//	addWindowFooter
	
	/**************************************************************************
	 *  Test Class
	 *  @param args args
	 */
	public static void main (String[] args)
	{
		WebDoc doc = WebDoc.create("Test");
		doc.getBody().addElement(new b("111 <<< >>> &&& \\\\ \u0100 �"));
		form f = new form("myaction");
		f.addElement(new input());
		doc.getBody().addElement(f);
	}   //  main
	
	public static String makeAjaxProgressGIF(String pID,boolean hasImg4NN) {
		StringBuffer rtVal = new StringBuffer();
		img img = new img().setSrc(WebEnv.getBaseDirectory("ajax/img/indicator.gif"));
		img.setID("progress"+pID);
		img.setStyle("display:none;");
		if (hasImg4NN){
			img img4NN = new img().setSrc(WebEnv.getBaseDirectory("ajax/img/h.gif"));
			rtVal.append(img4NN).append(img);
		}else{
			rtVal.append(img);			
		}
		return rtVal.toString();
	}	//	makeAjaxProgressGIF
	
	/**
	 * var iframe = document.getElementById("WWindow");
		iframe.src = "start.html";
	 * @return
	 */
	public static String getMenuOnLoadScript() {
		StringBuffer sb = new StringBuffer();
		//sb.append( "alert(window.frames[\"WWindow']); alert('frames='+window.frames); alert(window.frames[1]); window.frames['WWindow'].location.href='start.html'");
		
		// 2010.03.12 siqin start
		// sb.append( "top.frames['WWindow'].location.href='start.html';");
		sb.append( "top.frames['WWindow'].location.href='/compiere/ampiere/WPerformanceMeter';");
		// 2010.03.12 siqin end
		return sb.toString();
	}
	
	public static String getWindowOnUnloadScript() {
		StringBuffer sb = new StringBuffer();
		sb.append( "window.onunload =makeSessionCleanRequest;");
		return sb.toString();
	}

}   //  WDoc
