/******************************************************************************
 * The contents of this file are subject to the   Compiere License  Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * You may obtain a copy of the License at http://www.compiere.org/license.html
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is Compiere ERP & CRM Smart Business Solution. The Initial
 * Developer of the Original Code is Jorg Janke. Portions created by Jorg Janke
 * are Copyright (C) 1999-2005 Jorg Janke.
 * All parts are Copyright (C) 1999-2005 ComPiere, Inc.  All Rights Reserved.
 * Contributor(s): ______________________________________.
 *****************************************************************************/

package org.compiere.install;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;

import java.util.logging.Level;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Ini;

/**
 *	DB Spec Export.
 *
 * 	@author 	Jirimuto
 * 	@version 	$Id: DBExportTrl.java,v 1.3 2009/08/25 05:57:37 siqin Exp $
 */
public class DBExportTrl {
	
	private CLogger	 log = CLogger.getCLogger(getClass());
	
public void export(String directory, int AD_Client_ID, String AD_Language, String Trl_Table) {
	
	String FilePath=directory;
	int Data_Precision=0;
	int Data_Length=0;
	String OldTable="";
	String Help="";
	String Name="";
	String Name_Trl="";
	String Description="";
	String Data_Type="";
	String ColumnName="";
	String NullAble="";
	String Key="";
	String TableName="";
	String Table_Name="";
	int C_Coulumn_ID = 0;
	
	StringBuffer sql = new StringBuffer("SELECT ");
	sql.append("t.TABLENAME, ");
	sql.append("tt.NAME AS TABLE_NAME, ");
	sql.append("c.COLUMNNAME, ");
	sql.append("atc.DATA_TYPE, ");
	sql.append("c.NAME, ");
	sql.append("ct.NAME as name_trl, ");
	sql.append("atc.DATA_LENGTH, ");
	sql.append("atc.DATA_PRECISION,  ");
	sql.append("atc.NULLABLE, ");
	sql.append("c.ISKEY, ");
	sql.append("aet.DESCRIPTION, ");
	sql.append("aet.HELP, ");
	sql.append("c.AD_COLUMN_ID ");
	sql.append("FROM AD_COLUMN c ");
	sql.append("INNER JOIN AD_COLUMN_TRL ct ON ( c.AD_COLUMN_ID = ct.AD_COLUMN_ID) ");
	sql.append("INNER JOIN AD_TABLE t on ( c.AD_TABLE_ID = t.AD_TABLE_ID) ");
	sql.append("INNER JOIN AD_TABLE_TRL tt on ( t.AD_TABLE_ID = tt.AD_TABLE_ID) ");
	sql.append("INNER JOIN AD_ELEMENT_TRL aet on ( c.AD_ELEMENT_ID = aet.AD_ELEMENT_ID) ");
	sql.append("LEFT JOIN SYS.USER_TAB_COLUMNS atc ON ( ");
	sql.append("UPPER(c.COLUMNNAME) = atc.COLUMN_NAME and atc.TABLE_NAME=UPPER(t.TABLENAME)) ");
	sql.append("WHERE  ct.AD_LANGUAGE=aet.AD_LANGUAGE and ct.AD_LANGUAGE=tt.AD_LANGUAGE and ct.AD_LANGUAGE=? AND t.ISVIEW='N' ");	
	if ( Trl_Table !=null && !"".equals(Trl_Table)) {
		sql.append(" AND t.TABLENAME= '");
		sql.append(Trl_Table);
		sql.append( "' ");
	}
	if ( AD_Client_ID !=-1) {
		sql.append("AND c.AD_Client_ID= ");
		sql.append(AD_Client_ID);
		sql.append( " ");
	}
	sql.append("ORDER BY t.TABLENAME, c.AD_COLUMN_ID ");
	
	String filename = FilePath+File.separator+"Compiere_"+AD_Language+".xls";
	POIFSFileSystem POIfs = null;
	HSSFWorkbook HSSFwb  = null;
	
	int tableCount = 0;
	
	PreparedStatement pstmt = null;
    try
    {
        pstmt = DB.prepareStatement (sql.toString(), null);
        pstmt.setString(1, AD_Language);
        ResultSet rs = pstmt.executeQuery ();
        
        if( POIfs == null ){
        	
        	createFile(filename);
        		
        	POIfs = new POIFSFileSystem(new FileInputStream(filename));
    		HSSFwb = new HSSFWorkbook(POIfs);
    		
        }
        
        while (rs.next ()) {
            TableName = rs.getString(1);
            Table_Name = rs.getString(2);
            ColumnName = rs.getString(3);
            Data_Type = rs.getString(4);
            Name = rs.getString(5);
            Name_Trl = rs.getString(6);
            Data_Length = rs.getInt(7);
            Data_Precision = rs.getInt(8);
            NullAble = rs.getString(9);
            Key = rs.getString(10);
            Description = rs.getString(11);
            Help = rs.getString(12);
            C_Coulumn_ID = rs.getInt(13);
            
        	if ( !TableName.equals(OldTable)) {
        		log.info("TableName: "+TableName);
	        	tableCount++;
	        	if( tableCount%128==0 ){
	        		try {
	        			HSSFwb.removeSheetAt(0);
	        			// Write the output to a file
	        			FileOutputStream fileOut = new FileOutputStream(filename);
	        			HSSFwb.write(fileOut);
	        			fileOut.close();
	        		} catch ( Exception e ){
	        			log.log(Level.SEVERE, "", e);
	        		}
	        		POIfs = null;
	        		HSSFwb = null;
	        		int filenum = tableCount/128;
	        		filename = FilePath+File.separator+"Compiere_"+AD_Language+"_"+filenum+".xls";	        		
	            	createFile(filename);
	            		
	            	POIfs = new POIFSFileSystem(new FileInputStream(filename));
	        		HSSFwb = new HSSFWorkbook(POIfs);
	        		
	        	}
	        	title(HSSFwb, TableName, Table_Name);
	        	OldTable=TableName;
        	}
    		log.info("ColumnName: "+ColumnName);
        	insert(HSSFwb, TableName, C_Coulumn_ID, ColumnName, Data_Type, Name, Name_Trl, Data_Length, Data_Precision, NullAble, Key, Description, Help);
        }
        
    }
	catch (SQLException e)
	{
		log.log(Level.SEVERE, sql.toString(), e);
	}
	catch (Exception e)
	{
		log.log(Level.SEVERE, "", e);
	}
	
	if( POIfs!=null && HSSFwb != null ){
		try {
			HSSFwb.removeSheetAt(0);
			// Write the output to a file
			FileOutputStream fileOut = new FileOutputStream(filename);
			HSSFwb.write(fileOut);
			fileOut.close();
		} catch ( Exception e ){
			log.log(Level.SEVERE, "", e);
		}
	}
}

private void createFile(String filename) throws Exception {
	String startDir = Ini.getCompiereHome() + File.separator + "data"+File.separator+"export";
	POIFSFileSystem fs =
        new POIFSFileSystem(new FileInputStream(startDir+File.separator+"DBEXPORTTEMPLATE_TRL.xls"));
	    HSSFWorkbook wb = new HSSFWorkbook(fs);
	    wb.setSheetName(0, "TempleteSheet");
	    HSSFSheet sheet = wb.getSheetAt(0);
	    HSSFCellStyle style = wb.createCellStyle();
	    // Create a row and put some cells in it. Rows are 0 based.
	    HSSFRow row = sheet.createRow((short) 2);
	    HSSFCell cell = row.createCell((short) 3);
	    cell.setCellValue("TempleteSheet");
	    cell.setCellStyle(style);
	    style.setDataFormat(HSSFDataFormat.getBuiltinFormat("m/d/yy"));
	    row = sheet.getRow((short) 0);
	    cell = row.createCell((short)10, HSSFCellStyle.ALIGN_LEFT);
	    cell.setCellValue(new Date());
	    style.setAlignment(HSSFCellStyle.ALIGN_LEFT);
	    style.setBorderBottom(HSSFCellStyle.BORDER_THIN);
	    style.setBorderLeft(HSSFCellStyle.BORDER_THIN);
	    style.setBorderRight(HSSFCellStyle.BORDER_THIN);
	    style.setBorderTop(HSSFCellStyle.BORDER_THIN);

	    cell.setCellStyle(style);
	    
		// Write the output to a file
		FileOutputStream fileOut = new FileOutputStream(filename);
		wb.write(fileOut);
		fileOut.close();
		
}

public void title(HSSFWorkbook wb, String tableName, String table_Name) throws Exception {
		
		HSSFSheet sheet = wb.cloneSheet(0);
		int sheetno = wb.getNumberOfSheets();
	    wb.setSheetName((sheetno-1), tableName);
	    HSSFCellStyle style = wb.createCellStyle();
	    // Create a row and put some cells in it. Rows are 0 based.
	    HSSFRow row = sheet.createRow((short) 2);
	    HSSFCell cell = row.createCell((short) 3);
	    cell.setCellValue(tableName);
	    cell.setCellStyle(style);
	    
	    row = sheet.createRow((short) 3);
	    cell = row.createCell((short) 4);
        cell.setCellType(HSSFCell.CELL_TYPE_STRING);
//	    cell.setEncoding(HSSFCell.ENCODING_UTF_16);
	    cell.setCellValue(table_Name);
	    cell.setCellStyle(style);
	    
	    style.setDataFormat(HSSFDataFormat.getBuiltinFormat("m/d/yy"));
	    row = sheet.getRow((short) 0);
	    cell = row.createCell((short)10, HSSFCellStyle.ALIGN_LEFT);
	    cell.setCellValue(new Date());
	    style.setAlignment(HSSFCellStyle.ALIGN_LEFT);
	    style.setBorderBottom(HSSFCellStyle.BORDER_THIN);
	    style.setBorderLeft(HSSFCellStyle.BORDER_THIN);
	    style.setBorderRight(HSSFCellStyle.BORDER_THIN);
	    style.setBorderTop(HSSFCellStyle.BORDER_THIN);

	    cell.setCellStyle(style);

	  }
  
  public void insert(HSSFWorkbook wb, String tableName, int C_Coulumn_ID, String ColumnName, String Dsta_Type, String Name, String Japanese_Name, double Dsta_Length, double Data_Precision, String NullAble, String Key, String Description, String Help) throws Exception {
	    HSSFSheet sheet = wb.getSheet(tableName);
	    HSSFCellStyle style = wb.createCellStyle();
	    if( C_Coulumn_ID > 1000000 ){
	    	style.setFillForegroundColor(HSSFColor.RED.index);
	    	style.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	    }
	    // Create a row and put some cells in it. Rows are 0 based.
	    for(int j=6; j<65536; j++){
	    HSSFRow row = sheet.getRow((short) j);
	    if (row==null){
		   	row = sheet.createRow( (short) j);	
		    HSSFCell cell = row.createCell((short) 0, HSSFCellStyle.VERTICAL_TOP);
		    cell.setCellValue(j-5);
		    style.setVerticalAlignment(HSSFCellStyle.VERTICAL_TOP);
		    style.setBorderBottom(HSSFCellStyle.BORDER_THIN);
		    style.setBorderLeft(HSSFCellStyle.BORDER_THIN);
		    style.setBorderRight(HSSFCellStyle.BORDER_THIN);
		    style.setBorderTop(HSSFCellStyle.BORDER_THIN);
		    cell.setCellStyle(style);
		    cell = row.createCell((short) 1);
		    cell.setCellValue(ColumnName);
		    cell.setCellStyle(style);
		    cell = row.createCell((short) 2);
		    cell.setCellValue(Dsta_Type);
		    cell.setCellStyle(style);
		    cell = row.createCell((short) 3);
		    cell.setCellValue(Name);
		    cell.setCellStyle(style);
		    cell = row.createCell((short) 4);
	        cell.setCellType(HSSFCell.CELL_TYPE_STRING);
//		    cell.setEncoding(HSSFCell.ENCODING_UTF_16);
		    cell.setCellValue(Japanese_Name);
		    cell.setCellStyle(style);
		    cell = row.createCell((short) 5);
		    cell.setCellValue(Dsta_Length);
		    cell.setCellStyle(style);
		    cell = row.createCell((short) 6);
		    cell.setCellValue(Data_Precision);
		    cell.setCellStyle(style);
		    cell = row.createCell((short) 7);
		    cell.setCellValue(NullAble);
		    cell.setCellStyle(style);
		    cell = row.createCell((short) 8);
		    cell.setCellValue(Key);
		    cell.setCellStyle(style);
		    cell = row.createCell((short) 9);
	        cell.setCellType(HSSFCell.CELL_TYPE_STRING);
//		    cell.setEncoding(HSSFCell.ENCODING_UTF_16);
		    cell.setCellValue(Description);
		    style.setWrapText( true );
		    cell.setCellStyle(style);
		    sheet.setColumnWidth( (short) 9, (short) 5000 );
		    cell = row.createCell((short) 10);
	        cell.setCellType(HSSFCell.CELL_TYPE_STRING);
//		    cell.setEncoding(HSSFCell.ENCODING_UTF_16);
		    cell.setCellValue(Help);
		    style.setWrapText( true );
		    cell.setCellStyle(style);
		    sheet.setColumnWidth( (short) 10, (short) 10000 );
		    style.setVerticalAlignment(HSSFCellStyle.VERTICAL_TOP);
		    
		    return;
	  }
    }
  }
}
/* end. */
