/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.jasperreport;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;

import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;

import org.compiere.apps.ADialog;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

/**
 *	Application Zoom Across Launcher.
 *  Called from APanel; Queries available Zoom Targets for Table.
 *	
 *  @author SiqinBilige
 *  @version $Id: AJasperReport.java,v 1.4 2010/03/03 01:57:39 siqin Exp $
 */
public class AJasperReport implements ActionListener {
	
	/**	Logger			*/
	private static CLogger log = CLogger.getCLogger(AJasperReport.class);

	/**	The Popup						*/
	private JPopupMenu 	m_popup = new JPopupMenu("ZoomMenu");

	/**	The Option List					*/
	private ArrayList<KeyNamePair>	m_list = new ArrayList<KeyNamePair>();

	/** Record ID */
	private int recordId;
	
	/**
	 *	Constructor
	 *  @param invoker component to display popup (optional)
	 *  @param tableName table name
	 *  @param query query
	 */
	public AJasperReport (JComponent invoker, int tableId, int recortId)
	{
		this.recordId = recortId;
		
		getJasperReports (invoker,tableId);
	}	//	AJasperReport

	/**
	 * 	Get the JasperReports List
	 *  Fill the list and the popup menu
	 *  @param invoker component to display popup (optional)
	 * 	@param AD_Table_ID table ID
	 */
	private void getJasperReports (JComponent invoker, int tableId) {
		String sql = MRole.getDefault().addAccessSQL(
			"SELECT AD_JasperFormat_ID, Name, Description "
				+ "FROM AD_JasperFormat "
				+ "WHERE AD_Table_ID=? AND IsActive='Y' "
				+ "ORDER BY Name",
			null, MRole.SQL_NOTQUALIFIED, MRole.SQL_RO);
		try
		{
			PreparedStatement pstmt = DB.prepareStatement(sql, null);
			pstmt.setInt (1, tableId);
			ResultSet rs = pstmt.executeQuery();
			while (rs.next()) {
				int key = rs.getInt(1);
				String name = rs.getString(2);
				m_list.add( new KeyNamePair( key, name));
				final JMenuItem mi = m_popup.add(name);
				mi.addActionListener(this);
			}
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			log.log(Level.SEVERE, sql, e);
		}

		//	No JasperReports
		if (m_list.size() == 0)
		{
			ADialog.info(0, invoker, "NoJasperReports");
		}
		else if (invoker.isShowing())
			m_popup.show(invoker, 0, invoker.getHeight());	//	below button
	}	//	getJasperReports
 

	/**
	 * 	Action Listener
	 * 	@param e event
	 */
	public void actionPerformed(ActionEvent e)
	{
		m_popup.setVisible(false);
		String cmd = e.getActionCommand();
		for (int i = 0; i < m_list.size(); i++)
		{
			KeyNamePair pp = (KeyNamePair)m_list.get(i);
			if (cmd.equals(pp.getName()))
			{
				launchJasperReport (pp);
				return;
			}
		}
	}	//	actionPerformed
	
	/**
	 * 	Launch JasperReport
	 *	@param pp KeyPair
	 */
	private void launchJasperReport (KeyNamePair pp) {

		String fileName = JasperUtils.toJasperXML(pp.getKey());
		if ( fileName != null ) {
			HashMap<String,Object> param = new HashMap<String,Object>();
			param.put( "RECORD_ID", this.recordId );
			param.put( "SUBREPORT_DIR", JasperUtils.JASPERREPORT_PATH );
			try {
		    	JasperReport jasperReport = (JasperReport)JRLoader.loadObject ( fileName );
				SwingJRViewerProvider viewer = new SwingJRViewerProvider();
		    	viewer.openViewer(JasperFillManager.fillReport( jasperReport, param, DB.getConnectionRO()), Msg.getMsg( Env.getCtx(), "JasperReportViewer" ) );
			} catch (Exception e) {
				log.log(Level.SEVERE, "RecordId="+pp.getKey() + ",name=" + pp.getName(), e);
			}
		}

	}	//	launchJasperReport
	
}	//	AJasperReport
