package org.compiere.jasperreport;

import java.io.File;
import java.util.logging.Level;

import org.compiere.model.MAttachment;
import org.compiere.model.MTable;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class JasperUtils {

	/**	Logger			*/
	private static CLogger log = CLogger.getCLogger(JasperUtils.class);
	
	public static final String JASPERREPORT_PATH = System.getProperty("java.io.tmpdir");

	/**
	 * create jasper xml file from AD_Jasperfomat(AD_ATTACHMENT)
	 * @param recordId AD_Jasperfomat_ID
	 * @return jasper xml file name
	 */
	public static String toJasperXML ( int recordId ) {
		String mainFileName = null;
		MTable table = MTable.get( Env.getCtx(), "AD_Jasperformat" );
		if ( table != null ) {
			int id = table.getAD_Table_ID();
			if ( id > 0 ) {
				MAttachment attachment = MAttachment.get( Env.getCtx(), id, recordId );
				for (int i = 0; i < attachment.getEntryCount(); i++) {
					try {
						String subFileName = JASPERREPORT_PATH + attachment.getEntryName(i);
						if ( i == 0 ) {
							mainFileName = subFileName;
						}
						File aFile = attachment.getEntryFile(i, subFileName);
						aFile.deleteOnExit();
					} catch (Exception e) {
						log.log(Level.SEVERE, "", e);
					}
				}
			}
		}
		return mainFileName;
	}
}
