/*
 * Class JasperViewer.
 */
package org.compiere.jasperreport;

import java.awt.BorderLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;

import org.compiere.db.CConnection;


public class JasperViewer extends javax.swing.JFrame {

	private static final long serialVersionUID = 1192807883081180999L;
	
	private String m_title;
	
    /** Creates new form JasperViewer */
    /**
     * @param jasperPrint report to display
     * @param frameTitle Title to be displayed
     * @throws JRException
     */
    protected JasperViewer(JasperPrint jasperPrint,String frameTitle) throws JRException {
        this.m_title = frameTitle;
    	initComponents();
        JasperReportViewer viewer = new JasperReportViewer(this, jasperPrint);
        this.pnlMain.add(viewer, BorderLayout.CENTER);
    }


    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents()//GEN-BEGIN:initComponents
    {
        pnlMain = new javax.swing.JPanel();

        setTitle(m_title);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm();
            }
        });
        addKeyListener( new KeyAdapter() {
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == KeyEvent.VK_ESCAPE) exitForm();
            }

            public void keyTyped(KeyEvent event) {
                super.keyTyped(event);
            }
        });

        pnlMain.setLayout(new java.awt.BorderLayout());

        getContentPane().add(pnlMain, java.awt.BorderLayout.CENTER);

        pack();
        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setSize(new java.awt.Dimension(750, 550));
        setLocation((screenSize.width - 750) / 2, (screenSize.height - 550) / 2);
    }//GEN-END:initComponents

    /** Exit the Application */
    private void exitForm() {//GEN-FIRST:event_exitForm
    	setVisible(false);
        dispose();
    }//GEN-LAST:event_exitForm


    /**
     *
     */
    public static void viewReport(JasperPrint jasperPrint) throws JRException {
        JasperViewer jasperViewer = new JasperViewer(jasperPrint,"JasperReport");
        jasperViewer.setVisible(true);
    }
    public static void viewReport(JasperPrint jasperPrint,String frameTitle) throws JRException {
        JasperViewer jasperViewer = new JasperViewer(jasperPrint,frameTitle);
        jasperViewer.setVisible(true);
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel pnlMain;
    // End of variables declaration//GEN-END:variables

    /**
	* @param args the command line arguments
	*/
	public static void main(String args[]) {
        try {
        	JasperReport myjasperReport = (JasperReport) JasperCompileManager.compileReport(args[0] );
        	JasperPrint myjasperPrint = JasperFillManager.fillReport( myjasperReport, new HashMap(), getConnection());
            JasperViewer.viewReport(myjasperPrint);
           } 
        catch (Exception e) {
            e.printStackTrace();
        }
    }

	public static Connection getConnection(String args[])
	{
		CConnection compiereConnection = CConnection.get();
		
        try {
        	if (compiereConnection.isOracle())
        		DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());
        	if (compiereConnection.isPostgreSQL())
        		DriverManager.registerDriver(new org.postgresql.Driver());
//        	if (compiereConnection.isSybase())
        		//DriverManager.registerDriver(new com.sybase.jdbc3.jdbc.SybDriver());
//        		DriverManager.registerDriver(new net.sourceforge.jtds.jdbc.Driver());
        	
            //this is for test only
            return DriverManager.getConnection(args[1], args[2], args[3]);
        } catch (SQLException e) {
            e.printStackTrace();
            return null;
        }		
	}
    public static Connection getConnection() {
        try {
            DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());
            //this is for test only prefer testingby calling org.compiere.report.JaserViewer JDBC_CONNECTION JDBC_USER JDBC_PASS
            return DriverManager.getConnection("jdbc:oracle:thin:@abalone.lesmuids.com:1521:abalone", "adempiere", "adempiere");
        } catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

}
