/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.pos;

import java.awt.*;
import java.awt.event.*;
import java.math.BigDecimal;

import javax.swing.border.*;

import org.compiere.grid.ed.*;
import org.compiere.model.MOrder;
import org.compiere.process.DocAction;
import org.compiere.swing.*;
import org.compiere.util.*;


/**
 *	POS Checkout Sub Panel
 *	
 *  @author Jorg Janke
 *  @version $Id: SubCheckout.java,v 1.3 2009/08/20 14:40:20 jrmt Exp $
 */
public class SubCheckout extends PosSubPanel implements ActionListener
{
	/**
	 * 	Constructor
	 *	@param posPanel POS Panel
	 */
	public SubCheckout (PosPanel posPanel)
	{
		super (posPanel);
	}	//	PosSubCheckout
	
	private CButton f_register;
	private CButton f_summary;
	private CButton f_process;
	private CButton f_print;

	private CLabel f_lcreditCardNumber;
	private CTextField f_creditCardNumber;
	private CLabel f_lcreditCardExp;
	private CTextField f_creditCardExp;
	private CLabel f_lcreditCardVV;
	private CTextField f_creditCardVV;
	private CButton f_creditPayment;

	private CLabel f_lDocumentNo;
	private CTextField f_DocumentNo;
	private CLabel f_lcashGiven;
	private VNumber f_cashGiven;
	private CLabel f_lcashReturn;
	private VNumber f_cashReturn;
	private CButton f_cashPayment;
	
	/**	Logger			*/
	private static CLogger log = CLogger.getCLogger(SubCheckout.class);
	
	/**
	 * 	Initialize
	 */
	public void init()
	{
		//	Title
		TitledBorder border = new TitledBorder(Msg.getMsg(Env.getCtx(), "Checkout"));
		setBorder(border);
		
		//	Content
		setLayout(new GridBagLayout());
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.insets = INSETS2;
		
		//	--	0
		gbc.gridx = 0;
		f_register = createButtonAction("Register", null);
		gbc.gridy = 0;
		add (f_register, gbc);
		//
		f_summary = createButtonAction("Summary", null);
		gbc.gridy = 1;
		add (f_summary, gbc);
		//
		f_process = createButtonAction("Process", null);
		gbc.gridy = 2;
		add (f_process, gbc);
		//
		f_print = createButtonAction("Print", null);
		gbc.gridy = 3;
		add (f_print, gbc);

		//	--	1 -- Cash 
		gbc.gridx = 1;
		gbc.gridheight = 2;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.weightx = .1;
		CPanel cash = new CPanel(new GridBagLayout());
		cash.setBorder(new TitledBorder(Msg.getMsg(Env.getCtx(), "Cash")));
		gbc.gridy = 0;
		add (cash, gbc);
		GridBagConstraints gbc0 = new GridBagConstraints();
		gbc0.insets = INSETS2;
		gbc0.anchor = GridBagConstraints.WEST;
		
		f_lDocumentNo = new CLabel(Msg.getMsg(Env.getCtx(),"DocumentNo"));
		cash.add (f_lDocumentNo, gbc0);
		f_DocumentNo = new CTextField("");
		f_DocumentNo.setPreferredSize(new Dimension(160,20));
		f_DocumentNo.setName("DocumentNo");
		cash.add (f_DocumentNo, gbc0);
		//
		f_lcashGiven = new CLabel(Msg.getMsg(Env.getCtx(),"CashGiven"));
		cash.add (f_lcashGiven, gbc0);
		f_cashGiven = new VNumber("CashGiven", false, false, true, DisplayType.Amount, 
			Msg.translate(Env.getCtx(), "CashGiven"));
		f_cashGiven.setColumns(10, 25);
		f_cashGiven.addActionListener(this);
		cash.add (f_cashGiven, gbc0);
		f_cashGiven.setValue(Env.ZERO);
		//
		f_lcashReturn = new CLabel(Msg.getMsg(Env.getCtx(),"CashReturn"));
		cash.add (f_lcashReturn, gbc0);
		f_cashReturn = new VNumber("CashReturn", false, true, false, DisplayType.Amount, 
			"CashReturn");
		f_cashReturn.setColumns(10, 25);
		cash.add (f_cashReturn, gbc0);
		f_cashReturn.setValue(Env.ZERO);
		//
		f_cashPayment = createButtonAction("Payment", null);
		f_cashPayment.setActionCommand("Cash");
		gbc0.anchor = GridBagConstraints.EAST;
		gbc0.weightx = 0.1;
		cash.add (f_cashPayment, gbc0);
		
		//	--	1 -- Creditcard 
		CPanel creditcard = new CPanel(new GridBagLayout());
		creditcard.setBorder(new TitledBorder(Msg.translate(Env.getCtx(), "CreditCardType")));
		gbc.gridy = 2;
		add (creditcard, gbc);
		GridBagConstraints gbc1 = new GridBagConstraints();
		gbc1.insets = INSETS2;
		gbc1.anchor = GridBagConstraints.WEST;
		
		gbc1.gridx = 0;
		gbc1.gridy = 0;
		f_lcreditCardNumber = new CLabel(Msg.translate(Env.getCtx(), "CreditCardNumber"));
		creditcard.add (f_lcreditCardNumber, gbc1);
		gbc1.gridy = 1;
		f_creditCardNumber = new CTextField(18); 
		creditcard.add (f_creditCardNumber, gbc1);
		gbc1.gridx = 1;
		gbc1.gridy = 0;
		f_lcreditCardExp = new CLabel(Msg.translate(Env.getCtx(),"CreditCardExp"));
		creditcard.add (f_lcreditCardExp, gbc1);
		gbc1.gridy = 1;
		f_creditCardExp = new CTextField(5); 
		creditcard.add (f_creditCardExp, gbc1);
		gbc1.gridx = 2;
		gbc1.gridy = 0;
		f_lcreditCardVV = new CLabel(Msg.translate(Env.getCtx(), "CreditCardVV"));
		creditcard.add (f_lcreditCardVV, gbc1);
		gbc1.gridy = 1;
		f_creditCardVV = new CTextField(5); 
		creditcard.add (f_creditCardVV, gbc1);
		//
		gbc1.gridx = 3;
		gbc1.gridy = 0;
		gbc1.gridheight = 2;
		f_creditPayment = createButtonAction("Payment", null);
		f_creditPayment.setActionCommand("CreditCard");
		gbc1.anchor = GridBagConstraints.EAST;
		gbc1.weightx = 0.1;
		creditcard.add (f_creditPayment, gbc1);
		
		
	}	//	init
	
	/**
	 * 	Get Panel Position
	 */
	public GridBagConstraints getGridBagConstraints()
	{
		GridBagConstraints gbc = super.getGridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 3;
		return gbc;
	}	//	getGridBagConstraints
	
	/**
	 * 	Dispose - Free Resources
	 */
	public void dispose()
	{
		super.dispose();
	}	//	dispose

	/**
	 * 	Action Listener
	 *	@param e event
	 */
	public void actionPerformed (ActionEvent e)
	{
		String action = e.getActionCommand();		
		if (action == null || action.length() == 0)
			return;
		log.info( "PosSubCheckout - actionPerformed: " + action);
		
		//	Summary
		if (action.equals("Summary"))
		{
			displaySummary();			
		}
		else if (action.equals("Process"))
		{
			if (isOrderFullyPay())
			{
				MOrder order = p_posPanel.f_currentLine.getOrder();
				order.setPaymentRule(MOrder.PAYMENTRULE_Cash);	
				if( order.save() ){
					displaySummary();
					//Check if order is completed, if so, print and open drawer, create an empty order and set cashGiven to zero
					if(processOrder())
					{
						printTicket();
						openCashDrawer();
						p_posPanel.newOrder();
						p_posPanel.updateInfo();
						f_cashGiven.setValue(Env.ZERO);
					}
				}			
			}
			else
			{
				p_posPanel.f_status.setStatusLine("PAYMENT NOT FULL.");
			}
		}
		//	Print
		else if (action.equals("Print"))
		{
			if (isOrderFullyPay())
			{
				displaySummary();
				printTicket();
				openCashDrawer();
			}
			else
			{
				p_posPanel.f_status.setStatusLine("Order not fully paid.");
			}
		}
		//	Cash (Payment)
		else if (action.equals("Cash"))
		{
			MOrder order = p_posPanel.f_currentLine.getOrder();
			order.setPaymentRule(MOrder.PAYMENTRULE_Cash);	
			if( order.save() ){
				displayReturn();			
				openCashDrawer();
			}
		}
		else if (e.getSource() == f_cashGiven)
			displayReturn();
		
		//	CreditCard (Payment)
		else if (action.equals("CreditCard"))
		{
			MOrder order = p_posPanel.f_currentLine.getOrder();
			order.setPaymentRule(MOrder.PAYMENTRULE_CreditCard);
			if( order.save() ){
				displayReturn();			
			}
			log.info("CreditCard");
		}  
		
		p_posPanel.updateInfo();
	}	//	actionPerformed

	private void displaySummary() {
		p_posPanel.f_status.setStatusLine(p_posPanel.f_currentLine.getOrder().getSummary());
		displayReturn();
	}

	/**
	 * 	Process Order
	 */
	public boolean processOrder()
	{		
		//Returning orderCompleted to check for order completness
		boolean orderCompleted = false;
		p_posPanel.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
		MOrder order = p_posPanel.f_currentLine.getOrder();
		if (order != null)
			// check if order completed OK
			if (order.getDocStatus().equals("DR") )
			{ 
				order.setDocAction(DocAction.ACTION_Complete);
				try
				{
					if (order.processIt(DocAction.ACTION_Complete) )
					{
						order.save();
					}
					else
					{
						log.info( "SubCheckout - processOrder FAILED");	
						p_posPanel.f_status.setStatusLine("Order can not be completed.");				
					}
				}
				catch (Exception e)
				{
					log.severe("Order can not be completed - " + e.getMessage());
					p_posPanel.f_status.setStatusLine("Error when processing order.");
				}
				finally
				{ // When order failed convert it back to draft so it can be processed
				  if( order.getDocStatus().equals("IN") )
				  {
					order.setDocStatus("DR");
				  }
				  else if( order.getDocStatus().equals("CO") )
				  {
					order = null;
					orderCompleted = true;
					//p_posPanel.newOrder();
					//f_cashGiven.setValue(Env.ZERO);
					log.info( "SubCheckout - processOrder OK");
					p_posPanel.f_status.setStatusLine("Order completed.");	 
				  }			
				  else
				  {
					log.info( "SubCheckout - processOrder - unrecognized DocStatus");
					p_posPanel.f_status.setStatusLine("Orden was not completed correctly.");	 
				  }					
				} // try-finally
			}
		p_posPanel.setCursor(Cursor.getDefaultCursor());
		return orderCompleted;
	}	// processOrder
	
	/**
	 * 	Print Ticket
	 */
	public void printTicket()
	{
		MOrder order = p_posPanel.f_currentLine.getOrder();
		
		if (order != null)
		{
			try 
			{
				// print standard document
				// ReportCtl.startDocumentPrint(p_posPanel.getCtx(), ReportEngine.ORDER, order.getC_Order_ID(), true);
				
			}
			catch (Exception e) 
			{
				log.severe("PrintTicket - Error Printing Ticket");
			}
		}	  
	}	

	/**
	 * 	Display cash return
	 *  Display the difference between tender amount and bill amount
	 */
	public void displayReturn()
	{
		if( f_cashGiven != null ) {
			BigDecimal given = new BigDecimal(f_cashGiven.getValue().toString());
	 		if (p_posPanel != null && p_posPanel.f_currentLine != null)
			{
				f_cashGiven.setPrecision(p_posPanel.getCurrencyPrecision());
				f_cashReturn.setPrecision(p_posPanel.getCurrencyPrecision());
				MOrder order = p_posPanel.f_currentLine.getOrder();
				BigDecimal total = new BigDecimal(0);
				if (order != null)
					{
	  				f_DocumentNo.setText(order.getDocumentNo());
					total = order.getGrandTotal();
					}				
				double cashReturn = given.doubleValue() - total.doubleValue();
				f_cashReturn.setValue(new BigDecimal(cashReturn));
			}
		}
	}	

	/**
	 * Is order fully pay ?
	 * Calculates if the given money is sufficient to pay the order
	 */
	public boolean isOrderFullyPay()
	{
		boolean paid = false;
		if( f_cashGiven != null ){
			BigDecimal given = new BigDecimal(f_cashGiven.getValue().toString());
			if (p_posPanel != null && p_posPanel.f_currentLine != null)
			{
				MOrder order = p_posPanel.f_currentLine.getOrder();
				BigDecimal total = new BigDecimal(0);
				if (order != null)
					total = order.getGrandTotal();
				paid = given.doubleValue() >= total.doubleValue();
			}
		}
		return paid;
	}
	/**
	 * TODO
	 */
	public void openCashDrawer()
	{

	}
	
}	//	PosSubCheckout
