CREATE OR REPLACE VIEW C_ORDER_QUICKREGISTER_V
AS 
SELECT
		o.AD_CLIENT_ID AS AD_CLIENT_ID,
		o.AD_ORGTRX_ID AS AD_ORGTRX_ID,
		o.AD_ORG_ID AS AD_ORG_ID ,
		o.AD_USER_ID AS AD_USER_ID,
		o.BILL_BPARTNER_ID AS BILL_BPARTNER_ID,
		o.BILL_LOCATION_ID AS BILL_LOCATION_ID,
		o.BILL_USER_ID AS BILL_USER_ID,
		o.C_ACTIVITY_ID AS C_ACTIVITY_ID,
		o.C_BPARTNER_ID AS C_BPARTNER_ID,
		o.C_BPARTNER_LOCATION_ID AS C_BPARTNER_LOCATION_ID ,
		o.C_CAMPAIGN_ID AS C_CAMPAIGN_ID,
		o.C_CASHLINE_ID AS C_CASHLINE_ID,
		o.C_CHARGE_ID AS C_CHARGE_ID ,
		o.C_CONVERSIONTYPE_ID AS C_CONVERSIONTYPE_ID ,
		o.C_CURRENCY_ID AS C_CURRENCY_ID,
		o.C_DOCTYPETARGET_ID AS C_DOCTYPETARGET_ID,
		o.C_DOCTYPE_ID AS C_DOCTYPE_ID,
		o.C_ORDER_ID AS C_ORDER_ID,
		o.C_PAYMENTTERM_ID AS C_PAYMENTTERM_ID ,
		o.C_PAYMENT_ID AS C_PAYMENT_ID,
		o.C_PROJECT_ID AS C_PROJECT_ID ,
		o.CHARGEAMT AS CHARGEAMT ,
		o.COPYFROM AS COPYFROM ,
		o.CREATED AS CREATED ,
		o.CREATEDBY AS CREATEDBY,
		o.DATEACCT AS DATEACCT ,
		to_char(o.DATEORDERED,'yyyy-mm-dd') AS DATEORDERED ,
		o.DATEPRINTED AS DATEPRINTED ,
		o.DATEPROMISED AS DATEPROMISED ,
		o.DELIVERYRULE AS DELIVERYRULE ,
		o.DELIVERYVIARULE AS DELIVERYVIARULE ,
		o.DESCRIPTION AS DESCRIPTION ,
		o.DOCACTION AS DOCACTION ,
		o.DOCSTATUS AS DOCSTATUS ,
		o.DOCUMENTNO AS DOCUMENTNO ,
		o.FREIGHTAMT AS FREIGHTAMT ,
		o.FREIGHTCOSTRULE AS FREIGHTCOSTRULE ,
		o.GRANDTOTAL AS GRANDTOTAL ,
		o.INVOICERULE AS INVOICERULE ,
		o.ISACTIVE AS ISACTIVE ,
		o.ISAPPROVED AS ISAPPROVED,
		o.ISCREDITAPPROVED AS ISCREDITAPPROVED,
		o.ISDELIVERED AS ISDELIVERED ,
		o.ISDISCOUNTPRINTED AS ISDISCOUNTPRINTED,
		o.ISDROPSHIP AS ISDROPSHIP,
		o.ISINVOICED AS ISINVOICED,
		o.ISPRINTED AS ISPRINTED ,
		o.ISRETURNTRX AS ISRETURNTRX ,
		o.ISSOTRX AS ISSOTRX ,
		o.ISSELECTED AS ISSELECTED ,
		o.ISSELFSERVICE AS ISSELFSERVICE ,
		o.ISTAXINCLUDED AS ISTAXINCLUDED ,
		o.ISTRANSFERRED AS ISTRANSFERRED,
		o.M_PRICELIST_ID AS M_PRICELIST_ID,
		o.M_RMACATEGORY_ID AS M_RMACATEGORY_ID,
		o.M_RETURNPOLICY_ID AS M_RETURNPOLICY_ID,
		o.M_SHIPPER_ID AS M_SHIPPER_ID ,
		o.M_WAREHOUSE_ID AS M_WAREHOUSE_ID,
		o.ORIG_INOUT_ID AS ORIG_INOUT_ID ,
		o.ORIG_ORDER_ID AS ORIG_ORDER_ID ,
		o.POREFERENCE AS POREFERENCE,
		o.PAY_BPARTNER_ID AS PAY_BPARTNER_ID,
		o.PAY_LOCATION_ID AS PAY_LOCATION_ID,
		o.PAYMENTRULE AS PAYMENTRULE ,
		o.POSTED AS POSTED ,
		o.PRIORITYRULE AS PRIORITYRULE,
		o.PROCESSED AS PROCESSED,
		o.PROCESSING AS PROCESSING,
		o.REF_ORDER_ID AS REF_ORDER_ID,
		o.SALESREP_ID AS SALESREP_ID,
		o.SENDEMAIL AS SENDEMAIL ,
		o.TOTALLINES AS TOTALLINES,
		o.UPDATED AS UPDATED,
		o.UPDATEDBY AS UPDATEDBY,
		o.USER1_ID AS USER1_ID ,
		o.USER2_ID AS USER2_ID ,
		o.VOLUME AS VOLUME ,
		o.WEIGHT AS WEIGHT ,
		dsrl.NAME as DOCSTATUSNAME,
		dt.NAME as C_DOCTYPENAME,
		bp.NAME as C_BPARTNERNAME,
		bpl.NAME as C_BPARTNER_LOCATIONNAME,
		wh.name as M_WAREHOUSENAME,
		prrl.NAME as PAYMENTRULENAME
	from C_ORDER o, 
		C_DOCTYPE dt ,
		AD_REFERENCE dsr,
		AD_REF_LIST dsrl,
		C_BPARTNER bp,
		M_WAREHOUSE wh,
		C_BPARTNER_LOCATION bpl,
		AD_REFERENCE prr,
		AD_REF_LIST prrl
	where dsr.AD_REFERENCE_ID = 131				--DocStatus
	and dsr.AD_REFERENCE_ID = dsrl.AD_REFERENCE_ID
	and dsrl.VALUE = o.DOCSTATUS
	and o.C_DOCTYPETARGET_ID = dt.C_DocType_ID 
	and o.C_BPARTNER_ID = bp.C_BPARTNER_ID
	and o.M_WAREHOUSE_ID = wh.M_WAREHOUSE_ID
	and o.C_BPARTNER_LOCATION_ID = bpl.C_BPARTNER_LOCATION_ID
	and prr.AD_REFERENCE_ID = 195				--PaymentRule
	and prr.AD_REFERENCE_ID = prrl.AD_REFERENCE_ID
	and o.PAYMENTRULE = prrl.VALUE
	order by o.DATEORDERED desc,o.DOCUMENTNO desc 
