/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.quickregister;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;

import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

import org.compiere.apps.ADialog;
import org.compiere.apps.AWindow;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.model.GridTab;
import org.compiere.model.GridWorkbench;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPOS;
import org.compiere.process.ProcessInfo;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;

/**
 * Main Application Panel.
 * 
 * @author Horcha
 * @version $Id: QuickRegisterFormPanel.java,v 1.3 2010/01/10 07:50:34 jrmt Exp $
 */
public final class QuickRegisterFormPanel extends CPanel implements FormPanel {
	/**
	 * Constructs a new instance. Need to call initPanel for dynamic
	 * initialization
	 */
	public QuickRegisterFormPanel() {
		super(new BorderLayout());
		isNested = true;
	} // QuickRegisterPPanel

	/** Logger */
	private static CLogger log = CLogger
			.getCLogger(QuickRegisterFormPanel.class);

	private QuickRegisterPanel qucikRegisterPanel = null;
	/** Sales Rep */
	private int m_SalesRep_ID = 1;
	/** Window No */
	private int m_WindowNo = 20;
	/** FormFrame */
	private FormFrame m_frame;
	/** Quick Register Model */
	protected MQuickRegister p_QuickRegister = null;
	private int order_Id = 0;

	/** QuickRegisterForm Model */
	protected MPOS m_QuickRegisterForm = null;
	private MOrder m_order = null;
	/** Order Lines */
	private MOrderLine[] m_lines = null;
	private JScrollPane centerScrollPane = new JScrollPane();
	
	/**
	 * The Layout
	 */
	private BorderLayout mainLayout = new BorderLayout();
	private JToolBar toolBar = new JToolBar();
	private JMenuBar menuBar = new JMenuBar();
	private boolean isNested = false;
	
	/**
	 * Initializes the state of this instance.
	 * 
	 * @throws Exception
	 */
	public void init(int WindowNo, FormFrame frame) {
		{
			this.setLocale(Language.getLoginLanguage().getLocale());
			
			m_SalesRep_ID = m_ctx.getAD_User_ID();
			log.info("init - SalesRep_ID=" + m_SalesRep_ID);
			m_WindowNo = WindowNo;
			m_frame = frame;
			
			WindowListener wl = new WindowAdapter() {
				private JFrame frame = m_frame;

				public void windowActivated(WindowEvent we) {
					frame.removeWindowListener(this);
					// fullScreen(true);
					final WindowListener wl = this;
					SwingUtilities.invokeLater(new Runnable() {
						public void run() {
							frame.addWindowListener(wl);
						}
					});
				}

				public void windowDeactivated(WindowEvent we) {
					frame.removeWindowListener(this);
					final WindowListener wl = this;
					SwingUtilities.invokeLater(new Runnable() {
						public void run() {
							frame.addWindowListener(wl);
						}
					});
				}
			};
			m_frame.setUndecorated(false);
			m_frame.setSize(1024, 768);
			m_frame.addWindowListener(wl);
			m_frame.setState(frame.NORMAL);
			m_frame.setResizable(true);
			//
			log.info("VOrderReceipIssue.init - WinNo=" + m_WindowNo);

			try {
				centerScrollPane.getViewport().add(this, null);
				centerScrollPane.setPreferredSize(new Dimension(950, 700));
				frame.getContentPane().add(centerScrollPane,
						BorderLayout.CENTER);

				if (!dynInit()) {
					dispose();
					frame.dispose();
					return;
				}
			} catch (Exception e) {
				log.config("QuickRegisterPanel.init - " + getPreferredSize());
			}
			log.config("QuickRegisterPanel.init - " + getPreferredSize());
//			
			
			return;
		}
	} // jbInit
	/**
	 * Dispose
	 */
	public void dispose() {
		// MenuBar
		if (qucikRegisterPanel != null)
			qucikRegisterPanel.dispose();
		if (menuBar != null)
			menuBar.removeAll();
		menuBar = null;
		// ToolBar
		if (toolBar != null)
			toolBar.removeAll();
		toolBar = null;
		// Prepare GC
		this.removeAll();
	} // dispose


	private boolean dynInit() {
		if (!setMPOS())
			return false;

		this.setLayout(mainLayout);
		mainLayout.setHgap(2);
		mainLayout.setVgap(2);
		
		qucikRegisterPanel = new QuickRegisterPanel();
		this.qucikRegisterPanel.f_bpartner.setC_BPartner_ID(m_QuickRegisterForm
				.getC_BPartnerCashTrx_ID());
		this.add(qucikRegisterPanel, mainLayout.CENTER);
		qucikRegisterPanel.f_lines.setVisible(false);
		qucikRegisterPanel.f_bpartner.f_bNew.setEnabled(false);
		qucikRegisterPanel.f_bpartner.f_bEdit.setEnabled(false);
		qucikRegisterPanel.f_bpartner.f_location.setEnabled(false);
		qucikRegisterPanel.f_bpartner.f_user.setEnabled(false);
		qucikRegisterPanel.f_bpartner.f_bSearch.setEnabled(false);
		qucikRegisterPanel.f_bpartner.f_name.setEnabled(false);
		qucikRegisterPanel.f_orderline.f_descreption.setEditable(false);
		qucikRegisterPanel.f_orderline.f_complete.setEnabled(false);
		qucikRegisterPanel.f_product.f_bSearch.setEnabled(false);
		qucikRegisterPanel.f_product.f_name.setEnabled(false);
		qucikRegisterPanel.f_product.f_name.setValue("");
		qucikRegisterPanel.f_currentLine.f_new.setEnabled(false);
//		qucikRegisterPanel.f_currentLine.f_price.setEnabled(false);
		qucikRegisterPanel.f_currentLine.f_quantity.setEnabled(false);
		qucikRegisterPanel.f_quickRegisterMenu.aNew.getButton().requestFocusInWindow();
		return true;
	}

	/**
	 * Set MPOS
	 * 
	 * @return true if found/set
	 */
	private boolean setMPOS() {
		MPOS[] poss = null;
		if (m_SalesRep_ID == 100) // superUser
			poss = getPOSs(0);
		else
			poss = getPOSs(m_SalesRep_ID);
		//
		if (poss.length == 0) {
			ADialog.error(m_WindowNo, m_frame, "NoPOSForUser");
			return false;
		} else if (poss.length == 1) {
			m_QuickRegisterForm = poss[0];
			return true;
		}

		// Select POS
		String msg = Msg.getMsg(m_ctx, "SelectPOS");
		String title = Env.getHeader(m_ctx, m_WindowNo);
		Object selection = JOptionPane.showInputDialog(m_frame, msg, title,
				JOptionPane.QUESTION_MESSAGE, null, poss, poss[0]);
		if (selection != null) {
			m_QuickRegisterForm = (MPOS) selection;
			return true;
		}
		return false;
	} // setMPOS

	/**
	 * Get POSs for specific Sales Rep or all
	 * 
	 * @param SalesRep_ID
	 * @return array of POS
	 */
	private MPOS[] getPOSs(int SalesRep_ID) {
		ArrayList<MPOS> list = new ArrayList<MPOS>();
		String sql = "SELECT * FROM C_POS WHERE SalesRep_ID=?";
		if (SalesRep_ID == 0)
			sql = "SELECT * FROM C_POS WHERE AD_Client_ID=?";
		PreparedStatement pstmt = null;
		try {
			pstmt = DB.prepareStatement(sql, null);
			if (SalesRep_ID != 0)
				pstmt.setInt(1, m_SalesRep_ID);
			else
				pstmt.setInt(1, m_ctx.getAD_Client_ID());
			ResultSet rs = pstmt.executeQuery();
			while (rs.next())
				list.add(new MPOS(m_ctx, rs, null));
			rs.close();
			pstmt.close();
			pstmt = null;
		} catch (Exception e) {
			log.log(Level.SEVERE, sql, e);
		}
		try {
			if (pstmt != null)
				pstmt.close();
			pstmt = null;
		} catch (Exception e) {
			pstmt = null;
		}
		MPOS[] retValue = new MPOS[list.size()];
		list.toArray(retValue);
		return retValue;
	} // getPOSs

	/**
	 * Return MenuBar
	 * 
	 * @return JMenuBar
	 */
	public JMenuBar getMenuBar() {
		return menuBar;
	} // getMenuBar

	/**
	 * Get Title of Window
	 * 
	 * @return String with Title
	 */
	public String getTitle() {
		if (m_mWorkbench.getWindowCount() > 1) {
			StringBuffer sb = new StringBuffer();
			sb.append(m_mWorkbench.getName()).append("  ").append(
					m_ctx.getContext("#AD_User_Name")).append("@").append(
					m_ctx.getContext("#AD_Client_Name")).append(".").append(
					m_ctx.getContext("#AD_Org_Name")).append(" [").append(
					m_ctx.getContext("#DB_UID")).append("]");
			return sb.toString();
		}
		return Env.getHeader(m_ctx, m_curWindowNo);
	} // getTitle

	/** Context */
	private Ctx m_ctx = Env.getCtx();

	/** Workbench Model */
	private GridWorkbench m_mWorkbench;
	/** Current MTab */
	private GridTab m_curTab;
	/** Current Window No */
	private int m_curWindowNo;
	/** Process Info */
	private boolean m_isLocked = false;
	/** Show Personal Lock */

	/**
	 * Indicate Busy
	 * 
	 * @param busy
	 *            busy
	 * @param focus
	 *            request focus
	 */
	private void setBusy(boolean busy, boolean focus) {
		m_isLocked = busy;
		//
		JFrame frame = Env.getFrame(this);
		if (frame == null) // during init
			return;
		if (frame instanceof AWindow)
			((AWindow) frame).setBusy(busy);
		if (busy) {
			this.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
			frame.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
		} else {
			this.setCursor(Cursor.getDefaultCursor());
			frame.setCursor(Cursor.getDefaultCursor());
		}
	} // set Busy

	/**
	 * setValueOrderPanal
	 * */
	public void setValueOrderPanal(int selectRow) {
		Object orderNo = qucikRegisterPanel.f_orderlines.getM_table()
				.getValueAt(selectRow, 7);
		Object fBPartner = qucikRegisterPanel.f_orderlines.getM_table()
				.getValueAt(selectRow, 8);
		Object docmentType = qucikRegisterPanel.f_orderlines.getM_table()
				.getValueAt(selectRow, 9);

		if (fBPartner != null)
			qucikRegisterPanel.f_orderline.f_customerNo.setValue(fBPartner
					.toString());
		else
			qucikRegisterPanel.f_orderline.f_customerNo.setValue("");
		if (orderNo != null)
			qucikRegisterPanel.f_orderline.f_orderNo.setValue(orderNo
					.toString());
		else
			qucikRegisterPanel.f_orderline.f_orderNo.setValue("");
		if (docmentType != null)
			qucikRegisterPanel.f_orderline.f_docmentType.setValue(docmentType
					.toString());
		else
			qucikRegisterPanel.f_orderline.f_docmentType.setValue("");
	}

	/**
	 * Get Lines of Order
	 * 
	 * @param requery
	 *            requery
	 * @param orderBy
	 *            optional order by column
	 * @return lines
	 */
	public MOrderLine[] getLines(boolean requery, String orderBy) {
		if (m_lines != null && !requery)
			return m_lines;
		//
		String orderClause = "ORDER BY ";
		if (orderBy != null && orderBy.length() > 0)
			orderClause += orderBy;
		else
			orderClause += "Line";
		m_lines = getLines(null, orderClause, order_Id);
		return m_lines;
	} // getLines

	/**************************************************************************
	 * Get Lines of Order
	 * 
	 * @param whereClause
	 *            where clause or null (starting with AND)
	 * @param orderClause
	 *            order clause
	 * @return lines
	 */
	public MOrderLine[] getLines(String whereClause, String orderClause,
			int order_Id) {
		ArrayList<MOrderLine> list = new ArrayList<MOrderLine>();
		StringBuffer sql = new StringBuffer(
				"SELECT * FROM C_OrderLine WHERE C_Order_ID=? ");
		if (whereClause != null)
			sql.append(whereClause);
		if (orderClause != null)
			sql.append(" ").append(orderClause);
		PreparedStatement pstmt = null;
		try {
			pstmt = DB.prepareStatement(sql.toString(), null);
			pstmt.setInt(1, order_Id);
			ResultSet rs = pstmt.executeQuery();
			while (rs.next()) {
				MOrderLine ol = new MOrderLine(m_ctx, rs, null);
				ol.setHeaderInfo(deleteLineByGetOrder());
				list.add(ol);
			}
			rs.close();
			pstmt.close();
			pstmt = null;
		} catch (Exception e) {
			log.log(Level.SEVERE, sql.toString(), e);
		} finally {
			try {
				if (pstmt != null)
					pstmt.close();
			} catch (Exception e) {
			}
			pstmt = null;
		}
		//
		MOrderLine[] lines = new MOrderLine[list.size()];
		list.toArray(lines);
		return lines;
	} // getLines

	/**
	 * Get/create Header
	 * 
	 * @return header or null
	 */
	public MOrder deleteLineByGetOrder() {
		if ((m_order == null) && (order_Id != 0)) {
			m_order = new MOrder(Env.getCtx(), order_Id, null);
			if(m_QuickRegisterForm != null){
				if(m_QuickRegisterForm.getAD_Org_ID() != 0)
					m_order.setAD_Org_ID(m_QuickRegisterForm.getAD_Org_ID());
					if(m_QuickRegisterForm.getM_PriceList_ID() != 0)
					m_order.setM_PriceList_ID(m_QuickRegisterForm.getM_PriceList_ID());
					if(m_QuickRegisterForm.getM_Warehouse_ID() != 0)
					m_order.setM_Warehouse_ID(m_QuickRegisterForm.getM_Warehouse_ID());
					if(m_QuickRegisterForm.getSalesRep_ID() != 0)
					m_order.setSalesRep_ID(m_QuickRegisterForm.getSalesRep_ID());
					if (!m_order.save()){
						m_order = null;
					m_order.setIsSOTrx(true);
					}
			}
		}
		return m_order;
	} // getHeader

	/**************************************************************************
	 * Lock User Interface. Called from the Worker before processing
	 * 
	 * @param pi
	 *            process info
	 */
	public void lockUI(ProcessInfo pi) {
		// log.fine("" + pi);
		setBusy(true, false);
	} // lockUI

	/**
	 * Unlock User Interface. Called from the Worker when processing is done
	 * 
	 * @param pi
	 *            of execute ASync call
	 */
	public void unlockUI(ProcessInfo pi) {
		// log.fine("" + pi);
		boolean notPrint = pi != null
				&& pi.getAD_Process_ID() != m_curTab.getAD_Process_ID();
		//
		setBusy(false, notPrint);

	} // unlockUI

	/**
	 * Is the UI locked (Internal method)
	 * 
	 * @return true, if UI is locked
	 */
	public boolean isUILocked() {
		return m_isLocked;
	} // isLoacked

	/**
	 * Method to be executed async. Called from the ASyncProcess worker
	 * 
	 * @param pi
	 *            process info
	 */
	public void executeASync(ProcessInfo pi) {
		log.config("-");
	} // executeASync

} 
